/* This is a simple demo of the SREhttp/2 "multi-send" procedure
   Please see MULTSEND.TXT for a description of the SREH2_MULTI_SEND
   procedure.

Syntax for sre_multi_send:
 res=sre_multi_send(thevalue,thetype,astatus,isfile,verbose,optheaders,id_info,cprotocol) 

*/

parse arg list,servername,verb,tempfile,,
          prog_file,reqnum,verbose,user,privset,,
          uri,host_nickname,id_info

/* protocol is used by SRE_MULTI_SEND */
cprotocol=sre_extract('clientprotocol')
parse var cprotocol '/' ver

/* check to see if the browser understands multi-part documents */
if ver<1.1 then do
  a=sre_reqfield('Connection')||sre_reqfield('PROXY-Connection')
  a=strip(translate(a))
  if pos('KEEP-ALIVE',a)+pos('MAINTAIN',a)=0 then do 
    wow=sre_reqfield('user-agent')
    foo=sre_command('String Sorry: Your Browser ('||wow||') does not support Connection:Keep-Alive',,id_info)
    return foo
  end  
end


/* give this request 40 seconds to complete */

foo=sre_command('SET LIMITTIMETOTAL',40,id_info)

/* Start the parts with some simple text -- which is sent in several pieces */

/* this sets up the basic structure, and sends the first chunk of the first part */
foo=sreh2_multi_send('This is a simple additive send.. first line'||'0d0a'x, ,
                    ' expires 0.0001 nowait text/plain','SS',
                     ,,,'X-Push: Test ', ,
                     id_info,cprotocol)

/* note that a return code starting with 'ERROR' indicates an error,
perahsp the connection has been dropped... so let's not make the server 
try to send stuff to someone who's not there */

if abbrev(foo,'ERROR')=1 then return error

/* wait for 2 seconds, and send the 2nd chunk of the first part */
aa=syssleep(2)
foo=sreh2_multi_send(' .. it should have taken 2 seconds to display this 2nd '||'0d0a'x,'text/plain','A', ,
                         ,,,id_info,cprotocol)
if abbrev(foo,'ERROR')=1 then return error


/* wait for 3 seconds, and send the 3rd chunk of the first part */
aa=syssleep(3)
foo=sreh2_multi_send('and 3 seconds for this last line.  '||'0d0a'x,,'A',,                   
                         ,,,id_info,cprotocol)
if abbrev(foo,'ERROR')=1 then return error

/* Now send last chunk of first part */
foo=sreh2_multi_send("Now let's do a server-push style animation ....  ",,'SE',,
                         ,,,id_info,cprotocol)
if abbrev(foo,'ERROR')=1 then return error

/* Wait 3 seconds, and then send a set of parts that performs a 7 frame  
  animation */
aa=syssleep(3)

/* make sure SC*.GIF files are available */

ddir=strip(sre_datadir('default'))
ddir=strip(ddir,,'\')||'\'
aa=stream(ddir||'sre2k\srehttp2\imgs\sc1.gif','c','query exists')

/* if not available, send a simple error message */
if aa='' then do
    foo=sreh2_multi_send('Sorry: push movie requires' ddir'sre2k\srehttp2\imgs\sc*.gif','text/plain','M',,
                         ,,'X-PushMovie: none',id_info,cprotocol)
call syssleep(4)
end 
else do

  do jj=1 to 7          /* now send the 7 frames */
    aa=syssleep(1)
    foo=sreh2_multi_send(ddir'sre2k\srehttp2\imgs\sc'||jj||'.gif','image/gif','M',1,,,
                      'X-PushMovie: '||jj,id_info,cprotocol)
    if foo<>'' then call pmprintf(' MULTSEND status: 'foo)
    if abbrev(foo,'ERROR')=1 then   return foo
  end
end


aa=syssleep(2)

/* and end up with a little description, complete with links
to the source code */

crlf='0d0a'x
aa="<html><head><title>SRE-http server push example</title></head>"crlf
aa=aa||" <body> Wasn't that <b>fun</b>.<p> "crlf
aa=aa||' <p> It was generated by a <a href="/sre2k/srehttp2/multsend.cmd">simple REXX procedure</a> that calls the SREhttp/2 '
aa=aa||" sreh2_multi_send procedure.  You can use it as a template for your own"
aa=aa||' server-side-push tasks.  You might also want to read a <a href="/sre2k/srehttp2/multsend.txt">brief description</a> of '
aa=aa||" sreh2_multi_send. </body></html>"
foo=sreh2_multi_send(aa,'text/html','E',,,'X-End: yes',id_info,cprotocol)


return foo              /* all done! */


