/**********************
        The "find best matching files" SREhttp/2 procedure.

This is invoked by setting the SREHTTP2.CFG parameter:
      not_found_file='!PROCS\MTCHFILE.REX'
(assuming MTCHFILE.REX is in the SREHTTP2\PROCS directory).

This procedure will find several names, in the "directory" (or a parent 
directory) of the requested (but not found) file, and create a linked
list to them.  However, it will NOT display links to
directories and filenames (possibly wildcarded filenames)
listed in the DIR_EXCLUSION parameter.

The following arguments will be passed here (and to any other
procedure invoked through this !not_found_file trick).

   docfile -- the file the selector matched (which could not be found)
   who     -- numeric client ip addres
   selector-- the request selector
   verb    -- the method (it will almost always be GET)
   user    -- username (or '', if no username is available)
  verbose  -- the verbose flag
  privset  -- the client's privileges
 transaction -- the SRE2003 transaction #
 tempfile   -- a filename that can be used as a temporary file
 host_nickname -- the host_nickname

MTCHFILE does not use most of these arguments, but other 
procedures might.

MTCHFILE (and any other of this not-found-file class of procedures) must 
return a string containing a fully specified HTML document (complete with
<HTML><HEAD> ... </BODY></HTML>.  SREhttp/2 will then use the
contents of this string as the response to the client.

*************************************************************/

/******* User changeable parameters *******/

nshow=5                 /* # of matches to show */
noscore=0               /* noscore=1 to suppress display of score */

/******* End of User changeable parameters *******/

parse arg myfile,who,selo,verb,user,verbose,privset,,
          transaction,tempfile,host_nickname

crlf='0d0a'x


htm='<html><head><title>File Not Found</title></head><body>'crlf
htm=htm||'<h2>Requested file could not be found</h2>'crlf
htm=htm||'Your request for:<blockquote><tt>'selo'</tt></blockquote>'crlf
htm=htm||'could <b>not</b> be satisfied.<p>'

alist0=mk_match_list(selo,myfile,nshow,noscore)
parse var alist0 seldir','alist
if alist<>'' then do
    htm=htm||'<em>How about:</em><ol>'||crlf||alist||crlf||'</ol>'crlf
    htm=htm||'<tt>in http://'||sre_servername()||seldir'</tt>'crlf
end

htm=htm||'<hr><em>'||sre_datestamp()||crlf
htm=htm||'</body></html>'
return htm



/**************/
/* create list of 5 links to close matches, using 
compword procedure to score mathces */
mk_match_list:procedure
parse arg selo,myfile,nshow,noscore

prefix='<li>'
listit=''
checkname=filespec('n',myfile)

parse var selo ssel '?' .
ssel=translate(ssel,'\','/')
ssel='\'||strip(ssel,,'\')

direx=translate(SREh2_value('DIR_EXCLUSION',,host_nickname))
direx=translate(direx,'\','/')


/* find the first existant directory */
mydir=myfile
basis=''

do forever
   i1=lastpos('\',ssel) 
   if i1=0 then leave
   ssel=left(ssel,i1-1)

   i2=lastpos('\',mydir) 
   if i2=0 then leave
   mydir=left(mydir,i2-1)

/* check direxclusion */
   i1a=lastpos('\',ssel)
   if i1a>0 then do
      mysub=translate(substr(ssel,i1a))
      if wordpos(mysub,direx)>0 then iterate  /* match, so don't look at */
   end
   gg=mydir
   if right(gg,1)=':' then gg=gg'\'   
   if dosisdir(gg) then do
      basis=gg
      leave
   end /* do */
end
seldir=translate(ssel,'/','\')
if seldir<>'/' then seldir=seldir'/'

aa=sysfiletree(basis'\*.*',goos,'fo')
parse upper var checkname aname '.' aext

nwild=0
do mm=1 to words(direx)
   aw=strip(word(direx,mm))
   if pos('\',aw)>0 then iterate  /* dir */
   if pos('*',aw)=0 then iterate  /* not wildcard */
   nwild=nwild+1
   wilds.nwild=aw
end /* do */
iok=0
maxscore=-1
do mm=1 to goos.0
   nogo=0
   score1=0 ; score2=0
   tname=filespec('n',goos.mm) 
   ttname=translate(tname)
   if wordpos(ttname,direx)>0 then do 
       goos.mm.!score=-2
       iterate
   end
   do jj=1 to nwild
     if sre_wild_match(translate(tname),wilds.jj,' ')<>0 then do
          goos.mm.!score=-2
          iterate mm
      end /* do */
   end /* do */

/* direx not relevant */
   iok=iok+1
   parse upper var tname bname '.' bext
   sc1=compword(aname,bname)
   sc2=compword(aext,bext)
   score1=((3*sc1)+sc2)/4

   sc1=compword(bname,aname)
   sc2=compword(bext,aext)
   score2=((3*sc1)+sc2)/4

   score=(score1+score2)/2
   goos.mm.!score=trunc(score*100)

end

/* find top nshow */
do mm=1 to min(goos.0,nshow)
  amax=-1
  do nn=1 to goos.0
     if goos.nn.!score>amax then do
         amax=goos.nn.!score ; iat=nn
     end
  end
  bests.mm=goos.iat' 'goos.iat.!score
  goos.iat.!score=-1
end 
do mm=1 to min(goos.0,nshow,iok)
   parse var bests.mm a1a score
   a1=filespec('n',a1a)
   mkk=prefix'<a href="'seldir||a1'">'a1'</a>'
   if noscore<>1 then mkk=mkk' <em>('score')</em>'
   listit=listit||mkk||'0d0a'x
end 
return seldir','listit


/*********************/
/* compare words, return score between 0 and 100 */
/* Needle is compared against haystack.
  A score is returned, with 100 being "perfect match", and 0 being "no match"
  Note that switching needle and haystack can effect the score 
*/

compword:procedure
parse upper arg  needle,haystack

lenn=length(needle)

if needle=haystack  then return 1.0  /*1.0 = perfect match */

if needle='' | haystack='' then return 0

score=0 ; maxscore=0
lenh=length(haystack)

LFACT=MIN(LENH/LENN,LENN/LENH)

do m1=1 to lenn
  m11=m1-1
  do m2=1 to lenn-m11
     if m1>lenh then leave
     al=substr(needle,m2,m1)
     
     ival=pos(al,haystack)
     if ival>0 then score=score+(m1/(1+abs(m2-ival)))
     maxscore=maxscore+m1
  end /* do */
end /* do */

do m1=1 to lenn-2
  al=substr(needle,m1,1)
  maxscore=maxscore+1
  al2=substr(needle,m1+2,1)
  iv1=pos(al,haystack)
  if iv1=0 then iterate
  iv2=pos(al2,haystack,iv1+1)
  if iv2=0 then iterate
  diff=1/(1+abs((iv2-iv1)-2))
  score=score+diff
end /* do */

do m1=1 to lenn-3
  al=substr(needle,m1,1)
  maxscore=maxscore+1
  al2=substr(needle,m1+3,1)
  iv1=pos(al,haystack)
  if iv1=0 then iterate
  iv2=pos(al2,haystack,iv1+1)
  if iv2=0 then iterate
  diff=1/(1+abs((iv2-iv1)-3))


  score=score+diff
end /* do */

return LFACT*score/maxscore

