/* 2 October 2002: SRE Watch: Launch and Monitor SRE2003

  SREWATCH (SRE Watch) is used to launch and monitor the SRE2003 http server.

  SRE Watch will:

  1) Start SRE2003.CMD

  2) Monitor the state of the server.
  
  3) If a crash or other bad error involving SRE2003 is detected, then
     SREWatch will attempt to restart SRE2003.


Usage:

  1) From an OS/2 command prompt, change to the SRE2003 "working directory"
     (the directory you installed SRE2003 into).

  2) Run SREWATCH.CMD. For example, if D:\SRE2003 is your working directory:
         D:\SRE2003>srewatch

  3)  That's it. SREWatch will start up (or detect) SRE2003; and monitor it.
      

Notes:

  * Although SRE Watch can monitor an already running version of SRE2003, we
    recommend using SRE Watch to start SRE2003. That is, before running
    SREWATCH, you should NOT have a copy of SRE2003 running.

  * SREWATCH must be run from the SRE2003 "working directory" (the directory
    that contains SRE2003.CMD).
  
  * In general, you do NOT need to change the user configurable parameters 
    contained in SREWATCH.CMD

  * To use an alternate SRE2003 CFG file, you can start SREWATCH with 
    its name.  For example:
       D:\SRE2003>srewatch cfg\alt_cfg.cfg
    means "start SRE2003 with the CFG\ALT_CFG.CFG configuration file".


Hints on running an unattended server:

    * Include the following at the end of STARTUP.CMD
        x:              (x: is your SRE2003 drive)
        cd \SRE2003
        START SREWATCH

    * Include the following lines in your CONFIG.SYS file:
         REIPL=ON
         SUPPRESSPOPUPS=x
      
      REIPL=ON will cause the machine to reboot when an error occurs
      SUPPRESSPOPUPS will suppress popup error messages, errors will be
      sent to a POPUPLOG.OS2 (text) file on your x drive (x can be C,
      D, or any valid drive letter).

    * Set the SREWATCH user configurable parameter
        REBOOT_ON_FAILURE=1 
      (see below for the details).

User Configurable Parameters

 There are a number of user configurable parameters that can be set in 
 SREWATCH.CMD. In most cases, you will NOT need to modify them. 

 The more important user configurable parameters are:

      UPDATE:   Frequency to check (in minutes). Higher values mean check LESS often
               The default is to check every 5 minutes.

      IP_NAME : The domain name for your server. 
               If not specified, an OS/2 HOST command is used to determine the
               domain name of this machine.
               On some sites, this may not work properly -- in which case 
               setting the IPNAME parameter is required.

    MAX_BADS:  How quickly to "kill, and restart, SRE2003". 
               Higher values mean one is LESS likely to kill & restart -- 
               SRE Watch will try a bit harder to make an http connection 
               with SRE2003.

        PORT : the port the server is running on. By default, this is set to 
               80. If you are running on a non-80 port, you MUST change the 
               value of the PORT parameter.

    REBOOT_ON_FAILURE: If SRE2003 is unstartable, or unkillable, then 
                       SRE Watch can attempt to reboot the computer. 
                       This is useful for unattended installations.


    KILL_FILE:  A fully qualified file name. If this file exists, then a "failure"
                has occurred, and SRE2003 will be shutdown (or the machine will
                reboot). 

.end    DO not remove this line

*******/

/***************** Begin USER Changeable Parameters ******************/
/*  Most of the time, you will NOT need to modify any of these parameters.
   However...
    * If you are running on a port other then 80, change the ip_port parameter 
    * On some sites, setting the IP_NAME (to be the domain name of your server)
      might be necessary  

  Other Notes:   
    * To "watch" your server more closely, you can  modify the UPDATE parameter
    * If your site should be "initialized" via a call to specific URI, then
      change the FIRST_HIT parameter
*/

/* double and triple check to make sure that sre2003 is actually killed.
  1= Yes (double check)
  0= No (don't double check) */
double_check_kill=1

/* Use this on the "first hit" to the server (i.e.; hit the main page)
   For example: first_hit='/index.htm'
   To use the default, set first_hit=''
   Note that a HEAD request is used  */
first_hit='/'

/* IP (name) address to monitor. Set IP_ADDRESS='' to use "own" address. */
ip_name=''

/* Port to monitor. Typically, 80 is used */
ip_port=80


/* A "kill yourself" file. If this file exists, then assume SRE2003 has failed.
   To NOT enable this option, set KILL_FILE=0 or KILL_FILE=''.
   Otherwise, this should be a fully qualified filename (that may be anywhere
   on your machine or lan drives accessible from your machine). */
kill_file=0

/* Log file -- events are written here. Files are relative to the current
   directory (typically, the log directory)*/
logfile='log\srewatch.log'

/* If more then this number of consecutive timeouts (or connection refusals)
   detected; then kill and restart SRE2003
   To suppress this, set MAX_bads=100000000, or set TRY_RESTART=0 */
max_bads=2

/* Use  this on other hits (HEAD requests). If =0, then a special request
  (TEST PING)  is used.
   In general, we recommend using otherhits=0   */
otherhits=0

/* length of time to wait on a socket call. */
timeout_sec=10

/* If possibly bad problem detected, attempt to kill, then restart
   Values are:
        Try_Restart = 0         -- do not attempt to restart
        Try_Restart = 1         -- attempt to restart    (after max timeouts)       */
Try_Restart=1

/* If an attempt to Kill or Restart SRE2003 fails, you can reboot the machine.
   1= Yes -- reboot on failure to restart
   0= No -- do not reboot. SREWATCH will exit. 
Note: this uses SETBOOT /B to reboot. SETBOOT will NOT work on a dual-boot (as 
opposed to a Boot Manager) configured machine.
*/
reboot_on_failure=0

/* Update frequency, in minutes. More frequent updates will mean less time between
"recoveries", but will increase server load. */
update=5


/* verboseness of output: 0=normal, 1=verbose, 2=too much */
verbose=1

/*              -----------------------------                     */
/* the remaining parameters control on-screen display colors, etc. */

topmess="SRE Watch 1.12: The SRE2003 monitor"

/* these ANSI characters are used to write the  "frame"
  They may need to be changed if you are 
   using a non-english or non "latin 1" code page */

/* Vertical frame character */
vchar=d2c(179)

/* Horizontal frame character */
hchar=d2c(196)

/* upper left corner */
ulc=d2c(218)

/* upper right corner */
urc=d2c(191)

/* lower left corner */
llc=d2c(192)

/* lower right corner */
lrc=d2c(217)

/* border foreground and background color codes  */
border_fore=43
border_back=42


/* if 1, then use a blinking ? in the user-input area
   0 to suppress blinking ? */
doblink=0

/*   ------------------- Some notes on colors  ------------------

* ANSI colors are used for the bounding box:
   The actual color combinations may depend on your installation.
    In general, the foreground colors are:
      30 = black     31 = red       32 = green  33 = gold  
      34 = blue      35 = magenta   36 = cyan   37 = white
   Bright colors range from 40 to 47 (black to white).


 * SCRWRITE is used for writing messages.
   
      SCRWRITE([row],[col],[string],[length],[pad],[attr])
 
             Attribute values are computed by adding the number that 
             represents a foreground color to the number that represents 
             a background color:
 
             Foreground Colors:
 
         0 - black         1 - blue           2 - green              3 - cyan 
         4 - red           5 - magenta        6 - brown              7 - white 
         8 - gray          9 - light blue 
        10 - light green  11 - light cyan    12 - light red          13 - light magenta 
        14 - yellow       15 - high intensity white 
 
              Background Colors:
         0 - black         16 - blue         32 - green             48 - cyan 
        64 - red           80 - magenta      96 - brown            112 - white 

        Adding 128 will produce blinking text. If blinking is disabled, adding 128
        produces a bright background.
 
*/


/* ********************** END user changable parameters **************/

signal on halt name doexit
signal on error name err1 
signal on failure name err1

parse arg cfgfile
cfgfile=strip(cfgfile)

if cfgfile='?' then do
say  'SRE Watch 1.12: the SRE2003 monitor. '
say ' It will start, and if necessary, restart, SRE2003'
say ' To use it, you may need to set a few parameters (at the top of SREWATCH.CMD).'
say
ii=yesno('Would you like to view a more detailed description of SRE Watch?',,'Y')
if ii=1  then fo=show_intro(2,,'SRE Watch 1.12 ')
exit
end

call load       /* load procs, etc */

say  cy_ye'SRE Watch 1.12: the SRE2003 monitor. 'normal' (SREWATCH ? for simple usage hints)'
call syssleep 1


call start_screen
if doblink=1 then foo=scrblink(1)

/* say '            'cy_ye ' SRE Watch: the SRE2003 monitor. 'normal */


/* -------- is sre2003 currently running? */
gospid=get_process()

if gospid<0 then do
 say bold 'Multiple instances of SRE2003 detected' normal
 say  '(possibly running on multiple ports).'
 say 'SRE Watch can not operate with multiple instances of SRE2003!'
 exit
end

if gospid>0 then do
  say bold"SRE2003 seems to be running"normal
  say "  SRE Watch works best when it starts up SRE2003 (rather then"
  say "  watching a currently executing version)."
  say "  We recommend stopping SRE2003 first, and then running SRE Watch "
  ii=yesno("  Would you like to continue anyways? ",,'N')
  if ii=0 then do
      say "Bye. "
      exit
  end
  call start_screen
/*  say '            'cy_ye ' SRE Watch: the SRE2003 monitor. 'normal */
end



call show_time 'Started:'

if ip_name='' then ip_name=get_hostname()

rc=sockgethostbyname(ip_name, "serv.0")  /* get dotaddress of server */
if rc=0 then do; 
call show_time 'Bad IP address '
  call write_error 'Unable to resolve "'ip_name'"'
  signal doexit
end
dotserver=serv.0addr                   
foo=cursor(2,2)
say  bold' Server: 'normal||IP_name||'  ('||dotserver||':'||ip_port||')'

if reboot_on_failure=1 then
  am1=' enabled'
else
  am1=' disabled'

oo=cursor(3,2)
say  bold' Reboot option: 'normal||am1

call lineout logfile,' '
call lineout logfile,' ----- SRE Watch invoked at ' date('n') time('n')


foo=scrwrite(says.!scrrows-1,13,'  ESC=exit   R=restart  C=check   K=kill&exit ' ,51,,63)

foo=scrwrite(7,2,'SRE2003 Process ID:',20,,43)
foo=scrwrite(8,2,'   Server Software:',20,,43)

foo=scrwrite(9,2,'Status:',10,,62)
foo=scrwrite(10,2,' history:',10,,62)

foo=scrwrite(11,2,'Errors:',10,,116)
foo=scrwrite(14,2,'Messages:',10,,103)

/* foo=scrwrite(says.!scrrows-1,15,'  'copies('-',36),40,,55) */


if gospid>0 then do
  parse value dospriority(,,gospid) with lvl clas ; clas=strip(clas)
  prmess='(Priority Class='says.!priority_levels.clas||', level='lvl')'
  call write_process ' found on '||gospid||' 'prmess
  call write_status2 'SRE2003 detected at 'date('n')||' '||time('n')

  call lineout logfile,"  SRE2003 found on process: " gospid
  call lineout logfile,'  SRE2003 detected at 'date('n')||time('n')
end


foo=cursor(4,2)
say  bold' Messages written to: 'normal||logfile

if gospid<=0 then do                 /* start sre2003 */

  if cfgfile<>'' then do          
     foo=cursor(5,2)
     say  bold'      Using CFG file: 'normal||cfgfile
  end
  call write_status 'Starting SRE2003 '
  gospid=start_sre()
  if gospid=0 then do
     call write_error " Unable to start SRE2003! "
     exit
  end 
  parse value dospriority(,,gospid) with lvl clas ; clas=strip(clas)
  prmess='(Priority Class='says.!priority_levels.clas||', level='lvl')'
  call write_process gospid' 'prmess
  call write_status2 'SRE2003 started at 'date('n')||' '||time('n')
  call lineout logfile,"  SRE2003 running on process: " gospid
end


nthstart=0

/* now start hitting the server with request .... */

if verbose>0 then call write_message "Checking "ip_name " with " first_hit
wow=doit(first_hit,1)              /* hit it with a real HEAD request */

parse var wow wow wowmessage ;wow=strip(wow)

if wow<0 then do
  call check_bad_doit     /* on first call, extra error message checking (possible exit */
  if res=0 then signal doexit
  nbads=nbads-1           /* just try one more time */
end
else do     /* if here, okay */
  call write_message " Server at " ip_name " is currently running.... "
end


/* ------ start monitoring .. . */

hitwith=otherhits
first1=0
do loop1=1              /* monitor .... */


/* kill file check */
  if kill_file<>'' then do
       foo=stream(kill_file,'c','query exists')
       if foo<>'' then do
          call write_error "Kill file detected; ReStarting."
          call restartit
          foo=sysfiledelete(kill_file)
          if result<0 then signal doexit
       end
  end 

  showmes=hitwith
  if hitwith=0 then showmes='TEST TRANSACTION '
  call write_status ' Checking with: 'showmes
  call show_time ' checking '
  wow=doit(hitwith,first1)       /* hit it with a TEST  */
  hitwith=otherhits
  first1=0

  parse var wow wow wowmessage

  if wow=1 then do                      /* success == nap and try again */
      call write_status ' Server okay at '||time('n')||'; next check in 'nsec " seconds"
      call write_error ' '
      call show_time 'Okay at '

      if verbose>0 then do    
          fo=write_message('Server response: 'wowmessage,,1)
      end 

/* nap, with peeks to see if user input recieved .... */

      do mm=1 to nsec by 3
        call syssleep 3             /* the "update" # of seconds */
        akey=inkey('N')       /* Keystroke detected? */
        
        call write_userinput '? '
        fo=cursor(says.!scrrows,14)

        ikey=c2d(akey)
        if ikey<>0 then  do
          call write_userinput ' '

           if ikey=27 then do 
              call write_message 'SRE Watch ending at '||date('n')||' '||time('n')
              signal  doexit
           end 
           if ikey=114 | ikey=82 then do           /* R: restart */
               call show_time 'restarting '
               call restartit
               if result<0 then signal doexit
               iterate loop1                /* and start watching some more */
            end 
           if ikey=99 | ikey=67 then do        /* C:  leave loop, check now */
              foo=write_message(' User request to check server ...',,1)
              leave
           end
          if ikey=107 | ikey=75 then do        /* K: kill, and exit         */
               call show_time 'kill and exit '
               foo=restart_sre(gospid,1)
               call write_message 'SRE Watch ending at '||date('n')||' '||time('n')
               signal doexit
          end 
         
        end
        call show_time 'napping '
      end 
      getshead=0
      nbads=0
      iterate
  end                   /* End of nap */


  if try_restart<1  then do     /* some kind of error, just note it and try again: */
      nbads=nbads+1
      call write_error nbads': 'wowmessage'"  Try again in 10 seconds '
      call syssleep 10
      iterate
  end 

/* problems, perhaps restart. */
   nbads=nbads+1

   call write_error "Error Detected ("wowmessage"), " nbads  " of " max_bads

   if nbads>=max_bads then do             /* restart after consecutive maxtimeout failures */
       call restartit
       if result<0 then signal doexit
   end 

end             /* of forever */

say "SHOULD NOT GET HERE "
exit

err1:
call charout, '1b5b'x||23||';4H'||''
say "Syntax error at line "sigl ',' rc
exit


doexit:
aa=scrclear(,,says.!scrrows-3,1)
call syssleep 1
atr=says.!scrrows-2
call charout, '1b5b'x||atr||';4H'||'Bye.'

if says.!IsFailure=1 & reboot_on_failure=1 then do
   call lineout logfile,'Rebooting Server '
   say 'Rebooting Server '
   call lineout logfile
   'SETBOOT /B '
end 


exit




/******/
/* restart .. */
restartit:
   call write_software ' '
    call write_status 'Restart SRE2003 '
    gospid=restart_sre(gospid)   /* exit in restart_sre if fatal error */
    if gospid<0  then  do
       says.!IsFailure=1
       return -1
    end
    nthstart=nthstart+1
    call write_status2 'SRE2003 restarted (#' nthstart') at '||date('n')||' '||time('n')
    nbads=0
    first1=1
    hitwith=first_hit
  
    return 1

/***********/
/* write to status line*/
write_status:
parse arg amessage
foo=scrwrite(9,12,strip(amessage),66)
return 1

/***********/
/* write to status line*/
write_userinput:
parse arg amessage
foo=scrwrite(says.!scrrows,13,strip(amessage),3,,(doblink*128)+55)
return 1



/***********/
/* write to status line*/
write_status2:
parse arg amessage
foo=scrwrite(10,12,strip(amessage),66)
return 1

/***********/
/* write to process line*/
write_process:
parse arg amessage
foo=scrwrite(7,22,strip(amessage),55)
return 1

/***********/
/* write to software line*/
write_software:
parse arg amessage
foo=scrwrite(8,22,strip(amessage),55)
return 1


/***********/
/* write to error area */
write_error:
parse arg amessage
if length(amessage)<78 then do
   foo=scrwrite(12,2,amessage,77,,12)
   foo=scrwrite(13,2,' ',77,,12)
   if amessage<>' ' then call lineout logfile,date('n')||' '||time('n')||' ERROR: ' amessage
   return 1
end

/* here for long messages */
oo=leftpos(amessage,' ',77)
if oo=0 then oo=77
a1=left(amessage,oo)
a2=substr(amessage,oo+1)
if length(a2)>77 then a2=left(a2,77)
foo=scrwrite(13,2,a1,,,12)
 call lineout logfile,,date('n')||' '||time('n')||' ERROR: ' a1
foo=scrwrite(14,2,a2,,,12)
 call lineout logfile,'   +++: ' a2

return 1

/***********/
/* write to error area */
write_message:procedure expose says. logfile 
parse arg amessage,attrib,nolog
nrows=says.!scrrows

amessage=translate(amessage,' ','0d0a09011a'x)
if attrib='' then attrib=7
if nolog<>1 then call lineout logfile, amessage

amessage=left(amessage,77,' ')

iat=says.!message.0
if iat<nrows-1 then do
        says.!message.iat=amessage
        says.!message2.iat=attrib
        foo=scrwrite(iat,2,amessage,,,attrib)
        says.!message.0=says.!message.0+1
end
else do             /* rewrite block */
       do jj=15 to nrows-3
          ij=jj+1
          says.!message.jj=says.!message.ij
          says.!message2.jj=says.!message2.ij
       end
       iat=nrows-2
       says.!message.iat=amessage
       says.!message2.iat=attrib
       do iu=15 to nrows-2
          foo=scrwrite(iu,2,says.!message.iu,77,,says.!message2.iu)
       end 
end 

return 1



/******************/
/* check for error, possibly exit */
/* -3=could not connect, -2=could not send , -1= could not recieve , 1= okay */

check_bad_doit:

if wow=-3 then do           /* unable to connect */
   call write_error ' Unable to connect: '||subword(wow,2)
   says.!badconnec=1
end

if wow=-2 then do           /* unable to send  */
   call write_error 'ERROR:  Unable to send: '||subword(wow,2)
end

if wow=-1 then do           /* unable to recieve  */
   call write_error 'ERROR:  Unable to recieve: '||subword(wow,2)
end

if try_restart=0 then return 0          /* signal exit */

foo=write_message("  trying again to connect.... ",,1)

return 1

/**********/
/* kill, then restart sre2003 */
restart_sre:procedure expose logfile bold normal logfile cfgfile says. double_check_kill 
parse arg gospid,killonly

foo=write_status(' Attempting to kill SRE2003 ',,1)
akill=kill_sre(gospid)

/* make sure it's dead? */
if double_check_kill=1 then do
  ii=get_process()
  if ii<>0 then do
      call write_message 'SRE2003 stil alive, try to kill again ..'
      akill=kill_sre(ii,20)
      ii2=get_process()            /* let's be obsessive and check again */
      if ii2<>0 then do
          call write_message 'SRE2003 stil alive, one last attempt to kill ..'
          akill=kill_sre(ii2,20)
      end
  end
end 

select
   when akill=1 then   do
      call write_status  " SRE2003 successfully killed!"
      call write_Process ' '
   end
   when akill=0 then do
     call write_error "ERROR: unable to flag process "gospid" for termination"
     return -1
   end
   otherwise do
     call write_error "unable to kill SRE2003 process "gospid" after 100 seconds "
     return -1
   end
end 
if killonly=1 then return 1

call write_status 'Starting SRE2003 '
gospid=start_sre(ip_name,tryrestart)
if gospid<=0 then do
      call write_error "problem restarting SRE2003 "gospid
      return -1
end /* do */

parse value dospriority(,,gospid) with lvl clas ; clas=strip(clas)
prmess='(Priority Class='says.!priority_levels.clas||', level='lvl')'
call write_process " restarted on " gospid' 'prmess 
call lineout logfile,date('n')||' '||time('n')||' SRE2003 restarted on ' gospid
return 1

/**************/
/* start sre2003 and return it's pid */
start_sre:procedure expose bold normal verbose says. cfgfile logfile  

target='SRE2003.CMD'
if stream(target,'c','query exists')='' then do
   call write_error " Could not find SRE2003,CND "
   return 0
end 

call write_message "Starting  SRE2003 (and pausing a few seconds) ... "
if cfgfile='' then
  address cmd '@START "SRE2003. The SRE2003 http server" /C /B   SRE2003 -watch -i 'cfgfile
else
   address cmd '@START "SRE2003. The SRE2003 http server"   SRE2003 -watch  '

call syssleep 6       /* wait a few seconds */

gpid=get_process()
fp=write_message("SRE2003 started on "gpid,,1)

return gpid

/******************************/
/* find sre2003 process.  Pid if found, 0 if not running, -n if more then one instance */
get_process:procedure expose says. 
toget='SRE2003.'

ii=0
foo=dosswitchlist('namestem','pidstem')
do mm=1 to namestem.0
  if abbrev(translate(namestem.mm),toget)>0 then do
      ii=ii+1
      gospid=pidstem.mm
  end
end 
if ii=0 then return 0 
if ii=1 then return gospid 
if ii>1 then return -ii


/**************************/
/* kill sre on process gospid */
kill_sre:procedure expose says. logfile verbose
parse arg gospid

nm=dosprocinfo('N',gospid)
if nm='' then return 1          /* it's already dead, jim */

/* first, set the shutdown flag */
if macroquery('SRE_FLAG_SET')<>'' then do
  call write_status ' Issuing a SHUTDOWN to SRE2003 '
   aa=sre_flag_set('SHUTDOWN',1,gospid)
end

/* poll for 30 seconds */
do mm=1 to 30
   call syssleep 1
   foo=dosprocinfo('N',gospid)
   if foo='' then return 1
   if (mm//4)=1 then call show_time 'wait on termination' 
end             

/* try killing it with prejudice */
call write_status ' Attempting to kill the SRE2003 process '
foo=doskillprocess(gospid,'P')
if foo=0 then return -1

/* now wait a while for it to close */
if verbose>0 then fo=write_message('  Waiting on SRE2003 termination ...')

do mm=1 to 40      
    foo=dosprocinfo('N',gospid)
    if foo='' then do
         call write_message 'SRE2003 process has been killed '
         return 1
     end
     if (mm//4)=1 then call show_time 'wait on termination' 
     call syssleep 1
end             /* otherwise, it's already dead */

return 0   /* it's still alive? */



/* ------------------------------------------------------------------- */
/* send a request */
/* -3=could not connect, -2=could not recieve, -1=503 error response, 1= okay */

doit:procedure expose gospid  logfile verbose ip_port dotserver server says. bold normal ,
                      timeout_sec  
parse arg amess,get_servername

crlf ='0d0a'x                        /* constants */
bytessent_con='' ;bytessent_Req=''
family  ='AF_INET'
httpport=ip_port

gosaddr.0family=family                  /* set up address */
gosaddr.0port  =httpport
gosaddr.0addr  =dotserver

if amess<>0 then do
  message='HEAD  'amess ' HTTP/1.0'crlf'HOST:'server||crlf
  message=message||crlf
end
else do
  message='TEST TRANSACTION HTTP/1.0'||crlf
  message=message||crlf
end 

tries=0
do vi=1 to 5
  gosock = SockSocket(family, "SOCK_STREAM", "IPPROTO_TCP")
  if verbose>1 then foo=write_message( " ..... trying socket =  " gosock ,,1)
  rc = SockConnect(gosock,"gosaddr.0")
  if rc=0 then leave            /* succesfull connection */
  rc=sockshutdown(gosock,2)
  rc = SockClose(gosock)

  oo=socksock_errno()
  if oo=10061 then do
     if verbose>0 then 
        foo=write_message("  Server not ready, trying again in  few seconds ...",14,1)
  end 
  else do
     foo=write_message(" : Connect error " oo,14,1)
     call show_time "trying to connect "
  end
  if vi=5 then return '-3 Unable to Connect'
  call syssleep  3
end 

If verbose>0 then fo=write_message("  ... connected on socket  "gosock,,1)
if says.!badconnec=1 then do
    call write_error ' '
    says.!badconnec=0
end 
if verbose>1 then ff=write_message(" .... sending message ",,1)

rc = SockSend(gosock, message)
if rc<0 then return '-1 '||socksock_errno()

/* Now wait for the response */
totrc=0
if verbose>0 then ff=write_message(" .... waiting for response ",,1)

rc=sockin(gosock,timeout_sec,1000,,verbose)
if abbrev(rc,'#SOCKIN')>0 then return '-1 'rc
got=rc

rc=sockshutdown(gosock,2)
rc = SockClose(gosock)

parse var got rline '0d0a'x .
parse var rline ih nval nmess  '0d0a'x .
ih=strip(ih)
if left(ih,1)='5' then return '-1  Server error: 'nval' 'nmess         /* server reports a problem */

/* if here, okay */
gotsname=0
if get_servername=1 then do   /* find the "server:" response header */
   do forever
      if got='' then leave
      parse var got a1 '0d0a'x got
      a1a=strip(translate(a1))
      if abbrev(a1a,'SERVER:') then do
         parse var a1 . a1
         call write_software a1
         call lineout logfile,' >>> Server Software: 'a1
         gotsname=1
         leave
      end 
   end 
  if gotsname=0 then do
     call lineout logfile,' Unable to find  Server: (server software) header'
  end
end
return 1' 'got

/*************/
/* get the hostname (numriec.numeric) for this machine */
get_hostname: procedure expose says.
    do queued(); pull .; end                   /* flush */
    address cmd '@hostname'  '| rxqueue'    
    parse pull hostname  
    return hostname



/* --- Load the function library, if necessary --- */
load:




/* enable ansi screen controls */
aesc='1B'x
cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
normal=aesc||'[0;m'
bold=aesc||'[1;m'
re_wh=aesc||'[31;47;m'
reverse=aesc||'[7;m'

/* add current directory to the libpath of this process */
/* this convoluted code is needed due to flakiness of early versions 
   of REXX. Note that on os/2 3.0 systems, you'll have to
   add the DLL subdirectory to your libpath statement */
aa=rxqueue('S','SESSION')
do forever
 if queued()=0 then leave
 pull goo
end
address cmd '@SET BEGINLIBPATH  | rxqueue '
goo=''
if queued() then do
  pull goo
end 
parse var goo . '=' goo 
goo=strip(goo)
aa=rxqueue('S',aa)
maindir=directory()
maindir=translate(maindir,'\','/')
maindir=strip(maindir,,'\')
dlldir=maindir||'\DLL'
if pos(translate(dlldir),translate(goo))=0 then do /*add dll subdir */
  foo=dlldir||';'||goo
  address cmd '@SET BEGINLIBPATH = 'foo
end


if RxFuncQuery("SockLoadFuncs")=1 then do      /* already there */
  call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
  call SockLoadFuncs
end

/* Load up advanced REXX functions */
foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
end

foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end
nsec=trunc(update*60)+1         /* seconds to wait */
if first_hit='' then first_hit='/' 
nbads=0
says.!message.0=15

parse value scrsize() with scrrows scrcols
says.!scrrows=scrrows; says.!scrcols=scrcols


says.!priority_levels.1 = "idle-time"
says.!priority_levels.2 = "regular"
says.!priority_levels.3 = "time critical"
says.!priority_levels.4 = "server"


/* this is orphaned, but keep it anyways */
says.!Priority.1=5              /* starting priority */
says.!Priority.0=10
clas='1 1 2 2 2 2 2 3 3 3 '
lvl='0 25 -15 -10 0 8 20 31 10 31 '
do jj=1 to 10
   says.!priority.!clas.jj=strip(word(clas,jj))
   says.!priority.!lvl.jj=strip(word(lvl,jj))
end 

says.!IsFailure=0

kill_file=strip(kill_file)
if kill_file='0' then kill_file=''


return

/**************************/
/* SOCKIN: a replacement for sockrecv. 
  call as
      stuff=sockin(socket,timeout,maxlen,timeoutmess,verbose)
  where:
     socket == a socket that's been established using sockconnect
    timeout == a timeout value in seconds
    maxlen  == maximum length of message to recieve
               If not specified, then no maximum is imposed
  timeoutmess == Prefix for "error" and "timeout" message.
                 If not specified, "#SOCKIN: " is used as a prefix
                 For example: #SOCKIN: timeout " will be returned if no response
                 was recieved in timeout seconds.
  verbose  == If 1, then report status messages. 
              If not specified, then do NOT report status messages 
and
   stuff = the contents returned from the server (up to maxlen characters)
           or an error message (starting with the timeoutmess)

Note: timeout refers to maximum seconds between "sockrecv" requests. 
      It does NOT refer to total length of time required to recieve a message.
      Thus, a number of medium length delays (say, a few seconds required
      to complete each of several sockrecv requests) will NOT cause a timeout 
      (in other words, the timeout counter is reset upon each successful 
      completion of a 1000 byte sockrecv request).

*/

SOCKIN:PROCEDURE expose says. 
PARSE Arg socket,timeout,maxlen,timeoutmess,verbose

if maxlen=0 | maxlen='' then maxlen=100000000
if timeoutmess=''  then timeoutmess='#SOCKIN:'
if timeout='' then timeout=0.1

if verbose>1 then ff=write_message("  SockIn: will wait for " timeout " seconds ....",,1)

if Sockioctl(socket,'FIONBIO',1) = -1 then /* switch to nonblocking mode */
   Return timeoutmess||'crashed in ioctl 'errno

ict=0
ok=0
incoming=''

Do While TimeOut > 0

    res=Sockrecv(socket,'data',1000) 
    if res=-1 then do                           /* error condition ? */

      If errno <> 'EWOULDBLOCK' THEN       /* real crash ? */
            Return timeoutmess||'crashed in sockrecv 'errno /* yes */

      /* not-fatal,no-data-available-condition:  errno = EWOULDBLOCK & sockrecv returned -1 */

      ict=ict+1
      if verbose>1 then ff=write_message('  SockIn: Waiting ('ict')...',,1)
      Call SysSleep 1              /* relinquish the CPU for one second, this is from REXXUTIL */

      TimeOut = TimeOut - 1; /* count down my timer */
      Iterate; /* loop again */
    End; /* if sockrecv = -1 */
    if res=0 then do
        ok=1 ; leave            /* got end of message, so exit this do loop*/
    end 
    if res<0 then do
         return timeoutmess||" Error in sockrecv " rc
    end
    incoming=incoming||data
    if verbose>1 then
       ff=write_message("  SockIn: total data recieved: "||length(incoming) ,,1)

    if length(incoming)>maxlen then do
       ok=2
       leave
    end 
    ict=0               /* reset counter */
End /* do while timeout > 0 */

/* here we are timed out, or got entire message */
if ok=1  then do
   If sockioctl(socket,'FIONBIO',0) = -1 then do /* switch to blocking mode */
       if verbose>0 then 
          call write_error '  SockIn: ioctl error on switch to blocking mode: ' errno
   end
   return incoming                              /* success! */
end
if ok=2  then do
   if sockioctl(socket,'FIONBIO',0) = -1 then do  /* switch to blocking mode */
      if verbose>0 then 
         call write_error '  SockIn: ioctl error on switch to blocking mode: ' errno
   end
   Return timeoutmess||' message length exceeds maximum of 'maxlen
end

Return timeoutmess||' timeout '


/********************************/
show_time:procedure
parse arg amess
tim=time('n')
oo=scrwrite(1,49,' 'strip(amess)||' '||tim,29,,46)
return 1


/* -------------------- */
/* choose between 3 alternatives (by default,a yes or no ),
return 1 if yes (or 0,1,2 for chosen altenative ) */

yesno:procedure
parse arg amessage , altans,def,arrowok
ahdr=''
if pos('|',amessage)>0 then parse var amessage ahdr '|' amessage
aesc='1B'x
cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
normal=aesc||'[0;m'
bold=aesc||'[1;m'
re_wh=aesc||'[31;47;m'
reverse=aesc||'[7;m'

if altans='' then altans='No Yes'

aynn=' '
if def='' then do
 defans=''
end
else do
 if datatype(def)='NUM' then do
    dd=def+1
    dd2=word(altans,dd)
    defans=translate(left(strip(dd2),1))
 end
 else do
    defans=translate(left(strip(def),1))
 end
end

w.0=words(altans)
do iw0=1 to w.0
     w.iw0=strip(word(altans,iw0))
     a.iw0=translate(left(w.iw0,1))
     aa.iw0=substr(w.iw0,2)
     aynn=aynn||bold
     if  a.iw0=defans then aynn=aynn||cy_ye
     aynn=aynn||a.iw0||normal||aa.iw0
     if iw0<w.0 then aynn=aynn'|'
end
if arrowok=1 then aynn=aynn||' [UP]'
do forever
 foo1=normal||ahdr||reverse||amessage||normal||aynn||' 'normal
 if length(amessage)+length(altans)<78 then
    foo1=normal||ahdr||reverse||amessage||normal||aynn||' 'normal
 else
    foo1=normal||ahdr||reverse||amessage||normal||'0d0a'x||'    '||aynn||' 'normal
 call charout, foo1
 anans=translate(sysgetkey('echo'))
 ianans=c2d(anans)
 if ianans=27 then return defans
 if anans='' | ianans=13 | ianans=10 then  anans=defans

 if arrowok=1 & ianans=0 then do
     ians=c2d(sysgetkey('noecho'))
     if ians=72 then  do
           say ;say
           return -1  /* -1 : up key */
     end
 end /* do */

 do ijj=1 to w.0
    if abbrev(anans,a.ijj)=1 then do
        say
        return Ijj-1
    end
 end /* do */
 call charout,'0d'x
end

/*****************/
/*************/
show_intro:procedure expose normal 
parse arg noww,afile,title
parse value scrsize() with nrows ncols

if afile='' then parse source goo goo2 afile
aesc='1B'x
cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
normal=aesc||'[0;m'
bold=aesc||'[1;m'
re_wh=aesc||'[31;47;m'
reverse=aesc||'[7;m'

ii=0
lins.0=0
do until lines(afile)=0
   foo=linein(afile)
   if  abbrev(strip(foo),'.end ') then leave
   ii=ii+1
   lins.ii=foo
end
lins.0=ii
i1=1
lside=1
if noww=3 then do                        /* ??? */
do ii=1 to lins.0
   say substr(lins.ii,lside,78) 
   iat=ii
end 
exit
end

n19=nrows-4
do forever
do ii=i1 to min(i1+n19,lins.0)
   say substr(lins.ii,lside,78) 
   iat=ii
end 
ll=iat
if iat=lins.0 then ll=ll' (eof)'
ll=ll||','||lside
ms1=ll':ESC,Space,PgUp,PgDn, Arrows, Home, End '
ik=wait_sec(0,ms1,'201b'x||'IQGHPOKM'||'0d0a'x, 0.01)
                     /*Puup PgDN  Home UPArow Dwnaro  End left right cr lf */
if ik=5  then do        /* home */
     call syscls2
     i1=1 ; lside=1
end 
if ik=8 then do         /* end */
  i1=max(1,lins.0-n19) ;lside=1
  call syscls2
end
if ik=9 then do         /* left arrow */
   lside=max(1,lside-1)
  call syscls2
end /* do */
if ik=10 then do                /* right arrow */
   lside=min(lside+1,1500)
   call syscls2
end
if ik=7 then do         /* down arrow */
   if i1+1>lins.0 then do
     ik=1
   end
   else do
     call syscls2
     i1=i1+1
   end 
end
if ik=6 then do         /* up arrow */
   i1=max(1,i1-1)
   call syscls2
end
if ik=4 then do                    /* pgdn */
   i2=iat+nrows-2
   if i2>lins.0 then do
     ik=1
   end
   else do
     call syscls2
     i1=i2
   end 
end
if ik=1 | ik>10 then do
   if iat<lins.0 then do
     i1=iat+1
   end
   else do
     call syscls2
   end
end 
if ik=2 then leave
if ik=3 then do 
   call syscls2
   i1=max(1,i1-20)
end 
   
end 
if noww=2 then return 1
exit

/**/
/* clear screen, write a title, write a seperator bar */
syscls2:
     call syscls
     say ' '||cy_ye||center(title,78)||normal
return 1 

/********/
/* display message, wait do pause seconds. Return keystroke using
position in okays list. If not in okays list, ignore keystroke,
If timeout, return 0. If okays list not specified, okay=' '||esc 
Default is: 1 on space bar, 2 on esc, 0 on timeout */
wait_sec:procedure
parse arg dopause,message,okays,freq
if freq='' then freq=0.2
aesc='1B'x
normal=aesc||'[0;m'
bold=aesc||'[1;m'
if okays='' then okays=' '||'1b0d0a'x
cr='0d'x
if datatype(dopause)<>'NUM' then dopause=5
if dopause=0 then do
 dopause=11111122
 if message='' then 
      message='Hit Esc to cancel, SPACE to continue...'
end
else do
 if message='' then
   message='Hit Esc (within 'dopause' seconds) to cancel, SPACE to continue...'
end
call charout, bold||message||normal
do mm=1 to trunc((1/freq)*dopause)
      ikey=inkey('N')
      if length(ikey)>1 then ikey=right(ikey,1)
      inn=pos(ikey,okays)
      if inn>0 then do 
        call charout, cr||copies(' ',78)||cr
        return inn
      end
      call sre_syssleep(freq)
end
call charout, cr||copies(' ',78)||cr
return 0

/***************/
/* initialize the screen */
start_screen:

jrows=says.!scrrows

foo=scrclear()

call charout, '1b5b'x||'1;1H'||aesc||'['border_fore';'border_back';m'||ulc||copies(hchar,77)||urc||normal

if topmess='' then topmess="SRE Watch"
topmess=left(topmess,37,' ')

call charout, '1b5b'x||'1;7H'||cy_ye||topmess||normal

do mm=2 to jrows-2
  call charout, '1b5b'x||MM||';1H'||aesc||'['border_fore';'border_back';m'||vchar||normal
  call charout, '1b5b'x||MM||';79H'||aesc||'['border_Fore';'border_back';m'||vchar||normal
end

call charout, '1b5b'x||(jrows-1)||';1H'||aesc||'['border_fore';'border_back';m'||llc||copies(hchar,77)||lrc||normal

ffo=cursor(jrows,2)

return 1





/**********
this doesn't work...
          if ikey=43 then do            
              nowpriority=min(1+says.!priority.1,says.!priority.0)
              call write_message "Change priority to " nowpriority
              says.!Priority.1=nowpriority
              clas=says.!priority.!clas.nowpriority
              lvl=says.!priority.!lvl.nowpriority
              ff=dospriority(lvl,clas,gospid) 
              parse value dospriority(,,gospid) with lvl clas ; clas=strip(clas)
              prmess='(Priority Class='says.!priority_levels.clas||', level='lvl')'
              call write_process '   on '||gospid||' 'prmess
          end
          if ikey=45 then do            
              nowpriority=max(says.!priority.1-1,1)
              call write_message "Change priority to " nowpriority
              says.!Priority.1=nowpriority
              clas=says.!priority.!clas.nowpriority
              lvl=says.!priority.!lvl.nowpriority
              ff=dospriority(lvl,clas,gospid) 
              parse value dospriority(,,gospid) with lvl clas ; clas=strip(clas)
              prmess='(Priority Class='says.!priority_levels.clas||', level='lvl')'
              call write_process '   on '||gospid||' 'prmess
          end
***********/
