/* Nov 2003. The SRE2003 installation program */

call init_it
crlf='0d0a'x

cls
say  " " ; say

call lineout, bold cy_ye
call lineout, "This is the SRE2003 (v 1.12) installation program (7 Nov 2003)."
call lineout, "... an http/1.1 server for OS/2 "
call lineout, normal



say cy_ye"  Short disclaimer: "normal
say "    SRE2003 is free, it's open source, and we want to hear"
say "    comments & complaints. However, it is NOT warranteed against "
say "    misuse, abuse, security related problems, and other forms of failure."
if yesno(" Would you like to view the disclaimer?",'No Yes','N')=1 then call show_disclaim


say " This installation program program will ask for the names of a few directories,"
say " and will copy a number of files to these directories."
say "  "

aa=yesno(' Would you like to: ','Exit Continue View_Documentation','C')
if aa=0 then do
 say " See you later?.. "
 exit
end
if aa=2 then do
    say " Okay, viewing the SRE2003 manual ... "
     '@START  "The SRE2003 Manual" /C /F /WIN NETSCAPE file:///SRE2003.HTM'
    say ' '
end

/* first, check tcp/ip version -- suggest upgrade */
'@inetver | rxqueue '
oy=''
do until queued()=0
   pull oy 1
   oy=oy||oy1
end /* do */
parse var oy . ':' aver 
parse var aver mainver '.' subver
if mainver='4' then do
  if subver<'02T' then do
      say
      say bold"WARNING: " normal" Your TCP/IP version is "aver
      say "           We "bold"STRONGLY"normal" recommend upgrading to 4.02t (or above)"
     if yesno(" Continue installing SRE-http (and upgrade TCP/IP later)?")=1 then do
        say "   Okay, but you may experience sporadic errors."
        say ' '
     end
     else do
        say "As of 10 Dec 1998, 4.02t info can be found at: "
        say "   ftp://ps.software.ibm.com/ps/products/tcpip/rsu/stack/latestv4.html"
        say
        say "See you later.... "
        exit
     end /* do */
  end
end



/* check status of sre2003 and macrospace routines */
a=dosswitchlist('l2')
do mm=1 to a
 foo=upper(strip(filespec('n',l2.mm)))
 if foo='SRE2003.CMD' then do
     say bold " SRE2003 appears to be running " normal
     say " Please shut down SRE2003  before you (re) install SRE2003 "
      exit
  end  /* Do */
end /* do */


is_upgrade=yesno(normal" Is this a: "bold" New installation (N), or an upgrade (U)",'New Upgrade')


call check_macro  /* clear macrospace? */


/* -------- Create directories */
call make_def_dirs

foo=sysfiletree(workdir'\SRE2003.CMD','goo','F')
foo=sysfiletree(workdir'\SRE2002.CMD','goo2','F') /* might be upgrading sre2002 version */

if is_upgrade=1 & (goo2.0+goo.0)=0 then do         /*check for prior version */
      say bold"ERROR: "normal" Prior version of SRE2003 "bold"not"normal" detected! "
      exit
end
if goo.0>0  then do             /* backup ? even if "new" installation */
  call do_backup
end

/* --- copy files ... */

if is_upgrade=0 then
  foo=yesno(" SRE2003 will now be installed. Are you ready? ")
else
  foo=yesno(" SRE2003 will now be upgraded. Are you ready? ")

if foo=0 then do
       say "Installation discontinued. "
       say " Please see SRE2003.HTM for more detailed installation instructions."
       exit
end

workdir=worK_dir

dlldir=strip(work_dir,,'\')||'\DLL'

bindir=strip(work_dir,,'\')||'\BIN'

imdir=strip(work_dir,,'\')||'\BIN\IM'


cfgdir=strip(work_dir,,'\')||'\CFG'

/* datadir=strip(work_dir,,'\')||'\WWW'  */

logdir=strip(work_dir,,'\')||'\LOG'
docdir=strip(work_dir,,'\')||'\DOC'
simpledir=strip(work_dir,,'\')||'\SIMPLE'
scriptdir=strip(work_dir,,'\')||'\SIMPLE\SCRIPTS'

sampledir=strip(datadir,,'\')||'\SRE2K'
imgdir=strip(datadir,,'\')||'\SRE2K\IMGS'


say " "
say " Copying  program files "
if gotrxlib=1 then do
   say " Note: a copy of REXXLIB seems to be on your system "
end 
foo=check_copy('*.DLL',dlldir,,1)
foo=check_copy('SRE2003.CMD',workdir,,1)
foo=check_copy('ADD_PLUG.CMD',workdir,,1)
foo=check_copy('SREWATCH.CMD',workdir,,1)
foo=check_copy('DO*.CMD',workdir,,1)
foo=check_copy('GOS2SRE*.CMD',workdir,,1)
foo=check_copy('READ.ME',workdir,,1)

adrive=left(workdir,1)
htype=translate(dosfilesys(adrive))
if abbrev(htype,'H')=0 then 
  foo=check_copy('EDIT-2003.CMD',workdir'\EDT-2003.CMD',,1)
else
  foo=check_copy('EDIT-2003.CMD',workdir,,1)


/* copy to BIN dir */
foo=check_copy('*.EXE',bindir,,1)
foo=check_copy('SRE_*.RXX',bindir,,1)
foo=check_copy('README.BIN',bindir,,1)

foo=check_copy('XRANGE.RXX',imdir,,1)
foo=check_copy('BADIPS.RXX',bindir,,1)
foo=check_copy('BALANCE1.RXX',bindir,,1)
foo=check_copy('TOO_BUSY.RXX',bindir,,1)

foo=check_copy('SRE2003.RXL',bindir,,1)
foo=check_copy('SRE2003.IDX',bindir,,1)
foo=check_copy('SRE2003A.RXL',bindir,,1)
foo=check_copy('SRE2003A.IDX',bindir,,1)

foo=check_copy('INIT*.RXX',bindir,,1)
foo=check_copy('SRE2PRC.ZIP',bindir,,1)
foo=check_copy('MOD_INI.CMD',bindir,,1)

say " Copying  documentation "
foo=check_copy('*.TXT' ,docdir,,1) 
foo=check_copy('SRE2003.HTM' ,docdir,,1) 
foo=check_copy('SRE2PRC.HTM' ,docdir,,1) 
foo=check_copy('im_use.HTM' ,docdir,,1) 


say " Copying sample home page "
foo=check_copy('*.TXT',sampledir,,1)
foo=check_copy('*.HTM',sampledir,,1)
foo=check_copy('*.GIF',imgdir,,1)


say "Copying configuration files "
if is_upgrade=0 then do
  foo=check_copy('*.CFG' ,CFGdir,,1) 
  foo=check_copy('*.IN' ,CFGdir,,1) 
  foo=check_copy('ADD_PLUG.DAT' ,CFGdir,'Are you sure (this is the SRE2003 plugin database)') 
end

oo=sysfiletree('*.CM_','cms','FO')
say "Copy SIMPLE filter and "cms.0" sample scripts "
foo=check_copy('SIMPLE.*',simpledir,,1)
foo=check_copy('FASTFILT.RXX',simpledir,,1)
do mm=1 to cms.0
   parse var cms.mm afile '.' .
   afile=afile||'.CMD'
   tofile=scriptdir||'\'||filespec('n',afile)
   foo=check_copy(cms.mm,tofile,,1)
end
   
if is_upgrade=0 then do
  say " "
  say " Configuring SRE2003.CFG "
  cfgfile=cfgdir||'\SRE2003.CFG'
  ii=stream(cfgfile,'c','query size')
  if ii=0 | ii=''  then do
      say "Error: Unable to configure "cfgfile
      exit
  end 
  stuff=charin(cfgfile,1,ii)
  foo=stream(cfgfile,'c','close')
  oldstring='datadir=\www'
  newstring='datadir='||datadir
  stuff=replacestrg(stuff,oldstring,newstring)
  oo=sysfiledelete(cfgfile)
 if oo<>0 then  do
    say ' Could not remove 'cfgfile
    exit
  end
  foo=charout(cfgfile,stuff,1)
  if foo<>0 then do
     say "Warning: problem replacing "cfgfile
  end 
end


say " "

a=scrclear()

/* add some env vars  for use by filter installers */
a=value('SREINSTALL_SRE2003_DIR',work_dir,'os2environment')
a=value('SREINSTALL_WWW_DIR',datadir,'os2environment')

call lineout, bold cy_ye  " SRE2003 has been installed... " normal
say " "
say ' Your web site is now ready to be built!  '
say '      (just add documents, images, links, etc...)'
say ' '
say ' Notes:'
say '    * To start, run SRE2003.CMD (in 'work_dir')'
say '      By default, SRE2003 uses the SIMPLE filter, and assumes the root '
say '      of your web tree is in 'datadir
say '    * SRE2003.CFG (in 'cfgdir') '
say '      is the SRE2003 configuration file.  You can edit it with '
say '      any text editor.  Or run SRE2003 -m (or SRE2003 -mall)'
say '    * SRE2003.HTM (in 'docdir') is the SRE2003 manual'
say '    * INDEX.HTM (in 'sampledir')  '
say '      contains links to more documents, and links to a few demo scripts.'
say '      To view INDEX.HTM: '
say '         Run SRE2003, and point your browser at /SRE2K/INDEX.HTM'
if is_upgrade=1 then do
say '    * 'bold'Upgraders Note:'normal' If you modified advanced-user options in SRE2003.CMD  '
say '      (and elsewhere), you will need to re-enter those changes. '
end
say '    * 'bold'Security Tip:'normal' The SECURITY_LEVEL parameter (in SRE2003.CFG) can be used'
say '      to disable the web-based configuration tools.'

exit




/***********/
/* installation notes */
goNotes:


return 0


/* ----------------------------------------------------------------------- */
/* HOST -- return the result of a HOST command  (a ping )                  */
/* ----------------------------------------------------------------------- */
/* This need not be in the main filter program                             */
  host: procedure
   parse arg eek
    do queued(); pull .; end                   /* flush */
    address cmd '@host' eek '| rxqueue'     /* execute the command */
    parse pull hostresult                      /* get result */
    return hostresult

/* -------------------- */
/* get a yes or no , return 1 if yes */
yesno0:procedure expose normal reverse bold
parse arg fooa , allopt
ayn='  '||bold||'Y'||normal||'es\'||bold||'N'||normal||'o'
do forever
 foo1=normal||reverse||fooa||normal||ayn
 call charout,  foo1 normal ':'
 pull anans
 if abbrev(anans,'Y')=1 then return 1
 if abbrev(anans,'N')=1 then return 0

end

/* -------------------- */
/* choose between 3 alternatives (by default,a yes or no ),
return 1 if yes (or 0,1,2 for chosen altenative ) */

yesno:procedure expose normal reverse bold cy_ye got_rexxutil opsys noansi varname preimg postimg
parse arg amessage , altans,def,arrowok
ony2:
aynn=' '
if def='' then
 defans=''
else
 defans=translate(left(strip(def),1))
if altans='' then altans='No Yes'

w.0=words(altans)
goo=aynn
do iw0=1 to w.0
     w.iw0=strip(word(altans,iw0))
     a.iw0=translate(left(w.iw0,1))
     aa.iw0=substr(w.iw0,2)
     aynn=aynn||bold
     if  a.iw0=defans then aynn=aynn||cy_ye
     aynn=aynn||a.iw0||normal||aa.iw0
     goo=goo||a.iw0||aa.iw0
     if iw0<w.0 then do
       if noansi=0 then
          aynn=aynn'  '
       else
          aynn=aynn'  '
       goo=goo||'  '
     end
end
if arrowok=1 then aynn=aynn||' [UP]'

do forever
 foo1=normal||reverse||amessage||'? '||normal||aynn||': 'normal
 goo=amessage'?'||goo':'

 if length(goo)<73 then do
    call charout,foo1
 end
 else do
    foo1=normal||reverse||amessage||'? '||normal
    say foo1
    call charout,'     : 'aynn||': 'normal
 end

 if got_rexxutil =1 then do
    anans=translate(sysgetkey('echo'))
 end
 else do
    pull anans
    anans=left(strip(anans),1)
 end

 if anans='?' then do   /* asking for help */
     call online_help varname
     say
     signal ony2
 end 

 ianans=c2d(anans)
 if anans='' | ianans=13 | ianans=10 then  anans=defans

 if arrowok=1 & ianans=0 & got_rexxutil=1 then do
     ians=c2d(sysgetkey('noecho'))
     if ians=72 then  do
           say ;say
           return -1  /* -1 : up key */
     end
 end /* do */

 do ijj=1 to w.0
    if abbrev(anans,a.ijj)=1 then do
        say
        return Ijj-1
    end
 end /* do */
 call charout,'0d'x
end


/* ------------------------ */
/* ask for directory name,use defname2 as default */
/* give user opportunity to create it */

get_dir:procedure expose normal reverse bold re_wh
/* procedure expose reverse normal bold */
parse arg defname2 , mustsub, chkhpfs
defname0=defname2

n2:
call charout ,  reverse ' <ENTER>=' defname2  normal ' ?'
pull godir

if godir=" " then godir=defname2
if godir="n.a." then signal n2


if mustsub<>"" then do    /* check 'must be subdirectory' option */
  if abbrev(godir,mustsub)=0 then do
     say " This directory MUST be under the " mustsub " directory! "
     say "  .. please re enter ! "
     signal n2
  end
end

godir=strip(godir,'t','\')


adrive=left(godir,1)
htype=translate(dosfilesys(adrive))
if abbrev(htype,'H')=0 then do
    say "Warning: although not required, we recommend installing SRE2003 on "
    say '         an HPFS drive. Your chosen drive, 'adrive', is 'htype
    yy=yesno('Would you like to choose a different directory')
    if yy=1  then signal n2
end 


isme=directory()

isnew=directory(godir)
if isnew="" then do
   say "    Could not find  " godir
   if yesno(normal"        "re_wh"Would you like to create it")=1 then do
        oo=sysmkdir2(godir)
        if oo=0  then
           say "      Directory created: " godir
        else do
           say "      Could not create " godir "(error = " oo
           if godir=defname2 then defname2= "n.a."
           signal n2
        end
   end
   else do
        say " please reenter directory name ... "
        if godir=defname2 then defname2= "n.a."
        signal n2
   end
end  /* Do */


isme=directory(isme)



return godir

/* ------------- */
sysmkdir2:procedure
parse arg adir

adir=strip(adir,'t','\')
ff=sysmkdir(adir)
if ff=0 then return ff

/* make the tree */
f2=adir'\'
dd=filespec('d',f2)
pp=filespec('p',f2)
if pp='\' | pp='' then return -1

pp2=strip(translate(pp,' ','\'))

do mm=1 to words(pp2)
   a1=subword(pp2,1,mm)
   a1=translate(a1,'\',' ')
   dd2=dd'\'a1
   hoo=sysmkdir(dd2)
   if hoo=0 then say ' ... creating: 'dd2  
end /* do */

return hoo


/* ------------- */
/* ----------------------------------------------------------------------- */
/* REPLACESTRG: In string astring, find first occurence substring target and
.   replace it with substring putme
.      if no target, return unchanged astring
.      if no putme, then remove target
.      if type=backward, then find/change LAST occurence
.      if type=all, find/change all occurences
.      if exactmatch=yes, then do not capitalize during search (exact match only */
/* ----------------------------------------------------------------------- */

replacestrg: procedure

exactmatch=0
backward=0 ; doall=0

parse arg astring ,  target   , putme , type , exactmatch

type = translate(type)
if type="BACKWARD" then backward="YES"
if type="ALL" then doall="YES"

iat=1
joelen=length(target)
joelen2=length(putme)

doagain:                /* here if doall=yes */
 if exactmatch="YES" then do
    if   backward="YES" then
        joe= lastpos(target,astring)
    else
        joe= pos(target,astring,iat)
 end
 else do
   if   backward="YES" then
        joe= lastpos(translate(target),translate(astring))
    else
        joe= pos(translate(target),translate(astring),iat)
 end
 if joe=0 then
         return astring

 astring=delstr(astring,joe,joelen)
 if putme<>' ' then
    astring=insert(putme,astring,joe-1)

 if doall="YES" then do
     iat=joe+joelen2
     signal doagain
 end
/* else, all done */
 return astring

/* ----------------------------------------------------------------------- */
/* GRAB_FILE read in a file, but first check to see if openable, and if
.   openable, open and read it.
.    Returns with the file, or with 0 if file not obtainable.
.    Note that file is closed before returning
.   in,
.    usage:   afile_string=grab_file(the_file,seconds_to_try_for)
*/
/* ----------------------------------------------------------------------- */


grab_file: procedure

parse arg afile

ause=stream(afile,'c','open read')
if ause<>"READY:" then
  return 0

goo=charin(afile,1,chars(afile))
ause=stream(afile,'c','close')

/* get rid of ending ctl-z */
if c2d(right(goo,1))=26 then
  goo=left(goo,length(goo)-1)

return goo


/*******************************************/
/* check for existence of file, then ask user to copy or not */
/* note that for X.* type copies, it only checks once
   (not for each file, but just for any one of them */
/********************************************/
check_copy: procedure expose  reverse bold normal re_wh
parse arg file1, dest1 , amess , noask
dest2=strip(dest1,'t','\')||'\'

filename=dest1
if pos('.',dest1)=0 then filename=dest2||file1


aa=sysfiletree(filename,isit,'F')
ok=1
if aa<>0 then do
   say " Warning: error when looking for pre-existing copy of: " filename
   ok=yesno(" Do you want to copy this file (or files) anyways? ")
   if ok=1 & amess<>""  then
      ok=yesno(amess)
end

if noask=1 then signal doit3

if isit.0>0 then do
  if pos('*',file1)=0 then do
      say " "
      say " A file exists with the name: " filename
      ok=yesno(" Do you want to overwrite this file? ")
      if ok=1 & amess<>""  then  ok=yesno(amess)

  end
  else do
    say " "
      say " There is at least one file that matches: " filename
      say "  (this match may " bold " not " normal " be one of the files that will be copied!) "
      ok=yesno(" Do you want to copy these files? ")
  end  /* Do */
end
if ok=0 then return 0

doit3:          /* jump here if noask=1 */
'COPY ' file1 dest1 ' > NUL '

return 1




 /* ------------------------------------------------------------------ */
 /* function: Check if ANSI is activated                               */
 /*                                                                    */
 /* call:     CheckAnsi                                                */
 /*                                                                    */
 /* where:    -                                                        */
 /*                                                                    */
 /* returns:  1 - ANSI support detected                                */
 /*           0 - no ANSI support available                            */
 /*          -1 - error detecting ansi                                 */
 /*                                                                    */
 /* note:     Tested with the German and the US version of OS/2 3.0    */
 /*                                                                    */
 /*                                                                    */
 CheckAnsi: PROCEDURE
   thisRC = -1

   trace off
                         /* install a local error handler              */
   SIGNAL ON ERROR Name InitAnsiEnd

   "@ANSI 2>NUL | rxqueue 2>NUL"

   thisRC = 0

   do while queued() <> 0
     queueLine = lineIN( "QUEUE:" )
     if pos( " on.", queueLine ) <> 0 | ,                       /* USA */
        pos( " (ON).", queueLine ) <> 0 then                    /* GER */
       thisRC = 1
   end /* do while queued() <> 0 */

 InitAnsiEnd:
 signal off error
 RETURN thisRC




/* get the hostname (aa.bb.cc) for this machine */
get_hostname: procedure expose re_wh
    do queued(); pull .; end                   /* flush */
    address cmd '@hostname | rxqueue'

    parse pull hostname
    return hostname



/******/
get_work_dir:

call lineout, bold  " What is SRE2003's working directory? " normal
say "    *  This is where the SRE2003 program files will be installed. "

n1:
work_dir=get_dir(defname)

say "Installing to: " work_dir
return 0

/**********/
get_www_dir:

say " "
call lineout, cy_ye" + + + + "normal BOLD " What is your data directory ?" normal
say  '    .. this is  the location of your "home page" document. '

datadir=get_dir(defname2)
return 0

/*********/
get_ip_address:
say "What is your IP address (it will be given OWNERS status)"
ipaddr=" "
thishost=get_hostname()
sagain:
call charout , BOLD "What is your IP address (ENTER="thishost "):? " normal
pull youraddr
if youraddr=' ' then youraddr=thishost

parse var youraddr t1 '.' .
isnum=0
if  datatype(t1)='NUM' then
  isnum=1
say " wait while that address is checked ... "
chk=host(youraddr)
if translate(word(chk,2))<>"IS" &  word(chk,2)<>"=" then do
    call lineout,re_wh " Unable to find  address: " youraddr normal
    say "    OWNER variable not assigned (but you can assign it later)"
    ipaddr=" "
end  /* Do */
else do
   if isnum then
     ipaddr=word(chk,1)
   else
     ipaddr=word(chk,3)

   say " Your IP address: " ipaddr
end
return 0

/***************/
init_it:

/* Load up advanced REXX functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

nowdir=directory()

initfilt_file=''
echo off


/* --- Load the tcp/ip function library, if necessary --- */
if RxFuncQuery("SockLoadFuncs")=1 then  do    /* not there */
  call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
  call SockLoadFuncs
end

thishost=' '


parse version  atype .
if atype<>"REXXSAA" then do
 say    " WARNING: SRE2003 is designed to work under Classic Rexx "
 say     " In particular, it does NOT work under Object Rexx. "
 say     " Other versions of REXX, such as Quercus's REXX, have not been tested."
 say " Note: You are using REXX version: " atype
 say " (hit ENTER to continue) "
  pull .
end  /* Do */


/*---- load the rexxlib library */
droprxlib=0 ; gotrxlib=1
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 droprxlib=1 ; gotrxlib=0
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
    say " Could not find the REXXLIB procedure library (REXXLIB.DLL). "
    exit
end  


ansion=checkansi()
if ansion=1 then do
  aesc='1B'x
  cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
  normal=aesc||'[0;m'
  bold=aesc||'[1;m'
  re_wh=aesc||'[31;47;m'
  reverse=aesc||'[7;m'
end
else do
  say " Warning: Could not detect ANSI....  Install will look ugly ! "
  cy_ye="" ; normal="" ; bold="" ;re_wh="" ;
  reverse=""
end  /* Do */

/* some defaults */
    datadir="your  Data-directory"
    workdir="your  Working-directory"


return 0


/*********/
check_macro:
if macroquery('SRE_COMMAND')<>"" then do
     say " "
     say bold "A prior version of the SRE2003 macrospace procedures"normal
     say " was detected. We recommend clearing macrospace before you install SRE2003."
     say " However, this might adversely impact other programs (that may also "
     say " use REXX's macrospace). "
     ok=yesno(" Clear macrospace now (Y) ?")
     if ok=1 then do
        say " .... clearing macrospace "
        foo=macroclear()
        say " "
     end  /* Do */
     else do
          say " "
        say  bold " Macrospace will not be cleared. " normal
        say " When you are ready to run SRE2003, we recommend "
        say " that you first reboot your server."
          say " "
     end  /* Do */
end  /* Do */
return 0


/************/
make_def_dirs:

    adir=filespec("drive",nowdir)
    defname=adir||'\SRE2003'
    defname2=adir||'\WWW'

    call get_work_dir        /* but ask for a few directories */
    call get_www_dir

    gosds='BIN DLL BIN\IM TEMP CFG CFG\OLD DATA LOG DOC SIMPLE BAK SIMPLE\SCRIPTS LOG\ARC'
    wwwds='SRE2K SRE2K\IMGS '

   say "Note: The following sub directories will be created... "
   say  " under "work_dir ":   "
   say  "     "bold||subword(gosds,1,10)||normal
   say  "     "bold||subword(gosds,11)||normal
   say  " under "datadir" :  "
   say  "      "bold||wwwds||normal

    workdir=work_dir

    do ii=1 to words(gosds)
       a1=strip(word(gosds,ii))
       mdd=workdir'\'a1
       if dosisdir(mdd)=0 then do
          oo=sysmkdir(mdd)
          if oo<>0 then do 
            say 'ERROR: Could not create 'mdd ', error code= ' oo
            exit
         end /* do */
       end
    end /* do */
    do ii=1 to words(wwwds)
       a1=strip(word(wwwds,ii))
       mdd=datadir'\'a1
       if dosisdir(mdd)=0 then do
          oo=sysmkdir(mdd)
          if oo<>0 then do then
            say 'ERROR: Could not create 'mdd ', error code= ' oo
            exit
          end /* do */
       end
    end /* do */
return 1


/**************************************/
/* backup prior version */
do_backup:

 say " "
 foo=yesno(normal" "re_wh"Would you like to archive the various configuration files",,'Y')
 if foo=1 then do
      say  " Where should SRE2003 archive these files"
      aa="\BAK\BK"||space(translate(date('o'),' ','/\'),0)
      backup_dir=strip(get_dir(workdir||aa),,'\')||'\'
/* files to backup*/
      baks='SIMPLE\SIMPLE.RXX SIMPLE\FASTFILT.RXX SRE2003.CMD CFG\SRE2003.CFG ',
            'CFG\BADIPS.IN CFG\HOSTINFO.CFG SREWATCH.CMD'
     nocopy=0 ; yescopy=0
     do mm=1 to words(baks)
          a1=strip(word(baks,mm))
          oldfile=workdir||'\'||a1
          goo=stream(oldfile,'c','query exists')
          if goo='' then do
                say "Could not find "oldfile
                nocopy=nocopy+1
                iterate
          end /* do */
          tfile=backup_dir||a1
          newname=filespec('n',tfile)
          newfile=backup_dir||newname
          foo=check_copy(oldfile,newfile,,1)    
          goo=stream(newfile,'c','query exists')
          if newfile<>'' then do
              yescopy=yescopy+1
          end
          else do
             say "Problem copying "oldfile " to " newfile
             nocopy=nocopy+1
          end
     end 
     if yescopy>0 then say yescopy||' files were copied to 'backup_dir
     if nocopy>0 then say nocopy||' files were NOT copied to 'backup_dir

     say
      yooba=sysfiletree(workdir||'\BK*','goos','OD')
      if goos.0>1  then do
          say bold' Reminder:'normal' you have 'goos.0 ' SRE2003 archive directories; you might  '
          say     '          want to remove some of the older ones. '
      end /* do */
 end
return 0


/*********************************/
/* display the disclaimer */

show_disclaim:
say
say reverse "          Summary of the SRE2003 disclaimer"normal
say bold"The complete disclaimer is  contained in SRE2003.HTM"normal
say "  With some provisos, permission to use this program for any "
say "  purpose is hereby granted without fee. These provisos include:" 
say "   * the author's name may not be used in advertising or "
say "     publicity pertaining to distribution of the software "
say "     without specific written prior permision."
say "   * The authors of SRE2003, and any potentially affiliated institutions,"
say "     disclaim any and all liability for damages due to the use, misuse, or"
say "     failure of this product or related products."
say "         In particular, SRE2003 and related products are NOT "
say "         guaranteed to be secure.  Although we design and code our "
say "         product with attention to potential security holes, "
say "         we can NOT guarantee security."

    call charout , cy_ye ' (hit any key to continue) ' normal
    foo=SYSGETKEY("NOECHO")
say
return
