/* Program to convert "goserve" style programs  to SRE2003 style.
  It will search for all occurences of "completion" codes, and convert
  them. In particular:
  'FILE speclist' -- > foo=sre_command('FILE speclist')
  'VAR speclist name varname ' --> foo=sre_command('VAR SPECLIST ',varname)
  'EXTRACT varname ' -- > varname=sre_command('EXTRACT VARNAME')   
  'HEADER a header ' --> foo=sre_command('HEADER a header ')

*/

/******* User changeable parameters ****/

fileviewer='LST '

reportfile='gos2sre.rpt'

/*******  End of user changeable parameters ****/


call initit

parse arg infile
if infile='' then do
  call charout," Enter a filename (? for help): "
  parse pull infile
end

if infile='?' then do
   call helpme
   return 'no '
end 

if pos('*',infile)>0 then do
   foo=sysfiletree(infile,'infiles','FO')
   say "Pattern matches "infiles.0 " files."
end 
else do
   infiles.0=1 ; infiles.1=infile
end /* do */

autofix=yesno('Automatically convert ','AskFirst Yes CommentAlso')
report=yesno('Create a report (of all the changes) ')
if report=1 then do
   say reportfile ' will contain a list of changes '
   foo=sysfiledelete(reportfile)
end 

diddo=0

do jjm=1 to infiles.0
   filename=infiles.jjm
   if autofix=1 then
     ayy=1
   else
     ayy=yesno(cy_ye||' :: '||normal||bold||'Process 'filename,'No Yes Abort')
   if ayy=0 then iterate
   if ayy=2 then leave
    
   sz=stream(filename,'c','query size')
   if sz='' | sz=0 then do
      say "ERROR: no such file: " filename
      return 0
   end 

/* rename current file */
   ii=lastpos('.',filename)
   if ii=0 then ii=length(filename)+1
   fileroot=left(filename,ii-1)
   ok=0
   do mm1=1 to 99
       infile=fileroot||'.V'||mm1
       if stream(infile,'c','query exists')<>'' then iterate
       foo=dosrename(filename,infile)
       if foo=0 then do
          say "ERROR: Unable to rename "filename" to " infile
          return 0
       end 
       say bold||jjm||') '||normal||filename ||bold||" renamed to " ||normal||infile
       ok=1
       leave
   end 
   if ok=0 then do
       say " ERROR: unable to find unused name for backup file of " fileroot
       return 0
   end
   diddo=diddo+1
   foo=doit(infile,sz,filename)
end /* do */

say "Total of " diddo " files processed "
if report=1 then say "A report was written to "reportFile

return 0

/*****************************************/

/* do it here */
doit:procedure expose cy_ye bold normal reverse fileviewer autofix report reportfile fixcomments.

crlf='0d0a'x

parse arg infile,sz,outfile

stuff=charin(infile,1,sz)

ii=pos('00'x,stuff)
fixcomments.=0
if ii=0 then do
  call fix_comments
  say fixcomments.0 " comments accounted for "
end 

foo=stream(infile,'c','close')
say "File read: "sz " bytes "
/* create two list: original lines, and "concatenated lines */
origs.=0
concats.=0
isconcat=0
do forever
    if stuff='' then leave

    parse var stuff aline (crlf) stuff

    iat=origs.0+1
    origs.iat=aline
    origs.0=iat
    icomm=lastpos(',',aline)
    if isconcat=1 then do
       isconcat=0         /* do NOT concatenate next line */

       if icomm>0 then do
         if icomm=length(strip(aline,'t',' ')) then do
             ISCONCAT=1
             aline=left(aline,icomm-1)
          end 
          else do
          end 
       end
       iat=concats.0
       concats.iat=concats.iat||aline
       CONCATS.IAT.!LIST=CONCATS.IAT.!LIST' 'ORIGS.0    /* POINTS TO NEXT "ORIGINAL" */

    end 
    else do             /* A NEW LINE */
       isconcat=0
       if icomm>0 then do
         if icomm=length(strip(aline,'t',' ')) then DO
             isconcat=1
             aline=left(aline,icomm-1)
         END
       END
       iat=concats.0+1
       concats.iat=aline
       concats.0=iat
       CONCATS.IAT.!LIST=ORIGS.0    /* POINTS TO FIRST "ORIGINAL" */
   end
end /* do */

say "File parsed: "origs.0 " lines  comprising "concats.0" statements."

/* we now have the "concatenated" lines 
  Process them, looking for 'EXTRACT, 'FILE, "keyword" 
*/


keywords='EXTRACT FILE HEADER VAR CONTROL NODATA READ RESPONSE WAIT STRING SEND QUERY CLOSE AUDIT'
nkeys=words(keywords)

nissay=0
outstuff=''
newlines=0
nchanges=0
if report=1 then  do
 call lineout reportfile,' '
 call lineout reportfile,'*** >> ' outfile '( old version renamed to 'infile')'
end

DO MM=1 TO CONCATS.0
  mightbe=''
  if pos('"',concats.mm)+pos("'",concats.mm)=0 then do  /* no quote, so no chance of keyword  */
      call write_toout mm
      iterate
  end
/* any of the keywords? */
  taline=translate(concats.mm)
  if wordpos('SAY',taline)>0 then do
        nissay=nissay+1
        if report=1  then do 
            call lineout reportfile,'??? SAY in line 'newlines': 'concats.mm
         end
  end
  gotit=0
  do jj=1 to nkeys
      kw=strip(word(keywords,jj))
      if pos(kw,taline)>0 then do
/* is keyword directly preceded by a ' or " ? */
         gotit=parse_1(taline,kw)
         if gotit<>0 | mightbe<>'' then leave
         iterate
      end
   end
   if gotit=0 then do
       if mightbe<>'' then do
         newlines=newlines+1
         outstuff=outstuff||'/**** ??? The next line may need to be changed ***/'||crlf
         if report=1 then do
            call lineout reportfile,'??? Questionable line at 'newlines': 'concats.mm
         end
       end
       cc=write_toout(mm)
       iterate
   end 

 do forever             /* might need another shot at this line */
  say " "
  foo=line_show(mm, concats.mm,gotit)
  if autofix=1 then
    ians=2
  else
    ians=yesno(normal||bold||' ??'||normal,'Retain Skip Modify Comment Flag ViewFile ','R')
  select
     when ians=0 then do
       call write_toout mm
       leave
     end 
     when ians=1 then do                /* skip */
        nchanges=nchanges+1
        if report=1 then do
           call lineout reportfile,'Skipped line: 'concats.mm
        end 
        leave
     end 
     when ians=2 then do

/* propose a candidate */
        call fig_suggest

        if suggest<>'' then do 
           foo=line_show('>>>',suggest)
           select
              when autofix=1 then  njj=1
              when autofix=2 then njj=3  /* flag also */
              otherwise  njj=yesno(normal||bold||'Use suggestion'||normal,'No Yes CommentAlso FlagAlso Stop')
           end
           if njj=4 then iterate                /* do this line again */
           if njj=3 then do
               newlines=newlines+1
               outstuff=outstuff||'/**** This line was changed ***/'||crlf
           end
           if njj>0 then do
                outstuff=outstuff||suggest||crlf
                newlines=newlines+1
           end
           if njj=2 then do
                outstuff=outstuff||'/**** ---- Prior version of above:'||crlf
                foo=write_toout(mm,1)
                outstuff=outstuff||'****/'||crlf
                newlines=newlines+2
           end
           if njj>0 then do
              nchanges=nchanges+1
              if report=1 then do
                call lineout reportfile,'Changed: '||strip(fix_comments_2(concats.mm))
                call lineout reportfile,'..'||left(newlines,5)||': '||strip(fix_comments_2(suggest))
              end 
              leave
           end
        end 
      
/* if here, no suggestion was made */
        say "Enter new line (ENTER on blank line when done): "
        toput=''
        do forever
           call charout, reverse' ? 'normal
           parse pull aline
           if aline='' then leave
           toput=toput||aline||crlf
           newlines=newlines+1
        end 
        outstuff=outstuff||toput
        if report=1 then do 
           call lineout reportfile,'Changed: '||strip(fix_comments_2(concats.mm))
           call lineout reportfile,'..'||left(newlines,5)||': '||strip(fix_comments_2(toput))
        end 
        nchanges=nchanges+1

     end

     when ians=3 then do
       outstuff=outstuff'/**** ---- Comment out:'||crlf
       call write_toout mm
       outstuff=outstuff||'****/'||crlf
       newlines=newlines+2
       leave
     end
     when ians=4 then do
       outstuff=outstuff||'/**** ---- CHECK THIS FOR GOSERVE CONTROL WORD ---- */'||crlf
       call write_toout mm
       outstuff=outstuff||'/**** ----      ======================        ---- */'||crlf
       newlines=newlines+2
       leave
     end 
     when ians=5 then do
        say
        say bold"       Viewing "infile||normal
        say "          (look for lines "concats.mm.!list')'
        '@start /f /c "Look for lines: '||concats.mm.!list'" '||fileviewer||' 'infile
        iterate
     end 
     otherwise nop
  end
  leave
 end            /*loop for this line */
END

if fixcomments.0>0 then do 
  outnew=''
  do mm=1 to fixcomments.0
     kk='00'x||mm||'01'x
     parse var outstuff p1 (kk) outstuff
     outnew=outnew||p1||fixcomments.mm
  end
  outstuff=outnew||outstuff
end   

if nchanges>0  then do
   outstuff='/* 'nchanges' GoServe-syntax commands converted to SRE2003-syntax ('||time('n')||' '||date('n')||') */'||crlf||outstuff
end 


foo=stream(outfile,'c','open write')
foo=charout(outfile,outstuff,1)
foo=stream(outfile,'c','close')

if report=1 then do 
    call lineout reportfile,'### : Number of changes= 'nchanges
    if nissay>0 then do
       call lineout reportfile,' Note: 'nissay' occurrences of SAY.'
       call lineout reportfile,'       Consider changing these to SRE_SAY or SRE_PMPRINTF '
    end
    call lineout reportfile
end
return 0



/****************/
/* parse out comments, store in fixcomments. stem */
fix_comments:procedure expose stuff fixcomments.

i1=1
big1=9999999
do forever
  iq3=pos('/*',stuff,i1) 
  if iq3=0 then leave           /* no more comments */
  iq1=pos('"',stuff,i1) ; if iq1=0 then iq1=big1
  iq2=pos("'",stuff,i1) ; if iq2=0 then iq2=big1

  select                        /* " is first */
     when iq1<iq2 & iq1<iq3 then do
       iq11=pos('"',stuff,iq1+1)
       if iq11=0 then leave             /* no ending ", so exit */
       i1=iq11+1
       iterate                  /* skip to after second " */
     end
     when iq2<iq1 & iq2<iq3 then do    /* ' is first */
       iq11=pos("'",stuff,iq2+1)
       if iq11=0 then leave             /* no ending ', so exit */
       i1=iq11+1
       iterate                  /* skip to after second " */
     end
     when iq3<iq1 & iq3<iq2 then do  /* comment, remove it! */
       iq11=pos("*/",stuff,iq3+1)
       if iq11=0 then leave             /* no ending  so exit */

       nthc=fixcomments.0+1
       fixcomments.nthc=substr(stuff,iq3,1+(iq11+1)-iq3)
       fixcomments.0=nthc

       if (iq3=1) then
         stuff='00'x||nthc||'01'x||substr(stuff,iq11+2)
       else
          stuff=left(stuff,iq3-1)||'00'x||nthc||'01'x||substr(stuff,iq11+2)
       i1=iq3+1
       iterate                  /* skip to after second " */
     end 
     otherwise nop
  end
end
return 1

/***************/
/* initialiaztion */
initit:
foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 droprxlib=1 ; gotrxlib=0
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
    say " Could not find the REXXLIB procedure library (REXXLIB.DLL). "
    say "  Did you download it? "
    exit
end  /* Do */

aesc='1B'x
cy_ye=aesc||'[37;46;m'
normal=aesc||'[0;m'
bold=aesc||'[1;m'
reverse=aesc||'[7;m'

say "     "cy_ye"Convert GoServe-syntax to SRE2003-syntax"normal

return 0

/*****************/
/* determine likely change */
fig_suggest:
        icc=0 ; aphrase='';suggest=''
        do forever
          icc=pos(gotit,translate(concats.mm),icc+1)
          if icc=0 then leave           /* could not find a phrase */
          p1=left(concats.mm,icc-1)

          p2=substr(concats.mm,icc)
          ap2=substr(p2,length(gotit)+1,1)
          if pos(ap2,' '||'"'||"'"||'09'x)=0 then iterate  /* this is a substring */

          ap1=right(strip(p1),1)
          if pos(ap1,'"'||"'")=0 then iterate /* this is not a quoted keyword */

          aphrase=substr(concats.mm,icc)
          sp1=strip(p1,'t',' ')
          sp1=left(sp1,lengtH(sp1)-1)
          ll=pos('00'x,aphrase)
          bphrase=''
          if ll>0 then do
             bphrase=' 'substr(aphrase,ll)
             aphrase=left(aphrase,ll-1)
          end
          if gotit='VAR' then do                /* search for NAME varname */
              if pos('NAME',translate(aphrase))>0 then
                 parse upper var aphrase . ' NAME ' varname .
              else
                 parse upper var aphrase . 'NAME' varname .
              varname=space(translate(varname,' ',"'"||'"'||'09'x),0)
              suggest=sp1||" foo=sre_command('"||strip(aphrase)||","||varname||')'||bphrase
          end 
          else do
             suggest=sp1||" foo=sre_command('"||strip(aphrase)||')'||bphrase
          end
          leave
        end

        return 0



/*****/
/* "pretty" write a long line */
line_show:procedure   expose normal bold reverse cy_ye fixcomments.
parse arg mm0,aline,daword

aline=fix_comments_2(aline)

daword=strip(daword)
aline=strip(aline,'l',' ')
if length(aline)<72 then do
    if daword<>'' then   aline=replacestrg(aline,daword,bold||daword||normal,'ALL','N')
    say reverse||left(mm0,6)||normal||aline
    return 0
end
tmp=''
asp=' '
i1=0
do forever
  if aline='' then leave
  parse var aline t1 (asp) aline
  if length(tmp)+length(t1)<72 then do
       tmp=tmp||t1||asp
       iterate
  end /* do */
  else do
     i1=i1+1
     if i1=1 then do
         if daword<>'' then tmp=replacestrg(tmp,daword,bold||daword||normal,'ALL')
         say reverse||left(mm0,6)||normal||tmp
     end
     else do
         if daword<>'' then tmp=replacestrg(tmp,daword,bold||daword||normal,'ALL')
         say reverse||left(' ',6)||normal||tmp
     end
     if length(t1)>73 then do                          /* a long word */
        icc=lastpos(',',t1,72)
        if icc=0 then icc=72
        tmp=left(t1,icc)
        aline=substr(t1,icc+1)||' '||aline
     end
     else do
        tmp=t1||asp 
     end 

  end
end 

if tmp<>'' then  do
     i1=i1+1
     if i1=1 then do
        if daword<>'' then  tmp=replacestrg(tmp,daword,bold||daword||normal,'ALL')
         say reverse||left(mm0,6)||normal||tmp
     end
     else do
         if daword<>'' then tmp=replacestrg(tmp,daword,bold||daword||normal,'ALL')
         say reverse||left(' ',6)||normal||tmp
     end
end
return 0

/**************/
fix_comments_2:procedure expose fixcomments.
parse arg aline
if fixcomments.0>0 then do 
  do forever
    if pos('00'x,aline)=0 then leave
    parse var aline p1 '00'x p2 '01'x p3
    aline=p1||fixcomments.p2||p3
  end
end 
return aline

/*****/
/* parse, see if  quote keyword appears */
parse_1:procedure expose mightbe  
parse arg taline,keyw

/* make sure the keyw is really in there */
foo=translate(taline,' ','"'||"'"||'0d0a09'x)
if wordpos(keyw,foo)=0 then return 0            /* nope, must have been a substring */

/* see if this is a say , charout, lineout,  */
  tt=strip(space(taline))
  if abbrev(tT,'SAY') then do
    return 0   /* a SAY */
  end
  if abbrev(tT,'CALL LINEOUT') then return 0  /* a call lineout xxx, */
  if abbrev(tT,'CALL CHAROUT') then return 0  /* a call lineout xxx, */
  if pos('=CHAROUT(',word(taline,1))>0 then return 0 /* xxx=charout( */

do forever
   if pos(keyw,taline)=0 then return 0

   if taline='' then return 0           /* nothing left, not really a keyword */
   parse var taline t1 (keyw) taline
   t1=space(translate(t1,' ','09'x),0)

   if right(t1,1)<>'"' & right(t1,1)<>"'" then iterate   /* not preceded by quote, so not a keyword */

   ac=left(taline,1)
   if pos(ac,' '||'09'x||'"'||"'")=0 then iterate /* substring, and not a keyword */

   t1=strip(space(t1))
   lent1=length(T1)
   if lent1<1 then return 0

   if lent1>1 then do
      ac=substr(t1,lent1-1,1)

/* is this and argument to a function, or part of a comparison? */
      if pos(ac,',(<>|')>0 then iterate    /* it is -- so not a keyword */

      if ac='=' then do    /* = : might be something like ff='file name ' ; ff ; */
          if pos('NAME ',taline)+pos('AS ',taline)>0 then do
              mightbe=keyw
              iterate
          end 
          else do
              iterate
          end 
      end 

     if lent1>5 then do
        ac3=substr(t1,lent1-4,4)
        if ac3='THEN' then return keyw
     end

      if pos('(',t1)>0 then do    /* = : might be something like foo=aproc('FILE xxx  */
          mightbe=keyw
          iterate
      end 

   end

   if lent1>2 then do
     ac3=substr(t1,lent1-3,3)
     if ac3='SAY' then iterate            /*  part of a "SAY", then not a keyword */
   end


   return keyw                    /* this is a keyword! */

end 

/*****/
/* write original lines to outfile */
write_toout:procedure expose concats. outstuff newlines origs. crlf fixcomments.
parse arg mm1,fixit
do jj=1 to words(concats.mm1.!list)        
   il=strip(word(concats.mm1.!list,jj)) 
   if fixit=1 then
      outstuff=outstuff||fix_comments_2(origs.il)||crlf
   else
      outstuff=outstuff||origs.il||crlf
   newlines=newlines+1
end 
return 0


/* -------------------- */
/* choose between 3 alternatives (by default,a yes or no ),
return 1 if yes (or 0,1,2 for chosen altenative ) */

yesno:procedure expose normal reverse bold cy_ye     
parse arg amessage , altans,def,arrowok
ony2:
aynn=' '
if def='' then
 defans=''
else
 defans=translate(left(strip(def),1))
if altans='' then altans='No Yes'

w.0=words(altans)
goo=aynn
do iw0=1 to w.0
     w.iw0=strip(word(altans,iw0))
     a.iw0=translate(left(w.iw0,1))
     aa.iw0=substr(w.iw0,2)
     aynn=aynn||bold
     if  a.iw0=defans then aynn=aynn||cy_ye
     aynn=aynn||a.iw0||normal||aa.iw0
     goo=goo||a.iw0||aa.iw0
     if iw0<w.0 then do
       aynn=aynn'  '
       goo=goo||'  '
     end
end
if arrowok=1 then aynn=aynn||' [UP]'

do forever
 foo1=normal||reverse||amessage||'? '||normal||aynn||': 'normal
 goo=amessage'?'||goo':'

 if length(goo)<73 then do
    call charout,foo1
 end
 else do
    foo1=normal||reverse||amessage||'? '||normal
    say foo1
    call charout,'     : 'aynn||': 'normal
 end

 anans=translate(sysgetkey('echo'))

 ianans=c2d(anans)
 if anans='' | ianans=13 | ianans=10 then  anans=defans

 if arrowok=1 & ianans=0  then do
     ians=c2d(sysgetkey('noecho'))
     if ians=72 then  do
           say ;say
           return -1  /* -1 : up key */
     end
 end /* do */

 do ijj=1 to w.0
    if abbrev(anans,a.ijj)=1 then do
        say
        return Ijj-1
    end
 end /* do */
 call charout,'0d'x
end


/***************/
/* return 0 for no, 1 for yes, default otherwise */
is_yes_no:procedure expose bold normal  reverse cy_ye 
parse arg aval,def
tdef=strip(translate(aval))
if wordpos(tdef,'Y YES 1')>0 then return 1
if wordpos(tdef,'N NO 0')>0 then return 0
return def


/***********************
                astring : the "haystack" to look in
                target: the "needle" to look for
                putme: the "new needle" to replace the "needle" with
                type : The direction/type of search
                        FORWARD, BACKWARD, ALL
                exact: YES-- then cases in needle and haystack must match
*******/

replacestrg: procedure

exactmatch=0
backward=0 ; doall=0

parse arg astring ,  target   , putme , type , exactmatch


type = translate(type)
if type="BACKWARD" then backward="YES"
if type="ALL" then doall="YES"

iat=1
joelen=length(target)
joelen2=length(putme)

doagain:                /* here if doall=yes */
 if exactmatch="YES" then do
    if   backward="YES" then
        joe= lastpos(target,astring)
    else
        joe= pos(target,astring,iat)
 end
 else do
   if   backward="YES" then
        joe= lastpos(translate(target),translate(astring))
    else
        joe= pos(translate(target),translate(astring),iat)
 end
 if joe=0 then
         return astring

 astring=delstr(astring,joe,joelen)
 if putme<>' ' then
    astring=insert(putme,astring,joe-1)

 if doall="YES" then do
     iat=joe+joelen2
     signal doagain
 end
/* else, all done */
 return astring



/**********/
helpme:

say "       "cy_ye" gos2sre:"bold||' Convert GoServe-syntax to SRE2003-syntax'||normal
say
say "This utility will convert filters, addons, and other REXX program files "
say "that were written to work with GoServe.  The converted file can be used"
say "with SRE2003."
say
say "For example: "
say "   'FILE type text/html name d:\www\foo.txt' "
say "   "bold"would be converted to "normal
say "   tmp=sre_command('FILE type text/html name d:\www\foo.txt') "
say
say "gos2sre will catch almost all such GoServe commands.  However, it is not"
say "100% accurate.  We strongly recommend that you 'create a report file'"
say "(when asked), and peruse it after the conversions have been completed."
say
say bold||"Notes:"normal
say bold "  * "normal||' You can use wildcards to convert multiple files'
say bold "  * "normal||' The program can automatically convert, or it can'
say      "      prompt you for actions (such as 'convert and flag')"
say bold '  * 'normal||' Hint: check for 'bold'???'normal' lines in the report file'
call charout,reverse"(press ENTER to continue)"normal ; pull goo
return 0
