(**************************************************************************)
(*                                                                        *)
(*  Monitor for FtpServer                                                 *)
(*  Copyright (C) 2021   Peter Moylan                                     *)
(*                                                                        *)
(*  This program is free software: you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation, either version 3 of the License, or     *)
(*  (at your option) any later version.                                   *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful,       *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *)
(*  GNU General Public License for more details.                          *)
(*                                                                        *)
(*  You should have received a copy of the GNU General Public License     *)
(*  along with this program.  If not, see <http://www.gnu.org/licenses/>. *)
(*                                                                        *)
(*  To contact author:   http://www.pmoylan.org   peter@pmoylan.org       *)
(*                                                                        *)
(**************************************************************************)

IMPLEMENTATION MODULE Misc;

        (********************************************************)
        (*                                                      *)
        (*                   Monitor for FtpServer              *)
        (*                 Miscellaneous procedures             *)
        (*                                                      *)
        (*    Started:        29 March 2000                     *)
        (*    Last edited:    29 May 2021                       *)
        (*    Status:         OK                                *)
        (*                                                      *)
        (*      This module now down to one procedure.          *)
        (*      Should I relocate it?                           *)
        (*                                                      *)
        (********************************************************)


FROM SYSTEM IMPORT
    (* type *)  CARD32;

FROM Arith64 IMPORT
    (* const*)  Zero64, Max64,
    (* type *)  CARD64,
    (* proc *)  Div10, Compare64, Add64, Sub64, ShortMul64;

(********************************************************************************)

TYPE CharSet = SET OF CHAR;

CONST DecimalDigits = CharSet{'0'..'9'};

VAR Max64DIV10: CARD64;

(************************************************************************)

PROCEDURE StringToCard64 (VAR (*IN*) string: ARRAY OF CHAR;
                                          VAR (*INOUT*) pos: CARDINAL): CARD64;

    (* Reads a decimal number starting at string[pos], updates pos.     *)
    (* This is the same as StringToCard, below, except that we do the   *)
    (* calculation in 64-bit arithmetic.                                *)

    VAR value, test: CARD64;  increment: CARD32;

    BEGIN
        value := Zero64;
        WHILE (pos <= HIGH(string)) AND (string[pos] IN DecimalDigits) DO
            IF Compare64 (value, Max64DIV10) > 0 THEN
                value := Max64;
            ELSE
                value := ShortMul64 (value, 10);
            END (*IF*);
            increment := VAL(CARD32, ORD(string[pos]) - ORD('0'));
            test := Max64;
            Sub64 (test, increment);
            IF Compare64 (value, test) > 0 THEN
                value := Max64;
            ELSE
                Add64 (value, increment);
            END (*IF*);
            INC (pos);
        END (*WHILE*);
        RETURN value;
    END StringToCard64;

(********************************************************************************)

VAR dummy: CARDINAL;

BEGIN
    Div10 (Max64, Max64DIV10, dummy);
END Misc.

