/******************************************************************
*                                                                 *
* SMTP.C SMTP daemon for OS/2 using EMX.  (c) 1995 Pete Appleton. *
* Code is subject to GNU license conditions.                      *
* createunique() adapted from Dr. Niel Kempson's deliver.exe      *
*                                                                 *
******************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <os2.h>
#include <sys\types.h>
#include <sys\socket.h>
#include <netinet\in.h>
#include <arpa\inet.h>
#include <unistd.h>
#include <netdb.h>
#include <fcntl.h>
#include <io.h>
#include <share.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include "smtpd.h"

/* Can't someone just do a "#include *" extension? */

int hsock_in,hsock_out;     /* socket descriptors, kept global for close routines */
int daemon_stat;            /* daemon status, ditto */

void closein(void);
void closeout(void);
void stripcrlf(char *);

void main(int argc, char **argv) {
   char buffer[80];
   char *hostname;
   char *dlvr_agent=NULL;
   struct sockaddr_in sock_in, sock_out;
   struct hostent *hoststruct,*clientstruct;
   FILE *fi, *fo;
   int dlvr_type,i,x;
   unsigned char a,b,c,d;

	 int processconnection(char *,char *,FILE *,FILE *,int,char *);
	 void usage(char *);

	 printf("SMTP Daemon v0.1 (c) 1995 P. Appleton\n");

	 gethostname(buffer,80);
	 hoststruct=gethostbyname(buffer);
	 a=hoststruct->h_addr[0];
	 b=hoststruct->h_addr[1];
	 c=hoststruct->h_addr[2];
	 d=hoststruct->h_addr[3];

	 hostname=strdup(hoststruct->h_name);

	 if(argc==2) {
     if(stricmp(argv[1],"-t")) {
        usage(argv[0]);
        exit(1);
     }
     dlvr_type=DONTSPOOL;
   } else {
		 if(argc<3||(stricmp(argv[1],"-a")&&stricmp(argv[1],"-p"))){
   		usage(argv[0]);
	   	exit(1);
		 }
		 if(stricmp(argv[1],"-a")) {
   	 dlvr_type=SPOOLDIRECT;
     } else {
       dlvr_type=SPOOLAGENT;
     }
		 if (access(argv[2],0)) {
	   	printf("Error: delivery agent not recognised\n");
	   	exit(1);
	   }
		 x=0;
		 for(i=2;i<argc;i++) {
	   	x=x+strlen(argv[i])+1;         /* calculate length of string */
	   }
	   x=x+MAXUSER;                           /* allow room for user length */
	   dlvr_agent=(char *) calloc(x,sizeof(char));
	   if (!dlvr_agent) {
	      printf("Good grief, insufficient memory to allocate a file path!!!\n");
	      exit(1);
	   } 
	   *dlvr_agent='\0';
	   for(i=2;i<argc;i++) {
	      strcat(dlvr_agent,argv[i]);
	      strcat(dlvr_agent," ");
	   }
	 }
	 *strrchr(dlvr_agent,' ')='\0';       /* chop off terminating space */
	 hsock_in=socket(AF_INET,SOCK_STREAM,0);
	 memset(&sock_in,0,sizeof(sock_in));
	 i=1;
	 x=setsockopt (hsock_in, SOL_SOCKET, SO_REUSEADDR, &i, sizeof (i));
	 if (x) {
   	perror("Error on setsockopt()");
   	exit(1);
   }
	
	 printf("Daemon configured for %s (%i.%i.%i.%i)\n",hostname,a,b,c,d);
	
   sock_in.sin_family=AF_INET;
   sock_in.sin_addr.s_addr=INADDR_ANY;
   sock_in.sin_port=htons(25);

	 memset(buffer,0,80);
   if (hsock_in==-1) {
     perror("Error occured on socket()");
     exit(1);
   }
   atexit(closein);
   x=bind(hsock_in,(struct sockaddr *) &sock_in,sizeof(sock_in));
	 if (x==-1) {
     perror("Error occured on bind()");
     exit(1);
   }

	 do {
   x=listen(hsock_in,0);
   if (x==-1) {
 	 perror("Error occured on listen()");
 	 exit(1);
	 }
	 printf("Waiting for connection...\n");
   i=sizeof(sock_out);
   hsock_out=accept(hsock_in,(struct sockaddr *) &sock_out, &i);
   if (hsock_out==-1) {
     perror("Error occured on accept()");
     exit(1);
   }
	 fo=fdopen(hsock_out,"w");
	 fi=fdopen(hsock_out,"r");
	 if(!fo) {
  	 printf("Can't open output stream\n");
  	 exit(1);
   }
   if(!fi) {
     printf("Can't open input stream\n");
     exit(1);
   }
   atexit(closeout);

	 hoststruct=gethostbyaddr((char *)&sock_out.sin_addr.s_addr,4,AF_INET);
   printf("Connection accepted from %s\n",hoststruct->h_name);

	 daemon_stat=STATUS_TRANSINPROGRESS;
	 x=processconnection(dlvr_agent,hostname,fi,fo,dlvr_type,hoststruct->h_name);
	 daemon_stat=STATUS_IDLE;

   if (x) {
     printf("Mail failed... ");
	 }
   switch (x) {
     case CONN_NORMTERM:
			 printf("Connection terminated normally.\n");
       break;
	   case CONN_SOCKETBROKEN:
			 printf("Broken socket\n");
			 break;
		 case CONN_AGENTERROR:
			 printf("Couldn't open delivery agent.");
			 break;
		 case CONN_UNKNOWN:
			 printf("Unknown error!\n");
			 break;
		 default:
			 printf("Error in daemon!  Please contact author (pete@rayko.demon.co.uk)\n");
	 }
   close(hsock_out);
   fclose(fi);
   fclose(fo);
  } while(1);
}

int processconnection(char *dlvr_agent,char *hostname,FILE *fi,FILE *fo,int dlvr_type,char *clientname) {

	 int sosend(FILE *,char *);
	 int soread(FILE *,char *);
	 char *transp(char *);
	 FILE *creatunique(char *);

   int retcode=CONN_NORMTERM,heloflag=0,mailflag=0,rcptflag=0,x=0,i;
   char inp_line[MAXDATA];
   char fwdpath[100][65];
   FILE  *pipes[100];
   char *commands[]={"helo","mail from:","rcpt to:","data","quit","rset","noop","$$$"};
   char buffer[80];
   char *temp;
	 time_t t;
	 struct hostent *claimedstruct;

	 inp_line[0]='\0';
   sosend(fo,"220 SMTP Server Ready\r\n");
   do {
   x=soread(fi,inp_line);
 	 if (x==-1) {
			 retcode=CONN_SOCKETBROKEN;
		 } else {
   	 for(i=0;i<=HASHCOMMS;i++) {
      	 if(!strnicmp(commands[i],inp_line,strlen(commands[i]))) break;
       }
     }
	   switch (i) {
   	 case 0:
    		 temp=&inp_line[4];
    		 if(strchr(temp,' ')) {
        	 temp=strrchr(temp,' ')+1;
         }
				 x=0;
				 stripcrlf(temp);
         if(strlen(temp)) {
           if(!stricmp(clientname,temp)) {
             x=1;
           }
           if (x) {
      		   sprintf(buffer,"250 %s OK, pleased to meet you %s\r\n",hostname,clientname);
	       	 sosend(fo,buffer);
	       	 heloflag=1;
	         } else {
	           sprintf(buffer,"250 You are a liar %s!\r\n",clientname);
	           sosend(fo,buffer);
	           heloflag=1;
					 }
         } else {
           sosend(fo,"501 Require client ID data\r\n");
         }
         break;
      case 1:
         if(!mailflag&&heloflag) {
            sosend(fo,"250 OK\r\n");
            mailflag=1;
         } else {
            if(heloflag) {
	            sosend(fo,"503 Mail from: command already received\r\n");
						} else {
   					sosend(fo,"503 HELO expected\r\n");
   				}
         }
         break;
      case 3:
        if(mailflag&&rcptflag) {
          x=0;
          for(i=0;i<rcptflag;i++) {
	  				switch(dlvr_type) {
	    	 		case DONTSPOOL:
	    					printf("Would have opened mail pipe!\n");
	    					break;
	    				case SPOOLAGENT:
		         	pipes[i]=popen(dlvr_agent,"wrt");
								break;
	    				case SPOOLDIRECT:
	              pipes[i]=creatunique(dlvr_agent);
	              break;
	    			}
						if(!pipes[i]) x=-1;
					}
					if(!x) {
	          sosend(fo,"354 OK, send data.  Finish with <CR><LF>.<CR><LF>\r\n");
	          time(&t);
						if (dlvr_agent) {
							for(i=0;i<rcptflag;i++) {
	   				  fprintf(pipes[i],"X-Delivered-From: %s\n",clientname);
	   					fprintf(pipes[i],"X-Received-By OS/2 SMTP Daemon v0.1\n");
				        fprintf(pipes[i],"Received: %s %s",hostname,ctime(&t));
		   			}
						}
 	  			do {
	      			x=soread(fi,inp_line);
	      			temp=transp(inp_line);
	            if (temp!=NULL&&x!=-1) {
	              if (dlvr_agent) {
				      		for(i=0;i<rcptflag;i++) {
		 	        	  fprintf(pipes[i],"%s",temp);
									}
								}
							} else {
	   					x=-1;
	   			  }
	  			  } while (x!=-1);
	   			sosend(fo,"250 OK, mail accepted\r\n");
						printf("\x7Received mail\n");
						x=0;
					} else {
						sosend(fo,"451 Error in SMTP daemon ;-(\r\n");
					}
					for(i=0;i<rcptflag;i++) {
   		    switch (dlvr_type) {
      				case SPOOLAGENT:
 						  pclose(pipes[i]);
 							break;
 						case SPOOLDIRECT:
 							fclose(pipes[i]);
 							break;
 					}
					}
					if(!x) {
   				mailflag=0;
   				rcptflag=0;
   			}
				} else {
   			sosend(fo,"503 MAIL and RCPT commands not received\r\n");
   		}
   		x=0;
        break;
      case 2:
         if(heloflag) {
           stripcrlf(inp_line);
					 if(strchr(inp_line,'<')&&(strchr(inp_line,'>')==inp_line+strlen(inp_line)-1)) {
   				 temp=strchr(inp_line,'@');
   				 if(temp) {
      				 temp=temp+1;
	   				 *strchr(temp,'>')='\0';
      				 if(!stricmp(temp,hostname)) {
         			 sosend(fo,"250 Recipient OK\r\n");
         			 rcptflag++;
         		 } else {
            		 sosend(fo,"550 Address unknown\r\n");
            	 }
             } else {
               sosend(fo,"553 No mailbox specified\r\n");
             }
	   		 } else {
	           sosend(fo,"501 Error in parameters - address format not understood\r\n");
	         }
				 } else {
   			 sosend(fo,"503 HELO command not received\r\n");
   		 }
         break;
   	 case 4:
   		 x=-1;
   		 sprintf(buffer,"221 %s OK, see ya!\r\n",hostname);
   		 sosend(fo,buffer);
   		 break;
   	 case 5:
   		 sosend(fo,"250 OK, daemon reset\r\n");
					 for(i=0;i<rcptflag;i++) {
   			   switch (dlvr_type) {
      				 case SPOOLAGENT:
 						   pclose(pipes[i]);
 							 break;
 						 case SPOOLDIRECT:
 							 fclose(pipes[i]);
 							 break;
 					 }
					 }
   		 mailflag=0;
   		 rcptflag=0;
   		 break;
   	 case 6:
   		 sosend(fo,"250 OK, NOOP received\r\n");
   		 break;
   	 default:
   		 sosend(fo,"502 Unrecognised / unimplemented command\r\n");
	   }
	 } while (x!=-1);

   return(retcode);
}

int sosend(FILE *file, char *data) {
	 int retcode;

	 retcode=fputs(data,file);
	 fflush(file);
	 if (retcode==EOF) {
   	retcode=-1;
   } else {
      retcode=strlen(data);
   }
	 return(retcode);
}

int soread(FILE *file, char *data) {
   int retcode;
   char *temp;

   temp=fgets(data,MAXDATA,file);
   if (temp) {
      retcode=strlen(data);
   } else {
      retcode=-1;
   }
	 return(retcode);
}

void stripcrlf(char *temp) {
  if(temp) {
	  if(strchr(temp,'\r')) {
	    *strchr(temp,'\r')='\0';
	  }
	  if (strchr(temp,'\n')) {
	    *strchr(temp,'\n')='\0';
	  }
	}
}

void closein(void) {
   close(hsock_in);
}

void closeout(void) {
   close(hsock_out);
}

char *transp(char *dataline) {
   char *retval;

	retval=strdup(dataline);
	stripcrlf(retval);

	if(retval[0]=='.') {
		if(retval[1]=='\0') {
			retval=NULL;
		} else {
   	retval=dataline+1;
  	}
  } else {
    retval=dataline;
  }

	return(retval);
}

FILE *creatunique(char *path) {
   FILE *file;
   char *fname;
   time_t t;
   int fh,i;

	 time (&t);                                                               
   fh = -1;

   fname=malloc(strlen(path)+14);
	 if(fname) {
     strcpy(fname,path);
	   for (i = 0; i < 1000; ++i) {                                             
	     sprintf (fname, "%s\\%.8lx.%03d", path, (unsigned long)t, i);           
	     fh = sopen (fname, O_WRONLY | O_CREAT | O_EXCL, SH_DENYRW,S_IREAD | S_IWRITE);

	     if (fh != -1)                                                        
	       break;                                                           
                                                                             
	     if (errno != EEXIST) {                                               
	       perror (fname);                                                  
	     }                                                                    
	   }                                                                        
	   if (fh == -1) {
	     file==NULL;
		 } else {
	     file=fdopen(fh,"w");
	   }
	 } else {
     file=NULL;
   }

	 return(file);
}

void usage(char *exename) {
	printf("\nUsage:  %s <-t | -p <directory> | -a <delivery agent> [agent's options]>\nReceive incoming SMTP mail, and spool to agent or write to disk.\n\n-t parameter specifies test mode, no mail will be passed.\n-p specifies directory to place mail (for POP3D).\n-a specifies delivery agent, e.g. deliver.exe, plus parameters.\n   Note that the delivery agent _must_ include full path and extension.",strlwr(strrchr(exename,'\\')+1));
}

