<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="ui/profile">
  <div class="location-title">
    <a id="location-title__hamburger"
      href="#menu"
      class="location-title__hamburger"></a>
    <div class="location-title__text">Profile</div>
  </div>

  <div class="main-content">

    <script src="js/profile.js" type="text/javascript" language="javascript"></script>

    <div class="pe">

      <div class="pe__row pe__row_ctl">
        <div class="peRowCtl__caption">
          Storage used
        </div>
        <div class="peRowCtl__ctl">
          <xsl:value-of select="storage-used"/>
        </div>
      </div>
      <div class="pe__row pe__row_ctl">
        <div class="peRowCtl__caption">
          Storage limit
        </div>
        <div class="peRowCtl__ctl">
          <xsl:value-of select="storage-limit"/>
        </div>
      </div>
      <div class="pe__row pe__row_ctl">
        <div class="peRowCtl__caption">
          Maximum folder nesting depth
        </div>
        <div class="peRowCtl__ctl">
          <xsl:value-of select="depth-max"/>
        </div>
      </div>

      <div class="pe__row pe__row_hdr">
        Change password
      </div>
      <form enctype="multipart/form-data" method="post">
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Current password
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText"
              name="current-password" type="password" id="current-password"
              maxlength="256"/>
          </div>
        </div>

        <xsl:call-template name="password"/>

        <div class="pe__row pe__row_btn">
          <input class="btn" type="submit" value="Apply"/>
        </div>
        <xsl:if test="message">
          <div class="pe__row pe__row_hdr">
            Errors
          </div>
          <div class="pe__row">
            <xsl:apply-templates select="message"/>
          </div>
        </xsl:if>
      </form>
    </div>

  </div>
</xsl:template>

</xsl:stylesheet>
