<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:include href="interactive.xsl"/>
<xsl:include href="logon.xsl"/>
<xsl:include href="cu.xsl"/>
<xsl:include href="profile.xsl"/>
<xsl:include href="domains.xsl"/>
<xsl:include href="spamchk.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="ui"/>
</xsl:template>

<xsl:template match="/ui">
<html lang="ru">
<head>
  <title>Manjary</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
  <link rel="stylesheet" type="text/css" href="css/main.css"></link>
  <script src="js/utils.js" type="text/javascript" language="javascript"></script>
  <script src="js/main.js" type="text/javascript" language="javascript"></script>
<!--
  <link rel='shortcut icon' href='img/favicon.png'/>
  <link rel="icon" type="image/png" href="img/favicon.png"/>
-->
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
</head>
<body>
  <xsl:apply-templates select="cu"/>

  <div class="main-area">
    <xsl:apply-templates select="logon"/>
    <xsl:apply-templates select="profile"/>
    <xsl:apply-templates select="domains"/>
    <xsl:apply-templates select="spamchk"/>
  </div>
</body>
</html>
</xsl:template>

</xsl:stylesheet>
