<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="ui/logon">
  <script src="js/login.js" type="text/javascript" language="javascript"></script>

  <div class="login">
    <form class="login-box"
      action="logon" method="post" enctype="multipart/form-data">

      <div class="login-box_hdr">LOGIN</div>

      <input type="hidden" name='back-to' value="{back-to}"/>
      <xsl:if test="message">
        <div class="login-box_msg">
          <xsl:choose>
            <xsl:when test="message='UNABLETOCONNECT'">
              <xsl:text>Unable to connect to server.</xsl:text>
            </xsl:when>
            <xsl:when test="message='INVALIDHOSTNAME'">
              <xsl:text>Invalid server name.</xsl:text>
            </xsl:when>
            <xsl:when test="message='HOSTNOTFOUND'">
              <xsl:text>Server not found.</xsl:text>
            </xsl:when>
            <xsl:when test="message='CONNECTIONBROKEN'">
              <xsl:text>The connection is broken.</xsl:text>
            </xsl:when>
            <xsl:when test="message='LOGINFAILED'">
              <xsl:text>Invalid username or password.</xsl:text>
            </xsl:when>
            <xsl:when test="message='INSECURECONNECTION'">
              <xsl:text>Attention! Insecure connection. The username and password
                        will be sent over the network in clear text.</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="message"/>
            </xsl:otherwise>
          </xsl:choose>
        </div>
      </xsl:if>
      <div class="login-box_inputRow">
        <span class="login-box_inputRow-caption">Server:</span>
        <div class="login-box_inputRow-controls">
          <select class="login-box_inputRow-select" id="server-select">
            <xsl:apply-templates select="server"/>
            <option value="">Enter address...</option>
          </select>
          <input class="login-box_inputRow-field login-box_inputRow-field_hidden"
             type="text" name="server" id="server-addr" placeholder="server:port"/>
        </div>
      </div>
      <div class="login-box_inputRow">
        <span class="login-box_inputRow-caption">User:</span>
        <input class="login-box_inputRow-field" type="text" name="user"/>
      </div>
      <div class="login-box_inputRow">
        <span class="login-box_inputRow-caption">Password:</span>
        <input class="login-box_inputRow-field" type="password" name="password"/>
      </div>
      <input class="login-box_submit" type="submit" value="Log in"/>
    </form>
  </div>
</xsl:template>

<xsl:template match="server">
  <option value="{@addr}">
    <xsl:value-of select="."/>
  </option>
</xsl:template>

</xsl:stylesheet>
