window.addEventListener( "load", function() {

  function setInvalidView(el,fInvalid)
  {
    if ( fInvalid ) el.classList.add( "pe__inputText_invalid" );
    else el.classList.remove( "pe__inputText_invalid" );
  }

  /* Mode */

  const elSel = document.getElementById( "setup__mode" );
  const elSDID = document.getElementById( "setup__sdid" );
  const elSelector = document.getElementById( "setup__selector" );
  const elModeApply = document.querySelector( "form#setup input[type='submit']" );
  const regSelector = /^\S+$/;
  var   iMode = elSel.selectedIndex;
  var   fSDID = true;
  var   fSelector = false;
  var   timeoutAjaxDomain = null;

  function modeChanged() {
    iMode = elSel.selectedIndex;
    elSDID.disabled = iMode == 0;
    elSelector.disabled = (iMode == 0 || iMode == 2);

    setInvalidView( elSDID, !elSDID.disabled && !fSDID );
    fSelector = (iMode != 1) || regSelector.test( elSelector.value.trim() );
    setInvalidView( elSelector, !fSelector );

    utilVldrtCheck();
  }

  document.getElementById( "setup__mode" ).addEventListener( "change",
    modeChanged, true );

  utilInputOnChange( elSDID, function(e) {
    const  str = this.value.trim();

    fSDID = false;
    utilVldrtCheck();

    if ( timeoutAjaxDomain != null )
      clearTimeout( timeoutAjaxDomain );

    timeoutAjaxDomain = setTimeout(
      function(str) {
        utilAJAX( "ajax_domain?n=" + encodeURIComponent( str ),
          function(xmlRoot) {
            fSDID = xmlRoot.firstChild ? true : false;
            utilVldrtCheck();
            setInvalidView( elSDID, !fSDID );
          }
        );
      }, 400, str );

    return;
  } );

  utilInputOnChange( elSelector, modeChanged );

  document.getElementById( "setup" ).addEventListener( "submit",
    function(e) { elSelector.value = elSelector.value.trim(); }
    , true );

  utilVldrtSet( function() {
   return ( iMode == 0 ) ||
          ( ( iMode == 2 ) && fSDID ) || ( fSDID && fSelector );
  } );

  modeChanged();


  /* Key */

  const elRadioGenerate = document.getElementById( "key__generate" );
  const elKeyFile = document.getElementById( "key__file" );
  var   fFileSelected = false;

  function keyApplyCheck()
  {
    const  elApply = document.querySelector( "form#key input[type='submit']" );
    elApply.disabled = !elRadioGenerate.checked && !fFileSelected;
  }

  function keySrcChanged()
  {
    const elKeyLength = document.getElementById( "key__length" );

    elKeyLength.disabled = !elRadioGenerate.checked;
    elKeyFile.disabled = elRadioGenerate.checked;
    keyApplyCheck();
  }

  elRadioGenerate.addEventListener( "change",
    keySrcChanged, true );
  document.getElementById( "key__upload" ).addEventListener( "change",
    keySrcChanged, true );

  elKeyFile.addEventListener( "change", function(e) {
    fFileSelected = this.value ? true : false;
    keyApplyCheck();
  } );

  keySrcChanged();

  document.getElementById( "key" ).addEventListener( "submit",
    function(e) {
      const elKeyForm = this;

      if ( !document.getElementById( "key__getpubkey" ) )
        return true;

      confirmation( null, function() { elKeyForm.submit(); } );
      e.preventDefault();
      return false;
    }
    , true );
} );
