/* Enhanced REXX program for Adept multi-node chat by Matthew Taylor

 Based on the original sample chat script written by Steven Tower - Adeptsoft
 Modified greatly since that time for Lake Macquarie BBS, a 20 node system
 located in Newcastle, New South Wales (the mid East Coast) Australia.

 Telnet to:     lakebbs.cn-newc.com.au
 or email me:   matt@cn-newc.com.au

 for more information

*/



ARG Line

/* Load up user chat settings from user flag group #1 */

UserFlags1 = AdeptGetVar(line, 42)
PubMsg = AdeptCheckBit(line, 1, UserFlags1)
PrivMsg = AdeptCheckBit(line, 2, UserFlags1)
SysMsg = AdeptCheckBit(line, 3, UserFlags1)
PubAct = AdeptCheckBit(line, 4, UserFlags1)

/* Adaptive Flood Sensing - Gets more sensitive per offence until chat access
   simply removed entirely */

FloodTendancy = AdeptCheckBit(line, 31, UserFlags1) + AdeptCheckBit(line, 30, UserFlags1) + AdeptCheckBit(line, 29, UserFlags1)

If FloodTendancy = 0 then do
        ElapseTest = 1.5
        MaxFloods = 5
end

If FloodTendancy = 1 then do
        ElapseTest = 1.6
        MaxFloods = 4
end

If FloodTendancy = 2 then do
        ElapseTest = 1.75
        MaxFloods = 3
end

If FloodTendancy = 3 then do
        AdeptPrint(line,'\r\nYour chat access was removed by the system for repeated flooding!\r\n\n{PC')
        exit
end

UserName = AdeptGetvar(line, 2)
UserNode = Line
Security = AdeptGetVar(line, 40)

/* Default Settings & Constants */

ChannelName = 'GENERAL'
MaxChannelLength = 12
LastCommand = ''
InputText = ''
KeyList = D2C(9)
ContLoop = 1
FloodCount = 0
Operator = 500
Time('R')
PreviousTimeElapsed = 0

AdeptInitRexx(line)

/* Attempt to Connect User to Default Channel */

SendString = '{FG---> {FBUser {FG' || UserName || ' {FE[{FFNode ' || UserNode || '{FE] {FBhas entered online chat'
AdeptSysChatMsg(line, SendString)
RetC = AdeptSysChatConnectUser(line)
if RetC = 1 then AdeptSysChatJoinConf(line, ChannelName)
else do
   AdeptPrint(line, "\r\n\n{FGChat server unavailable\r\n{PC")
   exit
end

/* Successful Connection - Display initial entry information */

AdeptPrint(line, '{CS{FG\r\n/Q to exit.  /? for quick help\r\n')
AnnounceJoinChannel(line)

do while ContLoop = 1

    USERTEXT = ""

    Command = ''
    NodeTo = ''
    MsgText = ''

    if InputText \= '' then
        RetC = AdeptSysChatInput(line, "USERTEXT", KeyList, InputText)
    else
        RetC = AdeptSysChatInput(line, "USERTEXT", KeyList)

    InputText = ''

    if RetC = 9 then do
        if LastCommand \= '' then do
           InputText = LastCommand
           RetC = 1
        end
        Iterate
    end

    if RetC \= 1 then do
       if RetC = IRC_CHATWAITING then do
          RetC = ProcessChatMsg(line)
       end

       if RetC = IRC_CHATDOWN then do
          RetC = ReconnectUser(line)
          if(RetC \= 1) then do
              AdeptSysChatLeaveConf(line)
              exit
          end
       Iterate
       end

       if RetC = LOSTCARRIER then do
          SendString = '\r{FC---> {FGUser {FF' || UserName || '{FG on node {FF' || UserNode || '{FG has just Dropped Carrier{FC <---'
          AdeptSysChatMsg(line, SendString)
          AdeptSysChatLeaveConf(line)
          exit
       end

       if RetC = IRC_NOTIMELEFT then do
          SendString = '\r{FC---> {FGUser {FF' || UserName || '{FG on node {FF' || UserNode || '{FG has just run out of time{FC <---'
          AdeptSysChatMsg(line, SendString)
          AdeptSysChatLeaveConf(line)
          exit
       end

       if RetC = IRC_IDLETIMEOUT then do
          SendString = '\r{FC---> {FGUser {FF' || UserName || '{FG on node {FF' || UserNode || '{FG gone to sleep at the keyboard{FC <---'
          AdeptSysChatMsg(line, SendString)
          AdeptSysChatLeaveConf(line)
          exit
       end
       Iterate
    end
    else
    if RetC = 1 then do

       if UserText = '' then Iterate
       LastCommand = UserText
       AdeptPrint(line, '\r\n')

       if Left(UserText,1) = '/' then do

            RetC = FillData(UserText)

            if (Command = '/Q' | Command = '/E') then do
               SendString = '{FG---> {FBUser {FG' || UserName || ' {FE[{FFNode ' || UserNode || '{FE] {FBhas exited online chat'
               AdeptSysChatMsg(line, SendString)
               AdeptSysChatLeaveConf(line)
               exit
            end

            if Command = '/W' then do
               AdeptMenuType(line, 55)
               AdeptPrint(line, '\r\n')
               RetC = 0
               Iterate
            end

            if Command = '/A' then do
               AdeptMenuType(line, 52)
               AdeptPrint(line, '\r\n')
               RetC = 0
               Iterate
            end

            if Command = '/L' then do
               AdeptMenuType(line, 53)
               AdeptPrint(line, '\r\n')
               RetC = 0
               Iterate
            end

            if Command = '/T' then do
               RetC = ShowTime(line)
               Iterate
            end

            if Command = '/B' then do
               RetC = GetTime(line)
               Iterate
            end

            if Command = '/?' then do
               RetC = ShowHelp(line)
               Iterate
            end

  /* Chatting Setting Control Commands */

            if Command = '/PUBMSG' then do
               if PubMsg = 1 then do
                  PubMsg = 0
                  UserFlags1 = AdeptGetVar(line, 42)
                  rc = AdeptUnSetBit(Line, 1, UserFlags1)
                  rc = AdeptPutVar(Line, 42, rc)
                  AdeptPrint(line, '\r{FC--- {FGPublic message annoucement turned off {FC---\r\n')
               end
               else do
                  PubMsg = 1
                  UserFlags1 = AdeptGetVar(line, 42)
                  rc = AdeptSetBit(Line, 1, UserFlags1)
                  rc = AdeptPutVar(Line, 42, rc)
                  AdeptPrint(line, '\r{FC--- {FGPublic message annoucement turned on {FC---\r\n')
               end
               Iterate
            end

            if Command = '/PRIVMSG' then do
               if PrivMsg = 1 then do
                  PrivMsg = 0
                  UserFlags1 = AdeptGetVar(line, 42)
                  rc = AdeptUnSetBit(Line, 2, UserFlags1)
                  rc = AdeptPutVar(Line, 42, rc)
                  AdeptPrint(line, '\r{FC--- {FGPrivate message annoucement turned off {FC---\r\n')
               end
               else do
                  PrivMsg = 1
                  UserFlags1 = AdeptGetVar(line, 42)
                  rc = AdeptSetBit(Line, 2, UserFlags1)
                  rc = AdeptPutVar(Line, 42, rc)
                  AdeptPrint(line, '\r{FC--- {FGPrivate message annoucement turned on {FC---\r\n')
               end
               Iterate
            end

            if Command = '/SYSMSG' then do
               if SysMsg = 1 then do
                  SysMsg = 0
                  UserFlags1 = AdeptGetVar(line, 42)
                  rc = AdeptUnSetBit(Line, 3, UserFlags1)
                  rc = AdeptPutVar(Line, 42, rc)
                  AdeptPrint(line, '\r{FC--- {FGReceive system messages turned off {FC---\r\n')
               end
               else do
                  SysMsg = 1
                  UserFlags1 = AdeptGetVar(line, 42)
                  rc = AdeptSetBit(Line, 3, UserFlags1)
                  rc = AdeptPutVar(Line, 42, rc)
                  AdeptPrint(line, '\r{FC--- {FGReceive system messages turned on {FC---\r\n')
               end
               Iterate
            end

            if Command = '/PUBACT' then do
               if PubAct = 1 then do
                  PubAct = 0
                  UserFlags1 = AdeptGetVar(line, 42)
                  rc = AdeptUnSetBit(Line, 4, UserFlags1)
                  rc = AdeptPutVar(Line, 42, rc)
                  AdeptPrint(line, '\r{FC--- {FGPublic action annoucement turned off {FC---\r\n')
               end
               else do
                  PubAct = 1
                  UserFlags1 = AdeptGetVar(line, 42)
                  rc = AdeptSetBit(Line, 4, UserFlags1)
                  rc = AdeptPutVar(Line, 42, rc)
                  AdeptPrint(line, '\r{FC--- {FGPublic action annoucement turned on {FC---\r\n')
               end
               Iterate
            end

  /* Private Message Command */

            if (Command = '/S' & NodeTo \= '' & MsgText \= '') then do
                SendString = '{FE[{FG' || UserNode || '{F8-{FB' || UserName || '{FD, Pvt Msg{FE] {FC' || MsgText
                NodeUserName = AdeptGetVar(NodeTo, 2)
                if AdeptGetVar(NodeTo, 276) = 1 then do
                    if PrivMsg = 1 then AdeptPrint(line, '\r{FC--- {FGPrivate message sent to {FF' || NodeUserName || '{FG on node {FF' || NodeTo || '{FC ---\r\n')
                    AdeptSysChatPrivMsg(line, NodeTo, SendString)
                    CheckFlood(line)
                end
                else
                if PrivMsg = 1 then AdeptPrint(line, '\r{FC--- {FGPrivate message not sent, No one on node {FF' || NodeTo || '{FC ---\r\n')
                Iterate
            end

  /* Sysop Control Commands */

            if (Command = '/K' & NodeTo \= '' & Security = Operator) then do
               NodeUserName = AdeptGetVar(NodeTo, 2)
               if AdeptGetVar(NodeTo, 276) = 1 then do
                   AdeptPrint(Line, '\r{FC--- {FGUser {FF' || NodeUserName || '{FG on node {FF' || NodeTo || '{FG kicked off ---\r\n')
                   AdeptComDoDTR(NodeTo,'0')
                   SendString = '{FC--- {FGSystem Message {FC--> {FG' || NodeUserName ||'{FF was kicked off of node {FG' || NodeTo
                   AdeptSysChatMsg(Line, SendString)
               end
               else AdeptPrint(line, '\r{FC--- {FGUser not Kicked, No one on node {FF' || NodeTo || '{FG to logoff! {FC ---\r\n')
               Iterate
            end

            if (Command = '/N' & Security = Operator & Nodeto \= '') then do
               NodeUserName = AdeptGetVar(NodeTo, 2)
               SendString = '{F8* {FC' || NodeUserName || ' ' || MsgText
               AdeptSysChatNoPrePubMsg(Line, SendString)
               Iterate
            end

            if (Command = '/C' & Security = Operator) then do
               Count = 5
               do while count < 21
                   ConnString = AdeptConvert(count,'{SB')
                   If ConnString \= '' then do
                        IPAddress = SubStr(ConnString,28,length(ConnString)-27)
                        AdeptPrint(line,'{FGIP address for node {FB' || count || '{FG : "{FC' || IPAddress || '{FG"\r\n')
                   end
                   count = count + 1
               end
               Iterate
            end

  /*  Channel Control Commands  */

            if (Command = '/J' & MsgText \= '') then do
               ChannelName = Translate(MsgText)
               if Length(ChannelName) > MaxChannelLength
                  then ChannelName = Left(ChannelName,10)
               SendString = '{FG---> {FBUser {FG' || UserName || ' {FE[{FFNode ' || UserNode || '{FE] {FBjust left this channel'
               AdeptSysChatPubMsg(line, SendString)
               rc = AdeptSysChatJoinConf(Line, ChannelName)
               if rc = 2 then AnnounceJoinChannel(line)
               Iterate
            end

            if (Command = '/I' & NodeTo \= '') then do
Node=NodeTo
/*if Node > '6' then Call NoSuchNode */
/* if Node < '1' then Call UnAvail */
CheckChat = AdeptGetVar(Node,44)
IsOn = AdeptCheckBit(Node,24,CheckChat)
CheckCarr = AdeptGetVar(Node,276)
UserLoc = AdeptLocation(Node)
if(IsOn \= 0 & UserLoc \= "Browsing Files" & UserLoc \= "OFF-Line Mail Utility" & CheckCarr \= 0) then do
Call AdeptPrint Line,"\r\nInvitation will be sent when you "
Call AdeptHitReturn Line
carrier = AdeptGetVar(Node,276)
cr = X2C('0D')
lf = X2C('0A')
SendString = AdeptConvert(Line, '{FG---> {FG'|| UserName || ' {FE[{FFNode ' || UserNode || '{FE] {FGinvites you to join the {FB' || ChannelName || ' {FGChannel')
Call AdeptComWrite Node, cr lf || SendString || cr lf
rc = AdeptComPeekByte(Node,1000)
Call AdeptCls Line
end
else
call UnAvail
Iterate
end

  /* Public Action Command */

            if (Command = '/ME' & MsgText \= '') then do
                SendString = '{F8* {FC' || UserName || ' ' || MsgText
                AdeptSysChatNoPrePubMsg(line, SendString)
                if PubAct = 1 then AdeptPrint(line, '\r{FC--- {FGPublic action sent {FC---\r\n')
                CheckFlood(line)
                Iterate
            end
            AdeptPrint(line, '\r{FC--- {FGInvalid command "{FF' || Command || '{FG" press /? for help{FC---\r\n')
       end
       else
       if UserText \= '' then do
                SendString = '{FE[{FG' || UserNode || '{F8-{FB' || UserName || '{FE] {FC' || UserText
                AdeptSysChatPubMsg(line, SendString)
                CheckFlood(line)
                if PubMsg = 1 then AdeptPrint(line, '\r{FC--- {FGPublic Message Sent {FC---\r\n')
                Iterate
       end
    AdeptSleep(line, 64)
    end
    AdeptSleep(line, 64)
end

ProcessChatMsg:

   ARG line

   do while AdeptSysChatMsgWaiting(line) = 1

       RetC = AdeptSysChatGetMsg(line)

       if RetC = 3 then do
          if PktType = 100 then do
              AdeptPrint(line, "\r" || ChatMsgData || "\r\n")
              return 0
          end
          else
          if PktType = 101 then do
              AdeptPrint(line, "\r" || ChatMsgData || "\r\n")
              return 0
          end
          else
          if PktType = 102 then do
              AdeptPrint(line, "\r" || ChatMsgData || "\r\n")
              return 0
          end
          if (PktType = 105 & SysMsg = 1) then do
              AdeptPrint(line, "\r" || ChatMsgData || "\r\n")
              return 0
          end
       end
       AdeptSleep(line, 32);
   end
return 0


/* When chatserver goes down. Make 5 attempts to reconnect then give up! */

ReconnectUser:

   ARG line
   count = 1
   RetC = AdeptSysChatReConnectUser(line)
   do while(RetC \= 1 & count < 6)
       AdeptSleep(line, 1000)
       AdeptPrint(line, '\rChatserver down, Commencing Reconnection - Attempt ' || count || ' of 5.\r\n')
       count = count + 1
       RetC = AdeptSysChatReConnectUser(line)
   end
   RetC = AdeptSysChatUserConnected(line)
   if(RetC \= 1) then do
       AdeptPrint(line, '\rConnection to Chatserver LOST! Exiting...\r\n');
       return RetC
   end
   else do
       AdeptPrint(line, '\rChatserver Reconnection Sucessful!\r\n')
       return RetC
   end
return 0

/* Get raw input data, break into components & uppercase the command string */

FillData:

   Parse ARG uInput
   PARSE Var uInput Command ',' NodeTo ' ' MsgText


/* Special kludge for action command to allow a commas to be used in them */

   if Translate(Left(Command,4)) = '/ME '  then do
         PARSE Var uInput Command ' ' MsgText
         Command = Translate(Command)
         return 0
   end

   if Command = '' then Command = uInput

   if Command = uInput then do

      PoSit = Pos(' ', Command)

      if PoSit = 0 then do
         Command = Translate(Command)
         return 0
      end

      PARSE Var uInput Command ' ' MsgText

      Command = Translate(Command)

/* Special case to further break input down to extract private message text */

      if Command = '/S' then do
          PARSE Var MsgText NodeTo ' ' MsgText
      end

   end

   Command = Translate(Command)

return 0

/* Display Online Help */

ShowHelp:

   ARG line

   AdeptPrint(line, '\r\nItems in Brackets "[]" are required.\r\n\r\n')
   AdeptPrint(line, '/E or /Q                   - Exit chat mode\r\n')
   AdeptPrint(line, '/S,[node number] [message] - Send a private message\r\n')
   If Security = Operator then
      AdeptPrint(line, '/K,[node number]           - Kick user off the bbs\r\n')
   AdeptPrint(line, '/T                         - Displays current time/date info\r\n')
   AdeptPrint(line, '/B                         - Perform a Time Bank Transaction\r\n')
   AdeptPrint(line, '/ME [Message]              - Perform a action\r\n')
   AdeptPrint(line, '/W                         - Show who else is on-line\r\n')
   AdeptPrint(line, '/A                         - Show all nodes status\r\n')
   AdeptPrint(line, '/L                         - Show who is in this channel\r\n')
   AdeptPrint(line, '/J [channel name]          - Join/Create new chat channel (Max ' || MaxChannelLength || ' Chars)\r\n')
   AdeptPrint(line, '/I,[node number]           - Invite a user to your current channel\r\n')
   AdeptPrint(line, '/PUBMSG                    - Toggle Public Message Sent - Currently ' || BitStatus(PubMsg))
   AdeptPrint(line, '/PRIVMSG                   - Toggle Private Message Sent - Currently ' || BitStatus(PrivMsg))
   AdeptPrint(line, '/SYSMSG                    - Toggle System Messages - Currently ' || BitStatus(SysMsg))
   AdeptPrint(line, '/PUBACT                    - Toggle Public Action Messages - Currently ' || BitStatus(PubAct))
   AdeptPrint(line, '\r\n')



return 0

ShowTime:

   ARG line

   AdeptPrint(line, '\r{FFToday is: {FG{D8  {FFYou have {FG{T0 {FFminutes remaining this call.\r\n')

return 0

/* Time Bank Facility for use within Chat */

GetTime:

    ARG line

    BankedTime = AdeptGetVar(Line,15)
    AdeptPrint(line, '\r{FFYou currently have {FG' || BankedTime || '{FF minutes in the bank. \r\n\n')
    AdeptPrint(line, '{FB({FGW{FB)ithdraw or {FB({FGD{FB)eposit Time or ({FGC{FB)ontinue Chatting{FG')
    Choice = Translate(D2C(AdeptWaitKey(Line)))
    If Choice = 'D' then do
       AdeptPrint(Line,'\r\n')
       AdeptMenuType(Line,167,,,0)
    end
    If Choice = 'W' then do
       AdeptPrint(Line,'\r\n')
       AdeptMenuType(Line,168,,,0)
    end
    AdeptPrint(Line,'\r\n\n')

return 0

/* User chatting settings bit status display - used in online help */

BitStatus:

    ARG TheBit
    if TheBit = 1 then Status = '{FG*ON*{FF\r\n'
       else Status  = '{FG*OFF*{FF\r\n'

return Status

/* Displays current channel on the user's screen & announces their entry to
   that channel's current occupants */

AnnounceJoinChannel:

    ARG line
    AdeptPrint(line, '{FG\r\nYou have just joined the "{FB' || ChannelName || '{FG" channel.\r\n\n')
    SendString = '{FG---> {FBChannel was just joined by {FG' || UserName || ' {FE[{FFNode ' || UserNode || '{FE]'
    AdeptSysChatPubMsg(line, SendString)

return 0

CheckFlood:

    ARG line
    TimeElapsed = Time('E') - PreviousTimeElapsed
    PreviousTimeElapsed = Time('E')
    If TimeElapsed <= ElapseTest then do
        FloodCount = FloodCount + 1
        If FloodCount >= MaxFloods then do
            SendString = '{FC--- {FGSystem Message {FC--> {FG' || UserName || '{FF was kicked for flooding on node {FG' || Line
            AdeptSysChatMsg(Line, SendString)
            UserFlags1 = AdeptGetVar(line, 42)
            rc = AdeptSetBit(Line, 31 - FloodTendancy, UserFlags1)
            rc = AdeptPutVar(Line, 42, rc)
            AdeptLog(line, 3, '-*- User Auto Kicked for Flooding Chat! -*-')
            AdeptComDoDTR(Line,'0')
            AdeptPrint(line, '{PD{PD{PD')
        end
    end
    else FloodCount = 0

return 0
UnAvail:
Call AdeptCls Line
Call AdeptPrint Line,"\r\nThat Node/User is Currently unavailable for Chat...\r\n"
Call AdeptHitReturn Line
Return
NoSuchNode:
Call AdeptCls Line
Call AdeptPrint Line,"\r\nNo such Node Number, Node must be between 1 and 5 Inclusive\r\n"
Call AdeptHitReturn Line
Return
