unit ApiInt;

interface
uses
  types;

{----------------------------------------------------------------------------}
function  dllVer             : string; far;
procedure dllInit            (     path : string;
                                   node : Byte ); far; { path = FOSS/2-root path }
{----------------------------------------------------------------------------}
function  fioReadMainCfg     ( var cfg : TSysCfg )
                             : Boolean; far;
procedure fioWriteMainCfg    ( var cfg : TSysCfg ); far;
{----------------------------------------------------------------------------}
function  fioReadNodeCfg     ( var cfg : TNodeCfg;
                                   pos : LongInt )
                             : Boolean; far;
procedure fioWriteNodeCfg    ( var cfg : TNodeCfg;
                               var pos : LongInt); far;
procedure fioDelNodeCfg; far;
function  fioGetNodeCnt      : LongInt; far;
{----------------------------------------------------------------------------}
function  fioReadAreaCfg     ( var cfg : TAreaCfg;
                                   pos : LongInt ) : Boolean; far;
function  fioFindAreaCode    ( var cfg : TAreaCfg;
                                   code : string;
                                   pos : LongInt )
                             : Boolean; far;
function  fioFindAreaName    ( var cfg : TAreaCfg;
                                   name : string;
                                   pos : LongInt ) : LongInt; far;
procedure fioWriteAreaCfg    ( var cfg : TAreaCfg;
                                   pos : LongInt ); far;
{----------------------------------------------------------------------------}
function  fioReadEventCfg    ( var cfg : TEventCfg;
                                   pos : LongInt )
                             : Boolean; far;
procedure fioWriteEventCfg   ( var cfg : TEventCfg;
                               var pos : LongInt ); far;
procedure fioDelEventCfg     (     pos : LongInt ); far;
{----------------------------------------------------------------------------}
function  fioReadLocalUsr    ( var usr : TUser;
                                   pos : LongInt )
                             : Boolean; far;
function  fioFindLocalUsr    ( var usr : TUser;
                                   name : string;
                               var pos : LongInt )
                             : Boolean; far;
procedure fioWriteLocalUsr   ( var usr : TUser;
                               var pos : LongInt ); far;
function  fioGetLocalUsrCnt  : LongInt; far;

function  fioReadNetAddr     (     pos : LongInt;
                               var area : TAreaCfg )
                             : string; far;
function  fioWriteNetAddr    (     name : string;
                               var area : TAreaCfg )
                             : LongInt; far;
{----------------------------------------------------------------------------}
function  fioReadUsrAreaReg  ( var reg : TAreaUserStat;
                               var area : TAreaCfg;
                                   pos : LongInt )
                             : Boolean; far;
procedure fioWriteUsrAreaReg ( var reg : TAreaUserStat;
                               var area : TAreaCfg;
                               var pos : LongInt ); far;
{----------------------------------------------------------------------------}
function  fioReadMsgHeader   ( var mhd : TMessageHeader;
                               var area : TAreaCfg;
                                   pos : LongInt )
                             : Boolean; far;
function  fioFindMsgNo       ( var mhd : TMessageHeader;
                               var area : TAreaCfg;
                                   no : LongInt )
                             : Boolean; far;
function  fioFindNextMsg     ( var mhd : TMessageHeader;
                               var area : TAreaCfg )
                             : Boolean; far;
function  fioFindPrevMsg     ( var mhd : TMessageHeader;
                               var area : TAreaCfg )
                             : Boolean; far;
procedure fioReadMsgBuf      ( var mhd : TMessageHeader;
                               var area : TAreaCfg;
                                   ptr : PMsgBuffer ); far;
procedure fioReadMsgStatus   ( var area : TAreaCfg;
                               var reg : TAreaUserStat;
                               var usr : TUser;
                               var last,
                                   newall,
                                   newyou : LongInt ); far;
procedure fioWriteMsgHeader  ( var mhd : TMessageHeader;
                               var area : TAreaCfg;
                               var pos : LongInt ); far;
procedure fioUpdateMsgHeader ( var mhd : TMessageHeader;
                               var area : TAreaCfg ); far;
procedure fioWriteMsg        ( var mhd : TMessageHeader;
                               var area : TAreaCfg;
                                   ptr : PMsgBuffer ); far;
{----------------------------------------------------------------------------}
function  fioReadDirCfg      ( var cfg : TAreaDirCfg;
                               var area : TAreaCfg;
                                   pos : LongInt )
                             : Boolean; far;
function  fioFindDirNo       ( var cfg : TAreaDirCfg;
                                   no : LongInt;
                               var area : TAreaCfg;
                                   pos : LongInt )
                             : Boolean; far;
function  fioFindDirName     ( var cfg : TAreaDirCfg;
                                   name : string;
                               var area : TAreaCfg;
                                   pos : LongInt )
                             : Boolean; far;
procedure fioWriteDirCfg     ( var cfg : TAreaDirCfg;
                               var area : TAreaCfg;
                               var pos : LongInt); far;
{----------------------------------------------------------------------------}
function  fioReadFileRec     ( var frec : TDirFile;
                               var area : TAreaCfg;
                               var rpos : LongInt )
                             : Boolean;
procedure fioWriteFileRec    ( var frec : TDirFile;
                               var area : TAreaCfg;
                               var rpos : LongInt );
{----------------------------------------------------------------------------}
function  fioGetNodeStatus   ( var stat : TNodeStat;
                                   node : Word )
                             : Boolean; far;

{ ========================================================================= }
{ fioGetNodeMsg         Check if there are any node messages waiting

  INPUT:  none
  OUTPUT: msg           First incoming node message if any
  RETURN: TRUE          One node message returned in msg
          FALSE         No incoming node messages
{ ========================================================================= }
function  fioGetNodeMsg      ( var msg : TNodeMsg )
                             : Boolean; far;

{ ========================================================================= }
{ fioSendNodemsg        Send a node message

  INPUT:  msg           message record of message to send
          node          node to send message to
  OUTPUT: none
  RETURN: none
{ ========================================================================= }
procedure fioSendNodeMsg     ( var msg : TNodeMsg;
                                   node : Integer ); far;

{ ========================================================================= }
{ fioStampLog           Write a line of information to the system log file
                        or one of the nodes log files.

  INPUT:  txt           text string to write to log file
          node          number of node the log entry is for
                        -1 = current node
                        -2 = system log (log display to system at login)
  OUTPUT: none
  RETURN: none
{ ========================================================================= }
procedure fioStampLog        (     txt : string;
                                   node : Integer ); far;

{ ========================================================================= }
{ fioPrint              Write text to the terminal window.
  fioPrintln            Write text to the terminal window end with CR+LF.

                        You should allways send as much text as possible in
                        each call to these function because calling these
                        functions is not very fast.

  INPUT:  txt           text string to display to the user
{ ========================================================================= }
procedure fioPrint           (     Txt : string ); far;
procedure fioPrintln         (     Txt : string ); far;

{----------------------------------------------------------------------------}
function  strUpCase          (     S : string )
                             : string; far;
function  strNiceCase        (     S : string )
                             : string; far;
function  strInsertIdx       (     org,
                                   ins,
                                   idx : string )
                             : string; far;
{----------------------------------------------------------------------------}
function  usrHaveAccess      (     acc : SAccess;
                               var area : TAreaCfg;
                               var reg : TAreaUserStat;
                               var usr : TUser )
                             : Boolean; far;
function  usrAccess2Msg      ( var mhd : TMessageHeader;
                               var usr : TUser )
                             : Boolean; far;
function  usrMsgAddress      ( var msg : TMessageHeader;
                               var area : TAreaCfg;
                                   tofrom : Byte )
                             : string; far;
{----------------------------------------------------------------------------}
procedure scrSetVar          (     Ident : string;
                                   Value : string ); far;
function  scrGetVar          (     Ident : string )
                             : string; far;
{----------------------------------------------------------------------------}

implementation

function  dllVer;              external 'FOSS16' index   1;
procedure dllInit;             external 'FOSS16' index   2;

function  fioReadMainCfg;      external 'FOSS16' index   3;
procedure fioWriteMainCfg;     external 'FOSS16' index   4;

function  fioReadNodeCfg;      external 'FOSS16' index   5;
procedure fioWriteNodeCfg;     external 'FOSS16' index   6;
procedure fioDelNodeCfg;       external 'FOSS16' index   7;
function  fioGetNodeCnt;       external 'FOSS16' index   8;

function  fioReadAreaCfg;      external 'FOSS16' index   9;
function  fioFindAreaCode;     external 'FOSS16' index  22;
function  fioFindAreaName;     external 'FOSS16' index  23;
procedure fioWriteAreaCfg;     external 'FOSS16' index  10;

function  fioReadEventCfg;     external 'FOSS16' index  35;
procedure fioWriteEventCfg;    external 'FOSS16' index  36;
procedure fioDelEventCfg;      external 'FOSS16' index  39;

function  fioReadLocalUsr;     external 'FOSS16' index  11;
function  fioFindLocalUsr;     external 'FOSS16' index  14;
procedure fioWriteLocalUsr;    external 'FOSS16' index  12;
function  fioGetLocalUsrCnt;   external 'FOSS16' index  13;

function  fioReadNetAddr;      external 'FOSS16' index  44;
function  fioWriteNetAddr;     external 'FOSS16' index  45;

function  fioReadUsrAreaReg;   external 'FOSS16' index  15;
procedure fioWriteUsrAreaReg;  external 'FOSS16' index  16;

function  fioReadMsgHeader;    external 'FOSS16' index  17;
function  fioFindMsgNo;        external 'FOSS16' index  18;
function  fioFindNextMsg;      external 'FOSS16' index  19;
function  fioFindPrevMsg;      external 'FOSS16' index  38;
procedure fioReadMsgBuf;       external 'FOSS16' index  20;
procedure fioReadMsgStatus;    external 'FOSS16' index  21;
procedure fioWriteMsgHeader;   external 'FOSS16' index  34;
procedure fioUpdateMsgHeader;  external 'FOSS16' index  29;
procedure fioWriteMsg;         external 'FOSS16' index  28;

function  fioReadDirCfg;       external 'FOSS16' index  30;
function  fioFindDirNo;        external 'FOSS16' index  33;
function  fioFindDirName;      external 'FOSS16' index  31;
procedure fioWriteDirCfg;      external 'FOSS16' index  32;

function  fioReadFileRec;      external 'FOSS16' index  42;
procedure fioWriteFileRec;     external 'FOSS16' index  47;

function  fioGetNodeStatus;    external 'FOSS16' index  43;

function  fioGetNodeMsg;       external 'FOSS16' index  40;
procedure fioSendNodeMsg;      external 'FOSS16' index  41;

procedure fioStampLog;         external 'FOSS16' index  50;
procedure fioPrint;            external 'FOSS16' index  51;
procedure fioPrintln;          external 'FOSS16' index  52;

function  strUpCase;           external 'FOSS16' index  24;
function  strNiceCase;         external 'FOSS16' index  25;
function  strInsertIdx;        external 'FOSS16' index  26;

function  usrHaveAccess;       external 'FOSS16' index  27;
function  usrAccess2Msg;       external 'FOSS16' index  37;
function  usrMsgAddress;       external 'FOSS16' index  46;

procedure scrSetVar;           external 'FOSS16' index  48;
function  scrGetVar;           external 'FOSS16' index  49;

end.