@ECHO OFF
ECHO -------------------------------------------------------------------
ECHO       INSTALL.BAT - Basic installation routine for EleBBS.       
ECHO -------------------------------------------------------------------
ECHO.

ECHO.
ECHO  This installation routine is only meant for people performing a fresh
ECHO   install of EleBBS. If you already have an existing RemoteAccess/tcRA32
ECHO   or EleBBS installation, please press CTRL-C now to abort this
ECHO   installation batch. Any other key to continue with installation.
PAUSE >NUL

REM Make sure there was an drive specified on the commandline
if "%1" == "" GOTO NOPATH
if "%2" == "" GOTO NOUNPACK

REM Make sure all files exist before proceeding with install
IF NOT EXIST DOC.ZIP GOTO MISSING
IF NOT EXIST BIN.ZIP GOTO MISSING
IF NOT EXIST SAMPLES.ZIP GOTO MISSING
IF EXIST %1\ELE GOTO DIREXIST
IF NOT EXIST %2 GOTO NOPACKER

ECHO.
ECHO  Creating installation paths (%1)
ECHO    Creating system path %1\ELE
MKDIR %1\ELE >NUL
ECHO    Creating textfiles path %1\ELE\TXTFILES
MKDIR %1\ELE\TXTFILES >NUL
ECHO    Creating messagebase path %1\ELE\MSGBASE
MKDIR %1\ELE\MSGBASE >NUL
ECHO    Creating menufiles path %1\ELE\MENUS
MKDIR %1\ELE\MENUS >NUL
ECHO    Creating filebase path %1\ELE\FILEBASE
MKDIR %1\ELE\FILEBASE >NUL
MKDIR %1\ELE\FILEBASE\HDR >NUL
MKDIR %1\ELE\FILEBASE\IDX >NUL
MKDIR %1\ELE\FILEBASE\TXT >NUL
ECHO    Creating questionnaire (script) path %1\ELE\QUESTION
MKDIR %1\ELE\QUESTION >NUL
ECHO    Creating documentation path %1\ELE\DOC
MKDIR %1\ELE\DOC >NUL
ECHO    Creating samples path %1\ELE\SAMPLE
MKDIR %1\ELE\SAMPLE >NUL
ECHO  Unpacking packages (using %2)
ECHO    Unpacking DOC.ZIP into %1\ELE\
%2 DOC.ZIP %1\ELE\DOC\ >NUL
ECHO    Unpacking BIN.ZIP into %1\ELE\
%2 BIN.ZIP %1\ELE\ >NUL
ECHO    Unpacking SAMPLES.ZIP into %1\ELE\SAMPLE\
%2 SAMPLES.ZIP %1\ELE\SAMPLE\ >NUL
ECHO  Installing configuration files (using %2)
ECHO    Unpacking SAMPLE2.ZIP into %1\ELE\MENUS\
%2 %1\ELE\SAMPLE\SAMPLE2.ZIP %1\ELE\MENUS\ >NUL
ECHO       Moving template ANSI to example directory
COPY %1\ELE\MENUS\TEMPLATE.ANS %1\ELE\TXTFILES >NUL
ERASE %1\ELE\MENUS\TEMPLATE.ANS >NUL
ECHO       Copying ELEBBS.ANS as LOGO.ANS
COPY %1\ELE\DOC\ELEBBS.ANS %1\ELE\TXTFILES\LOGO.ANS >NUL
ECHO       Copying READ.ME to %1\ELE\DOC
COPY READ.ME.* %1\ELE\DOC >NUL
ECHO       Copying UPGRADE to %1\ELE\DOC
COPY UPGRADE.* %1\ELE\DOC >NUL
ECHO       Copying COMIP.TXT to %1\ELE\DOC
COPY COMIP.TXT %1\ELE\DOC >NUL
ECHO    Unpacking EXCFG.ZIP into %1\ELE
%2 %1\ELE\SAMPLE\EXCFG %1\ELE >NUL
ECHO  Copying of files finished. Press any key to continue . . .
PAUSE >NUL
CLS
ECHO.
ECHO Installation of EleBBS finished. Please configure an environment variable
ECHO of ELEBBS set to %1\ELE. For help on how to do this consult your operating
ECHO system manual. (eg: SET ELEBBS=%1\ELE\)
ECHO.
ECHO.
ECHO You can now configure your EleBBS by running ELCONFIG, or you can fire
ECHO up EleBBS into localmode by typing in:
ECHO ELEBBS -L
ECHO.
ECHO Have fun!
%1
CD \ELE
GOTO QUIT

:NOPACKER
ECHO.
ECHO  The un-archiver you have defined does not exist, installation aborted.
GOTO QUIT

:MISSING
ECHO.
ECHO  Missing files on this path. Make sure all files exist and try again.
GOTO QUIT

:DIREXIST
ECHO.
ECHO  Destination directory does already exist. Please do not perform this
ECHO   upgrade but simply unpack all the EXE's and OVR's into %1\ELE.
GOTO QUIT

:NOUNPACK
ECHO.
ECHO  Missing unpacker path at second parameter.
ECHO  Usage: INSTALL.BAT [Installation drive] [Unpack filename]
ECHO  Example: INSTALL.BAT C: C:\COMPRESS\UNZIP.EXE
ECHO  ** DO NOT USE AN TRAILING BACKSLASH **
GOTO QUIT

:NOPATH
ECHO.
ECHO  Missing destination path on first parameter.
ECHO  Usage: INSTALL.BAT [Installation drive] [Unpack filename]
ECHO  Example: INSTALL.BAT C: C:\COMPRESS\UNZIP.EXE
ECHO  ** DO NOT USE AN TRAILING BACKSLASH **
GOTO QUIT

:QUIT
ECHO  Installation ended.
ECHO.
