/* EZVoice.cmd - Swanee                                         */
/*                                                              */
/* Install EZIRC with it's normal installation script, then     */
/* run this cmd file from the EZIRC directory that contains     */
/* the "EZIRC.INI" file. It will setup the Webbnet servers and  */
/* the channels for as easy as possible connection to #Voice    */
/*                                                              */
/* After running this script, EZIRC should connect to a Webbnet */
/* server and automatically join the #Voice channel.            */
/*                                                              */
/* The connection should be complete. Watch for a while and     */
/* join in the conversation when you are comfortable.           */
/*                                                              */
/* There are several nets available for irc. The #Voice channel */
/* on Webbnet is only active during meetings. If you want to    */
/* try the #OS/2 channel on another net, you'll have to go to   */
/* "Server Options" - "Connect to Server" and scroll down the   */
/* IRC Server listing to any server listed below                */
/* "irc.se.webbnet.org:6667" These servers are the ones listed  */
/* originally by EZIRC and will get you onto UnderNet or Efnet  */
/* Here you will find active #OS/2 channels.                    */
/*                                                              */
/* Save your original EZIRC.INI and EZIRC.SCR files...          */
/* Just in case...                                              */

Call Init
Call DoIni
Call DoScr
Call DoJoin
say crlf crlf||'EZIRC should be ready to start and automatically'
say 'log onto the webbnet servers and channel #voice' crlf
say 'The channel is always open but meetings are on the'
say 'first and third mondays of the month. 8:00 EST' crlf

Done:
Exit

Init:

crlf='0D0A'x
filename=directory()||'\ezirc.ini'
ServerInfo1='server=irc.webbnet.org:6667 irc.us.webbnet.org:6667 irc.in2.webbnet.or:6667 irc.md2.webbnet.or:6667 irc.mi.webbnet.org:6667 irc.nc.webbnet.org:6667'
ServerInfo2=' irc.pa2.webbnet.or:6667 irc.tn.webbnet.org:6667 irc.tx2.webbnet.or:6667 irc.wa2.webbnet.or:6667 irc.ca.webbnet.org:6667 irc.de.webbnet.org:6667 irc.se.webbnet.org:6667 '
ServerInfo=ServerInfo1||ServerInfo2
ChannelInfo='preferred_channels=#voice #os/2 #os2prog'
ConnectInfo='auto_connect=yes'
JoinCmd="/* Script to auto join #voice */"||crlf||"parse arg window remain"||crlf||crlf||"str = '/join #voice'"||crlf||"return str"

return

DoIni:

  filename = STREAM(filename, 'C', 'QUERY EXISTS')
  IF filename>'' then do
    say crlf crlf crlf||"This script will modify the EZIRC.INI file making it easier" crlf||"to locate the #voice channel on it's Webbnet servers"
    index=0
    rc = STREAM(filename, 'C', 'OPEN READ')
    DO WHILE LINES(filename)
      index=index+1
      value.index = LINEIN(filename)
      if left(value.index, 7)='server=' then do
        EZServers=right(value.index,length(value.index)-7)
        value.index=ServerInfo||EZServers
      end
      if left(value.index, 19)='preferred_channels=' then value.index=ChannelInfo
      if left(value.index, 13)='auto_connect=' then value.index=ConnectInfo
      value.0=index
    END
    Call stream filename,'C','CLOSE'
    '@ERASE' filename
    DO x=1 to index
      CALL LINEOUT filename, value.x
    END
    CALL STREAM filename,'C','CLOSE'
    say crlf crlf||'The EZIRC.INI file has been changed.'
  END
  ELSE do
    say 'This script must be run from the directory containing the "EZIRC.INI" file'
    Call Done
  END

return

DoScr:

  filename=directory()||'\script\ezirc.scr'
  Call lineout filename, 'join.cmd MOTD'
  Call stream filename,'C','CLOSE'
  say 'The EZIRC.SCR file has been changed.'

return

DoJoin:

  filename=directory()||'\script\join.cmd'
  value=STREAM(filename, 'C', 'QUERY EXISTS')
  IF value>'' then '@ERASE' filename
  Call charout filename, JoinCmd, 1
  Call stream filename,'C','CLOSE'
  say 'The JOIN.CMD file has been written.'

return

