/* This program SYSDOWN copies files between two Mozilla profiles.            		*/
/* Copies from OS/2 to Windows!                                                 		*/
/*   				                                                      		*/
/* - The files are kept in a file list which has to be specified as first parameter		*/
/* - The following specifications are kept in the file list                    		*/
/*   1. complete path of profile for Windows Mozilla                      			*/
/*   2. complete path of profile for OS/2 Warpzilla	                        		*/
/*   3. all names of files to be copied, on per line		                        	*/
/*                                                                        			*/                                           
/* Author: K.Steinsky  Version: 0.1 Last updated: 08.08.2003                   		*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* ---------- Definitions  ----------------------------- */

Log_schreiben = 0                         /* Log_write on/off */
LOG = "SysDown.Log"

datum = substr(date(S),7,2)||'.'||substr(date(S),5,2)||'.'||substr(date(S),1,4)
parse value time() with std ':' min ':' sek . 
uhr = std||'.'||min||'.'sek'h'

/* ---------- Initialization  -------------------------- */ 

 parse arg dnl					/* Name of file list */
 ordner=directory()				/* get current directory */
 dnliste=strip(dnl)				/* remove blanks */

If Log_schreiben then do
   Call STREAM LOG,'C','open write'    /* open log file */ 
   If dnliste="" then do
      Logtext=datum", "||uhr||", No name for file name list is specified" 
      call LINEOUT LOG , Logtext
   End /*If do*/
   else do
      Logtext=datum", "||uhr||", Log opened, used file name list is '"||dnliste||"'." 
      call LINEOUT LOG , Logtext
   End /*else do*/                                                          
End /*If do*/                                                          
 
/* **** All open Mozilla windows will be killed **** */
"killem  Mozilla "       /* all Mozilla-Windows killed */
call SysSleep 3                           /* wait for Mozillas to terminate */
/* ---------- Open file list ------------------------ */ 

rc = STREAM(dnliste ,'C','open read')     /* open file name list */ 
IF rc <> 'READY:' THEN do
   Logtext=datum", "||uhr||", Name list '"||dnliste||"' not found." 
   If Log_schreiben then call LINEOUT LOG , Logtext 
End /*If do*/
else do
   Logtext=datum", "||uhr||", Name list '"||dnliste||"' opened." 
   If Log_schreiben then call LINEOUT LOG , Logtext 
End /*else do*/                                                          

Znr=0

/* ---------- set path variable ---------------------------- */ 

Do UNTIL LINES(dnliste) = 0           /* Loop till end of file */
   Znr=Znr+1
   If Znr < 3 then do
     parse UPPER value  STRIP(LINEIN(dnliste),B) with ID '=' pfad  
     If strip(ID) = "MOZ_WIN_PFAD" then WPfad = strip(pfad)
     If strip(ID) = "MOZ_OS2_PFAD" then OPfad = strip(pfad)
     If Log_schreiben & Znr=2 then call LINEOUT LOG , "From OS2_path=<"||OPfad||"> to WIN_Path=<"||WPfad||"> will be copied."

   End /*If do*/

/* ---------- Check existence of files ----------------- */ 
/* ---------- and copy if both found ------------------- */ 

   else do
     existiert2 = 0
     zeile =  STRIP(LINEIN(dnliste),B)   /* remove blanks */    
     win_datei = stream(WPfad||"\"||zeile, "C" , "QUERY EXISTS")   /* does file exist? */
     if win_datei = '' then do
        If Log_schreiben then call LINEOUT LOG , "File <"||WPfad||"\"||zeile||"> does not exist."
     End /*If do*/
     else do
        If Log_schreiben then call LINEOUT LOG , "File <"||win_datei"> does exist."
        existiert2 = existiert2+1
     End /* else do */

     os2_datei = stream(OPfad||"\"||zeile, "C" , "QUERY EXISTS")   /* do both files exist? */ 
     if os2_datei = '' then do
        If Log_schreiben then call LINEOUT LOG , "File <"||OPfad||"\"||zeile||"> does not exist."
     End /*If do*/
     else do
        If Log_schreiben then call LINEOUT LOG , "File <"||os2_datei"> does exist."
        existiert2 = existiert2+1
     End /* else do */

     If existiert2 = 2 then do            /* Do both files exist? */
        'COPY "'||os2_datei||'"  "'||WPfad||'"'   /* copy file */
        If RC > 0 then do
          If Log_schreiben then call LINEOUT LOG , "----> Copy error due to file <"||zeile||">."
        End /* If do */
        else do
        If Log_schreiben then call LINEOUT LOG , "----> File <"||zeile||"> copied from <"||OPfad||"> to <"||WPfad||">."
        End /* else do */
     End /*If do*/
     else do
        If Log_schreiben then call LINEOUT LOG , "----> File <"||OPfad||"\"||zeile||"> not copied."
     End /* else do */
   End /*else do*/                                                          
end /* Do UNTIL */ 

Call STREAM LOG,'C','close'            /* Close Log file  */ 
Call STREAM dnliste,'C','close'        /* Close file name list */ 
If Log_schreiben then call LINEOUT LOG , datum", "||uhr||", Log closed." 
If Log_schreiben then call SysSleep 1    /* Waiting 1 second to clear cache */  

/* Here you can insert/replace the program to shutdown the system */ 

/*"SHUTDOWN.EXE  " */                      /* Call Shutdown  */ 

EXIT

