// ***********************************************************************
// OS2PAL.HPP
// ***********************************************************************
//
// Written by Michael T. Duffy
//
// Object derived from palette object for handling palettes under OS/2
//
// ***********************************************************************

#ifndef OS2PAL_H
#define OS2PAL_H

// ***********************************************************************
//  Constant Definitions
// ***********************************************************************

const USHORT       PAL_FMT_UNKNOWN        = 0;
const USHORT       PAL_FMT_8BIT           = 1;
const USHORT       PAL_FMT_OS2            = 2;

// These color definitions are for the first 16 colors in a standard VGA
//  palette.

#ifndef COLOR_DEFS
#define COLOR_DEFS
const BYTE         BLACK        = 0;
const BYTE         BLUE         = 1;
const BYTE         GREEN        = 2;
const BYTE         CYAN         = 3;
const BYTE         RED          = 4;
const BYTE         MAGENTA      = 5;
const BYTE         BROWN        = 6;
const BYTE         LIGHTGRAY    = 7;
const BYTE         DARKGRAY     = 8;
const BYTE         LIGHTBLUE    = 9;
const BYTE         LIGHTGREEN   = 10;
const BYTE         LIGHTCYAN    = 11;
const BYTE         LIGHTRED     = 12;
const BYTE         LIGHTMAGENTA = 13;
const BYTE         YELLOW       = 14;
const BYTE         WHITE        = 15;
#endif



// ***********************************************************************
//  Internal Structures
// ***********************************************************************

typedef struct _PALLIBHDR
  {
  USHORT           usFormat;
  BYTE             byFlag;
  } PALLIBHDR;
typedef PALLIBHDR *  PPALLIBHDR;

// ***********************************************************************
//  Class Definition
// ***********************************************************************

class OS2Palette
  {
  private:
    USHORT         usLastErrorCode;

    BYTE           abyData [1024];
    USHORT         usCurrentFormat;
    BYTE           byFlag;

    // OS/2 specific variables.
    HAB            hab;
    HDC            hdc;
    HPS            hps;
    HWND           hwnd;
    HPAL           hpal;

  public:

    // Constructor
    OS2Palette (VOID);
    OS2Palette (HAB  habIn, HWND  hwndIn, HDC  hdcIn, HPS  hpsIn);

    // Destructor
    ~OS2Palette (VOID);

    VOID Default16
      (
      VOID
      );

    VOID Convert
      (
      ULONG        ulFormat
      );

    VOID InitSystemPalette
      (
      HAB          habIn,
      HWND         hwndIn,
      HDC          hdcIn,
      HPS          hpsIn
      );

    VOID UninitSystemPalette
      (
      VOID
      );

    VOID SuspendSystemPalette
      (
      VOID
      );

    VOID RestoreSystemPalette
      (
      VOID
      );

    VOID SetAsDiveSource
      (
      HDIVE        hdive
      );

    VOID SetAsDiveDestination
      (
      HDIVE        hdive
      );

    VOID LoadActualPalette
      (
      HPS          hpsIn
      );

    VOID SetValuesFromRaw8
      (
      PBYTE        pbyValuesIn,
      ULONG        ulStart,
      ULONG        ulNumber
      );

    ERRORSTATUS PaletteFromBlock
      (
      PBYTE            pbyBlock,
      ULONG            ulBlockSize
      );

    ERRORSTATUS RequestSaveBlock
      (
      PBYTE *          ppbyBlockOut,
      PULONG           pulSizeOut
      );

    ERRORSTATUS ReleaseSaveBlock
      (
      PBYTE *          ppbyBlockOut
      );

    // Inline functions
    VOID SetFlag
      (
      BYTE             byFlagIn
      ) {byFlag = byFlagIn;};

    BYTE QueryFlag
      (
      VOID
      ) {return (byFlag);};

    PBYTE QueryPaletteArray
      (
      VOID
      ) {return (abyData);};

    USHORT QueryLastErrorCode
      (
      VOID
      ) {return (usLastErrorCode);};
  };





#endif // OS2PAL_H

