/* --------------------------------------------------------------------
      This is the main OS/2 shell from which the game will be hung.
   Almost all other modules should be OS inspecific, with the exception
   of the input modules.

                              Michael T. Duffy
-------------------------------------------------------------------- */

// ***********************************************************************
//  Header Files
// ***********************************************************************

#define __IBMC__
#define INCL_WIN
#define INCL_GPI
#define INCL_DOS
#define INCL_ERRORS

// OS/2 API functions
#include <os2.h>

// DIVE required header files
#define  _MEERROR_H_
#include <mmioos2.h>
#include <dive.h>
#include <fourcc.h>

// ANSI C functions
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "newtypes.hpp"
#include "canvas.hpp"
#include "game1.hpp"
#include "errdisp.hpp"


/* Global Variables                 */
// ***********************************************************************
//  Variables
// ***********************************************************************


// OS/2 environment variables.
HAB                hab;
HWND               hwndFrame,
                   hwndClient;
CHAR               szTitle [64];
BOOL               bAppIsActive = FALSE;
HDC                hdcClientHDC = NULLHANDLE;

const CHAR         szClientClass []  = "CLIENT";

SHORT              sBorderHeight;
SHORT              sBorderWidth;


// Dive variables
DIVE_CAPS          DiveCaps           = {0};
FOURCC             fccFormats[100]    = {0};
HDIVE              hDive              = NULLHANDLE;
BOOL               bDiveHaveBuffer    = FALSE;
ULONG              ulDiveBufferNumber = 0;


// Canvas variables
PCANVAS            pcnvMainCanvas = NULL;

// Palette variables
HPAL               hpalMain;


// Constants
const ULONG        ulIMAGE_WIDTH  = 320;
const ULONG        ulIMAGE_HEIGHT = 200;

LONG               lTotalWidth   = 320;
LONG               lTotalHeight  = 200;

BYTE               abyVGADefault16Palette[] =
                                    {
//  B    G    R       O           B    G    R       O
    0,   0,   0, PC_RESERVED,   171,   0,   0, PC_RESERVED,
    0, 171,   0, PC_RESERVED,   171, 171,   0, PC_RESERVED,
    0,   0, 171, PC_RESERVED,   171,   0, 171, PC_RESERVED,
    0,  85, 171, PC_RESERVED,   171, 171, 171, PC_RESERVED,
   85,  85,  85, PC_RESERVED,   255,  85,  85, PC_RESERVED,
   85, 255,  85, PC_RESERVED,   255, 255,  85, PC_RESERVED,
   85,  85, 255, PC_RESERVED,   255,  85, 255, PC_RESERVED,
   85, 255, 255, PC_RESERVED,   255, 255, 255, PC_RESERVED
                                    };


// ***********************************************************************
//  Code
// ***********************************************************************


//........................................................................
int main()
//........................................................................
  {
  HMQ              hmq;
  QMSG             qmsg;
  ULONG            flFrameFlags;



  hab = WinInitialize (0);
  hmq = WinCreateMsgQueue (hab, 0);

  WinRegisterClass (hab, szClientClass, ClientWndProc, CS_SIZEREDRAW, 0);

  if (InitializeDive () == NO_ERROR)
    {
    // Ready variables for main window creation.
    WinLoadString (hab, 0, ID_APPMAIN, sizeof(szTitle), szTitle);
    flFrameFlags = FCF_TITLEBAR      | FCF_DLGBORDER  |  FCF_MINBUTTON |
                   FCF_SHELLPOSITION | FCF_TASKLIST   |  FCF_ICON      |
                   FCF_SYSMENU       | FCF_MENU;// | FCF_NOBYTEALIGN;

    // Create the main window
    hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
                                    &flFrameFlags, szClientClass, szTitle,
                                    0, 0, ID_APPMAIN, &hwndClient);


    if (InitializeAppWindow () == ES_ERROR)
      {
      WinPostMsg(hwndClient, WM_QUIT, 0L, 0L);
      };
    DrawTestPatten ();

    // Size the window here.
    Snap1_1 ();
    CenterWindow ();

    WinShowWindow (hwndFrame, TRUE);
    WinSetActiveWindow (HWND_DESKTOP, hwndFrame);

    // Process messages while there are some.
    while (WinGetMsg (hab, &qmsg, 0, 0, 0))
        WinDispatchMsg (hab, &qmsg);


    WinSetVisibleRegionNotify (hwndClient, FALSE);
    };

  if (bDiveHaveBuffer)
    {
    DiveFreeImageBuffer (hDive, ulDiveBufferNumber);
    ulDiveBufferNumber = 0;
    bDiveHaveBuffer = FALSE;
    };

  if (pcnvMainCanvas != NULL)
    {
    delete (pcnvMainCanvas);
    pcnvMainCanvas = NULL;
    };

  if (hDive != NULLHANDLE) DiveClose (hDive);

  WinDestroyWindow (hwndFrame);

  WinDestroyMsgQueue (hmq);
  WinTerminate (hab);
  return (0);
  };

//........................................................................
ERRORSTATUS InitializeAppWindow
//........................................................................
  (
  VOID
  )
{
PBYTE              pbySurface;
ULONG              ulWidth;
USHORT             usLastError;



ulDiveBufferNumber = 0;
bDiveHaveBuffer = FALSE;

// Create your display canvas.  Make it a bottom up canvas for use with DIVE
if (pcnvMainCanvas != NULL) delete (pcnvMainCanvas);
pcnvMainCanvas = new Canvas ((USHORT)ulIMAGE_WIDTH,
                             (USHORT)ulIMAGE_HEIGHT,
                             FALSE);
if ((usLastError = pcnvMainCanvas->QueryLastErrorCode ()) != 0)
  {
  PostError (hab, hwndFrame, usLastError);
  return (ES_ERROR);
  };

pbySurface = pcnvMainCanvas->QuerySurface ();
ulWidth    = (ULONG) pcnvMainCanvas->QueryWidth ();

// Associate the canvas with a DIVE handle
if (DiveAllocImageBuffer (hDive, &ulDiveBufferNumber, FOURCC_LUT8,
                          ulIMAGE_WIDTH, ulIMAGE_HEIGHT,
                          ulWidth,  pbySurface) == ES_ERROR)
  {
  // post error message here.
  PostError (hab, hwndFrame, IDS_ERR_CREATE_DIVEBUFFER);
  return (ES_ERROR);
  };
bDiveHaveBuffer = TRUE;

// Turn on visible region notification.
WinSetVisibleRegionNotify (hwndClient, TRUE);

// Send an invalidation message to the client.
WinPostMsg (hwndFrame, WM_VRNENABLED, 0L, 0L );

return (ES_NO_ERROR);
};


//........................................................................
VOID DrawTestPatten
//........................................................................
  (
  VOID
  )
{


// Draw Test pattern to canvas
pcnvMainCanvas->Clear (WHITE);
pcnvMainCanvas->SetDrawColor (0);
pcnvMainCanvas->Rectangle (40,40,80,80);
pcnvMainCanvas->Rectangle (10,10,80,80);
pcnvMainCanvas->SetDrawColor (RED);
pcnvMainCanvas->Rectangle (30,30,60,60);
};


//........................................................................
VOID Snap1_1
//........................................................................
  (
  VOID
  )
{
LONG               lBorderWidth;
LONG               lBorderHeight;
LONG               lTitlebarHeight;
LONG               lMenuHeight;



lBorderWidth    = (LONG) WinQuerySysValue (HWND_DESKTOP, SV_CXDLGFRAME);
lBorderHeight   = (LONG) WinQuerySysValue (HWND_DESKTOP, SV_CYDLGFRAME);
lTitlebarHeight = (LONG) WinQuerySysValue (HWND_DESKTOP, SV_CYTITLEBAR);
lMenuHeight     = (LONG) WinQuerySysValue (HWND_DESKTOP, SV_CYMENU);

lTotalWidth  = ulIMAGE_WIDTH + lBorderWidth * 2;
lTotalHeight = ulIMAGE_HEIGHT + (lBorderHeight * 2) + lTitlebarHeight +
               lMenuHeight;

// Set the window size.
WinSetWindowPos (hwndFrame,
                 HWND_TOP,
                 0, 0, lTotalWidth, lTotalHeight,
                 SWP_SIZE | SWP_SHOW | SWP_ACTIVATE);
};

//........................................................................
VOID CenterWindow
//........................................................................
  (
  VOID
  )
{
LONG               lcxWindowPos;
LONG               lcyWindowPos;


lcxWindowPos   = ( (LONG)WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN)
                     - lTotalWidth ) / 2;
lcyWindowPos   = ( (LONG)WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN)
                     - lTotalHeight ) / 2;

// Set the window position.
WinSetWindowPos (hwndFrame,
                 HWND_TOP,
                 lcxWindowPos, lcyWindowPos, 0, 0,
                 SWP_MOVE | SWP_SHOW | SWP_ACTIVATE);
};

//........................................................................
MRESULT EXPENTRY ClientWndProc
//........................................................................
  (
  HWND             hwnd,
  ULONG            msg,
  MPARAM           mp1,
  MPARAM           mp2
  )
{
HPS                hps;
POINTL             pointl;         // Point to offset from Desktop
SWP                swp;            // Window position
HRGN               hrgn;           // Region handle
RECTL              rcls[50];       // Rectangle coordinates
RGNRECT            rgnCtl;         // Processing control structure
SETUP_BLITTER      SetupBlitter;   // structure for DiveSetupBlitter
static HPS         hpsMainHPS;
SIZEL              sizl;
ULONG              ulcPaletteColors = 256;


switch (msg)
  {
  case WM_CREATE:
       sizl.cx = sizl.cy = 0;
       hdcClientHDC = WinOpenWindowDC (hwnd);
       hpsMainHPS = GpiCreatePS (hab, hdcClientHDC, &sizl,
                           PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC);

       hpalMain = GpiCreatePalette (hab,
                                    LCOL_PURECOLOR,
                                    LCOLF_CONSECRGB,
                                    ulcPaletteColors,
                                    (PULONG) abyVGADefault16Palette);

       GpiSelectPalette (hpsMainHPS, hpalMain);
       WinRealizePalette (hwnd, hps, &ulcPaletteColors);

       DiveSetSourcePalette (hDive, 0, 256L, (PBYTE) abyVGADefault16Palette);
       DiveSetDestinationPalette (hDive, 0, 256, 0 );
       return (0);

  case WM_DESTROY:
       if (hpsMainHPS  != NULLHANDLE)
         {
         GpiSelectPalette (hpsMainHPS, NULLHANDLE);
         };
       if (hpalMain != NULLHANDLE)
         {
         GpiDeletePalette (hpalMain);
         };
       if (hpsMainHPS != NULLHANDLE)  GpiDestroyPS (hpsMainHPS);
       return (0);

  case WM_PAINT:
       hps = WinBeginPaint (hwnd, NULLHANDLE, NULL);

       // blit Dive buffer to screen.
       DiveBlitImage (hDive,
                      ulDiveBufferNumber,
                      DIVE_BUFFER_SCREEN );

       WinEndPaint (hps);
       return (0);

  case WM_COMMAND:
       switch (SHORT1FROMMP(mp1))
         {
         case IDM_QUIT:
           {
           WinPostMsg(hwndClient, WM_CLOSE, MPVOID, MPVOID);
           return(0);
           };
         };
       break;

  case WM_REALIZEPALETTE:
       // This tells DIVE that the physical palette may have changed.
       DiveSetDestinationPalette (hDive, 0, 256, 0 );
       break;

  case WM_VRNDISABLED:
       DiveSetupBlitter (hDive, 0);
       break;

  case WM_VRNENABLED:
       if ( !hpsMainHPS )
          break;
       hrgn = GpiCreateRegion ( hpsMainHPS, 0L, NULL );
       if ( hrgn )
          {
          // NOTE: If mp1 is zero, then this was just a move message.
          // Illustrate the visible region on a WM_VRNENABLE.
          //
          WinQueryVisibleRegion ( hwnd, hrgn );
          rgnCtl.ircStart     = 0;
          rgnCtl.crc          = 50;
          rgnCtl.ulDirection  = 1;

          // Get the all ORed rectangles
          if ( GpiQueryRegionRects ( hpsMainHPS, hrgn, NULL, &rgnCtl, rcls) )
             {
             // Now find the window position and size, relative to parent.
             WinQueryWindowPos (hwndClient, &swp );

             // Convert the point to offset from desktop lower left.
             pointl.x = swp.x;
             pointl.y = swp.y;
             WinMapWindowPoints ( hwndFrame, HWND_DESKTOP, &pointl, 1 );

             // Tell DIVE about the new settings.
             SetupBlitter.ulStructLen = sizeof ( SETUP_BLITTER );
             SetupBlitter.fccSrcColorFormat = FOURCC_LUT8;
             SetupBlitter.ulSrcWidth   = ulIMAGE_WIDTH;
             SetupBlitter.ulSrcHeight  = ulIMAGE_HEIGHT;
             SetupBlitter.ulSrcPosX    = 0;
             SetupBlitter.ulSrcPosY    = 0;
             SetupBlitter.fInvert      = TRUE;
             SetupBlitter.ulDitherType = 1;

             SetupBlitter.fccDstColorFormat = FOURCC_SCRN;
             SetupBlitter.ulDstWidth        = swp.cx;
             SetupBlitter.ulDstHeight       = swp.cy;
             SetupBlitter.lDstPosX          = 0;
             SetupBlitter.lDstPosY          = 0;
             SetupBlitter.lScreenPosX       = pointl.x;
             SetupBlitter.lScreenPosY       = pointl.y;
             SetupBlitter.ulNumDstRects     = rgnCtl.crcReturned;
             SetupBlitter.pVisDstRects      = rcls;
             DiveSetupBlitter (hDive, &SetupBlitter);
             }
          else
             DiveSetupBlitter (hDive, 0);

          GpiDestroyRegion (hpsMainHPS, hrgn);
          }
       break;

  }; // switch (msg)

return (WinDefWindowProc(hwnd, msg, mp1, mp2));
};

//........................................................................
ERRORSTATUS InitializeDive
//........................................................................
  (
  VOID
  )
{


// Get the screen capabilities, and if the system supports only 16 colors
//  the program should be terminated.

DiveCaps.pFormatData    = fccFormats;
DiveCaps.ulFormatLength = 100;
DiveCaps.ulStructLen    = sizeof(DIVE_CAPS);

if ( DiveQueryCaps ( &DiveCaps, DIVE_BUFFER_SCREEN ))
   {
   WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
       (PSZ)"Error: DIVE routines cannot function in this system environment.",
       (PSZ)"   This program is unable to run.", 0, MB_OK | MB_INFORMATION );
   return (ES_ERROR);
   };

if ( DiveCaps.ulDepth < 8 )
   {
   WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
       (PSZ)"Error: Not enough screen colors to run DIVE.  Must be at least 256 colors.",
       (PSZ)"   This program is unable to run.", 0, MB_OK | MB_INFORMATION );
   return (ES_ERROR);
   };

// Get an instance of DIVE APIs.
if ( DiveOpen ( &hDive, FALSE, 0 ) )
   {
   WinMessageBox( HWND_DESKTOP, HWND_DESKTOP,
       (PSZ)"Error: Unable to open an instance of DIVE.",
       (PSZ)"   This program is unable to run.", 0, MB_OK | MB_INFORMATION );
   return (ES_ERROR);
   };

return (ES_NO_ERROR);
};


