//-------------------------------------------------------------------------------
// FILE: Spinbut1.cpp
//-------------------------------------------------------------------------------
#define  INCL_WIN
#include <os2.h>
#include "spinbut1.h"

PCHAR achSpin1Array[] = {  "One",
                           "Two",
                           "Three",
                           "Four",
                           "Five",
                           "Six",
                           "Seven",
                           "Eight",
                           "Nine",
                           "Ten",
                           "And once again"
                          };

//-------------------------------------------------------------------------------
// Prototypes
//-------------------------------------------------------------------------------
MRESULT EXPENTRY SpinDlg (HWND, ULONG ,MPARAM, MPARAM);

//-------------------------------------------------------------------------------
// Main
//
// Sets up a simple dialogbox to demonstrate spinbuttons. By using a dialog
// none of the usual window control has to be included.
//-------------------------------------------------------------------------------
void main(void)
     {
     HAB  hab;
     HMQ  hmq;

     hab = WinInitialize(0);
     hmq = WinCreateMsgQueue(hab,0);

     WinDlgBox(HWND_DESKTOP,
               HWND_DESKTOP,
               SpinDlg,
               NULLHANDLE,
               SPINDLG,
               0);

     WinDestroyMsgQueue(hmq);
     WinTerminate(hab);
     }


//---------------------------------------------------------------------------------
// dialog procedure
//---------------------------------------------------------------------------------
MRESULT EXPENTRY SpinDlg(HWND hwndDlg, ULONG ulMsg, MPARAM mpParm1, MPARAM mpParm2)
     {
     switch (ulMsg)
          {
          case WM_INITDLG:
               {
               WinSendDlgItemMsg(hwndDlg,                  // Spinbut1 to predefined
                                 SPINBUT1,
                                 SPBM_SETARRAY,
                                 MPFROMP (achSpin1Array),
                                 MPFROMSHORT (11));

               WinSendDlgItemMsg(hwndDlg,                  // Spinbut2 to range
                                 SPINBUT2,
                                 SPBM_SETLIMITS,
                                 MPFROMLONG (100),
                                 MPFROMLONG (0));
               }
          }
     return WinDefDlgProc(hwndDlg, ulMsg, mpParm1, mpParm2);
     }