//---------------------------------------------------------------------------------------------
// File BUBBLE.CPP
//
// Example of a simple toolbat with a bubble help
// Eric Slaats 12-11-95 (For EDM/2)
//---------------------------------------------------------------------------------------------

#define INCL_WIN
#define INCL_GPIBITMAPS // For RGB struct

#include <os2.h>
#include <stdio.h>
#include "BUBBLE.H"

//---------------------------------------------------------------------------------------------
// Prototypes
//---------------------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc ( HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY NewToolProc   ( HWND, ULONG ,MPARAM, MPARAM ); // subclass Toolbar FOR BUBBLEHELP

//---------------------------------------------------------------------------------------------
// Global vars
//---------------------------------------------------------------------------------------------
HAB   hab;
HWND  hwndFrame,
      hwndClient;

//---------------------------------------------------------------------------------------------
// Main routine
//---------------------------------------------------------------------------------------------
main()
     {
     HMQ    hmq;
     QMSG   qmsg;
     PFNWP  pfnwOldToolProc;  // Pointer to normal Toolbar menu routine for subclassing (bubble)

     ULONG flFrameFlags = FCF_TITLEBAR |FCF_SYSMENU |FCF_SIZEBORDER |FCF_MINMAX
                         |FCF_TASKLIST |FCF_SHELLPOSITION |FCF_MENU ;

     CHAR  szClient[] = "CLIENT";

     hab = WinInitialize (0);
     hmq = WinCreateMsgQueue (hab, 0);

     WinRegisterClass (hab, szClient, ClientWndProc, CS_SIZEREDRAW, 0);

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP,
                                     WS_VISIBLE,
                                     &flFrameFlags,
                                     szClient,
                                     "Toolbar With Bubble Help",
                                     0,
                                     NULLHANDLE,
                                     TOOLMENU,
                                     &hwndClient);
     //---------------------------------------------------------------------------------------------
     // Subclass the menubar
     //---------------------------------------------------------------------------------------------
     // Subclass Tool/menubar (help bubble)
     pfnwOldToolProc = WinSubclassWindow(WinWindowFromID(hwndFrame, FID_MENU) ,NewToolProc);
     // Pointer to oldMenuproc in winword
     WinSetWindowULong(WinWindowFromID(hwndFrame, FID_MENU),QWL_USER,(ULONG)pfnwOldToolProc);


     while (WinGetMsg (hab, &qmsg, 0, 0, 0))
           WinDispatchMsg (hab, &qmsg);

     WinDestroyWindow (hwndFrame);
     WinDestroyMsgQueue (hmq);
     WinTerminate (hab);
     return(0);
     }


MRESULT EXPENTRY ClientWndProc (HWND hwndWnd, ULONG msg, MPARAM mpParm1, MPARAM mpParm2)
     {
     char String[64];

     switch (msg)
          {
          case WM_ERASEBACKGROUND:
          return MRFROMSHORT(TRUE);

          case WM_COMMAND:
               {
               switch (SHORT1FROMMP(mpParm1))
                    {
                    case IDM_ONEB:
                    case IDM_ONE:
                         sprintf(String,"Item ONE selected");
                    break;

                    case IDM_TWOB:
                    case IDM_TWO:
                         sprintf(String,"Item TWO selected");
                    break;

                    case IDM_THREEB:
                    case IDM_THREE:
                         sprintf(String,"Item THREE selected");
                    break;

                    case IDM_FOURB:
                    case IDM_FOUR:
                         sprintf(String,"Item FOUR selected");
                    break;

                    case IDM_FIVEB:
                    case IDM_FIVE:
                         sprintf(String,"Item FIVE selected");
                    break;
                    }

               WinMessageBox(HWND_DESKTOP,
                             hwndWnd,
                             String,
                             "Menu item selected",
                             0,
                             MB_OK|MB_INFORMATION|MB_MOVEABLE);
               }
          }
     return (WinDefWindowProc (hwndWnd,msg,mpParm1,mpParm2));
     }



//--------------------------------------------------------------------------------------------------
// NewToolProc
//
// Subclass toolbar/menu for help display bubblehelp
//--------------------------------------------------------------------------------------------------
MRESULT EXPENTRY NewToolProc(HWND hwnd, ULONG msg, MPARAM mpParm1, MPARAM mpParm2)
     {
     //-------------------------------------------------------------------
     // Static values for reentry (automatic set to 0)
     //-------------------------------------------------------------------
     static HWND  hwndBubble;     // Bubblehelp Framewindow
     static short sLastitem ;     // Last Item Selected
     static BOOL  bBubble = TRUE; // Bubble toggle

     PFNWP oldToolProc = (PFNWP) WinQueryWindowULong( hwnd, QWL_USER ); // Pointer from windowword

     switch (msg)
          {

          case WM_BUTTON2DBLCLK:
               bBubble = !bBubble;
          break;

          case WM_TIMER:
               {
               //-----------------------------------------------------------------
               // Check if Toolbar is no more under mousepointer (Disable bubble)
               //-----------------------------------------------------------------
               POINTL ptl;
               SWP    swpMenu;
               WinQueryWindowPos(hwnd, &swpMenu);
               WinQueryPointerPos(HWND_DESKTOP, &ptl);
               WinMapWindowPoints(HWND_DESKTOP, hwndFrame, &ptl, 1);

               if (swpMenu.x > ptl.x || swpMenu.x + swpMenu.cx < ptl.x ||
                   swpMenu.y > ptl.y || swpMenu.y + swpMenu.cy < ptl.y)
                    {
                    WinDestroyWindow(hwndBubble);
                    hwndBubble = 0;
                    WinStopTimer(hab, hwnd, 1);
                    }
               }
          break;

          case WM_MOUSEMOVE:
	          {
               //--------------------------------------------------------------------------------
               // If frame not queried for active, the editor will become active if moused over!
               //--------------------------------------------------------------------------------
               if (hwndFrame == WinQueryActiveWindow(HWND_DESKTOP) && bBubble)
                    {
                    //---------------------------------------------------------------------------
                    // Define Bubblearray
                    //---------------------------------------------------------------------------------------------
                    short BubbleItems =	6;
                    short asToolEntries[6] = {IDM_ONEB,
                                              IDM_TWOB,
                                              IDM_THREEB,
                                              IDM_FOURB,
                                              IDM_FIVEB,
                                              0};


                    RECTL rectl;        // Button rect
                    short I,            // Counter
                          sCurrentitem; // Menu Value under mouse pointer
                    //---------------------------------------------------------------------------
                    // Check above which item the mouse pointer resides
                    //---------------------------------------------------------------------------
                    for (I=0; I<BubbleItems;I++)
                         {
                         sCurrentitem = asToolEntries[I];
                         oldToolProc(hwnd, MM_QUERYITEMRECT,
                                     MPFROM2SHORT(asToolEntries[I], FALSE),
                                     &rectl);

                         if (MOUSEMSG(&msg)->x > rectl.xLeft   && MOUSEMSG(&msg)->x < rectl.xRight &&
                             MOUSEMSG(&msg)->y > rectl.yBottom && MOUSEMSG(&msg)->y < rectl.yTop)
                              break;
                         }
                    //---------------------------------------------------------------------------
                    // Kill displayed bubble if needed
                    //---------------------------------------------------------------------------
                    if (sLastitem != sCurrentitem && hwndBubble)
                         {
                         WinDestroyWindow(hwndBubble);    // destroy current bubble
                         hwndBubble = 0;                  // reset the bubblehandle for checks
                         }
                    //---------------------------------------------------------------------------
                    // Set up new bubble
                    //---------------------------------------------------------------------------
                    if (!hwndBubble && sCurrentitem)      // if sCurrentitem = 0 not above button
                         {
                         sLastitem = sCurrentitem;
                         //----------------------------------------------------------------------
                         // Set up Bubble window
                         //----------------------------------------------------------------------
                         HWND  hwndBubbleClient;
                         ULONG style = FCF_BORDER;
                         hwndBubble = WinCreateStdWindow(HWND_DESKTOP,       // clipped to desktop (parent)
                                                         0,                  // WindowStyle
                                                         &style,             // Frame style
                                                         WC_STATIC,          // Client class
                                                         "",                 // Titlebar text
                                                         SS_TEXT| DT_LEFT| DT_VCENTER, // Client style
                                                         NULLHANDLE,         // Resource in exe
                                                         BUBBLEHELP,         // ID (defined in header)
                                                         &hwndBubbleClient); // Client hwnd
                         //-----------------------------------------------------------------------
                         // Set window position for bubble
                         //-----------------------------------------------------------------------
                         POINTL pointl = {rectl.xLeft, rectl.yBottom};
                         WinMapWindowPoints(hwnd, HWND_DESKTOP, &pointl, 1);

                         WinSetWindowPos(hwndBubble,
                                         HWND_TOP,
                                         pointl.x, pointl.y - 24,
                                         100 , 22, // size off bubble
                                         SWP_SIZE | SWP_MOVE|SWP_SHOW);
                         //-----------------------------------------------------------------------
                         //Set lettertype and color of bubblewindow with PP
                         //-----------------------------------------------------------------------
                         WinSetPresParam(hwndBubbleClient, PP_FONTNAMESIZE, 7,"8.Helv");
                         RGB rgb = {200,200,0};
                         WinSetPresParam(hwndBubbleClient, PP_BACKGROUNDCOLOR, sizeof(RGB),&rgb);
                         //-----------------------------------------------------------------------
                         // Set the text value in the bubble
                         //-----------------------------------------------------------------------
                         char String[32];
                         WinLoadString (hab, 0, sCurrentitem, sizeof(String), String);
                         WinSetWindowText(hwndBubbleClient, String);
                         //-----------------------------------------------------------------------
                         // Check timer started  (Did the pointer leave the menu area?)
                         //-----------------------------------------------------------------------
                         WinStartTimer(hab, hwnd, 1, 50);
                         }
                    }
               }
               break;
          }
     return oldToolProc(hwnd, msg, mpParm1, mpParm2);
     }

