/*******************************************************************************
*      File: client1.c                                                         *
*                                                                              *
*      Property of Edward D. Boykin                                            *
*      Permission is herby granted to use this code as long as credit          *
*      or beer money is donated to the origional author.                       *
*                                                                              *
*******************************************************************************/
#include <os2.h>
#include <types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdio.h>

/* Client main - Connects to a server on a particulr port
   Arguments:
       hostname   hostname of the server
       port    port number to accept socket connection from client
       name       name to be sent to the server to identify you
*/

main (int argc, char **argv)
{

       ushort  port;   /* Server port to whihc the client will connect */
       char    srbuf[50];      /* Character buffer for sending and receiving
                                  data from client */
       int     csocket;        /* Socket for accepting the client connection */
       int     cname_length;   /* Length of the client name */

       struct  sockaddr_in server;     /* Server's address information */
       struct hostent *hostname;       /* Server hostname information */

       /* Make sure the correct number of args was given */

       if (argc != 4) {

               fprintf(stderr, "Usage: %s hostname port yourname.\n", argv[0]);
               exit(1);                                        /* Bye Bye */

               } /* End if */

       /* Here we will initialize the sockets. This check to see if there is a
          network running */

       sock_init();            /* returns 0 - failed
                                          1 - success */

       /* The port is now prepped by converting the argument to an integer and
          then running htons()
          to convert it from host to network byte order . It is then placed in
          the servers sockaddr_in
          struct's sin_port field. This is just like the server program*/

       port = (ushort) atoi(argv[2]);

       server.sin_port = htons(port);

       /* In order to connect to the server we need its interent address. We
          obtain this by calling
          gethostbyname(). There should be some errors checking here to see
          if the ip address
          wasn't what the user gave but I didn't feel like writing it */

       hostname = gethostbyname (argv[1]);
       if (hostname == (struct hostent *) 0) {

               fprintf (stderr, "Gethostbyname failed\n");
               exit (2);

               }

       /* Now the socket for creating connections is made using the socket()
          call
          It returns > 0 if succes and this is the socket descriptor.
          -1  Indicates an error.
          Check error by calling psock_errno() */

       if ((csocket = socket(AF_INET, SOCK_STREAM, 0)) < 0) {

               psock_errno("Socket()");
               exit(3);

               }

       /* The rest of the neccessary fields in the server's sockaddr_in struct
          are filled*/

       server.sin_family = AF_INET;
       server.sin_addr.s_addr = *((unsigned long *)hostname->h_addr);

       /* Now connect() to the server */

       if (connect(csocket, (struct sockaddr *)&server, sizeof(server)) < 0) {

               psock_errno("Connect()");
               exit(4);

               }

       /* We now have the new connection lets send the server your name... */

       if (send(csocket, argv[3], strlen(argv[3]), 0) < 0) {

               psock_errno("Send() - Login");
               exit(5);

               }

        /* Get the servers reply */

        if (recv(csocket, srbuf, sizeof(srbuf), 0 ) < 0) {

               psock_errno("recv() - Login Reply");
               exit(6);

               }

        fprintf (stderr, "%s\n", srbuf);

        soclose(csocket);

        printf("Client Test was successful\n");
        exit(0);

}


