BOOL sizeMajorTabs(HWND hwndNb)
//-------------------------------------------------------------------------
// This function sizes the major tabs of a notebook according to the
// largest text.
//
// Input:  hwndNb - handle of the notebook
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   HPS hpsTemp;
   SIZEL szlMax;
   ULONG ulMajor;
   ULONG ulPage;
   CHAR achText[256];
   BOOKTEXT btText;
   POINTL aptlBox[TXTBOX_COUNT];
   ULONG ulStyle;

   hpsTemp=WinGetPS(hwndNb);

   szlMax.cx=0;
   szlMax.cy=0;

   ulMajor=LONGFROMMR(WinSendMsg(hwndNb,
                                 BKM_QUERYPAGEID,
                                 MPFROMLONG(0),
                                 MPFROM2SHORT(BKA_FIRST,BKA_MAJOR)));
   while (ulMajor!=0) {
      ulPage=ulMajor;

      while (ulPage!=0) {
         btText.pString=achText;
         btText.textLen=sizeof(achText);

         WinSendMsg(hwndNb,
                    BKM_QUERYTABTEXT,
                    MPFROMLONG(ulPage),
                    MPFROMP(&btText));

         GpiQueryTextBox(hpsTemp,
                         strlen(btText.pString),
                         btText.pString,
                         TXTBOX_COUNT,
                         aptlBox);

         aptlBox[TXTBOX_TOPRIGHT].x-=aptlBox[TXTBOX_BOTTOMLEFT].x;
         aptlBox[TXTBOX_TOPRIGHT].y-=aptlBox[TXTBOX_BOTTOMLEFT].y;

         szlMax.cx=max(szlMax.cx,aptlBox[TXTBOX_TOPRIGHT].x);
         szlMax.cy=max(szlMax.cy,aptlBox[TXTBOX_TOPRIGHT].y);

         ulPage=LONGFROMMR(WinSendMsg(hwndNb,
                                      BKM_QUERYPAGEID,
                                      MPFROMLONG(ulPage),
                                      MPFROM2SHORT(BKA_NEXT,0)));
         if (ulPage!=0) {
            ulStyle=LONGFROMMR(WinSendMsg(hwndNb,
                                          BKM_QUERYPAGESTYLE,
                                          MPFROMLONG(ulPage),
                                          0));
            if ((ulStyle & BKA_MAJOR)!=0) {
               ulPage=0;
            } /* endif */
         } /* endif */
      } /* endwhile */

      ulMajor=LONGFROMMR(WinSendMsg(hwndNb,
                                    BKM_QUERYPAGEID,
                                    MPFROMLONG(ulMajor),
                                    MPFROM2SHORT(BKA_NEXT,BKA_MAJOR)));
   } /* endwhile */

   WinReleasePS(hpsTemp);

   WinSendMsg(hwndNb,
              BKM_SETDIMENSIONS,
              MPFROM2SHORT(szlMax.cx*4/3,szlMax.cy*3/2),
              MPFROMSHORT(BKA_MAJORTAB));

   return TRUE;
}
