#define INCL_ERRORS
#define INCL_DOS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define PROGNAME "client"
#define PIPE_NAME "\\pipe\\sembatch\\server"
#define MESSAGE_SIZE 128

typedef char *pchar, **ppchar;

void error_check(char *string,int i) {
	if (i) {
		printf ("%s -- Error %d!!!\n",string,i);
		exit(-1);
	}
}

void main (int argc, char *argv[]) {
	HFILE hfFile;
	CHAR pszInBuf[MESSAGE_SIZE],pszOutBuf[MESSAGE_SIZE];
	ULONG ulBytes,ulActionTaken,ulFileSize,ulFileAttribute,ulOpenFlag;
	ULONG ulOpenMode;
	USHORT rc;
	INT i;

	setbuf(stdout,NULL);
	for (i=1;i<argc;i++) {
		rc=DosWaitNPipe(PIPE_NAME,-1);
		error_check("DosWaitNPipe",rc);
		ulFileSize=0;
		ulFileAttribute=0;
		ulOpenFlag=OPEN_ACTION_OPEN_IF_EXISTS;
		ulOpenMode=OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE;
		rc=DosOpen(PIPE_NAME,
				   &hfFile,
				   &ulActionTaken,
				   ulFileSize,
				   ulFileAttribute,
				   ulOpenFlag,
				   ulOpenMode,
				   NULL);
		error_check("DosOpen",rc);
		
		strcpy(pszOutBuf,argv[i]);
		
		rc=DosWrite(hfFile,pszOutBuf,MESSAGE_SIZE,&ulBytes);
		error_check("DosWrite",rc);
		printf("wrote:%s\n",pszOutBuf);
/*
		rc=DosResetBuffer(hfFile);
		error_check("DosResetBuffer",rc);
*/		
		rc=DosRead(hfFile,pszInBuf,MESSAGE_SIZE,&ulBytes);
		error_check("DosRead",rc);
		printf("read:%s\n",pszInBuf);

		rc=DosClose(hfFile);
		error_check("DosClose",rc);
	}
}


