import java.awt.*;
import java.lang.Thread;
import java.net.URL;
import java.net.URLConnection;
import java.net.MalformedURLException;
import java.io.IOException;
import java.io.DataInputStream;
import java.io.EOFException;


public class BillBoard extends java.applet.Applet implements Runnable {
       Graphics        offScreenGraphic;
       Image           offScreenImage;
       Dimension       mysize;
       String          Text;
       int             ledSize,
                       ledSpace,
                       CircX,
                       CircY,
                       xOffset,
                       yOffset;

       Thread          clockThread;

       int             Count;

       public void init(){
               int     i;

               Count=0;
               clockThread=null;

               mysize=new Dimension();
               mysize=size();

               ledSize=12;
               ledSpace=3;

               CircX=mysize.width/(ledSpace+ledSize);
               CircY=mysize.height/(ledSpace+ledSize);

               mysize.height=CircY*(ledSpace+ledSize)-ledSpace;
               mysize.width=CircX*(ledSpace+ledSize)-ledSpace;

               offScreenImage= createImage(mysize.width,mysize.height);
               offScreenGraphic=offScreenImage.getGraphics();

//               offScreenGraphic.draw3DRect(100,100,100,100,true);
               offScreenGraphic.drawLine(0,0,mysize.width,mysize.height);

               Color curColor=new Color(255,0,0);

               curColor=curColor.darker();
               offScreenGraphic.setColor(curColor);

               for(i=0;i<CircX;i++){
                   offScreenGraphic.fillOval(i*(ledSpace+ledSize),0,ledSize,ledSize);
                   offScreenGraphic.fillOval(i*(ledSpace+ledSize),mysize.height-ledSize,ledSize,ledSize);
               }

               for(i=1;i<CircY-1;i++){
                   offScreenGraphic.fillOval(0,i*(ledSpace+ledSize),ledSize,ledSize);
                   offScreenGraphic.fillOval(mysize.width-ledSize,i*(ledSpace+ledSize),ledSize,ledSize);
               }

               xOffset=(size().width-mysize.width)/2;
               yOffset=(size().height-mysize.height)/2;

               Font myfont=new Font(getFont().getName(),Font.BOLD,14);
//               FontMetrics myMetric=new FontMetrics(myfont);

               offScreenGraphic.setFont(myfont);

               offScreenGraphic.drawString("Test", ledSpace+ledSize,mysize.height-(ledSpace+ledSize));
       }


       public void update(Graphics g){
          paint(g);
       }

       public void paint(Graphics g){
            g.drawImage(offScreenImage,xOffset,yOffset,this);
       }


       public void stop(){
         if(clockThread!=null){
            clockThread.stop();
            clockThread=null;

         }
       }

       public void start(){
         if(clockThread==null){
            clockThread=new Thread(this);
            clockThread.start();
         }

       }


       public void run(){
         while (true){
            LightLED(Count,true);

            if(Count+1>=2*(CircX+CircY))
               LightLED(0,true);
            else
               LightLED(Count+1,true);

            super.repaint();

            try {
               Thread.sleep(100);
            }
            catch (InterruptedException e) {
            }

            LightLED(Count,false);
            if(Count+1>=2*(CircX+CircY))
               LightLED(0,false);
            else
               LightLED(Count+1,false);


            Count++;
            if(Count>=2*(CircX+CircY))
               Count=0;

            super.repaint();

         }
       }


      private void LightLED(int led, boolean On){
         int X,Y;

         if(led<=CircX){   //top
            Y=0;
            X=(ledSpace+ledSize)*led;
         }
         else if ( (led>CircX) && (led<CircX+CircY) ){   //right
            Y=(ledSpace+ledSize)*(led-CircX);
            X=mysize.width-ledSize;
         }
         else if ( (led>CircX+CircY) && (led<CircX+CircY+CircX) ){   //bottom
            Y=mysize.height-ledSize;
            X=(ledSpace+ledSize)*((CircX+CircY+CircX)-led );
         }
         else{                            //left
            Y=(ledSpace+ledSize)*(2*(CircX+CircY)-led);
            X=0;
         }

         Color curColor=new Color(255,0,0);

         if(!On)
            curColor=curColor.darker();

         offScreenGraphic.setColor(curColor);

         offScreenGraphic.fillOval(X,Y,ledSize,ledSize);
      }
};
