#include <som.hh>


class SaverModule: public SOMObject{
   #pragma SOMClassVersion(*,1,1)
   #pragma SOMNoMangling(on)
   #pragma SOMClassName(*,"SaverModule")


public:
   typedef unsigned long HWND;


   SaverModule();
   ~SaverModule();

   int            IncCount();
   int            DecCount();

   virtual void   ActivateSaver()=0;
   virtual void   DeactivateSaver()=0;

   virtual HWND   GetPageHandle()=0;
   virtual string GetSaverName()=0;

   static void    SetWindow(HWND h);
   static void    SignalStop();

   #pragma SOMNoMangling(pop)
//   #pragma SOMReleaseOrder(GetNumPages(),ActivateSaver(),DeactivateSaver())
private:

   int      UseCount;

   static HWND
            ParentHand;

   #pragma SOMReleaseOrder(GetPageHandle(),GetSaverName(),ActivateSaver(),IncCount(),DecCount(),\
           DeactivateSaver(),SetWindow(HWND),SignalStop(),ParentHand)

};

#pragma SOMIDLPass(SaverModule, "Implementation-Begin", "dllname = \"saver.dll\";")

