/* MAKEURL.CMD Makes a WpURL object. Reads the URL from a file, a messy intermediate step to get
*  around my inability to parse '//' correctly when passed to a REXX command as a parameter.
*  We get the URL object title, and the folder to put it in, from the user. 
*  I am assuming that the Web Sites folder is under the desktop directory. I am also assuming that
*  the environment variable OS2_SHELL is set and that it refers to a program on the boot drive.
*  Note: If you want another URL folder COPY an existing one and rename it.
*  Parameters passed ..
*  URLfile - the name of the file containing the URL
*  Version 1.0 29-09-1999 Bob McLellan Created
*/
/* Set up the program */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
parse arg URLfile
URL=linein(URLfile)

/* Do the work */
Say "Bob's URL creator"
Title=titledialog()
Folder=folderdialog()
Call CreateObject
Exit

CreateObject:
rc = SysCreateObject('WPUrl', Title, Folder, 'DEFAULTVIEW=CONTENTS;URL='||URL||';;OBJECTID=<'||Title||'>', 'Fail' )
If rc <> 1 Then
 Say ' > failed to create ['Title'] at location ['Folder']'
return

titledialog: procedure
/* Get title for URL object. */
Say 'Please supply the title for the URL' 
Parse Pull Title

return Title

folderdialog: procedure
/* Get folder to hold object. */
boot=left(value('OS2_SHELL',,'OS2ENVIRONMENT'),3)                  /* Get the boot drive  & \ */  
/* If your Web URL folders are not in the desktop, change the next line. Watch out for duplicates, as in the ARCHIVES */
rc=SysFileTree(boot||'desktop\web sites','wsfolder','sdo')         /* Look for Web Sites folder */
if rc<>0 then
do
 say 'System problem while looking for Web Sites folder'
 exit
end

if wsfolder.0<>1 then
do
 say 'Either none or many Web Sites folders. Cannot proceed.'
 exit
end

rc=SysFileTree(wsfolder.1||'\*','folders','sdo')        /* Look for url folders in Web Sites folder */
if rc<>0 then
do
 say 'System problem while looking in Web Sites folder'
 exit
end
if folders.0=0 then
do
 say 'No folders found in Web Sites folder. Cannot proceed.'
 exit
end

do forever
 folderno=SelectFolder()              /* Show the folder names to the user and ask for a selection */
 if verify(folderno,'0123456789')<>0 | folderno>folder.0 then
 do
  say 'The response contained something other than digits. Please only enter digits, or'
  say 'The response was a number higher than listed. Please only use a listed number.'
  say 'Do you want to try again Y/N'
  pull reply
  if translate(reply)<>'Y' then exit
 end
 else leave
end

thefolder=folders.folderno

return thefolder

SelectFolder:
Say 'Please enter the NUMBER of the folder to hold the URL'
x=0
outline=''
blank='               '                             /* Create a 15 character field */

do i=1 to folders.0+1
 x=x+1
 field=overlay(filespec('Name',folders.i),blank,,15) /* Get just the name from the full filespec */
 outline=outline i field
 if x=3 | i=folders.0 then
 do
  say outline
  outline=''
  x=0
 end
end
Say 'Please enter the NUMBER of the folder to hold the URL' 
Parse Pull folderno
return folderno