:userdoc.
:title.SPEW Documentation
.*******************************************************************
.*
.*
:h1.Read Me
:p.
A while back, mark@pixar posted a program to generate random 'National
Enquirer' headlines.  This program worked from a 'rules file' which was a text
file describing how the headlines would be constructed.
:p.
Mark's program was, unfortunately, highly non-portable, and rather than
try to salvage it I wrote a new interpreter for the same text file.
Since then I have added several features, and thus greatly changed the
format of the rules file. Credits go to mark for the original concept
and much of the text in the supplied rulesfile (which I have cleaned up
and added to).
:p.
This shar includes the National Enquirer rules-file 'headline', the source to
the 'spew' interpreter, a 'manual' for the format of the control file, and
this READ_ME file. I believe this program might actually be useful, for such
tasks as generating huge quantities of input text for testing programs.  (I
may have a file which generates random syntactically-correct C code, but I
won't admit to it!! &colon.-). The format of the file allows a wide variety of text
formats to be generated - it almost works like Yacc in reverse.
Anyway, things like 'festoon' could certainly be coded as 'spew' rulesfiles,
and could thus be sent to the net as a 'spew' source.
Sorry I haven't written a proper manual page, but...
:p.
:font facename=Courier size=16x14.
:lines.
USAGE:
        spew [n]        generate one [or n] random thing(s) from default
                        rulesfile. If the environment variable RULESFILE
                        is set, the file-name is taken from there; other-
                        wise a compiled-in name is used (see Installation
                        instructions).

        spew [n] file   Same, but use the given file as input.

        spew -c
or      spew -c file    'Compress' the default or given file to the
                        standard output (the compressed format is unreadable
                        and must be redirected). 'Compress' is a misnomer
                        because the file gets about 20% larger. The
                        'compressed' format is more efficient for spew to
                        operate from, though. Spew automatically knows
                        whether it is reading a compressed or human-readable
                        rulesfile.  Examples:
                spew headline                   << make a headline
                spew -c headline >headline.comp << make compressed file
                spew headline.comp              << make another headline

        spew -d
        spew -d file    Read the default or given file, and dump the
                        resulting internal structure to the std output.
                        The format is pretty easy to figure out. It is
                        somewhat different when the input file is in
                        'compressed' format. DUMP must be #define'd
                        to enable this feeping creature.
:elines.
:font facename=default size=0x0.
:p.
INSTALLATION INSTRUCTIONS&colon.
The file spew.c contains some clearly labeled #defines which you may
want to play with. It should be possible to port to non-Un*x systems
just by changing these. The most important ones to start with are&colon.
:dl break=all tsize=3.
:dt.DEFFILE
:dd.which is the default rules file to use. Set this to the path
of your 'headline' file and then you can just put 'spew' in your
".login" file.
:dt.ENVIRON
:dd.which is set to "RULESFILE" in the release package. If this
environment variable is set, it is assumed to be a default file-name
over-riding the DEFFILE. You may want to change this.
Remove the #define if you don't have getenv().
:dt.SETRAND
:dt.ROLL(n)
:dd.define the former to a STATEMENT (not an expression) which
initializes your random number generator. Define the latter as
an expression which gives a random integer in the range 0<=i<n.
'n' will be an integer from 1 to several hundred.
The supplied definitions may or may not work well, depending
on your machine (here we have a VAX 11/780 4.2BSD, works ok
on a Sun too).
:edl.
.*******************************************************************
.*
.*
:h1.OS/2 Port-Specific Information
:p.
:hp5.Notes:ehp5.
:p.
You should have the following files in your spew.zip archive:
:lines.
        headline
        spew.exe
        spew.inf
        src/makefile
        src/spew.c
        src/spew.ipf
:elines.
:ul compact.
:eul.
:p.
The instructions in "Read Me" are basically correct.  If you do not type
in any argument when running spew, then the file "headline"
:hp1.must:ehp1. be in the current directory.  Otherwise, you must set
the :hp2.RULESFILE:ehp2. environment variable to point to the directory
that it is in, such as&colon. (the '/' are important)
:p.
        SET RULESFILES=C&colon./OS2/HEADLINE
:p.
:hp5.Changes:ehp5.
:ul compact.
:li.Makefile changed slightly to compile under emx as well as to include
the documentation compiler.
:li.IPF help file added in place of documentation.  (README, etc.)
:eul.
:p.
This was compiled with emx-0.8f but it does not require EMX.DLL.
:p.
Since the full, unmodified source and documentation was not included, I
am obligated to tell you that you can get it from the archive site
:hp2.wuarchive.wustl.edu:ehp2. in the directory
:hp8./usenet/comp.sources.misc/volume01:ehp8..
:lines align=center.
Jeff M. Garzik - April 17, 1993
gtd543a@prism.gatech.edu (preferred until June 1997)
jgarzik@nyx.cs.du.edu
jeff.garzik@bbs.oit.unc.edu
:elines.
.*******************************************************************
.*
.*
:h1.Manual
:p.
INPUT FILE FORMAT&colon.
:p.
The file is a series of class definitions followed by an end
marker. The end marker is a line containing only "%%".
:p.
A class definition begins with a line containing '%' followed by a class
name. Class names can be any length and can consist of any combination
of upper and lower case letters, and numbers.
:p.
The lines following are instances of the class, one per line. When a
class is invoked, one of these is picked at random. Most characters in
the line are just copied to the output. The newline at the end is not
copied. An instance may be continued onto the next line by ending the
line with '\'. There is a limit of 1000 bytes on the total size of an
instance.  An instance may begin with '%' if it is escaped&colon. '\%'. A
newline may be written as '\!'. A backslash may be written as '\\'.
:p.
The following is a simple rules-file that prints out either 'foo'
or bar, followed by a carriage-return&colon.
:font facename=Courier size=16x14.
:lines.
%MAIN
foo\!
bar\!
%%
:elines.
:font facename=default size=0x0.
:p.
The program generates a random instance of the class 'MAIN', which in
this case selects 'foo' or 'bar', with a 50-50 chance. A newline is
appended.
:p.
:hp2.WEIGHTS:ehp2.
:p.
To give 'foo' a 90% chance of happening, you can assign weights&colon.
:font facename=Courier size=16x14.
:lines.
%MAIN
(9)foo\!
bar\!
%%
:elines.
:font facename=default size=0x0.
:p.
The weight of 'bar' is 1 by default. If an instance is to begin with '('
it must be escaped, or given an explicit weight&colon.
:font facename=Courier size=16x14.
:lines.
\(animal)
(1)(vegetable)
:elines.
:font facename=default size=0x0.
:p.
:hp2.INVOCATION:ehp2.
:p.
Classes are normally invoked by writing their name immediately after a
backslash. Below is a rules-file which is equivalent to the foo-bar
example&colon.
:font facename=Courier size=16x14.
:lines.
%MAIN
\word\!
%word
(9)foo
bar
%%
:elines.
:font facename=default size=0x0.
:p.
In this case, the class 'word' outputs either 'foo' or 'bar', and
the newline is appended after the invocation in 'MAIN'.
:p.
If you wish to immediately follow a class invokation by a letter or a number,
you must write it followed by a slash and a space&colon.
:font facename=Courier size=16x14.
:lines.
%MAIN
\word/ bar\!
%word
foo
bar
%%
:elines.
:font facename=default size=0x0.
:p.
The above outputs either 'foobar' or 'barbar'. This method must also
be used if the invokation is to be immediately followed by a slash.
:p.
:hp2.VARIANTS:ehp2.
:p.
A class may be defined with variants, and may then be invoked with
variants. The 's' variant defined for the 'fruit' class below
allows correct plurals to be generated&colon.
:font facename=Courier size=16x14.
:lines.
%fruit{s}
apple{|s}
cherr{y|ies}
pear{|s}
mango{|es}
%MAIN
One \fruit and two \fruit/s.\!
%%
:elines.
:font facename=default size=0x0.
:p.
The variant tag is a single letter or number. In an invocation, the
class name is followed by a slash which is followed by the tag. Every
class has a 'null' variant (tagged by a space) by default (thus the "/ "
notation).
:p.
In the class definition line, the class name is followed by a list
of variant tags in curly brackets. The order of the tags is
significant.
:p.
In an instance definition, variants may be created with the following
notation&colon.
:p.
        { <null-variant-text> | <1st-variant-text> | <2nd-variant-text }
:p.
When a class is invoked with a null tag, or with a blank tag, the
text before the first '|' is used. If the first tag is used in the
invocation (i.e. the first tag listed in {}'s in the class definition),
the text between the first and second |'s is used, and so forth.  All
text not in {}'s is copied regardless of the tag used.
:p.
There are normally as many |'s in these as there are tags defined.
If there are too many tags, the excess ones select null strings, and
if there are too many |'s, the excess strings are redundant.
:p.
The '{' character, if required literally,  must always be escaped
outside the selector construction&colon. '\{', even when no variants are
defined in a class. The '|' and '}' characters must likewise be
escaped inside a constructor.
:p.
Invocations may appear in a selector, but cannot span a selector.
I.e. you cannot select between invoking 'catwalk' and 'catfish' by
:font facename=Courier size=16x14.
:lines.
        \cat{walk|fish}
:elines.
:font facename=default size=0x0.
:p.
You must use {\catwalk|\catfish}.
:p.
Finally, there is the &amp. tag which may be used in an invocation and
selects the same tag letter (or number) which the invoking
class was invoked with&colon.
:font facename=Courier size=16x14.
:lines.
%food{s}
\fruit/&amp.                        <--- this is the same as
{\fruit|\fruit/s}               <--- this.
:elines.
:font facename=default size=0x0.
:p.
MAIN is initially invoked with the null tag (although it can be invoked
recursively with other tags).
:p.
Here is a class with multiple tags that generates irregular verbs&colon.
:font facename=Courier size=16x14.
:lines.
%verb{sd}
{eat|eats|ate}
{be|is|was}
{see|sees|saw}
look{|s|ed}
f{ind|inds|ound}
%%
:elines.
:font facename=default size=0x0.
:p.
Thus \verb/d generates a past-tense verb.
:p.
:hp2.COMMENTS&colon.:ehp2.
:p.
At any point, '\*' may appear on a line and the rest of the line
is ignored. Blank lines are ignored completely ( as are lines
beginning in \* ).
Empty instances must therefore be given an explicit weight of one&colon.
:font facename=Courier size=16x14.
:lines.
%AllOrNothing\* 50% chance, 'All', or nothing.
All
(1)
:elines.
:font facename=default size=0x0.
:euserdoc.

