!    LockTest                   An inform library to choose default keys
!                               By L. Ross Raszewski
!
! By giving any key the "is_key" attribute, the commands "Lock" and "Unlock"
! will choose a default key if only one is held.  If more than one key is held,
! it checks the property "key_to".  If only one object has an entry in its 
! key_to array matching the object to be unlocked, it will be chosen as the
! default key.  This way, the game can recognise obvious keys, such as a 
! "gold key" to a "gold door".  If you think that this will give away a puzzle,
! just don't give that object a key_to value.
!
! This library IS compatible with the improved multi-key locking function by 
! the author
!



#IFNDEF key_to;
property key_to $ffff;
#ENDIF;
global assumed_key;
attribute is_key;
[ DefaultUnlockSub;
        print "(with ", (the) assumed_key, ".)^";
        <<Unlock noun assumed_key>>;
];
[ DefaultLockSub;
        print "(with ", (the) assumed_key, ".)^";
        <<Lock noun assumed_key>>;
];
[ DefaultKeyTest i j count;
        if (noun hasnt lockable) rfalse;
        objectloop (i in player)
                if (i has is_key) { count++; assumed_key=i;};
        if (count==1) rtrue;
        if (count>1) {
                count=0;
                objectloop (i in player)
                        { if (i has is_key)
                        { for (j=0:j<=(i.#key_to):j++)
                                if ((i.&key_to)-->j==noun)
                                        {count++; assumed_key=i;};};};};
        if (count==1) rtrue;
        rfalse;
];
Extend "lock" first * noun=DefaultKeyTest         ->DefaultLock;
Extend "unlock" first * noun=DefaultKeyTest       ->DefaultUnlock;
