#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BLOCK 1000

struct alkio {
  long   score;
  long   pvm;
  fpos_t paikka;
};

struct alkio * varaa (struct alkio *haku, int *varattu);
int vertaa (const void *a, const void *b);

int main (int argc, char *argv[])
{
 FILE *fp;
 struct alkio *haku=NULL;
 int i,
     varattu=0,
     lkm=0;
 char *fnimi="logfile",
      rivi[250];

 if (argc > 1)
    fnimi=argv[1];

#pragma warn -pia
 if (!(fp=fopen(fnimi,"r"))) {
#pragma warn .pia
    fprintf (stderr,"Can't open %s",fnimi);
    exit (1);
 }

 while (1) {
    if (lkm>= varattu)
       haku=varaa(haku,&varattu);
    fgetpos(fp,&(haku[lkm].paikka));
    fgets(rivi,sizeof(rivi),fp);
    if (feof(fp))
       break;
    if (strncmp(rivi,"3.4.",4)!=0 && strncmp(rivi,"3.3.",4)!=0) /* wrong version */
       break;
    sscanf (rivi,"%*d.%*d.%*d %ld %*d %*d %*d %*d %*d %*d %*ld %ld",
        	&(haku[lkm].score),&(haku[lkm].pvm));
    lkm++;
 }
 qsort (haku,lkm,sizeof (struct alkio),vertaa);

 for (i=0; i<lkm; i++) {
     fsetpos(fp,&(haku[i].paikka));
     fgets (rivi,sizeof(rivi),fp);
     printf (rivi);
 }
 return 0;
}

struct alkio * varaa (struct alkio *haku, int *varattu)
{
 *varattu+= BLOCK;
 haku=realloc(haku,*varattu * sizeof(struct alkio));
 if (!haku) {
    fprintf (stderr,"Can't allocate enough memory for %d records!",*varattu);
    exit (1);
 }
 return haku;
}

int vertaa (const void *a, const void *b)
{
 long ero;
 struct alkio *p1,*p2;

 p1=(struct alkio*)a;
 p2=(struct alkio*)b;
 ero=(p1->score - p2->score);   /* Pisteet laskevaan jrjestykseen..   */
 if (!ero)
    ero=(p2->pvm - p1->pvm);    /* Jos sama, niin pivmr nousevaan */
 if (ero<0)
    return 1;
 else if (ero>0)
    return -1;
 else
    return 0;
}