! Replacement for "WriteListFrom()".
! Version 0.98 of 14-April-97
! by Andreas Hoppler. Parts (lots) of this code by Graham Nelson.
!
! Andreas Hoppler ("andreas.hoppler@logon.ch")
! Zurich, Switzerland

Global use_new_writelist = true;

[ WriteListFromNew o style depth  l p;
        p = parent(o);
        if (o==child(p))
        {   SortOutList(o); o=child(p); }
        c_style=style;
        wlf_indent=0;
        l = Top__Lister;
        if (p && p provides lister_kind) {
            l = p.lister_kind;
        }
        l.List__R(o,depth);
        rtrue;
];

[ WriteListFromOld o style depth;
        if (o==child(parent(o)))
        {   SortOutList(o); o=child(parent(o)); }
        c_style=style;
        wlf_indent=0; WriteListR(o,depth);
        rtrue;
];

[ WriteListFrom o style depth;
        if (use_new_writelist)
            return WriteListFromNew(o,style,depth);
        else
            return WriteListFromOld(o,style,depth);
];

[ Locale descin text1 text2   lister;
    lister=GetListerKind(descin);
    lister.List__Locale(descin, text1, text2);
];

#ifdef EnglishNaturalLanguage;

[ List__EnglishMessage n x1;
        ! in the final version, these messages should be in 'english.h',
        ! under ListMiscellany.
        switch (n) {
            ! when ISARE_BIT is set
            1001:   print " you see:^";             ! singular or plural, NEWLINE_BIT
            1002:   print " ", (isorAre) x1, " ";   ! singular or plural
            1003:   print "are:^";                  ! guaranteed plural, NEWLINE_BIT
            1004:   print " are ";                  ! guaranteed plural

            ! used for list_together
            ! the messages with even numbers finish the message before.
            1011:   print (number) list_many, " ", (string) x1;         !  neither ENGLISH_BIT nor NEWLINE_BIT
            1012:   print "";
            1013:   print (number) list_many, " ", (string) x1, " (";   !  ENGLISH_BIT
            1014:   print ")";
            1015:   print (number) list_many, " ", (string) x1, ":^";   !  NEWLINE_BIT
            1016:   print "";

            ! used for recursion
            ! the messages with even numbers finish the message before.
            1021:   print ", with ";        ! Neither 'container' nor 'supporter'
            1022:   print "";
            1023:   print " (";             ! TERSE_BIT, not 'container'/'supporter'
            1024:   print ")";
            1025:   print ", on which";     ! 'supporter'
                    if (list_many>1) print (string) IS__TX;
                    else             print (string) ARE__TX;
                    print " ";
            1026:   print "";
            1027:   print " (with ";        ! TERSE_BIT, 'supporter'
            1028:   print ")";
            1029:   print ", which contains ";  ! 'container'
            1030:   print "";
            1031:   print " (containing ";  ! TERSE_BIT, 'container'
            1032:   print ")";
            default: rfalse;
        };
        rtrue;
];

#ifnot;

[ List__GermanMessage n x1;
        ! in the final version, these messages should be in 'german.h',
        ! under ListMiscellany.

        switch (n) {
            ! wenn ISARE_BIT gesetzt ist, werden folgende texte produziert
            1001:   print (ist) x1, ":^";       ! sing/plural, NEWLINE_BIT
            1002:   print (ist) x1, " ";        ! sing oder plural
            1003:   print "sind:^";             ! plural, NEWLINE_BIT
            1004:   print "sind ";              ! plural

            ! Wenn list_together von der Klasse string ist, werden
            ! die folgenden Texte produziert:
            ! (Die Meldungen mit geraden Nummern schliessen die vorhergehenden
            ! Meldungen ab).
            1011:   print (number) list_many, " ", (string) x1;         !  weder ENGLISH noch NEWLINE
            1012:   print "";
            1013:   print (number) list_many, " ", (string) x1, " (";   !  ENGLISH_BIT
            1014:   print ")";
            1015:   print (number) list_many, " ", (string) x1, ":^";   !  NEWLINE_BIT
            1016:   print "";

            ! die folgenden Texte erscheinen, wenn rekursiv gelistet wird.
            ! (Die Meldungen mit geraden Nummern schliessen die vorhergehenden
            ! Meldungen ab).
            ! short_name_case kann hier veraendert werden, und wird am
            ! Listenende automatisch wieder auf den alten wert gesetzt.

            1021:   print ", mit ";                ! Weder 'container' noch 'supporter'
                    short_name_case = CASE_DAT;
            1022:   print "";
            1023:   print " (mit ";                ! TERSE_BIT, weder 'container' noch 'supporter'
                    short_name_case = CASE_DAT;
            1024:   print ")";
            1025:   print ", auf ";                ! 'supporter'
                    PrefaceByArticle(x1, CASE_DAT, true, false);
                    short_name_case = CASE_NOM;
            1026:   if (list_many > 1) print " ruhen"; else print " ruht";
            1027:   print " (darauf ";             ! TERSE_BIT, 'supporter'
                    short_name_case = CASE_AKK;
            1028:   print ")";
            1029:   if (x1 has pluralname or female) ! 'container'
                        print ", welche ";
                    else if (x1 has male)
                        print ", welcher ";
                    else
                        print ", welches ";
                    short_name_case = CASE_AKK;
            1030:   if (x1 has pluralname)
                        print " enthalten";
                    else
                        print " enth@:alt";
            1031:   print " (darin ";              ! TERSE_BIT, 'container'
                    short_name_case = CASE_AKK;
            1032:   print ")";
            default: rfalse;
        };
        rtrue;
];

#endif;

