! Date                  An Inform Library Extention, written for Inform 5.5
!                       With library release 5/12. (Time games only)
!                       (c) 1996 L. Ross Raszewski
!                       REQUIRES ordinal.h
! recognises 30 and 31 day months and Leap Years!
! Month Day and year are stored in global variables of the same names.  Calling 
! the AdvDate function (from the TimePasses routine) advances the date if required
! Add this line before inclusion:
!       Global last_time;
! and then to the TimePasses Routine, somewhere add:  
!       AdvDate();
!       last_time=the_time;
! the Function PrintDate(format) 
! Prints the date, according to a given format:
!  1: Long Date, month day and year written out.
!  2: Month written out, day and year as numbers
!  3: Same as above, in Day-Month-Year format
!  4: Same as 2, month abbreviated
!  5: Same as 3, Month abbreviated
!  6: MM-DD-YY
!  7: MM/DD/YY
!  8: DD-MM-YY
!  9: DD/MM/YY
!If the Constant DATE_D is defined before inclusion, PrintDate defaults to 
!that format.  If it is not defined, it defaults to format 2.
!Date.h also includes 2 debugging verbs: 'Date' and 'SetD'. The usage
!"Date #" prints the current date in format #.  SetD M #, SetD D #, and 
!SetD Y # set the Month, Day, and year to the numbers given.
!
!The date is set by calling the function SetDate(m,d,y)

#IFNDEF DATE_D; Constant DATE_D 2; #ENDIF;
Global month=1;
Global day=1;
Global year=1996;
#IFNDEF DATE_D; Constant DATE_D 2; #ENDIF;
Array Month_NL --> "0" "January" "February" "March" "April" "May" "June" "July" "August" "September" "October" "November" "December";
Array Month_NS --> "0" "Jan." "Feb." "Mar." "Apr." "May" "Jun." "Jul." "Aug." "Sept." "Oct." "Nov." "Dec.";

[ PrintDate format i;
        if (format == 0) format=DATE_D;
        switch(format)
        {1: {print (string) Month_NL-->month, " "; 
                OrdinalNum(day); print ", ";
                       i=year/100;
                       EnglishNumber(i);
                       i=year%100;
                       print " ";
                       EnglishNumber(i);};
        2: print (string) Month_NL-->month, " ", day, ", ", year;
        3: print day, " ", (string) Month_NL-->month, ", ", year;
        4: print (string) Month_NS-->month, " ", day, ", ", year;
        5: print day, " ", (string) Month_NS-->month, " ", year;
        6: print month, "-", day, "-", (year%100);
        7: print month, "/", day, "/", (year%100);
        8: print day, "-", month, "-", (year%100);
        9: print day, "/", month, "/", (year%100);};];

[ SetDate m d y; month=m; day=d; year=y; ];

[ AdvDate;
        if (the_time>=last_time) rfalse;
        day=day+1;
          if (day==32 || (day==31 && 
             (month==6 || month==4 || month==9 || month==11)) ||
                (day==29 && month==2 && (year%4)~=0) ||
                        (day==30 && month==2 && (year%4)==0))
                {month=month+1; day=1;
                if (month==13) {month=1; year=year+1;};};
          rtrue;
];

#IFDEF DEBUG;
[ PrintDSub; PrintDate(noun);];
[ SetMonthSub; month=noun;];
[ SetDaySub; day=noun;];
[ SetYearSub; year=noun;];
verb "Date" * number                    ->PrintD
            *                           ->PrintD;
verb "SetD" * "m" number                ->SetMonth
            * "d" number                ->SetDay
            * "y" number                ->SetYear;
#ENDIF;

