!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!       AltMenu                 An Inform 6 Library extension to create 
!  Version 5.0a                 object-oriented menus.  By L. Ross Raszewski
!                               (rraszews@acm.org)
!  Requires DoMenu.h and utility.h
!
!  new in 5.0a: minor bugfix concerning banner_tags
!  new in 5.0: Added "tag" support, added version ID number
!              major code cleaning and revision
!              support for domenu 5 features
!  New in 4.2: "label" added
!  New in 4.1: Options with the 'locked' attribute are handled like separators
!
!    In brief, this is an object oriented front-end to my modified domenu
!    library.  It is designed for use with toggle options and dynamic menus
!    It supports menus over a page long.  It's easy to use and yet
!    greatly versatile.
!
! Usage:
!       To activate a menu, send the select(); message to the appropriate 
!       Menu-Class object.  The menu will automatically manipulate menus
!       longer than one screen.
!       Set the "nolook" attribute to suppress the <<look>> action generated
!       when quitting the menu
!       the short name:
!               if a title bar is given, printed on the second line of the
!               banner, else printed on the first line.
!       the description property:
!               Holds the description test to be printed at the top of the
!               menu.
!       the number property:
!               Holds the number of lines which the description takes up
!               or a function to determine them.  If someone can provide
!               me with a reliable function, which can account for
!               differing screen widths, variable pitch font,
!               and manual new_lines, please send it this way!.
!       the title_bar property:
!               If given, is printed on the top line of the banner
!       the sup_bar property:
!               if given, is printed on the second line of the banner.
!               DO NOT use both a sup_bar and a title_bar.
!       the banner_tags property:
!               if given, this array contains the top bar tags to be used
!               by domenu (see domenu.h for the format of the tagarray
!
!    The children of a menu are the items of that menu. All children
!    of a menu must inherit from class Option.
!       the select property:
!               Performs the task of the option.  Returns 1 to wait for a
!               keypress, 2 to return with no keypress, and 3 to return and
!               exit the current menu. By default, this prints the description
!               of the object.
!       the "tag" property:
!               if given, this is used as the name given in menu itself
!       the label property: if given, this is used as the name placed in the
!               top bar when the option is selected
!
!   This library contains 2 additional varities of option classes:
!       Separator: A menu item which cannot be selected.  Useful for
!               grouping options together within a menu.
!       SwitchOption: A menu item designed to toggle, as in game settings
!          the label property: Printed in the menu.  Should be changed
!                to reflect the setting of the switch
!          (synonymous to tag property.  If both a tag and a label are given
!           preference is given to the tag)
!          the toggle property: Does the work of the switch.  This may be
!                as simple as turnign the object from ~on to on, but might
!                involve global variables or otherwise affect the behavior
!                of the game
!  NOTES:
!       For adaptive menus, in order to keep items in the same order,
!       use the Pmove function (from pmove.h) to preserve lineage.
!
!  This is part of a series of inter-dependant libraries.
!  For this to work, you have to include:
!  DoMenu       -> A modified DoMenu routine to support extended functionality
!  Utility      -> A set of generic utility functions
! For maximum enjoyment, add on (not required)
!  Hints.H      -> A system for making object-oriented hints which appear
!                      formatted in the same way as Infocom's InvisiClues
!
System_file;
iffalse DOMENU_LIBRARY>42;
message error "AltMenu 5.0 requires version 4.2 or greater of the DoMenu library";
endif;
ifndef ALTMENU_LIBRARY;
Constant ALTMENU_LIBRARY 50;
Attribute nolook alias door;
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Option Class (Menu options)
!        select             (calls self.description to perform menu
!                                       function.)
!                               returns: self.description();
!       Usage:
! Option "Option One"
!       with description "Some text here.";
!       Note - description returns 1 to run and wait for a keypress,
!               2 to run and return to the menu with no keypress
!               3 to run and quit the current menu.
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Class Option
        with    tag [; print (name) self;],
                select [; return self.description();];

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Separator Class (Null Menu Item)
!      Usage:
! Separator "Game Commands";
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
Class separator
        class option;

!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! SwitchOption Class (Toggle options)
!       with sup_bar (this is only a stub property.  Switchoptions will never 
!                        use a sup_bar.)
!           short_name (prints self.label, if provided.)    
!           select (runs self.toggle();)    
!           title_bar (this is also a stub.)
!
!       Usage:
!  SwitchOption sound
!        with label [; print "Sound     ";
!                       if (self has on) style reverse; print "ON";
!                       style roman; print "   ";
!                       if (self hasnt on) style reverse; print "OFF";
!                       style roman;],
!               toggle [; if (self has on) give self ~on; else give self on;];
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 
Class SwitchOption              
  with    
       sup_bar NULL,
       short_name [; if (self provides label) 
                     { self.label(); return 1;}
                  ],
       select [; self.toggle(); return 2;],
       title_bar NULL;


!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
! Menu class (This is the big one.)
!       class option (A menu can also be an option of another menu.)
!       with select (The main menu loop. throws the results back to Domenu.)
!            label (Stub for the option label property.)
!            toggle (Stub for the switchoption toggle property)  
!            emblazon (prints the menu text, self.description, and the 
!               list of children.  This is the first argument sent to Domenu.)
!            titles (generates the option names sent to Domenu.)
!            execute (runs the selected option.  Sent as the third argument 
!                       to Domenu)  
!            selection_name (generates the name needed by self.titles)
!            doname (prints the name of the menu.  A separate property, 
!               because of the form of argument required by Domenu.)
!
!       Usage:
! Menu "Main Menu"
!       with description "This is the main Menu",
!            number 1, ! not strictly required, because in this case it is 1,
!                      !but provided for clarity
!            title_bar "The big game",  !will be printed on the first line 
!                               ! of the menu bar
!            sup_bar "A menu"; !will be printed on the second line.  Use one,
!                               ! or the other, not both.
!
!
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
Class Menu
  class Option
  with select [i j; 
                if (self has nolook) i=1;
                else i=0;
                if (self.banner_tags ~=0) j=self.&banner_tags;
                DoMenu(self.emblazon,self.titles,self.execute,i,j);
                return 2;
              ],
       banner_tags 0,
       label NULL,
       toggle NULL,
       emblazon [ doFrom o;
                  if (doFrom==0)
                   {
                    if (self provides description)
                     self.description();
                    else new_line;
                    dofrom=1;
                   }

                  o=Scion(self,dofrom);
                  while (o ofclass object)
                   {
                    spaces(5);
                    if (o provides tag) o.tag();
                    else print (name) o;
                    new_line;
                    o=sibling(o);
                   }
                   
                ],
       titles [ o;
                if (menu_item==-5)
                {
                  o=Scion(self,SkipItem);
                  if (o ofclass separator || o has locked)
                   return SKIP;
                }
                else if (menu_item==-1)
                {
                 if (self provides sup_bar)
                  item_name=self.sup_bar;
                 if (self provides title_bar) 
                  item_name=self.doname;
                 if (self provides number)
                  return self.number();
                 else return 1;
                }
                else if (menu_item==0)
                {
                 if (self provides title_bar)
                  item_name=self.title_bar;
                 else item_name=self.doname;
                 return children(self);
                }
                else
                {
                 o=Scion(self,menu_item);
                 if (o ofclass object)
                 { item_width=o;
                   item_name=self.selection_name;
                 }
                }
              ],
       execute [ o j; 
                 j=2;
                 o=Scion(self,menu_item);
                 if (o ofclass object)
                  j=o.select();
                 return j;
               ],
       number 1,
       selection_name [;
                        if (item_width provides label && item_width.label~=NULL)
                         if (item_width.label ofclass string) print (string) item_width.label;
                         else item_width.label();
                        else print (name) item_width;
                      ],
        doname [; print (name) self;];
endif;
