/*------------------------------ os2sound.c ----------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <audio.h>

#include "fly.h"

/* following define using DosBeep and the PC speaker */
#define SPEAKER 1

static AUDIOINFO info;
static LPAUDIOWAVE lpWave=NULL;
static HAC hVoice[2];
static BYTE aBuffer[5*1024];

static int useseal = 0, dynwave = 0;;

#define TRUE 1
#define FALSE 0

#if 1
#define FREQ(nPeriod) (((LONG) lpWave->nSampleRate * 428) / nPeriod)
#else
#define FREQ(nPeriod) ((LONG) nPeriod)
#endif

unsigned long DosBeep (unsigned long ulFrequency, unsigned long ulDuration);

/* Initialize this module.
*/
extern BOOL FAR
FInitSnd (void)
{
        UINT n, m;
    	AUDIOCAPS caps;

	/* initialize audio library */
	AInitialize();
    
	useseal = AGetAudioNumDevs ();
    	LogPrintf("List of registered sound devices:\n");
    	for (n = 0; n < useseal; n++) {
        	AGetAudioDevCaps(n, &caps);
        	LogPrintf("  %2d. %s\n", n, caps.szProductName);
    	}

	if (useseal >= 0) {
	    /* open audio device */
	    info.nDeviceId = AUDIO_DEVICE_MAPPER;
	    info.wFormat = AUDIO_FORMAT_16BITS | AUDIO_FORMAT_STEREO;
	    info.nSampleRate = 22050;
    	    if ((m = AOpenAudio(&info)) != AUDIO_ERROR_NONE) {
	        CHAR szText[80];
        	AGetErrorText(m, szText, sizeof(szText) - 1);
        	LogPrintf("ERROR: %s\n", szText);
        	useseal = 0;
        	return FALSE;
    	    }
    
    	    /* print information */
    	    AGetAudioDevCaps(info.nDeviceId, &caps);
    	    LogPrintf("%s at %d-bit %s %u Hz detected\n",
        	caps.szProductName,
        	info.wFormat & AUDIO_FORMAT_16BITS ? 16 : 8,
        	info.wFormat & AUDIO_FORMAT_STEREO ? "stereo" : "mono",
        	info.nSampleRate);

	    /* first allocate structure to hold the waveform object */
	    if ((lpWave = (LPAUDIOWAVE) malloc(sizeof(AUDIOWAVE))) != NULL) {
		/* create 8k Hz sinewave (sampled at 10 kHz) */
		for (n = 0; n < sizeof (aBuffer); n++)
		    aBuffer[n] = (BYTE)(127.0 * sin((8192 * 3.141592653 * n) /
						    sizeof (aBuffer)));

		/* create a 16-bit steroe one-shot waveform object */
		lpWave->wFormat = AUDIO_FORMAT_16BITS | AUDIO_FORMAT_STEREO;
		lpWave->nSampleRate = 22050;
		lpWave->dwLength = sizeof (aBuffer);
		lpWave->dwLoopStart = lpWave->dwLoopEnd = 0;
		if (ACreateAudioData(lpWave) != AUDIO_ERROR_NONE) {
		    free(lpWave);
		    lpWave = NULL;
		    return FALSE;
		}
		/* copy the data into the waveform object */
		memcpy(lpWave->lpData, aBuffer, sizeof (aBuffer));
		/* upload the data to the audio DRAM local memory */
		AWriteAudioData(lpWave, 0L, sizeof (aBuffer));

		dynwave = 1;
	    }

	    /* open and allocate voices */
	    AOpenVoices(2);
	    ACreateAudioVoice(&hVoice[0]);
	    ACreateAudioVoice(&hVoice[1]);
	    ASetVoiceVolume(hVoice[0], 64);
	    ASetVoiceVolume(hVoice[1], 64);
	    ASetVoicePanning(hVoice[0], 0);
	    ASetVoicePanning(hVoice[1], 255);

	    useseal = 1;

    	    return TRUE;
	}

    	return FALSE;
}

/* Close this module.
*/
extern void FAR
CloseSnd (void)
{
    if (useseal) {
        AStopVoice(hVoice[0]);
        AStopVoice(hVoice[1]);
        ADestroyAudioVoice(hVoice[0]);
        ADestroyAudioVoice(hVoice[1]);
    
        ACloseVoices();

	if (!dynwave) {
	    /* release the waveform file */
	    AFreeWaveFile(lpWave);

	    /* release the waveform file */
	} else {
	    if (lpWave) {
		if (lpWave->lpData) {
		    free(lpWave->lpData);
		}
		ADestroyAudioData (lpWave);
		free (lpWave);
		lpWave = NULL;
	    }
	    dynwave = 0;
	}

        /* close audio device */
        ACloseAudio();
    }
}


extern void FAR
Fly8PlaySnd (int Freq)
{
    if (useseal) {
	if (dynwave) {
	    int n;
	    
	    /* create Freq Hz sinewave (sampled at 10 kHz) */
	    for (n = 0; n < sizeof (aBuffer); n++)
		aBuffer[n] = (BYTE)(127.0 * sin((Freq * 3.141592653 * n) /
						    sizeof (aBuffer)));
	    /* copy the data into the waveform object */
	    memcpy(lpWave->lpData, aBuffer, sizeof (aBuffer));
	    /* upload the data to the audio DRAM local memory */
	    AWriteAudioData(lpWave, 0L, sizeof (aBuffer));
	}

	ASetVoiceFrequency(hVoice[0], FREQ (Freq));
	ASetVoiceFrequency(hVoice[1], FREQ (Freq));
        APlayVoice(hVoice[0], lpWave);
        APlayVoice(hVoice[1], lpWave);
	AUpdateAudio();
    }
#if SPEAKER
    else
	DosBeep (Freq, 10);
#endif
}

/* Stop playing the current sound.
*/
extern void FAR
StopSnd (void)
{
    if (useseal) {
	AStopVoice(hVoice[0]);
	AStopVoice(hVoice[1]);
    }
}