/***************************************************/
/* Installation Script for STris                   */
/* (c) 1995-96 R. Straub                           */
/***************************************************/

PrgName = 'STris'
Version = '1.45'

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'	/* Make REXX functions available */
CALL SysLoadFuncs

PARSE Arg InstallDir     									/* Command line parameter */
SIGNAL On Halt Name ErrorHandler							/* Error handler */

CALL SysCls

SAY
SAY
SAY " STris Installation "
SAY " ------------------ "

IF InstallDir=" " THEN DO									/* If no path is given, get one from the user */
    SAY
    SAY " Please specify the full-path to the directory"
    SAY " where you would like to install" PrgName " " Version
    SAY " Hit <Enter> to use the current directory,"
    SAY " or type 'Q'<Enter> to quit."
    SAY
    SAY " For Example:  E:\GAMES\STRIS<Enter>"
    SAY
    SAY " Please specify:"									/* Prompt for input */

    PARSE Value SysCurPos() with Row Col
    Col = Col+17
    Row = Row-1

    CALL SysCurPos Row, Col
    PULL InstallDir
    IF (InstallDir="Q") | (InstallDir="q") THEN EXIT		/* Quit if they hit 'Q' */
END

SAY

CurrentDir = directory()							/* Find the current directory */

IF (InstallDir=" ") Then InstallDir=CurrentDir		/* Set to the current directory if none given */

IF (CurrentDir\=directory(InstallDir)) THEN DO		/* If installing to different dir, do copying bit */

    Command = '@CD 'directory(CurrentDir)			/* Switch back to installation dir */
    Command

    CALL CreateDir InstallDir

    SAY " Now copying files to "InstallDir" ..."	/* Now copy files */

    CALL FileMove 'STris.EXE', InstallDir
    CALL FileMove 'STris.HLP', InstallDir
    CALL FileMove 'STris.INI', InstallDir
    CALL FileMove 'STris.HSC', InstallDir

	CALL FileMove 'Glass.WAV', InstallDir
	CALL FileMove 'Ding.WAV', InstallDir
	CALL FileMove 'BreakIt.WAV', InstallDir

	CALL FileMove 'File_ID.DIZ', InstallDir
    CALL FileCopy 'Read.Me', InstallDir
END


SAY " Creating WPS program object ..."					/* Create WPS-Desktop object */

LastChar = substr(InstallDir,length(InstallDir),1)		/* See if directory terminates in a \ */

IF LastChar = "\" THEN SetupString="EXENAME="InstallDir"STris.exe;STARTUPDIR="InstallDir
ELSE                   SetupString="EXENAME="InstallDir"\STris.exe;STARTUPDIR="InstallDir

rc=SysCreateObject("WPProgram",PrgName" "Version,"<WP_DESKTOP>",SetupString,UPDATE)
IF rc=0 THEN DO
  SAY
  SAY " WARNING : Couldn't create program object on WPS."
/*  EXIT  */
END

SAY " Now you get to read the ReadMe file ..."

Command='@E Read.Me'									/* Look at the README.TXT */
Command

CALL FileDelete 'Read.Me'
CALL FileDelete 'Install.CMD'

SAY
SAY " STris has been successfully installed. Have fun ..."

EXIT




/***************************************************/
/* File Move                                       */
/***************************************************/

FileMove: Arg FileName, Destination

/*	SAY "FileCopy " FileName " " Destination */
	CALL FileCopy FileName, Destination
	CALL FileDelete FileName

RETURN




/***************************************************/
/* File Copy                                       */
/***************************************************/

FileCopy: Arg FileName, Destination

  Command='@Copy 'FileName' 'Destination' >NUL'
  Command

  IF rc\=0 THEN DO										/* Error copying file */
    SAY " ERROR : Failed to copy file "FileName". Installation aborted ..."
    EXIT
  END

RETURN



/***************************************************/
/* File Delete                                     */
/***************************************************/

FileDelete: Arg FileName

  rc=SysFileDelete(FileName)
  IF rc\=0 THEN DO
    SAY " ERROR : Failed to delete file "FileName". Installation aborted ..."
    EXIT
  END

RETURN



/***************************************************/
/* CreateDir                                       */
/***************************************************/

CreateDir: Arg DirName

  CALL SysFileTree DirName, FileDirectory, 'D'	/* Search for new directory */

  IF FileDirectory.0='0' THEN DO				/* If not found, create it */
    SAY " Now creating directory "DirName

    rc=SysMkDir(DirName)
/*    SAY "SysMkDir :" rc "."  */

    IF rc\=0 THEN DO
      SAY
      SAY " ERROR : The directory " DirName " couldn't be created,"
      SAY " probably because you specified an invalid directory name"
      SAY " or the destination disk is write-protected."
      SAY " Installation aborted."
      EXIT
    END

  END
  ELSE
    SAY " Using existing directory " DirName

RETURN



/***************************************************/
/* Error handler                                   */
/***************************************************/

ErrorHandler:

  CALL SysCls
  SAY " Error while installing STris ! Installation aborted ..."

EXIT


