/* Author - J. Pedone */
/* Questions or comments ? */
/* E-Mail me at jpedone@flash.net */

/* Legal Stuff: */
/* This program is provided as is for free and I make no warranties */
/* So have a great day ! */

/* Start things rolling */
/* Load REXX functions */
	call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	call SysLoadFuncs
/* Load MCI REXX support */
	Call RXFUNCADD "mciRxInit","MCIAPI","mciRxInit"
	Call mciRxInit
/* Load RXU functions */
	call rxfuncadd 'rxuinit','rxu','rxuinit'
	call rxuinit
/* Cleans things up at program termination */
	signal on halt
/* Initialize a counter */
	times = 0

pick_a_letter:
/* set some program variables and run some checks */
	pid = 'VB.EXE'

/* Change this line if VB is located elsewhere */
	full_name = 'C:\MMOS2\VB.EXE'	

	type = 'P'
	procname = pid
	letter = RANDOM(1,26) 
	picture = RANDOM(1,26) 

/* Make sure at least a few of the letters and sounds match */
	IF picture = letter THEN times = 0
	ELSE times = times + 1
	IF times > 4 THEN
		DO
			times = 0
			letter = picture
		END
/* This section gets rid of the problem letters like K, C, Z & X */
/* Set picture to C if sound is C AND picture is K */
	IF letter = 3 THEN
		DO
		IF picture = 11 THEN
			DO
			picture = 3
			END
		END

/* Set picture to K if sound is K AND picture is C */
IF letter = 11 THEN
		DO
		IF picture = 3 THEN
			DO
			picture = 11
			END
		END

/* Set picture to Z if sound is Z AND picture is X */
	IF letter = 26 THEN
		DO
		IF picture = 24 THEN
			DO
			picture = 26
			END
		END

/* Set picture to K if sound is K AND picture is C */
	IF letter = 24 THEN
		DO
		IF picture = 26 THEN
			DO
			picture = 24
			END
		END

/* change these two lines as appropriate if you use other than TIFF or WAVE files */
picfile = '.\pic\'picture'.tif'
wavfile = '.\wav\'letter'.wav'

display_picture:
/* Kill VB if it's running */
	rc = rxqprocstatus('q.','l')
	find_it=q.0P.0
		do n=1 to find_it
			found = q.0p.n.6
		if found = full_name THEN CALL kill_vb
		end
/* Start vb and wait for the desktop to release the sound card */
	view = 'START VB 'picfile
	view
	CALL SysSleep(10)

play_sound:
/* play the sound files */
	MacRC = SendString(open Waveaudio wait)
	MacRC = Sendstring(load Waveaudio wavfile wait)
	MacRC = Sendstring(play Waveaudio wait)
	MacRC = SendString(close Waveaudio wait)

interact:
/* Put up some message boxes to control program flow */
	answer = RxMessageBox('Does the sound match ?', '(Cancel = quit)', YESNOCANCEL, QUESTION)
	IF answer = 2 THEN SIGNAL halt
	IF answer = 6 THEN
		DO
		IF picture = letter THEN
			DO
				IF RxMessageBox('You are right !! Try another ?', Correct, YESNO, QUESTION) = 6 THEN SIGNAL pick_a_letter
					ELSE
				SIGNAL halt
			END
		ELSE
			DO
				IF RxMessageBox('You are wrong !! Try Again ?', Wrong, YESNO, QUESTION) = 6 THEN SIGNAL play_sound
					ELSE
				SIGNAL pick_a_letter
			END
		END
	IF answer = 7 THEN
			DO
			IF picture <> letter THEN
				DO
					IF RxMessageBox('You are right !!  Try another ?', Correct, YESNO, QUESTION) = 6 THEN SIGNAL pick_a_letter
						ELSE
					SIGNAL halt
				END
			ELSE
				DO
					IF RxMessageBox('You are wrong !! Try again ?', Wrong, YESNO, QUESTION) = 6 THEN SIGNAL interact
						ELSE
					SIGNAL pick_a_letter
				END
			END
	SIGNAL halt

halt:
/* Halt program and release MCI functions */
	full_name = 'C:\MMOS2\VB.EXE'	
	type = 'P'
	procname = pid
	CALL kill_vb
	call mciRxExit
	exit

kill_vb:
/* kill the picture viewer */
	dosrc = rxqprocstatus('s.')
	do i=1 to s.0p.0
	    do
	    if abbrev(translate(filespec('n',s.0p.i.6)),translate(procname)) then 
	      do
	      procname = s.0p.i.6
	      xpid = strip(s.0p.i.1,'l','0')
	      pid = x2d(xpid)
	      dosrc = rxkillprocess(pid,type)
	      RETURN
	      end
	    end
	end
	RETURN

SendString:
/* Build MCI command */
	arg CmndTxt
	MacRC = mciRxSendString(CmndTxt, 'RetSt', '0', '0')
	return MacRC

