{$A+,B-,D+,E+,F-,I+,L+,N+,O-,R-,S+,V-}
{$M 16384,102400,655360}
PROGRAM Cribbage;

(*                                                                      *)
(* CONVERSION: Michael G. Slack - Org. Author: 'David Addison'          *)
(* DATE CONVERTED: 12-16-1988                                           *)
(*                                                                      *)
(* ENVIRONMENT: Turbo Pascal V5.5 - PC DOS V3.30 - Graphics mode 13H    *)
(*              (original - Amiga A-Basic)                              *)
(*                                                                      *)
(* -------------------------------------------------------------------- *)
(*                                                                      *)
(* Revised: 09-03-1989 M.G.S.                                           *)
(*          01-23-1994 - recomipled to borland pascal v7.0.             *)
(*          04/18/1994 - Revised to act as standalone, not compiled for *)
(*                       local machine only.                            *)
(*                                                                      *)

 USES Dos, Crt, Grph256, Wind256, SplashU;

 TYPE E11X6   = ARRAY[1..11,1..6] OF INTEGER;
      E4X5    = ARRAY[1..4,1..5]  OF INTEGER;
      E15X7   = ARRAY[1..15,1..7] OF INTEGER;
      E4X0    = ARRAY[1..4] OF INTEGER;
      E6X4    = ARRAY[1..6,1..4] OF INTEGER;
      E6X5    = ARRAY[1..6,1..5] OF INTEGER;
      CPICREC = RECORD
                 Pic : POINTER;
                 Com : BOOLEAN;
                END;
      CPICARR = ARRAY[1..13] OF CPICREC;
      DIRREC  = RECORD
                 Sz   : WORD;
                 OfSt : LONGINT;
                 CF   : BOOLEAN;
                END;

 CONST PegPos   : ARRAY[1..121] OF INTEGER = (16,7,7,7,7,12,7,7,7,7,12,
                                                 7,7,7,7,12,7,7,7,7,12,
                                                 7,7,7,7,12,7,7,7,7, 0,
                                            -7,-7,-7,-7,-12,-7,-7,-7,-7,-12,
                                            -7,-7,-7,-7,-12,-7,-7,-7,-7,-12,
                                            -7,-7,-7,-7,-12,-7,-7,-7,-7,  0,
                                                 7,7,7,7,12,7,7,7,7,12,
                                                 7,7,7,7,12,7,7,7,7,12,
                                                 7,7,7,7,12,7,7,7,7, 0,
                                            -7,-7,-7,-7,-12,-7,-7,-7,-7,-12,
                                            -7,-7,-7,-7,-12,-7,-7,-7,-7,-12,
                                            -7,-7,-7,-7,-12,-7,-7,-7,-7,  0);
       ConQ     : E11X6 = ((1,1,1,2,3, 9),(1,1,2,2,3,12),(1,1,2,3,3,12),
                           (1,1,2,3,4, 8),(1,2,2,2,3, 9),(1,2,2,3,3,12),
                           (1,2,2,3,4, 8),(1,2,3,3,3, 9),(1,2,3,3,4, 8),
                           (1,2,3,4,4, 8),(1,2,3,4,5, 5));
       ConR     : E4X5  = ((1,1,2,3,6),(1,2,2,3,6),(1,2,3,3,6),(1,2,3,4,4));
       ConS     : E4X0  = (1,2,3,3);
       ConV     : E15X7 = ((1,2,3,4,5,6,0),(1,2,3,5,4,6,0),(1,2,3,6,4,5,0),
                           (1,2,4,5,3,6,0),(1,2,4,6,3,5,0),(1,2,5,6,3,4,0),
                           (1,3,4,5,2,6,0),(1,3,4,6,2,5,0),(1,3,5,6,2,4,0),
                           (1,4,5,6,2,3,0),(2,3,4,5,1,6,0),(2,3,4,6,1,5,0),
                           (2,3,5,6,1,4,0),(2,4,5,6,1,3,0),(3,4,5,6,1,2,0));

       PicPath  : PATHSTR = '';
       CardPath : PATHSTR = '';
       PegPath  : PATHSTR = '';

 VAR PicPointer, ExSv          : POINTER;
     PicCom, Quit, Won, Who    : BOOLEAN;
     Me, You, Cut, MPeg, YPeg,
     MP1X, MP1Y, MP2X, MP2Y,
     YP1X, YP1Y, YP2X, YP2Y,
     MMM, B9, C9, K9, P9, R9,
     S9, T9, I1, I2, I3, I4, Q1,
     Q2, S1, S2, M5, CC, FF,
     CX1, CY1, CX2, CY2        : INTEGER;
     II                        : ARRAY[0..51] OF INTEGER;
     JJ                        : ARRAY[1..52] OF INTEGER;
     D                         : ARRAY[1..52,1..4] OF INTEGER;
     CribHand                  : ARRAY[1..4,1..4] OF INTEGER;
     Card                      : ARRAY[1..6] OF INTEGER;
     MM                        : E6X4;
     Q                         : E11X6;
     R                         : E4X5;
     S                         : E4X0;
     V                         : E15X7;
     WW                        : E6X4;
     YY                        : E6X5;
     Spades, Hearts, Diamonds,
     Clubs                     : CPICARR;
     LetArr                    : ARRAY[1..7] OF CPICREC;
     CardBack, EmptyHole, BluePeg,
     RedPeg                    : CPICREC;

(************************************************************************)

 PROCEDURE LastExit; FAR;
     (* procedure to execute when program quits *)

  BEGIN (*lastexit*)
   TextMode(LastMode);
   ExitProc := ExSv;
  END; (*lastexit*)

(************************************************************************)

 PROCEDURE MenuBox(Item : STRING; Col : BYTE);
     (* procedure to draw menu box on screen *)

    VAR X : INTEGER;

  BEGIN (*menubox*)
   SetForeColor(Col);
   SetBackColor(8);
   OverscanColor := 8;
   X := (317-(Length(Item)*8)) DIV 2; X := X + 1;
   DefineWindow(1,189,318,198,1);
   ClearWindow(1);
   PrtTextXY(X,191,Item);
  END; (*menubox*)

(************************************************************************)

 PROCEDURE UpdateHumScore(Peg : INTEGER);
     (* proceure to update the human score *)

    VAR NumStr : STRING[3];
        X      : INTEGER;

  BEGIN (*updatehumscore*)
   SetForeColor(14);
   SetBackColor(35);
   OverScanColor := 35;
   Str(Peg,NumStr);
   X := (28-(Length(NumStr)*8)) DIV 2; X := X + 233;
   DefineWindow(232,57,259,67,1);
   ClearWindow(1);
   PrtTextXY(X,59,NumStr);
  END; (*updatehumscore*)

(************************************************************************)

 PROCEDURE UpdateComScore(Peg : INTEGER);
     (* proceure to update the computer score *)

    VAR NumStr : STRING[3];
        X      : INTEGER;

  BEGIN (*updatecomscore*)
   SetForeColor(14);
   SetBackColor(34);
   OverScanColor := 34;
   Str(Peg,NumStr);
   X := (28-(Length(NumStr)*8)) DIV 2; X := X + 62;
   DefineWindow(62,57,89,67,1);
   ClearWindow(1);
   PrtTextXY(X,59,NumStr);
  END; (*updatecomscore*)

(************************************************************************)

 PROCEDURE TickSound;
     (* procedure to twick sound chip and make a tick sound *)

  BEGIN (*ticksound*)
   Sound(50);
   Delay(50);
   NoSound;
   Delay(100);
  END; (*ticksound*)

(************************************************************************)

 PROCEDURE ClearBuffer;
     (* macro definition to clear the keyboard (PC) of input *)
  INLINE($B8/$06/$0C/       {MOV AX,0C06h - dos function 12 (0Ch), call 6}
         $BA/$FF/$00/       {MOV DX,00FFh - return immed., no wait}
         $CD/$21);          {INT 21h      - do the dos function}

(************************************************************************)

 FUNCTION UpcaseStr(S : STRING) : STRING;
     (* function to upper case a string *)

    VAR I : INTEGER;

  BEGIN (*upcasestr*)
   FOR I := 1 TO Length(S) DO
    S[I] := Upcase(S[I]);
   UpcaseStr := S;
  END; (*upcasestr*)

(************************************************************************)

 FUNCTION RemvLeading(S : STRING) : STRING;
     (* function to remove leading spaces in a string *)

  BEGIN (*remvleading*)
   WHILE (Length(S) <> 0) AND (S[1] = ' ') DO
    Delete(S,1,1);
   RemvLeading := S;
  END; (*remvleading*)

(************************************************************************)

 PROCEDURE CheckForPaths;
     (* procedure to check for path file *)

    VAR F : TEXT;
        S : STRING;
        E : PATHSTR;
        I : INTEGER;

  BEGIN (*checkforpaths*)
   IF Lo(DosVersion) >= 3
    THEN BEGIN {get exe path}
          E := ParamStr(0); I := Length(E);
          WHILE (I > 0) AND (E[I] <> '\') DO
           Dec(I);
          E[0] := CHAR(I);
         END
   ELSE E := '.\';
   Assign(F,E+'CRIBBAGE.CFG');
   {$I-} Reset(F); {$I+}
   IF IOResult <> 0 THEN Exit;
   WHILE NOT(EOF(F)) DO
    BEGIN
     Readln(F,S); S := UpcaseStr(S);
     IF Copy(S,1,3) = 'PI=' THEN PicPath  := RemvLeading(Copy(S,4,Length(S)));
     IF Copy(S,1,3) = 'CA=' THEN CardPath := RemvLeading(Copy(S,4,Length(S)));
     IF Copy(S,1,3) = 'PE=' THEN PegPath  := RemvLeading(Copy(S,4,Length(S)));
    END; {while}
   Close(F);
  END; (*checkforpaths*)

(************************************************************************)

 PROCEDURE DoError(Err : INTEGER; S : STRING);
     (* procedure to list a file error to the user *)

  BEGIN (*doerror*)
   TextMode(LastMode);
   CASE Err OF
    1 : Writeln('ERROR: main picture file (',PicPath+S,') missing.');
    3 : Writeln('ERROR: peg picture file (',PegPath+S,') missing.');
    4 : Writeln('ERROR: card deck directory (',CardPath+S,') missing.');
    5 : Writeln('ERROR: card deck picture file (',CardPath+S,') missing.');
    6 : Writeln('ERROR: missing all letter files (',CardPath+S,').');
    ELSE Writeln('ERROR: unknown file error.');
   END; {case}
   ExitProc := ExSv;
   Halt(1);
  END; (*doerror*)

(************************************************************************)

 PROCEDURE LoadFiles;
     (* procedure to load the card files into memory *)

    VAR Temp : FILE;
        NRd  : INTEGER;
        CCC  : BOOLEAN;
        Err  : INTEGER;
        PP   : POINTER;
        Size : INTEGER;
        Ser  : SEARCHREC;
        I    : INTEGER;
        Dr   : ARRAY[1..53] OF DIRREC;

  BEGIN (*loadfiles*)
   CheckForPaths;
   SetForeColor(1);
   PrtTextXY(0,9,'Original copyright David Addison');
   SetForeColor(2);
   PrtTextXY(0,18,'IBM VGA port Michael G. Slack, 1988');
   SetForeColor(12);
   PrtTextXY(0,27,'Not for resale purposes.');
   SetForeColor(15);
   Delay(2000);
   PrtTextXY(0,36,'Please hold on while I load the data');
   ReadSplash(PicPath+'\CRIBBAGE.SS',TRUE);
   IF PicturePointer = NIL THEN DoError(1,'\CRIBBAGE.SS');
   PicCom := SplashCom;
   PicPointer := PicturePointer;
   LoadSplashColorTable;
   ReadSplash(PegPath+'\EMTYHOLE.ST',FALSE);
   IF PicturePointer = NIL THEN DoError(3,'\EMTYHOLE.ST');
   EmptyHole.Com := SplashCom;
   EmptyHole.Pic := PicturePointer;
   ReadSplash(PegPath+'\REDPEG.ST',FALSE);
   IF PicturePointer = NIL THEN DoError(3,'\REDPEG.ST');
   RedPeg.Com := SplashCom;
   RedPeg.Pic := PicturePointer;
   ReadSplash(PegPath+'\BLUEPEG.ST',FALSE);
   IF PicturePointer = NIL THEN DoError(3,'\BLUEPEG.ST');
   BluePeg.Com := SplashCom;
   BluePeg.Pic := PicturePointer;
   Assign(Temp,CardPath+'\CARDS.DIR');
   {$I-} Reset(Temp,1); {$I+}
   IF IOResult <> 0 THEN DoError(4,'\CARDS.DIR');
   BlockRead(Temp,I,2,NRd);
   BlockRead(Temp,Dr,SizeOf(Dr),NRd);
   Close(Temp);
   Assign(Temp,CardPath+'\CARDS.PIC');
   {$I-} Reset(Temp,1); {$I+}
   IF IOResult <> 0 THEN DoError(5,'\CARDS.PIC');
   GetMem(PP,Dr[1].Sz);
   BlockRead(Temp,PP^,Dr[1].Sz,NRd);
   CardBack.Com := Dr[1].CF;
   CardBack.Pic := PP;
   FOR I := 1 TO 13 DO
    BEGIN {load up the clubs}
     GetMem(PP,Dr[I+1].Sz);
     Seek(Temp,Dr[I+1].OfSt);
     BlockRead(Temp,PP^,Dr[I+1].Sz,NRd);
     Clubs[I].Com := Dr[I+1].CF;
     Clubs[I].Pic := PP;
    END; {loading clubs}
   FOR I := 1 TO 13 DO
    BEGIN {load up the hearts}
     GetMem(PP,Dr[I+14].Sz);
     Seek(Temp,Dr[I+14].OfSt);
     BlockRead(Temp,PP^,Dr[I+14].Sz,NRd);
     Hearts[I].Com := Dr[I+14].CF;
     Hearts[I].Pic := PP;
    END; {loading hearts}
   FOR I := 1 TO 13 DO
    BEGIN {load up the diamonds}
     GetMem(PP,Dr[I+27].Sz);
     Seek(Temp,Dr[I+27].OfSt);
     BlockRead(Temp,PP^,Dr[I+27].Sz,NRd);
     Diamonds[I].Com := Dr[I+27].CF;
     Diamonds[I].Pic := PP;
    END; {loading diamonds}
   FOR I := 1 TO 13 DO
    BEGIN {load up the spades}
     GetMem(PP,Dr[I+40].Sz);
     Seek(Temp,Dr[I+40].OfSt);
     BlockRead(Temp,PP^,Dr[I+40].Sz,NRd);
     Spades[I].Com := Dr[I+40].CF;
     Spades[I].Pic := PP;
    END; {loading spades}
   Close(Temp);
   FindFirst(CardPath+'\?LET.PIC',$3F,Ser);
   IF DosError = 18 THEN DoError(6,'\?LET.PIC');
   FOR I := 1 TO 7 DO
    BEGIN {load up animation stamps}
     Assign(Temp, CardPath+'\'+Ser.Name);
     Reset(Temp,1);
     Size := FileSize(Temp)-SizeOf(BOOLEAN);
     BlockRead(Temp,CCC,SizeOf(BOOLEAN),NRd);
     GetMem(PP,Size);
     BlockRead(Temp,PP^,Size,NRd);
     Close(Temp);
     LetArr[I].Com := CCC;
     LetArr[I].Pic := PP;
     FindNext(Ser);
    END; {loading animation sequence}
  END;  (*loadfiles*)

(************************************************************************)

 PROCEDURE InitializeSome;

  BEGIN (*initializesome*)
   CY1 := 151; CX1 := 210; CY2 := 116; CX2 := 210;
   S1 := 0; FF := 0; S2 := 0;
   MPeg := 2; YPeg := 2;
   Won := FALSE; Quit := FALSE;
   Cut := 1;
   MP1X := 29; MP1Y := 37; MP2X := 29; MP2Y := 28;
   YP1X := 28; YP1Y := 81; YP2X := 28; YP2Y := 90;
  END; (*initailizesome*)

(************************************************************************)

 PROCEDURE InitializeOthers;

  BEGIN (*initializeothers*)
   Q := ConQ; R := ConR; S := ConS;
  END; (*initializeothers*)

(************************************************************************)

 PROCEDURE DisplayCard(X,Y,Suit,Num : INTEGER);
     (* procedure to display card on screen *)

  BEGIN (*displaycard*)
   CASE Suit OF
    1 : IF Clubs[Num].Com
         THEN DisplayCompress(X,Y,Clubs[Num].Pic)
        ELSE StoreBitBlock(X,Y,0,Clubs[Num].Pic);
    2 : IF Hearts[Num].Com
         THEN DisplayCompress(X,Y,Hearts[Num].Pic)
        ELSE StoreBitBlock(X,Y,0,Hearts[Num].Pic);
    3 : IF Diamonds[Num].Com
         THEN DisplayCompress(X,Y,Diamonds[Num].Pic)
        ELSE StoreBitBlock(X,Y,0,Diamonds[Num].Pic);
    4 : IF Spades[Num].Com
         THEN DisplayCompress(X,Y,Spades[Num].Pic)
        ELSE StoreBitBlock(X,Y,0,Spades[Num].Pic);
   END; {case}
  END;

(************************************************************************)

 PROCEDURE EraseCards(Extend : BOOLEAN);
     (* Procedure to erase cards from hand *)

  BEGIN (*erasecards*)
   OverscanColor := 0;
   IF Extend
    THEN DefineWindow(19,149,224,186,1)
   ELSE DefineWindow(19,149,159,186,1);
   ClearWindow(1);
  END; (*erasecards*)

(************************************************************************)

 PROCEDURE ShuffleCards;
     (* procedure to shuffle the cards *)

    VAR I,J,K : INTEGER;

  BEGIN (*shufflecards*)
   MenuBox('* * * * SHUFFLING * * * *',14);
   Delay(1000);
   FOR J := 0 TO 51 DO
    II[J] := J;
   FOR J := 51 DOWNTO 1 DO
    BEGIN
     K := Random(J+1);
     I := II[J]; II[J] := II[K]; II[K] := I;
    END;
   I := 1;
   WHILE I < 53 DO
    BEGIN
     J := II[I-1] + 1;
     D[I,1] := J;
     D[I,3] := ((J-1) DIV 13) + 1;
     D[I,4] := J-13*((J-1) DIV 13);
     IF D[I,4] < 10
      THEN D[I,2] := D[I,4]
     ELSE D[I,2] := 10;
     Inc(I);
    END;
  END; (*shufflecards*)

(************************************************************************)

 PROCEDURE CutForDeal;
     (* procedure to figure out who goes first *)

    VAR I,J : INTEGER;
        Ch  : CHAR;
        Suit, Num : INTEGER;

  BEGIN (*cutfordeal*)
   MenuBox('Press any key to cut for first crib',14);
   Ch := ReadKey;
   ClearBuffer;
   I := Random(52) + 1;
   MenuBox('Your card is.....',35);
   Suit := D[I,3]; Num  := D[I,4];
   DisplayCard(20,151,Suit,Num);
   Delay(3000);
   J := I;
   WHILE J = I DO
    J := Random(52) + 1;
   MenuBox('My card is.......',34);
   Suit := D[J,3]; Num  := D[J,4];
   DisplayCard(55,151,Suit,Num);
   Delay(3000);
   IF D[I,4] < D[J,4]
    THEN BEGIN
          MMM := 1;
          MenuBox('YOUR CRIB....',35);
          Delay(2000);
         END
   ELSE BEGIN
         IF D[I,4] <> D[J,4]
          THEN BEGIN
                MMM := 0;
                MenuBox('MY CRIB......',34);
                Delay(2000);
               END
         ELSE BEGIN
               IF D[I,3] < D[J,3]
                THEN BEGIN
                      MMM := 1;
                      MenuBox('YOUR CRIB....',35);
                      Delay(2000);
                     END
               ELSE BEGIN
                     MMM := 0;
                     MenuBox('MY CRIB......',34);
                     Delay(2000);
                    END;
              END;
        END;
   EraseCards(FALSE);
  END; (*cutfordeal*)

(************************************************************************)

 PROCEDURE DealCards;
     (* procedure to deal and sort the cards *)

    VAR I, K, L, N, Temp, YYY, Num, Suit, Cnt : INTEGER;

  BEGIN (*dealcards*)
   IF MMM = 1 THEN SetForeColor(35) ELSE SetForeColor(34);
   SetBackColor(0);
   PrtTextXY(125,133,'CRIB');
   MMM := 1 - MMM; YYY := 1 - MMM; N := 1;
   WHILE N < 7 DO
    BEGIN {while loop}
     K := 2*N-YYY; L := 2*N-MMM; I := 1;
     WHILE I < 5 DO
      BEGIN {while loop}
       MM[N,I] := D[K,I]; YY[N,I] := D[L,I]; YY[N,5] := 1;
       Inc(I);
      END; {while loop}
     Inc(N);
    END; {while loop}
   K := 1;
   WHILE K < 6 DO
    BEGIN {while loop}
     L := K + 1;
     WHILE L < 7 DO
      BEGIN {while loop}
       IF YY[K,4] < YY[L,4]
        THEN BEGIN {then}
              I := 1;
              WHILE I < 5 DO
               BEGIN {while loop}
                Temp := YY[K,I]; YY[K,I] := YY[L,I]; YY[L,I] := Temp;
                Inc(I);
               END; {while loop}
              END; {then}
       Inc(L);
      END; {while loop}
     Inc(K);
    END; {while loop}
   Cnt := 20;
   FOR I := 1 TO 6 DO
    BEGIN
     Num := YY[I,4]; Suit := YY[I,3];
     DisplayCard(Cnt,151,Suit,Num);
     Cnt := Cnt + 35;
    END;
  END; (*dealcards*)

(************************************************************************)

 PROCEDURE MoreAnalysis(VAR P : INTEGER);
     (* procedure to do more analysis of coms hand *)

    VAR I : INTEGER;

  BEGIN (*moreanalysis*)
   P := 0; I := 1;
   WHILE I < 5 DO
    BEGIN
     IF (WW[I,3] = WW[5,3]) AND (WW[I,4] = 11)
      THEN BEGIN
            Inc(P); Exit;
           END;
     Inc(I);
    END;
   END; (*moreanalysis*)

(************************************************************************)

 PROCEDURE EvenMoreAnalysis(VAR P : INTEGER);
     (* more of the same *)

    LABEL 3, 4, 5;

    VAR A, I, J, K, L : INTEGER;

  BEGIN (*evenmoreanalysis*)
   I := 1; L := 4;
   WHILE I < 4 DO  {checking for a flush}
    BEGIN
     IF WW[I,3] <> WW[I+1,3] THEN Dec(L);
     Inc(I);
    END;
   IF (CC = 0) AND (L = 4) {aren't doing a crib hand and have a flush}
    THEN BEGIN
          P := P + 4;
          IF WW[4,3] = WW[5,3] THEN P := P + 1;
         END
   ELSE IF (WW[4,3] = WW[5,3]) AND (L = 4) {crib hand / flush-check up card}
         THEN P := P + 5;
   I := 1;
   WHILE I < 5 DO
    BEGIN
     J := I + 1;
     WHILE J < 6 DO
      BEGIN
       IF (WW[I,2]+WW[J,2]) = 15 THEN P := P + 2;
       Inc(J);
      END;
     Inc(I);
    END;
   I := 1;
   WHILE I < 4 DO
    BEGIN
     J := I + 1;
     WHILE J < 5 DO
      BEGIN
       K := J + 1;
       WHILE K < 6 DO
        BEGIN
         IF (WW[I,2]+WW[J,2]+WW[K,2]) = 15 THEN P := P + 2;
         Inc(K);
        END;
       Inc(J);
      END;
     Inc(I);
    END;
   I := 1;
   WHILE I < 3 DO
    BEGIN
     J := I + 1;
     WHILE J < 4 DO
      BEGIN
       K := J + 1;
       WHILE K < 5 DO
        BEGIN
         L := K + 1;
         WHILE L < 6 DO
          BEGIN
           IF (WW[I,2]+WW[J,2]+WW[K,2]+WW[L,2]) = 15 THEN P := P + 2;
           Inc(L);
          END;
         Inc(K);
        END;
       Inc(J);
      END;
     Inc(I);
    END;
   A := 0; I := 1;
   WHILE I < 6 DO
    BEGIN
     A := A + WW[I,2];
     Inc(I);
    END;
   IF A = 15 THEN P := P + 2;
   FOR I := 1 TO 13 DO
    JJ[I] := 0;
   FOR I := 1 TO 5 DO  {count dups - pairs, three of a kind, etc.}
    BEGIN
     J := WW[I,4]; JJ[J] := JJ[J] + 1;
    END;
   FOR I := 1 TO 13 DO {give points for the pairs, etc.}
    CASE JJ[I]+1 OF
     3 : P := P + 2;   {pair}
     4 : P := P + 6;   {3 of a kind}
     5 : P := P + 12;  {4 of a kind}
    END;
   FOR I := 1 TO 5 DO  {sort cards}
    FOR J := I TO 5 DO
     IF WW[I,4] > WW[J,4]
      THEN BEGIN
            L := WW[J,4]; WW[J,4] := WW[I,4]; WW[I,4] := L;
           END;
   L := WW[1,4]-Q[1,1];
   FOR I := 1 TO 11 DO
    FOR J := 1 TO 5 DO
     Q[I,J] := Q[I,J] + L;
   I := 1;
   WHILE I < 12 DO
    BEGIN
     J := 1;
     WHILE J < 6 DO
      IF WW[J,4] <> Q[I,J]
       THEN GOTO 3
      ELSE Inc(J);
     P := P + Q[I,6];
     Exit;
     3: Inc(I);
    END;
   L := 1;
   WHILE L < 3 DO
    BEGIN
     A := WW[L,4]-R[1,1];
     FOR I := 1 TO 4 DO
      FOR J := 1 TO 4 DO
       R[I,J] := R[I,J] + A;
     I := 1;
     WHILE I < 5 DO
      BEGIN
       K := 1;
       WHILE K < 5 DO
        BEGIN
         IF WW[K+L-1,4] <> R[I,K] THEN GOTO 4;
         Inc(K);
        END;
       P := P + R[I,5];
       Exit;
       4: Inc(I);
      END;
     Inc(L);
    END;
   L := 1;
   WHILE L < 4 DO
    BEGIN
     A := WW[L,4]-S[1];
     FOR I := 1 TO 3 DO
      S[I] := S[I] + A;
     I := 1;
     WHILE I < 4 DO
      IF WW[L+I-1,4] <> S[I]
       THEN GOTO 5
      ELSE Inc(I);
     P := P + S[4]; {+ 3}
     Exit;
     5: Inc(L);
    END;
  END; (*evenmoreanalysis*)

(************************************************************************)

 PROCEDURE AnalyzeComsHand;
     (* procedure to analyze the computers hand *)

    LABEL 1, 2, 3, 4, 5, 6, 7;

    VAR P, N, I, J, K, L, ZZ, Z9 : INTEGER;

  BEGIN (*analyzecomshand*)
   Z9 := 1; P9 := 0;
   WHILE Z9 < 16 DO
    BEGIN
     I1 := V[Z9,1]; I2 := V[Z9,2]; I3 := V[Z9,3]; I4 := V[Z9,4];
     J := 1;
     WHILE J < 5 DO
      BEGIN
       WW[1,J] := MM[I1,J];
       WW[2,J] := MM[I2,J];
       WW[3,J] := MM[I3,J];
       WW[4,J] := MM[I4,J];
       WW[5,J] := 25;
       Inc(J);
      END;
     CC := 0;
     MoreAnalysis(P);
     EvenMoreAnalysis(P);
     InitializeOthers;
     V[Z9,7] := P;
     IF P > P9 THEN P9 := P;
     Inc(Z9);
    END;
   J := 0;
   I := 1;
   WHILE I < 16 DO
    BEGIN
     IF V[I,7] = P9
      THEN BEGIN
            Inc(J); II[J] := I;
           END;
     Inc(I);
    END;
   B9 := II[1];
   IF J > 1 THEN GOTO 1;
   Exit;
   1: C9 := 5;  ZZ := 1; GOTO 2;
   3: N  := 1;  C9 := 8; ZZ := 2; GOTO 2;
   4: C9 := 7;  ZZ := 3; GOTO 2;
   5: C9 := 11; ZZ := 4; GOTO 2;
   6: C9 := 1;  ZZ := 5; GOTO 2;
   7: B9 := Random(J) + 1;
   B9 := II[B9]; Exit;
   2: P9 := 0;
   FOR I := 1 TO 15 DO
    JJ[I] := 0;
   I := 1;
   WHILE I <= J DO
    BEGIN
     K := 1;
     WHILE K < 5 DO
      BEGIN
       L := V[II[I],K];
       IF MM[L,4] = C9 THEN JJ[I] := JJ[I]+1;
       Inc(K);
      END;
     Inc(I);
    END;
   K := 0;
   FOR I := 1 TO J DO
    IF JJ[I] = P9
     THEN BEGIN
           Inc(K); B9 := II[I];
          END;
   IF K <> 1
    THEN CASE ZZ OF
          1 : GOTO 3;
          2 : GOTO 4;
          3 : GOTO 5;
          4 : GOTO 6;
          5 : GOTO 7;
         END;
  END; (*analyzecomshand*)

(************************************************************************)

 PROCEDURE Display4Pixels(X,Y : INTEGER; Col : BYTE);
     (* procedure to display 4 pixels under card to choose *)

  BEGIN (*display4wpixels*)
   PutCPixel(X+1,Y+1,Col);   {      }
   PutCPixel(X+2,Y+1,Col);   {  XX  }
   PutCPixel(X,Y+2,Col);     { X  X }
   PutCPixel(X+3,Y+2,Col);   {      }
  END; (*display4wpixels*)

(************************************************************************)

 PROCEDURE Display9Pixels(X,Y : INTEGER; Col : BYTE);
     (* procedure to display 9 pixels in an x shape *)

  BEGIN (*display9pixels*)
   PutCPixel(X,Y+1,Col);
   PutCPixel(X,Y+2,Col);       { X X }
   PutCPixel(X+2,Y+1,Col);     { X X }
   PutCPixel(X+2,Y+2,Col);     {  X  }
   PutCPixel(X+1,Y+3,Col);     { X X }
   PutCPixel(X,Y+4,Col);       { X X }
   PutCPixel(X,Y+5,Col);
   PutCPixel(X+2,Y+4,Col);
   PutCPixel(X+2,Y+5,Col);
  END; (*display9pixels*)

(************************************************************************)

 PROCEDURE GetPlayerDiscards;
     (* procedure to get the players discards *)

    VAR Ch     : CHAR;
        Num    : INTEGER;
        N      : INTEGER;
        Pisser : INTEGER;
        Leave  : BOOLEAN;

  BEGIN (*getplayerdiscards*)
   Pisser := 1;
   Display4Pixels(Pisser*30,181,15);
   MenuBox('Your Discards (Choose 2 cards (1-6))',14);
   Num := 1;
   FOR N := 1 TO 6 DO
    BEGIN
     IF YY[N,5] = 1 THEN Card[Num] := N;
     Inc(Num);
    END;
   Q1 := 0; Q2 := 0;
   Leave := FALSE;
   REPEAT
    ClearBuffer;
    REPEAT
     Ch := ReadKey;
    UNTIL Ch IN ['0'..'9',#0,^M];
    IF (Ch = #0) OR (Ch = ^M)
     THEN BEGIN
           IF Ch = #0 THEN Ch := ReadKey;
           CASE Ch OF
            #75 : BEGIN {cursor left}
                   IF Pisser = 1
                    THEN BEGIN
                          Pisser := 6;
                          Display4Pixels(30,181,0);
                         END
                   ELSE BEGIN
                         N := (Pisser*35)-5;
                         Display4Pixels(N,181,0);
                         Dec(Pisser);
                        END;
                   N := (Pisser*35)-5;
                   Display4Pixels(N,181,15);
                  END;
            #77 : BEGIN {cursor right}
                   IF Pisser = 6
                    THEN BEGIN
                          Pisser := 1;
                          Display4Pixels(205,181,0);
                         END
                   ELSE BEGIN
                         N := (Pisser*35)-5;
                         Display4Pixels(N,181,0);
                         Inc(Pisser);
                        END;
                   N := (Pisser*35)-5;
                   Display4Pixels(N,181,15);
                  END;
            ^M  : BEGIN {enter key}
                   Num := Pisser * 35;
                   IF Q1 = 0
                    THEN BEGIN
                          Display9Pixels(Num,181,14);
                          Q1 := Card[Pisser];
                         END
                   ELSE IF Q2 = 0
                         THEN BEGIN
                               Q2 := Card[Pisser];
                               IF Q2 = Q1
                                THEN BEGIN
                                      Display9Pixels(Num,181,0);
                                      Q2 := 0;
                                      Q1 := 0;
                                     END
                               ELSE Display9Pixels(Num,181,14);
                              END;
                  END;
            ELSE Write(^G);
           END; {case}
          END {then}
    ELSE BEGIN {else}
          N := Ord(Ch) - Ord('0');
          Num := N * 35;
          IF (N > 0) AND (N < 7)
           THEN BEGIN
                 IF Q1 = 0
                  THEN BEGIN
                        Display9Pixels(Num,181,14);
                        Q1 := Card[N];
                       END
                 ELSE IF Q2 = 0
                       THEN BEGIN
                             Q2 := Card[N];
                             IF Q2 = Q1
                              THEN BEGIN
                                    Display9Pixels(Num,181,0);
                                    Q2 := 0;
                                    Q1 := 0;
                                   END
                             ELSE Display9Pixels(Num,181,14);
                            END;
                END
          ELSE Write(^G);
         END; {else}
    IF (Q1 > 0) AND (Q2 > 0) THEN Leave := TRUE;
   UNTIL Leave;
   I3 := Q1;
   I4 := Q2;
   YY[I3,5] := 0;
   YY[I4,5] := 0;
   EraseCards(TRUE);
   Num := 20;
   FOR N := 1 TO 6 DO
     IF YY[N,5] <> 0
      THEN BEGIN
            DisplayCard(Num,151,YY[N,3],YY[N,4]);
            Num := Num + 35;
           END;
   DefineWindow(86,122,113,139,1);
   OverScanColor := 8;
   ClearWindow(1);
  END; (*getplayerdiscards*)

(************************************************************************)

 PROCEDURE AssignCrib;
     (* procedure to assign the crib hand *)

    VAR I, J, K, L : INTEGER;

  BEGIN (*assigncrib*)
   I := 1;
   WHILE I < 5 DO
    BEGIN
     CribHand[1,I] := MM[I1,I];
     CribHand[2,I] := MM[I2,I];
     CribHand[3,I] := YY[I3,I];
     CribHand[4,I] := YY[I4,I];
     Inc(I);
    END;
   FOR I := 1 TO 3 DO
    FOR K := I+1 TO 4 DO
     IF CribHand[I,4] < CribHand[K,4]
      THEN FOR J := 1 TO 4 DO
            BEGIN
             L := CribHand[K,J];
             CribHand[K,J] := CribHand[I,J];
             CribHand[I,J] := L;
            END;
  END; (*assigncrib*)

(************************************************************************)

 PROCEDURE ErasePeg(X, Y : INTEGER);
     (* procedure to erase peg from position *)

  BEGIN (*erasepeg*)
   IF EmptyHole.Com
    THEN DisplayCompress(X,Y,EmptyHole.Pic)
   ELSE StoreBitBlock(X,Y,0,EmptyHole.Pic);
  END; (*erasepeg*)

(************************************************************************)

 PROCEDURE DisplayPeg(X, Y : INTEGER; Human : BOOLEAN);
     (* procedure to display the peg at position *)

  BEGIN (*displaypeg*)
   IF Human
    THEN BEGIN
          IF RedPeg.Com
           THEN DisplayCompress(X,Y,RedPeg.Pic)
          ELSE StoreBitBlock(X,Y,0,RedPeg.Pic);
         END
   ELSE BEGIN
         IF BluePeg.Com
          THEN DisplayCompress(X,Y,BluePeg.Pic)
         ELSE StoreBitBlock(X,Y,0,BluePeg.Pic);
        END;
  END; (*displaypeg*)

(************************************************************************)

 PROCEDURE MoveHumPeg(RRR : INTEGER);
     (* procedure to move the players peg rrr moves *)

    VAR Peg, XXXX, YYYY : INTEGER;

    PROCEDURE PlayWithPegs(VAR XXXX, YYYY : INTEGER; Peg : INTEGER);
        VAR Ch : CHAR;
     BEGIN (*local playwithpegs*)
      IF Peg = 121
       THEN BEGIN
             Won := TRUE;
             Who := TRUE;
             ErasePeg(XXXX,YYYY);
             DisplayPeg(28,81,TRUE);
             MenuBox('You have won - press a key',35);
             ClearBuffer;
             Ch := ReadKey;
             Inc(You); Exit;
            END;
      IF (Peg = 31) OR (Peg = 91)
       THEN BEGIN
             YYYY := YYYY - 9;
             IF (Q2 <> 30) AND (Q2 <> 90) THEN ErasePeg(XXXX, YYYY+9);
            END;
      IF Peg = 61
       THEN BEGIN
             YYYY := YYYY + 9;
             IF Q2 <> 60 THEN ErasePeg(XXXX, YYYY-9);
            END;
      IF Q1 <> 0 THEN ErasePeg(XXXX,YYYY);
      Q1 := 1;
      DisplayPeg(XXXX+PegPos[Peg],YYYY,TRUE);
     END;  (*local playwithpegs*)

  BEGIN (*movehumpeg*)
   YPeg := 3 - YPeg;
   Q1 := 0; Q2 := S2;
   IF YPeg = 1
    THEN BEGIN
          ErasePeg(YP1X,YP1Y);
          YP1X := YP2X; YP1Y := YP2Y;
         END;
   IF YPeg = 2
    THEN BEGIN
          ErasePeg(YP2X,YP2Y);
          YP2X := YP1X; YP2Y := YP1Y;
         END;
   FOR Peg := (S2+1) TO (S2+RRR) DO
    BEGIN
     CASE YPeg OF
      1 : BEGIN
           XXXX := YP1X; YYYY := YP1Y;
           PlayWithPegs(XXXX,YYYY,Peg);
           IF Won THEN Exit;
           YP1X := XXXX + PegPos[Peg]; YP1Y := YYYY;
          END;
      2 : BEGIN
           XXXX := YP2X; YYYY := YP2Y;
           PlayWithPegs(XXXX,YYYY,Peg);
           IF Won THEN Exit;
           YP2X := XXXX + PegPos[Peg]; YP2Y := YYYY;
          END;
     END;
     TickSound;
     UpdateHumScore(Peg);
    END;
   S2 := S2 + RRR;
   Delay(750);
  END; (*movehumpeg*)

(************************************************************************)

 PROCEDURE MoveComPeg(RRR : INTEGER);
     (* procedure to move the computers peg rrr moves *)

    VAR Peg, XXXX, YYYY : INTEGER;

    PROCEDURE PlayWithPegs(VAR XXXX, YYYY : INTEGER; Peg : INTEGER);
        VAR Ch : CHAR;
     BEGIN (*local playwithpegs*)
      IF Peg = 121
       THEN BEGIN
             Won := TRUE;
             Who := FALSE;
             ErasePeg(XXXX,YYYY);
             DisplayPeg(29,37,FALSE);
             MenuBox('I have won - press a key',34);
             ClearBuffer;
             Ch := ReadKey;
             Inc(Me); Exit;
            END;
      IF (Peg = 31) OR (Peg = 91)
       THEN BEGIN
             YYYY := YYYY + 9;
             IF (Q2 <> 30) AND (Q2 <> 90) THEN ErasePeg(XXXX, YYYY-9);
            END;
      IF Peg = 61
       THEN BEGIN
             YYYY := YYYY - 9;
             IF Q2 <> 60 THEN ErasePeg(XXXX, YYYY+9);
            END;
      IF Q1 <> 0 THEN ErasePeg(XXXX,YYYY);
      Q1 := 1;
      DisplayPeg(XXXX+PegPos[Peg],YYYY,FALSE);
     END;  (*local playwithpegs*)

  BEGIN (*movecompeg*)
   MPeg := 3 - MPeg;
   Q1 := 0; Q2 := S1;
   IF MPeg = 1
    THEN BEGIN
          ErasePeg(MP1X,MP1Y);
          MP1X := MP2X; MP1Y := MP2Y;
         END;
   IF MPeg = 2
    THEN BEGIN
          ErasePeg(MP2X,MP2Y);
          MP2X := MP1X; MP2Y := MP1Y;
         END;
   FOR Peg := (S1+1) TO (S1+RRR) DO
    BEGIN
     CASE MPeg OF
      1 : BEGIN
           XXXX := MP1X; YYYY := MP1Y;
           PlayWithPegs(XXXX,YYYY,Peg);
           IF Won THEN Exit;
           MP1X := XXXX + PegPos[Peg]; MP1Y := YYYY;
          END;
      2 : BEGIN
           XXXX := MP2X; YYYY := MP2Y;
           PlayWithPegs(XXXX,YYYY,Peg);
           IF Won THEN Exit;
           MP2X := XXXX + PegPos[Peg]; MP2Y := YYYY;
          END;
     END;
     TickSound;
     UpdateComScore(Peg);
    END;
   S1 := S1 + RRR;
   Delay(750);
  END; (*movecompeg*)

(************************************************************************)

 PROCEDURE GetUpCard;
     (* procedure to start off the game and display up card *)

    VAR I, J, K, L : INTEGER;

  BEGIN (*getupcard*)
   I := Random(38) + 14;
   MenuBox('The up card is....',14);
   DisplayCard(20,116,D[I,3],D[I,4]);
   Delay(2000);
   FOR J := 1 TO 4 DO
    WW[5,J] := D[I,J];
   T9 := WW[5,4];
   IF WW[5,4] = 11
    THEN BEGIN
          IF MMM = 0
           THEN BEGIN
                 MenuBox('= = TWO POINTS TO YOU = =',35);
                 MoveHumPeg(2);
                END
          ELSE BEGIN
                MenuBox('= = TWO POINTS TO ME = =',34);
                MoveComPeg(2);
               END;
         END;
  END; (*getupcard*)

(************************************************************************)

 FUNCTION GetCard(UpChr : CHAR; VAR Ch : CHAR) : INTEGER;
     (* function to get card choice *)

    VAR Message : STRING[45];
        I, N : INTEGER;

  BEGIN (*getcard*)
   Message := 'Your play - select a card (1-'+UpChr+',G)';
   MenuBox(Message,35);
   N := 1;
   FOR I := 1 TO 6 DO
    IF YY[I,5] = 1
     THEN BEGIN
           Card[N] := I; Inc(N);
          END;
   ClearBuffer;
   REPEAT
    Ch := UpCase(ReadKey);
   UNTIL Ch IN ['1'..UpChr,'G'];
   ClearBuffer;
   IF Ch <> 'G'
    THEN BEGIN
          N := Ord(Ch) - Ord('0'); Q1 := Card[N];
         END
   ELSE N := 1;
   GetCard := Card[N];
  END; (*getcard*)

(************************************************************************)

 PROCEDURE CheckForRun(I : INTEGER);
     (* procedure to check for a run played *)

    VAR J, K, L, X : INTEGER;

  BEGIN (*checkforrun*)
   FOR J := 11 TO 20 DO
    JJ[J] := 14;
   FOR J := 1 TO CC DO
    JJ[J+10] := JJ[CC-J+1];
   FOR K := 1 TO I - 1 DO
    BEGIN
     L := K + 1;
     WHILE L <= I DO
      BEGIN
       IF JJ[K+10] > JJ[L+10]
        THEN BEGIN
              X := JJ[K+10];
              JJ[K+10] := JJ[L+10];
              JJ[L+10] := X;
             END;
       Inc(L);
      END; {while loop}
    END; {for loop}
   FOR K := 1 TO I-1 DO
    IF JJ[K+10] <> JJ[K+11]-1 THEN Exit;
   R9 := I;
  END; (*checkforrun*)

(************************************************************************)

 PROCEDURE PointsScoreInGame(Msg : STRING; VAR X31, P : INTEGER);
     (* procedure to score points during the game *)

    LABEL 1, 2;

    VAR I, J, N : INTEGER;
        NumStr, Temp : STRING[3];

  BEGIN (*pointsscoreingame*)
   P := 0; X31 := 0;
   IF CC = 1 THEN Exit;
   IF S9 = 15
    THEN BEGIN
          P := P + 2;
          IF Msg <> 'NO'
           THEN BEGIN
                 Temp := Msg;
                 Msg := Msg + ' get 2 points for FIFTEEN';
                 MenuBox(Msg,14);
                 Msg := Temp;
                 Delay(1000);
                END;
         END;
   IF S9 = 31
    THEN BEGIN
          P := P + 2; X31 := 1;
         END;
   IF (CC - 2) > 2
    THEN N := CC - 2
   ELSE N := 2;
   J := 0;
   FOR I := CC DOWNTO N DO
    BEGIN
     IF JJ[I] <> JJ[I-1]
      THEN BEGIN
            IF Msg <> 'NO'
             THEN GOTO 1
            ELSE GOTO 2;
           END;
     CASE CC-I+1 OF
      1 : BEGIN
           P := P + 2; J := 1;
          END;
      2 : BEGIN
           P := P + 4; J := 2;
          END;
      3 : BEGIN
           P := P + 6; J := 3;
          END;
     END;
    END; {for loop}
   IF Msg = 'NO' THEN GOTO 2;
   1: IF J = 1
       THEN BEGIN
             Temp := Msg;
             Msg := Msg + ' get 2 points for a pair';
             MenuBox(Msg,14);
             Msg := Temp;
             Delay(1000);
            END;
   IF J = 2
    THEN BEGIN
          Temp := Msg;
          Msg := Msg + ' get 6 points for THREE of a KIND';
          MenuBox(Msg,14);
          Msg := Temp;
          Delay(1000);
         END;
   IF J = 3
    THEN BEGIN
          Temp := Msg;
          Msg := Msg + ' get 12 points for FOUR of a KIND';
          MenuBox(Msg,14);
          Msg := Temp;
          Delay(1000);
         END;
   2: IF CC = 2 THEN Exit;
   R9 := 0; I := 3;
   WHILE I <= CC DO
    BEGIN
     CheckForRun(I); Inc(I);
    END;
   P := P + R9;
   IF R9 <> 0
    THEN IF Msg <> 'NO'
          THEN BEGIN
                Temp := Msg;
                Str(R9,NumStr);
                Msg := Msg+' get '+NumStr+' points for a '+NumStr+' card run';
                MenuBox(Msg,14);
                Msg := Temp;
                Delay(1000);
               END;
  END; (*pointsscoreingame*)

(************************************************************************)

 PROCEDURE UpDateTotalWindow;
     (* procedure to update card count in window *)

    VAR NumStr : STRING[3];
        X : INTEGER;

  BEGIN (*updatetotalwindow*)
   Str(S9,NumStr);
   SetForeColor(14);
   SetBackColor(8);
   OverScanColor := 8;
   DefineWindow(86,122,113,139,1);
   ClearWindow(1);
   X := (27-(Length(NumStr)*8)) DIV 2;
   X := X + 87;
   PrtTextXY(X,127,NumStr);
  END; (*updatetotalwindow*)

(************************************************************************)

 PROCEDURE ErasePlayedCards;
     (* procedure to erase the screen of played cards *)

  BEGIN (*eraseplayedcards*)
   OverScanColor := 0;
   DefineWindow(210,116,313,180,1);
   ClearWindow(1);
  END; (*eraseplayedcards*)

(************************************************************************)

 PROCEDURE PlayComCard(VAR Msg : STRING);
     (* procedure to play a card for the computer *)

    LABEL 1, 2, 3, 4;

    VAR I, J, L, N, VVV, I9 : INTEGER;
        NStr                : STRING[2];

  BEGIN (*playcomcard*)
   Inc(CC); Inc(M5);
   IF CC <> 1 THEN GOTO 1;
   J := 1;
   WHILE J < 5 DO
    BEGIN
     I9 := V[B9,J]; VVV := 1;
     WHILE VVV <= M5+1 DO
      BEGIN
       IF II[VVV+20] = I9 THEN GOTO 2;
       Inc(VVV);
      END;
     IF MM[I9,2] = 5 THEN GOTO 2;
     II[M5+20] := I9; JJ[CC] := MM[I9,4]; P9 := 0; S9 := MM[I9,2];
     GOTO 3;
     2: Inc(J);
    END;
   L := V[B9,1];
   II[M5+20] := I9; JJ[CC] := MM[I9,4]; P9 := 0; S9 := MM[I9,2]; GOTO 3;
   1: J := 1;
   WHILE J <= K9 DO
    BEGIN
     I9 := II[J+30];
     IF II[I9] = P9 THEN GOTO 4;
     Inc(J);
    END;
   4: II[M5+20] := I9; JJ[CC] := MM[I9,4]; S9 := S9 + MM[I9,2];
   3: MenuBox('MY PLAY!',34);
   Delay(2000);
   DisplayCard(CX2,CY2,MM[I9,3],MM[I9,4]);
   Str(4-M5:1,NStr);
   SetForeColor(10); SetBackColor(0);
   PrtTextXY(125,123,'Cards: '+NStr);
   CX2 := CX2 + 15;
   FF := 2;
   UpDateTotalWindow;
   Msg := 'I';
   PointsScoreInGame(Msg,I,J);
   IF S9 = 31
    THEN BEGIN
          MenuBox('I get 2 points for 31!',34);
          Delay(2000);
         END;
   IF J <> 0 THEN MoveComPeg(J);
   IF Won THEN Exit;
   IF S9 <> 31 THEN Exit;
   ErasePlayedCards;
   CX1 := 210; CX2 := 210; CC := 0; S9 := 0; Msg := ' '; FF := 0;
   UpDateTotalWindow;
  END; (*playcomcard*)

(************************************************************************)

 PROCEDURE PlayGame;
     (* procedure to play out the game *)

    LABEL 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12;

    VAR I, J, K, L, N, P, X, H9 : INTEGER;
        Ch, UpChr : CHAR;
        C6, Y5, GG, X31, Cnt : INTEGER;
        Msg, Temp : STRING[40];

  BEGIN (*playgame*)
   IF Won THEN Exit;
   SetForeColor(10); SetBackColor(0);
   PrtTextXY(125,123,'Cards: 4');
   Y5 := 0; M5 := 0; S9 := 0; GG := 0; CC := 0; Msg := ' ';
   UpChr := '4';
   IF MMM = 0 THEN GOTO 1;
   5: IF Y5 <> 4 THEN GOTO 2;
   IF M5 = 4 THEN GOTO 3;
   GOTO 1;
   2: N := GetCard(UpChr,Ch);
   IF Ch <> 'G' THEN GOTO 4 ELSE Msg := 'GO';
   X := 31-S9; I := 1;
   WHILE I < 7 DO
    BEGIN
     IF (YY[I,4]  <= X) AND (YY[I,5] <> 0)
      THEN BEGIN
            MenuBox('SHAME SHAME SHAME! - you have a play.',14);
            Delay(2000);
            GOTO 2;
           END;
     Inc(I);
    END;
   GOTO 1;
   4: C6 := N;
   IF S9 + YY[C6,2] > 31
    THEN BEGIN
          MenuBox('That totals more than 31, TRY AGAIN!',14);
          Delay(2000);
          GOTO 2;
         END;
   S9 := S9 + YY[C6,2]; Inc(Y5); II[10+Y5] := C6; Inc(CC); JJ[CC] := YY[C6,4];
   N := Ord(UpChr) - Ord('0') - 1; UpChr := Chr(48+N);
   EraseCards(FALSE);
   DisplayCard(CX1,CY1,YY[C6,3],YY[C6,4]);
   CX1 := CX1 + 15;
   UpDateTotalWindow;
   YY[C6,5] := 0; Cnt := 20;
   FOR I := 1 TO 6 DO
    IF YY[I,5] <> 0
     THEN BEGIN
           DisplayCard(Cnt,151,YY[I,3],YY[I,4]); Cnt := Cnt + 35;
          END;
   Msg := 'You';
   PointsScoreInGame(Msg,X31,P);
   IF X31 = 1
    THEN BEGIN
          MenuBox('You get 2 points for 31!',35);
          Delay(2000);
         END;
   IF P <> 0 THEN MoveHumPeg(P);
   IF Won THEN Exit;
   FF := 1;
   IF S9 <> 31 THEN GOTO 1;
   ErasePlayedCards;
   CX1 := 210; CX2 := 210; CC := 0; S9 := 0; GG := 0; FF := 0;
   UpDateTotalWindow;
   1: IF M5 <> 4 THEN GOTO 6;
   IF Y5 = 4 THEN GOTO 3;
   IF Msg <> 'GO' THEN GOTO 5;
   CX1 := 210; CX2 := 210;
   IF FF = 2
    THEN BEGIN {then}
          MenuBox('I get ONE point for last card.',34);
          MoveComPeg(1);
         END {then}
   ELSE BEGIN {else}
         MenuBox('You get ONE point for last card.',35);
         MoveHumPeg(1);
        END;
   IF Won THEN Exit;
   FF := 0; CC := 0; S9 := 0;
   ErasePlayedCards;
   UpDateTotalWindow;
   GOTO 5;
   6: K9 := 0; P9 := 0; C9 := CC; Inc(CC); H9 := S9; N := 0;
   FOR I := 1 TO 6 DO
    BEGIN
     II[I] := 0;
     IF (I = I1) OR (I = I2) THEN GOTO 7;
     IF M5 = 0 THEN GOTO 12;
     FOR J := 1 TO M5 DO
      IF I = II[20+J] THEN N := 1;
     IF N = 1
      THEN BEGIN
            N := 0; GOTO 7;
           END;
     12: IF H9+MM[I,2] > 31 THEN GOTO 7;
     Inc(K9); S9 := H9+MM[I,2]; JJ[CC] := MM[I,4];
     Msg := 'NO';
     PointsScoreInGame(Msg,X31,P);
     IF P > P9 THEN P9 := P;
     II[I] := P; II[K9+30] := I;
     7:
    END; {for loop}
   CC := C9; S9 := H9;
   IF K9 <> 0 THEN GOTO 8;
   IF Msg <> 'GO' THEN GOTO 9;
   IF GG = 1 THEN GOTO 10;
   MenuBox('I get ONE point for last card.',34);
   CC := 0; S9 := 0; CX1 := 210; CX2 := 210;
   ErasePlayedCards;
   MoveComPeg(1);
   IF Won THEN Exit;
   UpDateTotalWindow;
   GOTO 5;
   9: IF Y5 <> 4 THEN GOTO 11;
   10: MenuBox('I''ll give you ONE point for last card.',35);
   MoveHumPeg(1);
   IF Won THEN Exit;
   CX1 := 210; CX2 := 210; CC := 0; S9 := 0; GG := 0;
   ErasePlayedCards;
   UpDateTotalWindow;
   Msg := ' '; GOTO 1;
   11: IF GG = 1 THEN GOTO 5;
   Msg := 'GO'; MenuBox(Msg,14); GG := 1;
   Delay(2000);
   GOTO 5;
   3: IF FF = 0 THEN Exit;
   CX1 := 210; CX2 := 210;
   IF FF = 1
    THEN BEGIN
          MenuBox('You get ONE point for last card.',35);
          MoveHumPeg(1);
         END
   ELSE BEGIN
         MenuBox('I get ONE point for last card.',34);
         MoveComPeg(1);
        END;
   S9 := 0;
   UpDateTotalWindow;
   Exit;
   8: PlayComCard(Msg);
   IF Won THEN Exit;
   IF Msg = 'GO' THEN GOTO 1;
   GOTO 5;
  END;  (*playgame*)

(************************************************************************)

 PROCEDURE GetPoints;
     (* procedure to get the points from player *)

    VAR Ch : CHAR;

  BEGIN (*getpoints*)
   P9 := 0;
   SetBackColor(0);
   SetForeColor(5);
   PrtTextXY(210,134,'ESC when done');
   PrtTextXY(210,143,'UP ARROW   ++');
   PrtTextXY(210,152,'DOWN ARROW --');
   REPEAT
    ClearBuffer;
    Ch := ReadKey;
    IF Ch = #0
     THEN BEGIN
           Ch := ReadKey;
           CASE Ch OF
            #72 : Inc(P9);
            #80 : IF P9 > 0 THEN Dec(P9);
           END;
          END;
    ClearBuffer;
    S9 := P9;
    UpDateTotalWindow;
   UNTIL Ch = #27;
   ErasePlayedCards;
  END; (*getpoints*)

(************************************************************************)

 PROCEDURE ScoreHands;
     (* procedure to total points in coms and players hand *)

    LABEL 1, 2, 3, 4;

    VAR I, J, K, L, N, P, X1 : INTEGER;
        Ch : CHAR;
        Msg : STRING;
        NStr : STRING[3];

  BEGIN (*scorehands*)
   IF Won THEN Exit;
   SetBackColor(0);
   PrtTextXY(125,123,'        ');
   EraseCards(FALSE);
   IF MMM = 0
    THEN BEGIN
          MenuBox('[ I score first ]',34);
          Delay(2000);
          X1 := 2;
          GOTO 2;
         END
   ELSE BEGIN
         MenuBox('[ You score first ]',35);
         Delay(2000);
         X1 := 1;
         GOTO 1;
        END;
   3: MenuBox('= = The crib contains = =',14);
   N := 20;
   FOR I := 1 TO 4 DO
    BEGIN
     DisplayCard(N,151,CribHand[I,3],CribHand[I,4]); N := N + 35;
    END;
   Delay(2000);
   FOR I := 1 TO 4 DO
    FOR J := 1 TO 4 DO
     WW[I,J] := CribHand[I,J];
   CC := 1; WW[5,4] := T9;
   MoreAnalysis(P);
   EvenMoreAnalysis(P);
   InitializeOthers;
   CASE X1 OF
    1 : BEGIN
         Str(P,NStr);
         Msg := 'The crib has '+NStr+' points';
         MenuBox(Msg,34);
         S9 := P;
         UpDateTotalWindow;
         Delay(1000);
         IF P <> 0 THEN MoveComPeg(P);
         IF Won THEN Exit;
         MenuBox('= = Press a key = =',14);
         ClearBuffer;
         Ch := ReadKey;
         ClearBuffer;
         S9 := 0; UpDateTotalWindow;
         EraseCards(FALSE);
         Exit;
        END;
    2 : BEGIN
         X1 := 3;
         GOTO 4;
        END;
   END;
   1: K := 1;
   FOR I := 1 TO 6 DO
    IF (I <> I4) AND (I <> I3)
     THEN BEGIN
           FOR J := 1 TO 4  DO
            WW[K,J] := YY[I,J];
           Inc(K);
          END;
   MenuBox('= = = Your cards = = =',35);
   N := 20;
   FOR I := 1 TO 4 DO
    BEGIN
     DisplayCard(N,151,WW[I,3],WW[I,4]); N := N + 35;
    END;
   Delay(2000);
   WW[5,4] := T9; CC := 0;
   MoreAnalysis(P);
   EvenMoreAnalysis(P);
   InitializeOthers;
   4: IF CC = 0
       THEN MenuBox('How many points do you have?',35)
      ELSE MenuBox('How many points are in the crib?',35);
   GetPoints;
   I := P - P9;
   IF I < 0
    THEN BEGIN
          MenuBox('Not with that hand, TRY AGAIN',15);
          Delay(2000);
          GOTO 4;
         END;
   IF P9 <> 0 THEN MoveHumPeg(P9);
   IF Won THEN Exit;
   IF I > 0
    THEN BEGIN
          Str(I,NStr);
          Msg := 'MUGGINS for '+NStr+' points';
          MenuBox(Msg,15);
          Delay(1000);
          MoveComPeg(I);
          IF Won THEN Exit;
         END;
   MenuBox('Press a key to continue',14);
   ClearBuffer;
   Ch := ReadKey;
   ClearBuffer;
   EraseCards(FALSE);
   S9 := 0; UpDateTotalWindow;
   CASE X1 OF
    1 : GOTO 2;
    2 : GOTO 3;
    3 : BEGIN
         EraseCards(FALSE);
         Exit;
        END;
   END;
   2: FOR K := 1 TO 4 DO
       BEGIN
        L := V[B9,K];
        FOR J := 1 TO 4 DO
         WW[K,J] := MM[L,J];
       END;
   FOR K := 1 TO 4 DO
    L := WW[K,1];
   MenuBox('= = = My cards = = =',34);
   N := 20;
   FOR I := 1 TO 4 DO
    BEGIN
     DisplayCard(N,151,WW[I,3],WW[I,4]); N := N + 35;
    END;
   Delay(2000);
   WW[5,4] := T9; CC := 0;
   MoreAnalysis(P);
   EvenMoreAnalysis(P);
   InitializeOthers;
   Str(P,NStr);
   S9 := P;
   UpDateTotalWindow;
   Msg := 'I have '+NStr+' points';
   MenuBox(Msg,34);
   Delay(2000);
   IF P <> 0 THEN MoveComPeg(P);
   IF Won THEN Exit;
   MenuBox('Press a key to move on',14);
   ClearBuffer;
   Ch := ReadKey;
   ClearBuffer;
   EraseCards(FALSE);
   S9 := 0; UpDateTotalWindow;
   CASE X1 OF
    1 : GOTO 3;
    2 : GOTO 1;
   END;
   EraseCards(FALSE);
  END; (*scorehands*)

(************************************************************************)

 PROCEDURE FinalTally;
     (* procedure to display up totals *)

    VAR Ch : CHAR;
        NS : STRING[3];

  BEGIN (*finaltally*)
   OverScanColor := 0;
   ClearScreen;
   SetBackColor(0);
   IF Who {human}
    THEN BEGIN
          SetForeColor(35);
          PrtTextXY(1,1,'You have won the game');
         END
   ELSE BEGIN
         SetForeColor(34);
         PrtTextXY(1,1,'I have won this game');
        END;
   SetForeColor(10);
   PrtTextXY(1,100,'Play another game (Y/N)?');
   SetForeColor(14);
   PrtTextXY(1,50,'GAMES:');
   SetForeColor(35);
   Str(You,NS);
   PrtTextXY(57,50,'You: '+NS);
   SetForeColor(34);
   Str(Me,NS);
   PrtTextXY(130,50,'Me: '+NS);
   REPEAT
    Ch := UpCase(ReadKey);
   UNTIL Ch IN ['Y','N'];
   IF Ch = 'N' THEN Quit := TRUE ELSE Quit := FALSE;
  END; (*finaltally*)

(************************************************************************)

 PROCEDURE DoIntro;
     (* procedure to do the intro screen animation *)

    VAR I, SA, BA, Crd, Let, Incr, X1, X2, Y : INTEGER;

  BEGIN (*dointro*)
   DefineWindow(7,109,159,156,1);
   ClearWindow(1);
   SA := 0; BA := 0; Incr := 3;
   X1 := 25; X2 := 25; Y := 145;
   Let := 1; Crd := Random(13) + 1;
   WHILE X2 <= 263 DO
    BEGIN
     DisplayCompress(X1,Y,LetArr[Let].Pic);
     DisplayCompress(X2,Y,Spades[Crd].Pic);
     Delay(20);
     X2 := X2 + 2;
     IF (X2 = 55) OR (X2 = 85) OR (X2 = 115) OR (X2 = 145) OR (X2 = 175)
        OR (X2 = 205) OR (X2 = 235)
      THEN BEGIN
            IF BA = 0
             THEN BEGIN
                   X1 := X1 + 29; BA := 1;
                  END
            ELSE X1 := X1 + 30;
            IF (Let = 4) AND (SA = 0)
             THEN SA := 1
            ELSE IF Let <> 7 THEN Inc(Let);
           END;
    END;
   SetForeColor(64);
   SetBackColor(8);
   PrtTextXY(50,191,'Press any key to begin game.');
   I := 1;
   WHILE (I < 16) AND NOT KeyPressed DO
    BEGIN
     MoveComPeg(Random(8)+1);
     IF NOT KeyPressed THEN MoveHumPeg(Random(8)+1);
     Inc(I);
    END;
   ClearBuffer;
  END; (*dointro*)

(************************************************************************)

BEGIN (*MAIN PROGRAM*)
 IF NOT CheckVideo
  THEN BEGIN
        Writeln('This program requires a VGA or MCGA graphics system.');
        Halt(1);
       END;
 ExSv := ExitProc; ExitProc := @LastExit;
 Randomize;
 Set256;
 You := 0; Me := 0;
 LoadFiles;
 IF PicCom = TRUE
  THEN DisplayCompress(0,0,PicPointer)
 ELSE StoreBitBlock(0,0,0,PicPointer);
 InitializeSome;
 DoIntro;
 REPEAT
  IF PicCom = TRUE
   THEN DisplayCompress(0,0,PicPointer)
  ELSE StoreBitBlock(0,0,0,PicPointer);
  InitializeSome;
  InitializeOthers;
  REPEAT
   IF CardBack.Com
    THEN DisplayCompress(20,116,CardBack.Pic)
   ELSE StoreBitBlock(20,116,0,CardBack.Pic);
   ShuffleCards;
   IF Cut = 1
    THEN BEGIN
          Cut := 0;
          ClearBuffer;
          CutForDeal;
         END;
   DealCards;
   V := ConV;
   AnalyzeComsHand;
   I1 := V[B9,5]; I2 := V[B9,6];
   GetPlayerDiscards;
   AssignCrib;
   GetUpCard;
   PlayGame;
   ErasePlayedCards;
   ScoreHands;
  UNTIL Won;
  FinalTally;
 UNTIL Quit;
END. (*MAIN PROGRAM*)
