/* SEVEN (Rel 0.01)* Copyright (c) 1994 Altair */

player.1='Urd'
player.2='Belldandy'
player.3='Skuld'
player.4='Marller'

'@chcp 437'
say "    SEVEN for OS/2 PM"
say "       Release 0.01"
say
say "Copyright (c) 1994, Altair"
say "    All rights reserved."
say
say
say "To exit this game..."
say "	1) Press 'Break' key with 'Ctrl' key."
say "	2) If SEVEN's dialogue-box has been openned, push 'OK' button of it."
player.0='Table';  player.5='You'
call RxFuncAdd SysSleep,RexxUtil,SysSleep
call RxFuncAdd VInit,VREXX,VInit;  call VInit
signal on failure name CleanUp
signal on halt name CleanUp
signal on syntax name CleanUp

suit.0=4;  suit.1='Spade';  suit.2='Heart';  suit.3='Club';  suit.4='Diamond'
rank.0='--- Call';  rank.1='A';  do i=2 to 10;  rank.i=i;  end
rank.11='J';  rank.12='Q';  rank.13='K'
do i=1 to 5;  score.i.3/*total score*/=0;  end

NewGame:
do i=1 to 4;  hands.i=0;  do j=1 to 13;  card.i.j=0;  end;  end
hands.0=52;  hands.5=0

push 0 33 33;  push 5 51  0;  push 4  0 33
push 1 66 33;  push 3 18 66;  push 2 51 66
do 6
  pull i frame.left frame.bottom
  color='BLUE';  if i=0 then color='GREEN'
  frame.right=frame.left+32;  frame.top=frame.bottom+32
  window.i=VOpenWindow('Seven - '||player.i,color,frame)
end;  drop frame.  color
call VSetFont window.0,'TIMEB',28;  call VSay window.0,50,800,'SEVEN'
call VSetFont window.0,'TIME',14;  call Vsay window.0,50,700,'Release 0.01'
call Vsay window.0,50,550,'Copyright (c) 1994, Altair';  call SysSleep 3

do 5;  do player=1 to 5;  call draw;  call DispHands;  end;  end
call _draw -1

player=0;  do i=0 to 11;  table.i='';  end;  call DispCard
draw7=(rank=7)*3;  if rank=12 then rank=0

do forever
  player=NextPlayer()
  if rank=1 then do
    push player.player': Skipped';  call DispTable
    player=NextPlayer()
  end
  if player.player='You'then
    if draw7=0 then call YourTurn;  else call YourTurn7
  else
    do
      call VClearWindow window.player
      call VBackColor window.player,'CYAN'
      call VForeColor window.player,'BLUE'
      call VSay window.player,50,500,'My turn'
      if draw7=0 then call play;  else call seven
    end
  if hands.player<1 then signal GameOver
  call DispHands
end

GameOver:
push player.player 'won the day!';  call DispTable
k=0;  n=0
do player=1 to 5
  score.player.1=player.player
  call VClearWindow window.player
  call VBackColor window.player,'BLUE'
  call VForeColor window.player,'CYAN'
  score.player.2=-DispFaces()
  n=n-score.player.2
  if score.player.2=0 then
    do
      call VBackColor window.player,'CYAN'
      call VForeColor window.player,'BLUE'
      call VSetFont window.player,'TIME',24
      call VSay window.player,50,500,'Win!'
      k=player
    end
  score.player.3=score.player.3+score.player.2
end
score.k.2=n;  score.k.3=score.k.3+n
do i=1 to 4
  do j=i+1 to 5
    if score.i.2<score.j.2 then
      do k=1 to 3
        n=score.i.k;  score.i.k=score.j.k;  score.j.k=n
      end
  end
end
do i=1 to 5;  player.i=score.i.1;  end
score.rows=5;  score.cols=3
score.label.1='Name';  score.label.2='Score';  score.label.3='Total'
score.width.1=15;  score.width.2=10;  score.width.3=6;  call VDialogPos 0,0
if VTableBox('Seven - Score',score,1,30,5,3)='OK'then do
  do i=0 to 5;  call VCloseWindow window.i;  end
  signal NewGame
end

CleanUp:
call VExit
exit

draw:procedure expose player window. hands. card. table.;  arg n_draw
  call VClearWindow window.player;  call VSetFont window.player,'TIME',24
  call VBackColor window.player,'CYAN';  call VForeColor window.player,'BLUE'
  call VSay window.player,50,500,'Drawing '||n_draw
  if hands.0<1 then do
    do i=1 to 4
      do j=1 to 13
        if card.i.j<0 then do;  card.i.j=0;  hands.0=hands.0+1;  end
      end
    end
    if hands.0=0 then do
      push 'Table: No stack!!';  call DispTable
      return 1
    end
    push 'Table: Shuffling';  call DispTable;  call SysSleep 1
  end
  call _draw player;  hands.player=hands.player+1
  return 0

_draw:procedure expose card. rank suit hands.;  arg owner
  do until card.suit.rank=0;  suit=random(1,4);  rank=random(1,13);  end
  card.suit.rank=owner;  hands.0=hands.0-1
  return

DispHands:procedure expose player window. card. hands. rank. suit. player.
  call VBackColor window.player,'BLUE'
  call VForeColor window.player,'CYAN'
  call VClearWindow window.player
  if player.player='You'then
    call DispFaces
  else
    do
      call VSetFont window.player,'TIME',24
      cards=' cards';  if hands.player=1 then cards=' card'
      call VSay window.player,50,500,'I have '||hands.player||cards
    end
  return

DispFaces:procedure expose player card. window. rank. suit.
  call VSetFont window.player,'TIME',12
  n=0;  x=50;  y=920
  do i=1 to 4
    do j=1 to 13
      if card.i.j=player then do
        call VSay window.player,x,y,rank.j||' '||suit.i
        y=y-80;  if y<0 then do;  x=550;  y=920;  end
        n=n+1+9*(j=12)+4*(j=7)
      end
    end
  end
  return n

DispTable:procedure expose table. window.
  call VClearWindow window.0
  parse pull table.0
  i=11
  do y=920 to 0 by-80
    call VSay window.0,50,y,table.i
    j=i-1;  table.i=table.j;  i=j
  end
  return

vrank:procedure expose player card.;  arg rank
  n=0;  do i=1 to 4;  n=n+(card.i.rank=player);  end;  return n+random()/2000

vsuit:procedure expose player card.;  arg suit
  n=-(card.suit.12=player)
  do i=1 to 13;  n=n+(card.suit.i=player);  end;  return n+random()/2000

seven:procedure expose player card. hands. rank suit window. rank. suit. table. player. draw7
  NewSuit=0;  v=0
  do i=1 to 4
    if card.i.7=player then do
      k=vsuit(i)
      if v<k then do
        NewSuit=i
        v=k
      end
    end
  end
  if NewSuit<>0 then do
    suit=NewSuit;  draw7=draw7+3
    card.suit.7=-1;  hands.player=hands.player-1
    signal DispCard
  end
  do i=1 to draw7 until draw(i);  end
  push player.player 'draws' draw7 'cards';  call DispTable;  draw7=0
  return

NextPlayer:return player+1-5*(player>=5)

play:procedure expose player card. hands. rank suit window. rank. suit. table. player. draw7
  MinHands=99
  do i=1 to 5
    if i=player then iterate
    if MinHands>hands.i then MinHands=hands.i
  end

  NewSuit=0
  do n_draw=1 by 1
    v=0
    if(vrank(12)<MinHands)then do
      do i=1 to 4
        if card.i.rank=player then do
          k=vsuit(i)+vrank(rank)
          if v<k then do;  v=k;  NewRank=rank;  NewSuit=i;  end
        end
      end
      do i=1 to 13
        if i=12 then iterate
        if card.suit.i=player then do
          k=vsuit(suit)+vrank(i)
          if i=7 then do;  j=NextPlayer();  k=k+(hands.j<3)/2;  end
          if v<k then do;  v=k;  NewRank=i;  NewSuit=suit;  end
        end
      end
      if NewSuit<>0 then do
        rank=NewRank;  suit=NewSuit
        card.suit.rank=-1;  hands.player=hands.player-1
        if rank=7 then draw7=draw7+3
        call SysSleep 1
DispCard:push player.player':' rank.rank suit.suit;  call DispTable
	return
      end
    end
    do i=1 to 4
      if card.i.12=player then do
        card.i.12=-1
        push player.player': Q' suit.i;  call DispTable
        hands.player=hands.player-1
        v=0
        do j=1 to 4
          k=vsuit(j)
          if v<k then do
            v=k
            suit=j
          end
        end
        rank=0
        call SysSleep 1
_call:	signal DispCard
      end
    end
    if draw(n_draw)then do
pass: push player.player': Pass';  call DispTable
      return
    end
  end

xsuit:procedure;  arg s
  return translate(substr(s,1,1),'1234','SHCD')

YourTurn:procedure expose player player. card. hands. rank suit window. rank. suit. table. draw7
  title='Seven - Your turn'
  do forever
    list.1='Draw';  k=1
    do i=1 to 4
      do j=1 to 13
        if card.i.j=player then do;  k=k+1;  list.k=rank.j||' '||suit.i;  end
      end
    end;  list.0=k;  call VDialogPos 100,0
    call VListBox title,list,10,5,1
    if list.vstring=list.1 then
      do
        if draw()then signal pass
        call DispHands
      end
    else
      do
        parse var list.vstring NewRank NewSuit
        if NewRank='Q'then
          do
            push 'You:' list.vstring;  call DispTable
            suit=xsuit(NewSuit)
            hands.player=hands.player-1;  card.suit.12=-1
            call VRadioBox 'Call what?','suit',1
            rank=0;
            suit=xsuit(suit.vstring)
	    signal _call
          end
        else
          do
            if(NewRank<>rank.rank)&(NewSuit<>suit.suit)then
              do
                list.0=1;  list.1='Must be same suit or rank!'
                call VMsgBox title,list,1
              end
            else
              do
                suit=xsuit(NewSuit)
                do rank=1 to 13 until NewRank=rank.rank;  end
                hands.player=hands.player-1;  card.suit.rank=-1
                if rank=7 then draw7=draw7+3
                signal DispCard
              end
          end
      end
  end

YourTurn7:procedure expose player player. card. hands. rank suit window. rank. suit. table. draw7
  title='Seven - Your turn'
  do forever
    list.1='Draw';  k=1
    do i=1 to 4
      do j=1 to 13
        if card.i.j=player then do;  k=k+1;  list.k=rank.j||' '||suit.i;  end
      end
    end;  list.0=k;  call VDialogPos 100,0
    call VListBox title,list,10,5,1
    if list.vstring=list.1 then
      do
	do i=1 to draw7 until draw(i);  end
        call DispHands
        push 'You draw' draw7 'cards';  call DispTable;  draw7=0
        return
      end
    parse var list.vstring NewRank NewSuit
    if NewRank='7'then
      do
        rank=7;  suit=xsuit(NewSuit)
        hands.player=hands.player-1;  card.suit.7=-1
        draw7=draw7+3
        signal DispCard
      end
    list.0=1;  list.1='Play seven or draw!'
    call VMsgBox title,list,1
  end
