/* Seahaven Towers for OS/2 installation program */

  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs

  Parse Arg InstallDir
  Signal On Halt Name ErrorHandler

  Say " "
  Say " "
  Say " "
  Say " Seahaven Towers Installation"

  If InstallDir=" " Then Do
    Say
    Say " Please specify the name of the subdirectory to"
    Say " which you would like to install Seahaven Towers,"
    Say " hit <ENTER> to use the current directory, or type"
    Say " 'Q'<ENTER> to quit."
    Say " "
    Say " For Example:  C:\SEAHAVEN<ENTER>"
    Say " "
    Say " Directory to install to:"

    Parse Value SysCurPos() with Row Col
    Col=Col+26
    Row=Row-1
    Call SysCurPos Row, Col
    Pull InstallDir
    If (InstallDir="Q")|(InstallDir="q") Then Exit
  End

  If InstallDir=" " Then InstallDir=directory()

  Else Do

    Call SysFileTree InstallDir, FileDirectory, 'D'

    If FileDirectory.0='0' Then Do
      Say
      Say " Now creating directory "InstallDir" . . ."
      rc=SysMkDir(InstallDir)
      If rc\=0 Then Do
        Say " "
        Say " Error creating directory "InstallDir" . . ."
        Say " You may have specified an invalid directory name."
        Say " Rerun install to try again."
        Exit
      End
    End
   End

  Say " "
  Say " Now copying files . . ."                              /* Now copy files */
  Call FileCopy 'Seahaven.HLP', InstallDir
  Call FileCopy 'ReadMe', InstallDir
  Call FileCopy 'Seahaven.EXE', InstallDir
  Say " "
  Say " Now creating WPS program object . . ."                  /* Now create the Desktop object*/
  SetupString="EXENAME="InstallDir"\Seahaven.EXE;STARTUPDIR="InstallDir

  rc=SysCreateObject("WPProgram","Seahaven Towers","<WP_DESKTOP>",SetupString)
  If rc=0 Then Do
    Say
    Say " Sorry, couldn't create the Seahaven Towers program object."
    Say " You may already have a Seahaven Towers program object on your"
    Say " Desktop.  Delete this object and rerun install. "
    Exit
  End

  Say
  Say " Seahaven Towers successfully installed."

  Exit


/******* FileCopy procedure */

  FileCopy: Arg FileName, Destination

    Command='@Copy 'FileName' 'Destination' >NUL'
    Command
    Return


/******* ErrorHandler procedure */

  ErrorHandler:

    Call SysCls
    Say "Unknown error - aborting installation . . ."
    Say "Contact the author with details please."
  Exit

