/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gmp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import net.sf.gogui.gmp.Util;
import net.sf.gogui.utils.StringUtils;

class WriteThread
extends Thread {
    private boolean m_sendInProgress;
    private final boolean m_verbose;
    private byte[] m_packet;
    private final Object m_mutex = new Object();
    private final OutputStream m_out;

    public WriteThread(OutputStream outputStream, boolean bl) {
        this.m_out = outputStream;
        this.m_verbose = bl;
    }

    public void run() {
        try {
            Object object = this.m_mutex;
            synchronized (object) {
                Random random = new Random();
                while (true) {
                    if (this.m_sendInProgress) {
                        long l = 20000L + (long)(random.nextDouble() * 10000.0);
                        this.m_mutex.wait(l);
                    } else {
                        this.m_mutex.wait();
                    }
                    if (!this.m_sendInProgress) continue;
                    this.writePacket();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resend() {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(byte[] byArray, boolean bl) {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_packet = byArray;
            if (bl) {
                this.writePacket();
                return;
            }
            this.m_sendInProgress = true;
            this.m_mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendTalk(String string) {
        Object object = this.m_mutex;
        synchronized (object) {
            int n = string.length();
            byte[] byArray = new byte[n + 1];
            for (int i = 0; i < n; ++i) {
                byte by = (byte)string.charAt(i);
                byArray[i] = by > 3 && by < 127 ? (int)by : 63;
            }
            byArray[n] = 10;
            try {
                this.m_out.write(byArray);
                this.m_out.flush();
            }
            catch (IOException iOException) {
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSend() {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_sendInProgress = false;
            this.m_mutex.notifyAll();
        }
    }

    private void writePacket() {
        Util.log("send " + Util.format(this.m_packet[0]) + " " + Util.format(this.m_packet[1]) + " " + Util.format(this.m_packet[2]) + " " + Util.format(this.m_packet[3]), this.m_verbose);
        try {
            this.m_out.write(this.m_packet);
            this.m_out.flush();
        }
        catch (IOException iOException) {
            Util.log("IOException", true);
        }
    }
}

