/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gmp;

import java.io.InputStream;
import java.io.OutputStream;
import net.sf.gogui.gmp.Cmd;
import net.sf.gogui.gmp.MainThread;

public final class Gmp {
    private final int m_size;
    private final MainThread m_mainThread;

    public Gmp(InputStream inputStream, OutputStream outputStream, int n, int n2, boolean bl, boolean bl2) {
        this.m_size = n;
        this.m_mainThread = new MainThread(inputStream, outputStream, n, n2, bl, bl2);
        this.m_mainThread.start();
    }

    public String getTalk() {
        return this.m_mainThread.getTalk();
    }

    public void interruptCommand() {
        this.m_mainThread.interruptCommand();
    }

    public boolean newGame(int n, StringBuffer stringBuffer) {
        if (n != this.m_size) {
            stringBuffer.append("Board size must be ");
            stringBuffer.append(this.m_size);
            return false;
        }
        return this.m_mainThread.send(new Cmd(2, 0), stringBuffer);
    }

    public boolean play(boolean bl, int n, int n2, StringBuffer stringBuffer) {
        int n3;
        if (n >= this.m_size || n2 >= this.m_size || n < -1 || n2 < -1) {
            stringBuffer.append("Invalid coordinates");
            return false;
        }
        int n4 = n3 = bl ? 0 : 512;
        if (n >= 0 && n2 >= 0) {
            n3 |= 1 + n + n2 * this.m_size;
        }
        return this.m_mainThread.send(new Cmd(5, n3), stringBuffer);
    }

    public boolean queue(StringBuffer stringBuffer) {
        return this.m_mainThread.queue(stringBuffer);
    }

    public boolean sendTalk(String string) {
        return this.m_mainThread.sendTalk(string);
    }

    public boolean undo(StringBuffer stringBuffer) {
        return this.m_mainThread.send(new Cmd(6, 1), stringBuffer);
    }

    public Move waitMove(boolean bl, StringBuffer stringBuffer) {
        int n = bl ? 0 : 512;
        MainThread.WaitResult waitResult = this.m_mainThread.waitCmd(5, 512, n);
        if (waitResult.m_response != null) {
            stringBuffer.append(waitResult.m_response);
        }
        if (!waitResult.m_success) {
            return null;
        }
        return Cmd.parseMove(waitResult.m_val, this.m_size);
    }

    public boolean waitNewGame(int n, StringBuffer stringBuffer) {
        if (n != this.m_size) {
            stringBuffer.append("Board size must be ");
            stringBuffer.append(this.m_size);
            return false;
        }
        MainThread.WaitResult waitResult = this.m_mainThread.waitCmd(2, 0, 0);
        if (waitResult.m_response != null) {
            stringBuffer.append(waitResult.m_response);
        }
        return waitResult.m_success;
    }

    public static class Move {
        public boolean m_isBlack;
        public int m_x;
        public int m_y;
    }
}

