/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.gui.AnalyzeCommand;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.utils.ErrorMessage;

public class ContextMenu
extends JPopupMenu {
    private static final long serialVersionUID = 0L;
    private final ActionListener m_actionListener;
    private final GoPoint m_point;
    private final JCheckBoxMenuItem m_mark;
    private final JCheckBoxMenuItem m_markCircle;
    private final JCheckBoxMenuItem m_markSquare;
    private final JCheckBoxMenuItem m_markTriangle;
    private JMenu m_analyzeMenu;
    private final Listener m_listener;
    private final ArrayList m_commands = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ContextMenu(GoPoint goPoint, boolean bl, ArrayList arrayList, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Listener listener) {
        this.m_point = goPoint;
        this.m_listener = listener;
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        if (!bl) {
            try {
                AnalyzeCommand.read(arrayList2, arrayList3, arrayList, string);
            }
            catch (ErrorMessage errorMessage) {
                // empty catch block
            }
        }
        this.m_actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Listener listener = ContextMenu.this.m_listener;
                if (listener == null) {
                    return;
                }
                String string = actionEvent.getActionCommand();
                if (string.equals("analyze-clear")) {
                    listener.clearAnalyze();
                } else if (string.equals("cancel")) {
                    ContextMenu.this.setVisible(false);
                } else if (string.equals("mark")) {
                    boolean bl = ContextMenu.this.m_mark.isSelected();
                    listener.mark(ContextMenu.this.m_point, MarkType.MARK, bl);
                } else if (string.equals("mark-circle")) {
                    boolean bl = ContextMenu.this.m_markCircle.isSelected();
                    listener.mark(ContextMenu.this.m_point, MarkType.CIRCLE, bl);
                } else if (string.equals("mark-square")) {
                    boolean bl = ContextMenu.this.m_markSquare.isSelected();
                    listener.mark(ContextMenu.this.m_point, MarkType.SQUARE, bl);
                } else if (string.equals("mark-triangle")) {
                    boolean bl = ContextMenu.this.m_markTriangle.isSelected();
                    listener.mark(ContextMenu.this.m_point, MarkType.TRIANGLE, bl);
                } else if (string.equals("edit-label")) {
                    listener.editLabel(ContextMenu.this.m_point);
                } else {
                    int n = Integer.parseInt(string);
                    AnalyzeCommand analyzeCommand = ContextMenu.this.getCommand(n);
                    analyzeCommand.setPointArg(ContextMenu.this.m_point);
                    listener.setAnalyzeCommand(analyzeCommand);
                }
            }
        };
        JLabel jLabel = new JLabel("Point " + goPoint);
        jLabel.setBorder(GuiUtils.createSmallEmptyBorder());
        this.add(jLabel);
        this.addSeparator();
        this.m_mark = this.createCheckBox("Mark", "mark");
        this.m_mark.setSelected(bl2);
        this.add(this.m_mark);
        this.m_markCircle = this.createCheckBox("Mark Circle", "mark-circle");
        this.m_markCircle.setSelected(bl3);
        this.add(this.m_markCircle);
        this.m_markSquare = this.createCheckBox("Mark Square", "mark-square");
        this.m_markSquare.setSelected(bl4);
        this.add(this.m_markSquare);
        this.m_markTriangle = this.createCheckBox("Mark Triangle", "mark-triangle");
        this.m_markTriangle.setSelected(bl5);
        this.add(this.m_markTriangle);
        this.add(this.createItem("Edit Label", "edit-label"));
        this.addSeparator();
        if (!bl && arrayList2.size() > 0) {
            this.m_analyzeMenu = new JMenu("Analyze");
            this.m_analyzeMenu.putClientProperty("jgoodies.noIcons", Boolean.TRUE);
            this.add(this.m_analyzeMenu);
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string2 = (String)arrayList2.get(i);
                AnalyzeCommand analyzeCommand = new AnalyzeCommand(string2);
                if (analyzeCommand.needsOnlyPointArg()) {
                    this.addCommand(analyzeCommand);
                    continue;
                }
                if (!analyzeCommand.needsOnlyPointAndColorArg()) continue;
                this.addColorCommand(analyzeCommand);
            }
            this.add(this.createItem("Analyze Clear", "analyze-clear"));
            this.addSeparator();
        }
        JMenuItem jMenuItem = new JMenuItem("Cancel");
        jMenuItem.addActionListener(this.m_actionListener);
        jMenuItem.setActionCommand("cancel");
        this.add(jMenuItem);
    }

    public GoPoint getPointArg() {
        return this.m_point;
    }

    public boolean isEmpty() {
        return this.m_commands.size() == 0;
    }

    private void addColorCommand(AnalyzeCommand analyzeCommand) {
        String string = analyzeCommand.getLabel();
        JMenu jMenu = new JMenu(string);
        jMenu.putClientProperty("jgoodies.noIcons", Boolean.TRUE);
        analyzeCommand.setColorArg(GoColor.BLACK);
        JMenuItem jMenuItem = this.createItem(analyzeCommand, "Black");
        jMenu.add(jMenuItem);
        analyzeCommand = analyzeCommand.cloneCommand();
        analyzeCommand.setColorArg(GoColor.WHITE);
        jMenuItem = this.createItem(analyzeCommand, "White");
        jMenu.add(jMenuItem);
        this.m_analyzeMenu.add(jMenu);
    }

    private void addCommand(AnalyzeCommand analyzeCommand) {
        JMenuItem jMenuItem = this.createItem(analyzeCommand, analyzeCommand.getLabel());
        this.m_analyzeMenu.add(jMenuItem);
    }

    private JMenuItem createItem(AnalyzeCommand analyzeCommand, String string) {
        if (!$assertionsDisabled && this.m_commands.contains(analyzeCommand)) {
            throw new AssertionError();
        }
        this.m_commands.add(analyzeCommand);
        return this.createItem(string, Integer.toString(this.m_commands.size() - 1));
    }

    private JCheckBoxMenuItem createCheckBox(String string, String string2) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jCheckBoxMenuItem.addActionListener(this.m_actionListener);
        jCheckBoxMenuItem.setActionCommand(string2);
        return jCheckBoxMenuItem;
    }

    private JMenuItem createItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this.m_actionListener);
        jMenuItem.setActionCommand(string2);
        return jMenuItem;
    }

    private AnalyzeCommand getCommand(int n) {
        return (AnalyzeCommand)this.m_commands.get(n);
    }

    static {
        $assertionsDisabled = !ContextMenu.class.desiredAssertionStatus();
    }

    public static interface Listener {
        public void clearAnalyze();

        public void editLabel(GoPoint var1);

        public void mark(GoPoint var1, MarkType var2, boolean var3);

        public void setAnalyzeCommand(AnalyzeCommand var1);
    }
}

