/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpstatistics;

import net.sf.gogui.utils.ErrorMessage;
import net.sf.gogui.utils.Histogram;
import net.sf.gogui.utils.Statistics;
import net.sf.gogui.utils.Table;
import net.sf.gogui.utils.TableUtils;

public final class PositionStatistics {
    public final boolean m_onlyBoolValues;
    public final boolean m_onlyIntValues;
    public final int m_numberNoResult;
    public final Histogram m_histogram;
    public final Statistics m_statistics = new Statistics();
    public final Table m_histoTable;

    public PositionStatistics(String string, Table table, boolean bl, double d, double d2) throws ErrorMessage {
        int n;
        boolean bl2 = true;
        int n2 = 0;
        boolean bl3 = true;
        for (int i = 0; i < table.getNumberRows(); ++i) {
            int n3;
            String string2 = table.get(string, i);
            if (string2 == null) {
                ++n2;
                continue;
            }
            if (TableUtils.isNumberValue(string2)) {
                if (!TableUtils.isIntValue(string2)) {
                    bl2 = false;
                }
                if (!TableUtils.isBoolValue(string2)) {
                    bl3 = false;
                }
            }
            try {
                n3 = Integer.parseInt(table.get("Move", i));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ErrorMessage("Invalid move in table");
            }
            if (n3 <= 0) {
                throw new ErrorMessage("Invalid move in table");
            }
            try {
                this.m_statistics.add(Double.parseDouble(string2));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                ++n2;
            }
        }
        this.m_onlyBoolValues = bl3;
        this.m_onlyIntValues = bl2;
        this.m_numberNoResult = n2;
        double d3 = this.m_statistics.getMin();
        double d4 = this.m_statistics.getMax();
        if (!bl) {
            d = d3;
            d2 = d4;
        }
        double d5 = d2 - d;
        int n4 = 20;
        if (bl2) {
            n = Math.max(1, (int)(d5 / (double)n4 + 1.0));
            this.m_histogram = new Histogram(d, d2, n);
        } else {
            this.m_histogram = new Histogram(d, d2, d5 / (double)n4);
        }
        for (n = 0; n < table.getNumberRows(); ++n) {
            String string3 = table.get(string, n);
            if (string3 == null) continue;
            try {
                this.m_histogram.add(Double.parseDouble(string3));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_histoTable = TableUtils.fromHistogram(this.m_histogram, string);
    }

    public int getCount() {
        return this.m_statistics.getCount();
    }

    public double getError() {
        return this.m_statistics.getError();
    }

    public double getDeviation() {
        return this.m_statistics.getDeviation();
    }

    public double getMax() {
        return this.m_statistics.getMax();
    }

    public double getMaxError(int n) {
        return this.m_statistics.getMaxError(n);
    }

    public double getMean() {
        return this.m_statistics.getMean();
    }

    public double getMin() {
        return this.m_statistics.getMin();
    }

    public double getSum() {
        return this.m_statistics.getSum();
    }
}

