/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.gui.ImageButton;
import net.sf.gogui.gui.SimpleDialogs;
import net.sf.gogui.utils.StringUtils;

public class SelectProgram
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private JComboBox m_comboBox;
    private JTextField m_textField;
    private String m_command;

    public SelectProgram(Frame frame) {
        super(frame, "Select Program", true);
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.add((Component)this.createCommandPanel(), "Center");
        container.add((Component)this.createButtons(), "South");
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("cancel")) {
            this.dispose();
        } else if (string.equals("ok")) {
            this.m_command = this.m_comboBox.getSelectedItem().toString();
            this.m_comboBox.insertItemAt(this.m_command, 0);
            SelectProgram.saveHistory(this.getHistory());
            this.dispose();
        } else if (string.equals("open")) {
            this.open();
        }
    }

    public static void addHistory(String string) {
        Serializable serializable;
        if ((string = string.trim()).equals("")) {
            return;
        }
        String[] stringArray = StringUtils.splitArguments(string);
        if (stringArray.length > 0) {
            try {
                serializable = new File(stringArray[0]);
                serializable = ((File)serializable).getCanonicalFile();
                if (((File)serializable).exists()) {
                    string = ((File)serializable).toString() + string.substring(stringArray[0].length());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        serializable = SelectProgram.loadHistory();
        ((ArrayList)serializable).add(0, string);
        SelectProgram.saveHistory((ArrayList)serializable);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27 && !this.m_comboBox.isPopupVisible()) {
            this.dispose();
        }
    }

    public static String select(Frame frame) {
        SelectProgram selectProgram = new SelectProgram(frame);
        selectProgram.setLocationRelativeTo(frame);
        selectProgram.setVisible(true);
        return selectProgram.m_command;
    }

    private JPanel createButtons() {
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 5, 0));
        jPanel.setBorder(GuiUtils.createEmptyBorder());
        JButton jButton = new JButton("Ok");
        jButton.setActionCommand("ok");
        jButton.addActionListener(this);
        jButton.setMnemonic(79);
        this.getRootPane().setDefaultButton(jButton);
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel");
        jButton2.addActionListener(this);
        jButton2.setMnemonic(67);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private JPanel createCommandPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(GuiUtils.createEmptyBorder());
        JLabel jLabel = new JLabel("Go Program Command");
        jLabel.setHorizontalAlignment(2);
        jPanel.add(jLabel);
        jPanel.add(this.createInputPanel());
        return jPanel;
    }

    private JPanel createInputPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.m_comboBox = new JComboBox<Object>(SelectProgram.loadHistory().toArray());
        StringBuffer stringBuffer = new StringBuffer(70);
        for (int i = 0; i < 70; ++i) {
            stringBuffer.append('-');
        }
        this.m_comboBox.setPrototypeDisplayValue(stringBuffer.toString());
        this.m_comboBox.setEditable(true);
        ComboBoxEditor comboBoxEditor = this.m_comboBox.getEditor();
        this.m_textField = (JTextField)comboBoxEditor.getEditorComponent();
        this.m_textField.setColumns(40);
        this.m_textField.selectAll();
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27 && !SelectProgram.this.m_comboBox.isPopupVisible()) {
                    SelectProgram.this.dispose();
                }
            }
        };
        this.m_textField.addKeyListener(keyAdapter);
        GuiUtils.setMonospacedFont(this.m_comboBox);
        jPanel2.add((Component)this.m_comboBox, "Center");
        ImageButton imageButton = new ImageButton("net/sf/gogui/images/fileopen.png", "Browse", "Browse for Go program");
        imageButton.setActionCommand("open");
        imageButton.addActionListener(this);
        jPanel2.add((Component)imageButton, "East");
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private ArrayList getHistory() {
        ArrayList<String> arrayList = new ArrayList<String>(32);
        int n = 20;
        int n2 = this.m_comboBox.getItemCount();
        int n3 = n2;
        if (n3 > n) {
            n3 = n;
        }
        for (int i = 0; i < n3; ++i) {
            arrayList.add(this.m_comboBox.getItemAt(i).toString().trim());
        }
        return arrayList;
    }

    private static File getHistoryFile() {
        String string = System.getProperty("user.home");
        File file = new File(string, ".gogui");
        if (!file.exists()) {
            file.mkdir();
        }
        return new File(file, "program-history");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList loadHistory() {
        ArrayList<String> arrayList = new ArrayList<String>(32);
        File file = SelectProgram.getHistoryFile();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    if (!arrayList.contains(string = string.trim())) {
                        arrayList.add(string);
                    }
                    string = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!arrayList.contains("gnugo --mode gtp")) {
            arrayList.add("gnugo --mode gtp");
        }
        return arrayList;
    }

    private void open() {
        String string;
        File file = SimpleDialogs.showOpen(this, "Select Go Program");
        if (file == null) {
            return;
        }
        String string2 = file.toString();
        if (string2.indexOf(32) >= 0) {
            string2 = "\"" + string2 + "\"";
        }
        if (file.getName().toLowerCase().startsWith("gnugo") && SimpleDialogs.showQuestion(this, string = "Append option '--mode gtp' for GNU Go?")) {
            string2 = string2 + " --mode gtp";
        }
        this.m_comboBox.insertItemAt(string2, 0);
        this.m_comboBox.setSelectedIndex(0);
        this.m_textField.setCaretPosition(this.m_textField.getText().length());
        this.m_textField.requestFocusInWindow();
    }

    private static void saveHistory(ArrayList arrayList) {
        File file = SelectProgram.getHistoryFile();
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)arrayList.get(i);
                if (string.equals("")) continue;
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

