/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gogui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.Serializable;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.EditorKit;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.gui.SimpleDialogs;
import net.sf.gogui.utils.Platform;
import net.sf.gogui.version.Version;

public final class AboutDialog
extends JOptionPane {
    private static final long serialVersionUID = 0L;
    private JTabbedPane m_tabbedPane = new JTabbedPane();

    public static void show(Component component, String string, String string2, String string3, String string4) {
        AboutDialog aboutDialog = new AboutDialog(string, string2, string3, string4);
        JDialog jDialog = aboutDialog.createDialog(component, "About");
        aboutDialog.m_tabbedPane.invalidate();
        jDialog.pack();
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    private AboutDialog(String string, String string2, String string3, String string4) {
        JPanel jPanel;
        this.m_tabbedPane.putClientProperty("jgoodies.noContentBorder", Boolean.TRUE);
        boolean bl = string != null && !string.equals("");
        int n = 0;
        this.m_tabbedPane.add("GoGui", this.createPanelGoGui());
        this.m_tabbedPane.setMnemonicAt(n, 71);
        this.m_tabbedPane.setSelectedIndex(n);
        ++n;
        if (bl) {
            String string5 = "";
            if (string2 != null && !string2.equals("")) {
                string5 = "<p align=\"center\">Version " + string2 + "</p>";
            }
            int n2 = GuiUtils.getDefaultMonoFontSize() * 25;
            jPanel = AboutDialog.createPanel("<p align=\"center\"><img src=\"" + this.getImage("program.png") + "\"></p>" + "<p align=\"center\"><b>" + string + "</b></p>" + string5 + "<p align=\"center\" width=\"" + n2 + "\">" + "GTP protocol version " + string3 + "<br>" + "Command: " + "<tt>" + string4 + "</tt></p>");
        } else {
            jPanel = new JPanel();
        }
        this.m_tabbedPane.add("Program", jPanel);
        this.m_tabbedPane.setMnemonicAt(n, 80);
        this.m_tabbedPane.setEnabledAt(n, bl);
        this.m_tabbedPane.add("Java", this.createPanelJava());
        this.m_tabbedPane.setMnemonicAt(++n, 74);
        ++n;
        this.setMessage(this.m_tabbedPane);
        this.setOptionType(-1);
    }

    private static JPanel createPanel(String string) {
        Serializable serializable;
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setBorder(GuiUtils.createEmptyBorder());
        jEditorPane.setEditable(false);
        if (Platform.isMac() && (serializable = UIManager.getColor("Label.background")) != null) {
            jEditorPane.setBackground((Color)serializable);
        }
        jPanel.add(jEditorPane);
        serializable = JEditorPane.createEditorKitForContentType("text/html");
        jEditorPane.setEditorKit((EditorKit)serializable);
        jEditorPane.setText(string);
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                URL uRL;
                HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
                if (eventType == HyperlinkEvent.EventType.ACTIVATED && !Platform.openInExternalBrowser(uRL = hyperlinkEvent.getURL())) {
                    SimpleDialogs.showError(null, "Could not open URL in external browser");
                }
            }
        });
        return jPanel;
    }

    private JPanel createPanelGoGui() {
        URL uRL = this.getImage("project-support.png");
        String string = "http://gogui.sf.net";
        String string2 = "http://sourceforge.net/donate/index.php?group_id=59117";
        return AboutDialog.createPanel("<p align=\"center\"><img src=\"" + this.getImage("gogui.png") + "\"></p>" + "<p align=\"center\"><b>GoGui</b></p>" + "<p align=\"center\">" + "Version " + Version.get() + "</p>" + "<p align=\"center\">" + "Graphical user interface to Go programs<br>" + "&copy; 2006 Markus Enzenberger" + "<br>" + "<tt><a href=\"" + string + "\">" + string + "</a></tt>" + "</p>" + "<p align=\"center\">" + "<a href=\"" + string2 + "\">" + "<img src=\"" + uRL + "\" border=\"0\"></a>" + "</p>");
    }

    private JPanel createPanelJava() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = System.getProperty("java.vm.name");
        stringBuffer.append("<p align=\"center\"><img src=\"" + this.getImage("java.png") + "\"></p>");
        if (string == null) {
            stringBuffer.append("<p align=\"center\">Unknown Java VM</p>");
        } else {
            String string2;
            stringBuffer.append("<p align=\"center\"><b>");
            stringBuffer.append(string);
            stringBuffer.append("</b></p>");
            object = System.getProperty("java.vm.version");
            if (object != null) {
                stringBuffer.append("<p align=\"center\">Version ");
                stringBuffer.append((String)object);
                stringBuffer.append("</p>");
            }
            stringBuffer.append("<p align=\"center\">");
            String string3 = System.getProperty("java.vm.vendor");
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            if ((string2 = System.getProperty("java.vm.info")) != null) {
                stringBuffer.append("<br>");
                stringBuffer.append(string2);
            }
            stringBuffer.append("<br>");
        }
        object = Runtime.getRuntime();
        long l = ((Runtime)object).maxMemory();
        String string4 = l == Long.MAX_VALUE ? "unlimited" : Long.toString(l);
        stringBuffer.append("Memory: ");
        stringBuffer.append(string4);
        stringBuffer.append("<br>(");
        stringBuffer.append(((Runtime)object).totalMemory());
        stringBuffer.append(" total, ");
        stringBuffer.append(((Runtime)object).freeMemory());
        stringBuffer.append(" free)");
        return AboutDialog.createPanel(stringBuffer.toString());
    }

    private URL getImage(String string) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource("net/sf/gogui/images/" + string);
    }
}

