/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
/*
 * config.c - Xened
 */

#include "xened.h"

/*************************************************************************/

extern PTILEBOX   ptbox, ptboxFont, ptboxFlags;
extern SHORT      rgsValues[MAX_SECTORS][7];
extern BYTE       g_bLanguage;
extern CHAR       g_pszErr[256], g_pszDir[256];

/*************************************************************************/

BOOL LoadConfig (PSZ pszFilename)
{
    SHORT   sLen;
    FILE    *pfile;

    if (! (pfile = fopen (pszFilename, "rb")))
    {
/* FIXME       fprintf (stderr, "ERROR: Could not open config-file \"%s\".\n",
                 pszFilename);
        getchar (); */
        return (FALSE);
    }

    if ((g_bLanguage = fgetc (pfile)) > 1)
        g_bLanguage = 0;
    memset (rgsValues[0], 0, MAX_SECTORS*7);
    fread (rgsValues[0], 1, MAX_SECTORS*7, pfile);

    if (g_pszDir[0] == '\0')
    {
        sLen = fgetc (pfile);
        fread (g_pszDir, sLen, 1, pfile);
        g_pszDir[sLen] = '\0';
    }

    fclose (pfile);
    return (TRUE);
}
/*************************************************************************/

BOOL SaveConfig (PSZ pszFilename)
{
    FILE   *pfile;

    if (! (pfile = fopen (pszFilename, "wb")))
    {
/* FIXME        fprintf (stderr, "ERROR: Could not open config-file \"%s\".\n",
                 pszFilename);
        getchar (); */
        return (FALSE);
    }

    fputc (g_bLanguage, pfile);
    fwrite (rgsValues[0], 1, MAX_SECTORS*7, pfile);

    fputc (strlen (g_pszDir), pfile);
    fwrite (g_pszDir, strlen (g_pszDir), 1, pfile);

    fclose (pfile);
    return (TRUE);
}
/*************************************************************************/

PSZ rgpszLangs[LANG_MAX] =
{
    "English",
    "Deutsch",
};

BOOL QueryConfig (PGADGETLIST pgadlist, USHORT xo, USHORT yo)
{
    SHORT     i = 0, kcode, action, old_x;
    PGADGET   pgad = pgadlist->pgadFirst;

    pgadlist->xo = xo;
    pgadlist->yo = yo;

    memset (rgsValues[0], 0, MAX_SECTORS*7);
    
#ifdef _DEBUG_
    printf ("Assigned offsets to pgadlist.\n");
    getchar ();
#endif

    old_x = (ptboxFlags->xs+2)*(ptboxFlags->cTiles-1)
        +10*(ptboxFlags->cTiles-2);
    old_x = (320-old_x)/2+xo;

    do
    {
        if (pgad != pgadlist->pgadFirst)
            pgad->x1 = old_x+ptboxFlags->xs+2+10;
        else
            pgad->x1 = old_x;
        
        pgad->x2 = pgad->x1+ptboxFlags->xs+1;
        pgad->y2 = ptboxFlags->ys+1;
        pgad->usTile = i;
        pgad->usActionID = i+ACT_ENGLISH;

        old_x = pgad->x1;
        
        show_string (ptboxFont, rgpszLangs[i], old_x+xo+
                     ((ptboxFlags->xs+2)-strlen (rgpszLangs[i])*
                      (ptboxFont->xs+1))/2+1, yo+30, 50);
        i ++;
        pgad = pgad->pgadNext;

#ifdef _DEBUG_
    printf ("Gadget %d ok.\n", i);
    getchar ();
#endif
    }
    while (pgad != pgadlist->pgadFirst);

#ifdef _DEBUG_
    printf ("Drawing stuff.\n");
    getchar ();
#endif

    gadlist_draw (pgadlist);

    do
    {
        kcode = -1;
        do
        {
            /*** Check for any user activities (keyboard,mouse) ***/
            kcode = _read_kbd (0, 0, 0);
            if (kcode == 0)
                kcode = _read_kbd (0, 0, 0);

            do_stars (0, 0, 0, 0);
        }
        while (kcode == -1);
        action = -1;

        /*** Check what action user wants ***/
        if (kcode != -1)
        {
            switch (kcode)
                {
                case 9:          action = ACT_GADGET_NEXT;     break;
                case K_BACKTAB:  action = ACT_GADGET_PREV;     break;
                case C_RIGHT:    action = ACT_GADGET_NEXT;     break;
                case C_LEFT:     action = ACT_GADGET_PREV;     break;
                case 13:         action = ACT_GADGET_SHOOT;    break;
                }
        }

        /*** Anything to do with the gadgets? ***/
        switch (action)
        {
        case ACT_GADGET_NEXT:
            gadlist_next (pgadlist);
            break;

        case ACT_GADGET_PREV:
            gadlist_prev (pgadlist);
            break;

        case ACT_GADGET_SHOOT:
            action = gadlist_shoot (pgadlist);
            break;
        }
    }
    while (action < ACT_ENGLISH);
    
    g_bLanguage = action-ACT_ENGLISH;

    GFX_BOX (0+xo, 0+yo, xo+320, yo+200, BLACK);

    /* FIXME */
#ifndef __LINUX__
    QueryDirectory ();
#endif
    
    return (TRUE);
}
/*************************************************************************/

#define WIN_QD_XS       250
#define WIN_QD_YS       44
#define MAX_INPUT       91

BOOL QueryDirectory (VOID)
{
    BOOL    fCtrlkey = FALSE;
    SHORT   kcode, action, sCursor = strlen (g_pszDir);
    SHORT   xo = (320-WIN_QD_XS)/2+1, yo = 100;

    draw_stone (0+xo, 0+yo, WIN_QD_XS-1+xo, WIN_QD_YS-1+yo, LIGHTGRAY,
                WHITE, DARKGRAY);
    draw_stone (4+xo, 4+yo, WIN_QD_XS-5+xo, WIN_QD_YS-5+yo, CYAN, DARKGRAY,
                WHITE);
    draw_stone (8+xo, 8+yo, WIN_QD_XS-9+xo, yo+16, BLACK,
                WHITE, DARKGRAY);

    switch (g_bLanguage)
    {
    case LANG_GERMAN:
        show_string (ptboxFont, "Bitte geben Sie das Xenon2-Verzeichnis ein:",
                     10+xo, 10+yo, WIN_QD_XS-16);
        break;

    case LANG_ENGLISH:
    default:
        show_string (ptboxFont, "Please enter Xenon2-Directory:",
                     10+xo, 10+yo, WIN_QD_XS-16);
        break;
    }
    
    do
    {
        do
        {
            draw_stone (8+xo, 19+yo, WIN_QD_XS-9+xo, WIN_QD_YS-9+yo, BLACK,
                        WHITE, DARKGRAY);
            /* FIXME */
            g_pszDir[sCursor] = CURSOR_CHAR;
            g_pszDir[sCursor+1] = '\0';
            show_string (ptboxFont, g_pszDir, 10+xo, 22+yo, WIN_QD_XS-18);
            g_pszDir[sCursor] = '\0';
            
            kcode = -1;
            do
            {
                /*** Check for any user activities (keyboard,mouse) ***/
                if ((kcode = _read_kbd (0, 0, 0)) != -1)
                {
                    if (kcode == 0)
                    {
                        fCtrlkey = TRUE;
                        kcode = _read_kbd (0, 0, 0);
                    }
                    else
                    {
                        if (kcode < ' ')
                            fCtrlkey = TRUE;
                        else
                            fCtrlkey = FALSE;
                    }
                }
    
                do_stars (xo, yo, xo+WIN_QD_XS-1, yo+WIN_QD_YS-1);
            }
            while (kcode == -1);
            action = -1;
    
            /*** Check what action user wants ***/
            if (kcode != -1)
            {
                switch (kcode)
                    {
                    case 8:    action = ACT_DIR_BACK;        break;
                    case 13:   action = ACT_DIR_OK;          break;

                    case 27:
                        g_pszDir[0] = '\0';
                        goto LinuxPatchEnd;
                        break;

                    default:
                        if (! fCtrlkey)
                            action = ACT_DIR_INPUT;
                        break;
                    }
            }
    
            /*** Do this then! ;) ***/
            switch (action)
            {
            case ACT_DIR_BACK:
                if (sCursor > 0)
                {
                    sCursor--;
                    g_pszDir[sCursor] = '\0';
                }
                break;
    
            case ACT_DIR_INPUT:
                if (sCursor < MAX_INPUT)
                {
                    g_pszDir[sCursor] = kcode;
                    sCursor++;
                }
                break;
            }
        }
        while (action != ACT_DIR_OK);

        /*** FIXME? Don't want no (back?)slash at end of string ... ***/
            
        sprintf (g_pszErr, "%s%cxenon2.exe", g_pszDir, DIR_SEPERATOR_CHAR);
        if (access (g_pszErr, 0) != 0)
        {
            switch (g_bLanguage)
                {
                case LANG_GERMAN:
                    sprintf (g_pszErr,
                             "Scheint das falsche Verzeichnis zu sein.\n"
                             "Konnte XENON2.EXE dort nicht finden.");
                    break;

                case LANG_ENGLISH:
                default:
                    sprintf (g_pszErr,
                             "Seems to be the wrong directory.\n"
                             "Could not find XENON2.EXE there.");
                    break;
                }
            message (g_pszErr, MAGENTA, MSG_X, MSG_Y);
        }
        else
            break;
    }
    while (19);

LinuxPatchEnd:
    GFX_BOX (0+xo, 0+yo, WIN_QD_XS-1+xo, WIN_QD_YS-1+yo, BLACK);
    
    return (TRUE);
}
/*************************************************************************/
