/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/

#include "xened.h"

BOOL gadlist_next (PGADGETLIST pgadlist)
{
    if (pgadlist->pgad->fBorder)
        ShadowRect (pgadlist->pgad->x1+pgadlist->xo,
                    pgadlist->pgad->y1+pgadlist->yo,
                    pgadlist->pgad->x2+pgadlist->xo,
                    pgadlist->pgad->y2+pgadlist->yo,
                    WHITE, DARKGRAY);

    if (pgadlist->pgad->pgadNext)
    {
        pgadlist->pgad = pgadlist->pgad->pgadNext;

        if (pgadlist->pgad->fBorder)
            ShadowRect (pgadlist->pgad->x1+pgadlist->xo,
                        pgadlist->pgad->y1+pgadlist->yo,
                        pgadlist->pgad->x2+pgadlist->xo,
                        pgadlist->pgad->y2+pgadlist->yo,
                        YELLOW, RED);
        
        return (TRUE);
    }
    return (FALSE);
}

BOOL gadlist_prev (PGADGETLIST pgadlist)
{
    if (pgadlist->pgad->fBorder)
        ShadowRect (pgadlist->pgad->x1+pgadlist->xo,
                    pgadlist->pgad->y1+pgadlist->yo,
                    pgadlist->pgad->x2+pgadlist->xo,
                    pgadlist->pgad->y2+pgadlist->yo,
                    WHITE, DARKGRAY);

    if (pgadlist->pgad->pgadPrev)
    {
        pgadlist->pgad = pgadlist->pgad->pgadPrev;

        if (pgadlist->pgad->fBorder)
            ShadowRect (pgadlist->pgad->x1+pgadlist->xo,
                        pgadlist->pgad->y1+pgadlist->yo,
                        pgadlist->pgad->x2+pgadlist->xo,
                        pgadlist->pgad->y2+pgadlist->yo,
                        YELLOW, RED);
        
        return (TRUE);
    }
    return (FALSE);
}

USHORT gadlist_shoot (PGADGETLIST pgadlist)
{
    return (pgadlist->pgad->usActionID);
}

BOOL gadlist_draw (PGADGETLIST pgadlist)
{
    PGADGET   pgad = pgadlist->pgadFirst;
    
    do
    {
        if (pgad->fBorder)
            ShadowRect (pgad->x1+pgadlist->xo, pgad->y1+pgadlist->yo,
                        pgad->x2+pgadlist->xo, pgad->y2+pgadlist->yo,
                        WHITE, DARKGRAY);

        if (pgad->usTile != NO_TILE)
            show_tile (pgadlist->ptbox, pgad->usTile,
                       pgad->x1 + (pgad->x2 - pgad->x1 +1 -
                                   pgadlist->ptbox->xs) /2 +pgadlist->xo,
                       pgad->y1 + (pgad->y2 - pgad->y1 +1 -
                                   pgadlist->ptbox->ys) /2 +pgadlist->yo);

        pgad = pgad->pgadNext;
    }
    while (pgad && (pgad != pgadlist->pgadFirst));

    if ((pgad = pgadlist->pgad) != NULL)
        if (pgad->fBorder)
            ShadowRect (pgad->x1+pgadlist->xo, pgad->y1+pgadlist->yo,
                        pgad->x2+pgadlist->xo, pgad->y2+pgadlist->yo,
                        YELLOW, RED);
    return TRUE;
}
