//  (C) COPYRIGHT International Business Machines Corp. 1996
//  All Rights Reserved
//  Licensed Materials - Property of IBM
//  US Government Users Restricted Rights - Use, duplication or
//  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//
//
//  DISCLAIMER OF WARRANTIES.
//  The following [enclosed] code is sample code created by IBM
//  Corporation. This sample code is not part of any standard or IBM
//  product and is provided to you solely for the purpose of assisting
//  you in the development of your applications.  The code is provided
//  "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
//  NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
//  FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
//  THIS CODE.  THIS CODE MAY CONTAIN ERRORS.  IBM shall not be liable
//  for any damages arising out of your use of the sample code, even
//  if it has been advised of the possibility of such damages.
//
//  DISTRIBUTION.
//  This sample code can be freely distributed, copied, altered, and
//  incorporated into other software, provided that it bears the above
//  Copyright notice and DISCLAIMER intact.

package COM.ibm.samples;

import java.applet.*;
import java.awt.*;
import java.net.*;

import COM.ibm.dsom.services.CosNaming.*;
import COM.ibm.dsom.services.CosLifeCycle.*;
import COM.ibm.dsom.services.ExtendedNaming.*;

import COM.ibm.samples.Checkers.*;

import sunw.corba.*;
import sunw.joe.*;

public class CheckersApp extends Applet implements Runnable
{
  //--------------------------------------------------------
  // Game and game state
  //--------------------------------------------------------
  private int               currentPlayer;
  private int               playerTurn;
  private CheckersRef       board = null;
  private boolean           turn     = true;
  private Point             moveFrom = null;
  private boolean           create = true;
  private String            nameOfObj = "defaultObjectName";
  private boolean           first = true;
  private NamingContextRef  rootNC = null;
  private ObjectRef         obj = null;

  //--------------------------------------------------------
  // Graphical stuff
  //--------------------------------------------------------
  private Dimension     dim;
  private int           intWidth;
  private int           intHeight;
  private String        message  = null;
  private CheckboxGroup options = new CheckboxGroup();
  private TextField     objText = new TextField(30);

  //--------------------------------------------------------
  // Set up the gifs for the kings...
  //--------------------------------------------------------
  URL blackKingURL;
  URL redKingURL;
  Image   blackKing;
  Image   redKing;

  //--------------------------------------------------------
  // Thread stuff
  //--------------------------------------------------------
  private boolean       stopped  = true;
  private Thread        thread;

  //--------------------------------------------------------
  // The object reference to the orb
  //--------------------------------------------------------
  private OrbRef orb;

  //--------------------------------------------------------
  // The applet's methods
  //--------------------------------------------------------
  public CheckersApp ()
  {
  } // ctor

  public void init ()
  {
    //--------------------------------------------------------
    // Initialize the orb and get a reference to it.
    // This is where the ORB parameter "joeservices" is retrieved
    // from the html file param tags.
    //
    // Example applet param tag for "joeservices":
    // <param name=joeservices value="http://server/~bockhold/services">
    //
    // The "services" file is created by SOM during som_cfg
    // based on the SOMD_JCLIENT stanza entry "SERVICES_FILE_TARGET="
    // in the somenv.ini file.
    //
    // By default the only entry in the services file will be:
    // NameService=<the stringified IOR of the root naming context>
    //
    // This is how the client gets access to the name service
    // of the SOM server...
    //--------------------------------------------------------
    orb = OrbStub.ORBInit (this, "sunw.joe.iiop");

    //--------------------------------------------------------
    // GUI setup
    //--------------------------------------------------------
    resize (400, 420);
    dim          = size ();
    intWidth  = dim.width / 8;
    intHeight = dim.height / 8;
    intWidth  = intHeight = Math.min (intWidth, intHeight);
    setLayout (new FlowLayout (FlowLayout.LEFT));
    add (new Label ("Welcome to Checkers!"));
    add (new Label ("Choose which player you will be:"));
    add (new Label (" - red names the checkerboard server object and moves first;"));
    add (new Label (" - black must enter the name the red opponent chose."));
    add(new Checkbox("Red Player", options, true));
    add(new Checkbox("Black Player", options, false));
    add (new Label("Enter the name of the checkerboard server object:"));
    add (objText);
    add (new Label ("(After entering a name please be patient; setup may take"));
    add (new Label ("some time when SOMDD has to start the server processes.)"));

    //--------------------------------------------------------
    // Bring in the images for the kings...
    //--------------------------------------------------------
    try
    {
	  blackKingURL = new URL(getCodeBase(),"kingsimages/moon.gif");
	  redKingURL   = new URL(getCodeBase(),"kingsimages/sun.gif");
    }
    catch (MalformedURLException e)
    {
	  System.out.println("Bad URL:" + e);
    }

    //--------------------------------------------------------
    // set up the images based on the URLs
    //--------------------------------------------------------
    blackKing =	getImage(blackKingURL);
    redKing =	getImage(redKingURL);
  } // init

  public boolean action (Event evt, Object arg)
  {
    //--------------------------------------------------------
    // Deal with the actions from the User Interface of the Applet.
    //--------------------------------------------------------
    if (evt.target instanceof Checkbox)
    {
      String selection = null;
      selection = ((Checkbox)evt.target).getLabel();
      if (selection.equals("Red Player"))
        create = true;
      else
        create = false;
      return true;
    }
    if (evt.target instanceof TextField)
    {
      nameOfObj = (String)arg;
      objText.hide();
      buildBoard();
      return true;
    }
    else
      return false; // We don't handle it here
  }

  public void createBoard () throws Exception
  {
    //--------------------------------------------------------
    // Obtain a reference root naming context.
    //
    // The rootNC is used for:
    // -----------------------
    // 1) binding the "Checkers" object to the name space for
    //    the first player using the name (nameOfObj) for the
    //    context name.
    // 2) resolving to the context name (nameOfObj) for the
    //    second player to get access to the "Checkers" object.
    //--------------------------------------------------------
    obj = orb.resolveInitialReferences ("NameService");
    rootNC = NamingContextStub.narrow (obj);

    //--------------------------------------------------------
    // Set up the key by new'ing up a NameComponent[] array
    // with one element (any other elements are ignored).
    // The first parameter is for the "id" field which contains
    // the fully scoped interface name of the object to be created.
    // This name should match what was put into the Implementation
    // Repository (regimpl) on the SOM server when you registered
    // the "server" for this object. The second parameter fills
    // in the "kind" field. The only "kind" supported is
    // "object interface" so this field is basically ignored.
    //--------------------------------------------------------
    NameComponent[] key = new NameComponent [1];
    key[0] = new NameComponent ("COM::ibm::samples::Checkers",
                                "object interface");

    //--------------------------------------------------------
    // Call create_object to create the Checkers object.
    //--------------------------------------------------------
    obj = GenericFactoryStub.create_object(key);
    board = CheckersStub.narrow (obj);

    //--------------------------------------------------------
    // Bind the checkerboard into the naming space using the
    // name specified by the user (nameOfObj).
    //--------------------------------------------------------
    NameComponent[] name = new NameComponent [1];
    name[0] = new NameComponent (nameOfObj, "");
    rootNC.bind(name, board);

    //--------------------------------------------------------
    // Set up so the creator is the red player
    //--------------------------------------------------------
    board.registerPlayer(Square.Red);

    currentPlayer = Square.Red;
    playerTurn = Status.RedTurn;
    turn = true;
    message = "It's your turn";
  } // createBoard

  public void findBoard () throws Exception
  {
    //--------------------------------------------------------
    // Obtain a reference root naming context.
    //
    // The rootNC is used for:
    // -----------------------
    // 1) binding the "Checkers" object to the name space for
    //    the first player using the name (nameOfObj) for the
    //    context name.
    // 2) resolving to the context name (nameOfObj) for the
    //    second player to get access to the "Checkers" object.
    //--------------------------------------------------------
    obj = orb.resolveInitialReferences ("NameService");
    rootNC = NamingContextStub.narrow (obj);

    //--------------------------------------------------------
    // Resolve to the Checkers object.
    // board = (CheckersStub) rootNC.resolve(new Name(nameOfObj));
    //--------------------------------------------------------
    NameComponent[] name = new NameComponent[1];
    name[0] = new NameComponent (nameOfObj, "");
    obj = rootNC.resolve (name);
    board = CheckersStub.narrow (obj);

    //--------------------------------------------------------
    // register the resolving player as the black player
    //--------------------------------------------------------
    board.registerPlayer(Square.Black);

    currentPlayer = Square.Black;
    playerTurn = Status.BlackTurn;
    turn = false;

  } // findBoard

  //----------------------------------------------------------
  // The buildBoard method will build the checkerboard by
  // creating a new Checkers object or resolving to an
  // existing board, depending on the user's request.
  //----------------------------------------------------------
  public void buildBoard()
  {
    try
    {
      if (create)
        createBoard ();
      else // resolve to an existing board
        findBoard ();

      //------------------------------------------------------
      // Thread setup
      //------------------------------------------------------
      thread = new Thread (this);
      stopped = false;
      thread.start ();

      //------------------------------------------------------
      // set first to false, we already displayed the options.
      //------------------------------------------------------
      first = false;

      //------------------------------------------------------
      // Clear the radio buttons and text field off of the
      // applet since we are done with them.
      //------------------------------------------------------
      removeAll ();
      repaint ();
    }
    //--------------------------------------------------------
    // Catch any exceptions that were raised during create/find.
    //--------------------------------------------------------
    catch (Exception e)
    {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
    }

  } //end of buildBoard

  //----------------------------------------------------------
  // The rest of the methods are for applet specific tasks...
  //----------------------------------------------------------
  public boolean mouseDown (Event event, int x, int y)
  {
      if (turn)
      {
        x = x / intWidth;
        y = y / intHeight;
        if (currentPlayer == Square.Black)
        {
          x = 7 - x;
          y = 7 - y;
        }
        moveFrom = new Point (x, y);
      }
    return true;
  } // mouseDown

  public boolean mouseUp (Event event, int x, int y)
  {
    if (turn)
    {
      x = x / intWidth;
      y = y / intHeight;
      if (currentPlayer == Square.Black)
      {
        x = 7 - x;
        y = 7 - y;
      }
      try
      {
        board.move (currentPlayer, (short)moveFrom.x, (short)moveFrom.y, (short)x, (short)y);
        if (board.getgameStatus () == playerTurn)
          // It is still the current player's turn
          message = "You can still jump.";
        else
        {
          turn = false;
          synchronized (this)
          {
            notify ();
          }
          message = null;
        }
      }
      catch (InvalidMove e)
      {
        message = e.details;
      }
      catch (Exception e)
      {
        message = e.getMessage ();
      }
      moveFrom = null;
      repaint ();
    }
    return true;
  } // mouseUp

  public boolean keyDown (Event event, int key)
  {
    if (!first)
    {
      if ((char)key == 'r')
      {
        try
        {
          board.reset ();
        }
        catch (SystemException e)
        {
          System.out.println ("SystemException on reset:  " + e);
        }
        repaint ();
        synchronized (this)
        {
          notify ();
        }
      }
      // Thread setup
      if (!thread.isAlive ())
      {
        thread = new Thread (this);
        stopped = false;
        thread.start ();
      }
      return true;
    }//end of if(!first)
    else
    {
    return super.keyDown(event, key);
    }
  } // keyDown

  public void stop ()
  {
    stopped = true;
  } // stop

  private void reverseBoard (int[][] squares)
  {
    for (int y = 0; y < 4; ++y)
      for (int x = 0; x < 8; ++x)
      {
        int tmp = squares[x][y];
        squares[x][y] = squares[7 - x][7 - y];
        squares[7 - x][7 - y] = tmp;
      }
  } // reverseBoard

  public void paint (Graphics g)
  {
    if (!first)
    {
      g.setColor (Color.gray);
      for (int x = 0; x < dim.width; x += intWidth)
        for (int y = 0; y < dim.height; y += intHeight)
          if ((((y / intHeight) + (x / intWidth)) % 2 == 0) &&
              ((dim.width - intWidth) >= x) &&
              ((dim.height - intHeight) >= y))
            g.fill3DRect (x + 1, y + 1, intWidth - 2,
                          intHeight - 2, true);

      int[][] bd = null;

      try
      {
        bd = board.getboard ();
      }
      catch (Exception e)
      {
        System.out.println ("board._get_board exception:  " + e);
      }

      int [][] squares = bd;
      if (currentPlayer == Square.Black)
        reverseBoard (squares);

      for (int x = 0; x < 8; ++x)
      {
        for (int y = 0; y < 8; ++y)
        {
          if (squares[x][y] == Square.Black  )
          {
            g.setColor (Color.black);
            g.fillOval (intWidth * x + intWidth / 10,
                        intHeight * y + intHeight / 10,
                        intWidth * 8 / 10, intHeight * 8 / 10);
	      }
          else
          {
            if (squares[x][y] == Square.BlackKing)
	        {
              //----------------------------------------------
	          // Draw a king gif
              //----------------------------------------------
	          g.drawImage(blackKing,
	                      intWidth * x + intWidth / 10,
	                      intHeight * y + intHeight / 10,
	                      intWidth * 8 / 10, intHeight * 8 / 10,
	                      this);

 	        }
            else
            {
              if (squares[x][y] == Square.Red )
              {
                g.setColor (Color.red);
                g.fillOval (intWidth * x + intWidth / 10,
                            intHeight * y + intHeight / 10,
                            intWidth * 8 / 10, intHeight * 8 / 10);
	          }
              else
              {
                if (squares[x][y] == Square.RedKing)
	            {
                  //-------------------------------------------
	              // Draw a king gif
                  //-------------------------------------------
	              g.drawImage(redKing,
	                          intWidth * x + intWidth / 10,
	                          intHeight * y + intHeight / 10,
	                          intWidth * 8 / 10, intHeight * 8 / 10,
	                          this);
	            }
	          }
	        }
	      }
	    } // end for loop for y
	  } // end for loop for x

      //------------------------------------------------------
      // if a message exists, draw it on the checkerboard.
      //------------------------------------------------------
      if (message != null)
        g.drawString (message, 0, 420);
    }
    super.paint (g);

  } // paint

////////////////////
// Method for Runnable
////////////////////

  public void run ()
  {
    int status = Status.Closed;
    while (!stopped)
    {
      try
      {
        status = board.getgameStatus ();
      }
      catch (Exception e)
      {
        System.out.println ("board._get_gameStatus exception:  " + e);
      }
      if (status == Status.Closed)
        stopped = true;
      else if (status == Status.RedWon || status == Status.BlackWon)
        stopped = true;
      else if (status == playerTurn)
      {
        message = "It's your turn";
        turn = true;
        repaint ();
        synchronized (this)
        {
          try
          {
            wait ();
          }
          catch (InterruptedException e)
          {
          }
        }
        message = "";
      }
      else
        try
        {
          Thread.sleep (500);
        }
        catch (InterruptedException e) {}
    }

    //--------------------------------------------------------
    //disply won/lost status to the user.
    //--------------------------------------------------------
    if (status == Status.RedWon)
      if (currentPlayer == Square.Red)
        message = "GAME OVER - You won!";
      else
        message = "GAME OVER - Tsk Tsk Tsk.";
    else if (status == Status.BlackWon)
      if (currentPlayer == Square.Black)
        message = "GAME OVER - You won!";
      else
        message = "GAME OVER - Tsk Tsk Tsk.";
    repaint ();

    //--------------------------------------------------------
    // Remove the checkerboard from the naming service (unbind)
    // since the game is over.
    //--------------------------------------------------------
    try
    {
      NameComponent[] name = new NameComponent [1];
      name[0] = new NameComponent (nameOfObj, "");
      rootNC.unbind (name);
    }
    catch (Exception e)
    {
      System.out.println ("An exception occurred during the unbind:  " + e);
    }
  }

} // class CheckersApp
