/* Sample Plugin for the SFX Installer */
/*==============================================================
Your plugin files must be written just like a rexx cmd file which
is, in all actuality, what they are. :-) There will be some
VisPro/Rexx commands that you'll be able to use to manipulate the
installer also. We will document some of them in the near future.

There is one variable that is important for you to use in these
commands in order to communicate with the installer. The installers
window handle will always be contained in the "window" variable.

Tiny example:

/* Put up a message box */
response=VpMessageBox(window,'Your TitleBarText','Your message here')

Look over the supplied example of a simple messagebox to see how
you can make use of it.
===============================================================*/
                /* Get boot_drive, letter and colon then FreeSpace    */
parse upper value VALUE( 'PATH',, 'OS2ENVIRONMENT' ) with ':\OS2\SYSTEM' -1 boot_drive +2
parse value SysDriveInfo(boot_drive) with . FreeSpace . .

                /* Set the titlebar text variable                     */
Title="SFX Installer"

                /* Set the message text variables (msg1 msg2)         */
                /* '0d0a'x is hex for a carraige return/line feed     */
msg1='This is a sample of a plugin at work'||'0d0a0d0a'x
msg2='Your boot drive is '||boot_drive||' and has '||FreeSpace||' bytes free'

                /* Open the messagebox with the msg's                 */
                /* concatenated together with "||"                    */
response=VpMessageBox(window,Title,msg1||msg2)
