 
/***-START-OF-SPECIFICATIONS-****************************************
***                                                               ***
***        CP/386 Experimental Operating System                   ***
***                                                               ***
***        Task Level Debugger                                    ***
***                                                               ***
***        COPYRIGHT   I B M   CORPORATION  1983, 1984, 1985      ***
***                                   1986, 1987, 1988, 1989      ***
***                                                               ***
***        LICENSED MATERIAL  -  PROGRAM PROPERTY OF I B M        ***
***                                                               ***
***        REFER TO COPYRIGHT INSTRUCTIONS: FORM G120-2083        ***
***                                                               ***
*********************************************************************
*                                                                   *
*                                                                   *
*   MODULE-NAME = MASMMNEM                                          *
*                                                                   *
*   DESCRIPTIVE-NAME = ASM/86 mnemonics for the dis-assembler.      *
*                      this is included into TLDUNPIK.C.            *
*                                                                   *
*                      Note that the mnemonic tables have the       *
*                      format of a data table for the routine       *
*                      "lookup", so it can be used for the          *
*                      assembler.                                   *
*                                                                   *
*                                                                   *
*   STATUS = Version 3 Release 2                                    *
*                                                                   *
*                                                                   *
*   CHANGE-ACTIVITY = translated from PLS/286 March 1989 by         *
*                     D. C. Toll, IBM Research, Yorktown Heights    *
*                                                                   *
*   05/02/89,       = extra orders for the 486 added.               *
*   D. C. Toll                                                      *
*                                                                   *
*                                                                   *
****-END-OF-SPECIFICATIONS-*****************************************/
 
 
#define _ASM86_   1                 /*  note that this file is present  */
 
 
/*************************************************************************
*                                                                        *
*   The following table holds the ASM/86 mnemonics:  these are accessed  *
*   by mnemonic number, not by instruction value.                        *
*                                                                        *
*   Note that these vectors all have names starting with "a86".          *
*                                                                        *
*************************************************************************/
 
 
 
CHAR a86mnem[] = {
       1,1,'A',
       3,3,'A','A','A',                 /*   2  */
       3,3,'A','A','D',
       3,3,'A','A','M',                 /*   4  */
       3,3,'A','A','S',
       2,2,'A','C',                     /*   6  */
       3,3,'A','C','I',
       4,4,'A','C','I','B',             /*   8  */
       4,4,'A','C','I','D',
       4,4,'A','C','I','W',             /*  10  */
       2,2,'A','I',
       3,3,'A','I','B',                 /*  12  */
       3,3,'A','I','D',
       3,3,'A','I','W',                 /*  14  */
       4,4,'A','R','P','L',
       5,5,'B','C','K','W','D',         /*  16  */
       5,5,'B','O','U','N','D',
       3,3,'B','S','F',                 /*  18  */
       3,3,'B','S','R',
       2,2,'B','T',                     /*  20  */
       3,3,'B','T','C',
       3,3,'B','T','R',                 /*  22  */
       3,3,'B','T','S',
       1,1,'C',                         /*  24  */
       4,4,'C','A','L','L',
       5,5,'C','A','L','L','F',         /*  26  */
       6,6,'C','A','L','L','F','I',
       7,7,'C','A','L','L','F','I','D', /*  28  */
       7,7,'C','A','L','L','F','I','W',
       5,5,'C','A','L','L','I',         /*  30  */
       2,2,'C','B',
       2,2,'C','D',                     /*  32  */
       2,2,'C','I',
       3,3,'C','I','B',                 /*  34  */
       3,3,'C','I','D',
       3,3,'C','I','W',                 /*  36  */
       5,5,'C','L','R','C','F',
       3,3,'C','P','L',                 /*  38  */
       4,4,'C','P','L','B',
       4,4,'C','P','L','C',             /*  40  */
       4,4,'C','P','L','D',
       4,4,'C','P','L','W',             /*  42  */
       4,4,'C','L','T','S',
       4,4,'C','V','B','W',             /*  44  */
       4,4,'C','V','D','Q',
       4,4,'C','V','W','D',             /*  46  */
       2,2,'C','W',
       4,4,'C','W','D','E',             /*  48  */
       3,3,'D','A','A',
       3,3,'D','A','S',                 /*  50  */
       3,3,'D','E','C',
       4,4,'D','E','C','B',             /*  52  */
       4,4,'D','E','C','D',
       4,4,'D','E','C','W',             /*  54  */
       2,2,'D','V',
       3,3,'D','V','B',                 /*  56  */
       3,3,'D','V','D',
       3,3,'D','V','S',                 /*  58  */
       4,4,'D','V','S','B',
       4,4,'D','V','S','D',             /*  60  */
       4,4,'D','V','S','W',
       3,3,'D','V','W',                 /*  62  */
       3,3,'E','N','B',
       5,5,'E','N','T','E','R',         /*  64  */
       6,6,'E','S','C','A','P','E',
       5,5,'F','O','R','W','D',         /*  66  */
       4,4,'H','A','L','T',
       3,3,'I','N','B',                 /*  68  */
       3,3,'I','N','C',
       4,4,'I','N','C','B',             /*  70  */
       4,4,'I','N','C','D',
       4,4,'I','N','C','W',             /*  72  */
       3,3,'I','N','D',
       3,3,'I','N','H',                 /*  74  */
       4,4,'I','N','S','B',
       4,4,'I','N','S','D',             /*  76  */
       4,4,'I','N','S','W',
       3,3,'I','N','T',                 /*  78  */
       4,4,'I','N','T','3',
       4,4,'I','N','T','O',             /*  80  */
       6,6,'I','N','T','R','E','T',
       7,7,'I','N','T','R','E','T','D', /*  82  */
       3,3,'I','N','W',
       1,1,'J',                         /*  84  */
       4,4,'J','C','X','Z',
       5,5,'J','E','C','X','Z',         /*  86  */
       2,2,'J','F',
       3,3,'J','F','I',                 /*  88  */
       4,4,'J','F','I','D',
       4,4,'J','F','I','W',             /*  90  */
       2,2,'J','H',
       2,2,'J','I',                     /*  92  */
       2,2,'J','L',
       2,2,'J','M',                     /*  94  */
       3,3,'J','N','H',
       3,3,'J','N','L',                 /*  96  */
       3,3,'J','N','M',
       3,3,'J','N','O',                 /*  98  */
       3,3,'J','N','P',
       3,3,'J','N','S',                 /* 100  */
       3,3,'J','N','Z',
       2,2,'J','O',                     /* 102  */
       2,2,'J','P',
       3,3,'J','P','E',                 /* 104  */
       3,3,'J','P','O',
       2,2,'J','S',                     /* 106  */
       2,2,'J','Z',
       1,1,'L',                         /* 108  */
       2,2,'L','A',
       4,4,'L','A','H','F',             /* 110  */
       3,3,'L','A','R',
       2,2,'L','B',                     /* 112  */
       2,2,'L','D',
       3,3,'L','D','S',                 /* 114  */
       5,5,'L','E','A','V','E',
       3,3,'L','E','S',                 /* 116  */
       3,3,'L','F','S',
       4,4,'L','G','D','T',             /* 118  */
       3,3,'L','G','S',
       2,2,'L','I',                     /* 120  */
       4,4,'L','I','D','T',
       4,4,'L','L','D','T',             /* 122  */
       4,4,'L','M','S','W',
       7,7,'L','O','C','K','B','U','S', /* 124  */
       4,4,'L','O','O','P',
       6,6,'L','O','O','P','N','Z',     /* 126  */
       5,5,'L','O','O','P','Z',
       3,3,'L','S','L',                 /* 128  */
       3,3,'L','S','S',
       3,3,'L','T','R',                 /* 130  */
       2,2,'L','W',
       1,1,'M',                         /* 132  */
       2,2,'M','B',
       2,2,'M','D',                     /* 134  */
       5,5,'M','O','V','S','X',
       6,6,'M','O','V','S','X','B',     /* 136  */
       6,6,'M','O','V','S','X','W',
       5,5,'M','O','V','Z','X',         /* 138  */
       6,6,'M','O','V','Z','X','B',
       6,6,'M','O','V','Z','X','W',     /* 140  */
       2,2,'M','S',
       3,3,'M','S','B',                 /* 142  */
       3,3,'M','S','D',
       3,3,'M','S','I',                 /* 144  */
       4,4,'M','S','I','W',
       3,3,'M','S','R',                 /* 146  */
       3,3,'M','S','W',
       3,3,'M','V','B',                 /* 148  */
       3,3,'M','V','D',
       4,4,'M','V','I','B',             /* 150  */
       4,4,'M','V','I','D',
       4,4,'M','V','I','W',             /* 152  */
       3,3,'M','V','W',
       2,2,'M','W',                     /* 154  */
       1,1,'N',
       2,2,'N','I',                     /* 156  */
       3,3,'N','I','B',
       3,3,'N','I','D',                 /* 158  */
       3,3,'N','I','W',
       3,3,'N','O','P',                 /* 160  */
       3,3,'N','O','T',
       4,4,'N','O','T','B',             /* 162  */
       4,4,'N','O','T','D',
       4,4,'N','O','T','W',             /* 164  */
       1,1,'O',
       2,2,'O','I',                     /* 166  */
       3,3,'O','I','B',
       3,3,'O','I','D',                 /* 168  */
       3,3,'O','I','W',
       4,4,'O','U','T','B',             /* 170  */
       4,4,'O','U','T','D',
       5,5,'O','U','T','S','B',         /* 172  */
       5,5,'O','U','T','S','D',
       5,5,'O','U','T','S','W',         /* 174  */
       4,4,'O','U','T','W',
       3,3,'P','O','P',                 /* 176  */
       4,4,'P','O','P','A',
       5,5,'P','O','P','A','D',         /* 178  */
       4,4,'P','O','P','D',
       4,4,'P','O','P','F',             /* 180  */
       5,5,'P','O','P','F','D',
       4,4,'P','O','P','W',             /* 182  */
       4,4,'P','U','S','H',
       5,5,'P','U','S','H','A',         /* 184  */
       6,6,'P','U','S','H','A','D',
       5,5,'P','U','S','H','D',         /* 186  */
       5,5,'P','U','S','H','F',
       6,6,'P','U','S','H','F','D',     /* 188  */
       5,5,'P','U','S','H','I',
       6,6,'P','U','S','H','I','D',     /* 190  */
       6,6,'P','U','S','H','I','W',
       5,5,'P','U','S','H','W',         /* 192  */
       3,3,'R','E','P',
       5,5,'R','E','P','N','Z',         /* 194  */
       4,4,'R','E','P','Z',
       3,3,'R','E','T',                 /* 196  */
       4,4,'R','E','T','F',
       5,5,'R','E','T','F','D',         /* 198  */
       5,5,'R','E','T','F','W',
       4,4,'R','O','C','L',             /* 200  */
       5,5,'R','O','C','L','B',
       5,5,'R','O','C','L','D',         /* 202  */
       5,5,'R','O','C','L','W',
       4,4,'R','O','C','R',             /* 204  */
       5,5,'R','O','C','R','B',
       5,5,'R','O','C','R','D',         /* 206  */
       5,5,'R','O','C','R','W',
       3,3,'R','O','L',                 /* 208  */
       4,4,'R','O','L','B',
       4,4,'R','O','L','D',             /* 210  */
       4,4,'R','O','L','W',
       3,3,'R','O','R',                 /* 212  */
       4,4,'R','O','R','B',
       4,4,'R','O','R','D',             /* 214  */
       4,4,'R','O','R','W',
       1,1,'S',                         /* 216  */
       2,2,'S','B',
       3,3,'S','B','I',                 /* 218  */
       4,4,'S','B','I','B',
       4,4,'S','B','I','D',             /* 220  */
       4,4,'S','B','I','W',
       3,3,'S','C','B',                 /* 222  */
       3,3,'S','C','D',
       3,3,'S','C','W',                 /* 224  */
       5,5,'S','E','G','O','V',
       5,5,'S','E','T','C','F',         /* 226  */
       4,4,'S','E','T','H',
       4,4,'S','E','T','L',             /* 228  */
       4,4,'S','E','T','M',
       5,5,'S','E','T','N','C',         /* 230  */
       5,5,'S','E','T','N','H',
       5,5,'S','E','T','N','M',         /* 232  */
       5,5,'S','E','T','N','O',
       5,5,'S','E','T','N','P',         /* 234  */
       5,5,'S','E','T','N','S',
       5,5,'S','E','T','N','Z',         /* 236  */
       4,4,'S','E','T','O',
       4,4,'S','E','T','P',             /* 238  */
       5,5,'S','E','T','P','E',
       5,5,'S','E','T','P','O',         /* 240  */
       4,4,'S','E','T','S',
       4,4,'S','E','T','Z',             /* 242  */
       4,4,'S','G','D','T',
       4,4,'S','H','L','D',             /* 244  */
       4,4,'S','H','R','D',
       2,2,'S','I',                     /* 246  */
       3,3,'S','I','B',
       3,3,'S','I','D',                 /* 248  */
       4,4,'S','I','D','T',
       3,3,'S','I','W',                 /* 250  */
       3,3,'S','L','A',
       4,4,'S','L','A','B',             /* 252  */
       4,4,'S','L','A','D',
       4,4,'S','L','A','W',             /* 254  */
       4,4,'S','L','D','T',
       3,3,'S','L','L',                 /* 256  */
       4,4,'S','L','L','B',
       4,4,'S','L','L','D',             /* 258  */
       4,4,'S','L','L','W',
       4,4,'S','M','S','W',             /* 260  */
       3,3,'S','R','A',
       4,4,'S','R','A','B',             /* 262  */
       4,4,'S','R','A','D',
       4,4,'S','R','A','W',             /* 264  */
       3,3,'S','R','L',
       4,4,'S','R','L','B',             /* 266  */
       4,4,'S','R','L','D',
       4,4,'S','R','L','W',             /* 268  */
       2,2,'S','T',
       5,5,'S','T','A','H','F',         /* 270  */
       3,3,'S','T','B',
       3,3,'S','T','D',                 /* 272  */
       3,3,'S','T','R',
       3,3,'S','T','W',                 /* 274  */
       4,4,'S','Y','N','C',
       1,1,'T',                         /* 276  */
       2,2,'T','I',
       3,3,'T','I','B',                 /* 278  */
       3,3,'T','I','D',
       3,3,'T','I','W',                 /* 280  */
       4,4,'V','E','R','R',
       4,4,'V','E','R','W',             /* 282  */
       1,1,'X',
       4,4,'X','C','H','G',             /* 284  */
       2,2,'X','I',
       3,3,'X','I','B',                 /* 286  */
       3,3,'X','I','D',
       3,3,'X','I','W',                 /* 288  */
       4,4,'X','L','A','T',
       4,4,'?','?','?','?',             /* 290  */
       5,5,'B','S','W','A','P',
       7,7,'C','M','P','X','C','H','G', /* 292  */
       4,4,'I','N','V','D',
       6,6,'I','N','V','L','P','G',     /* 294  */
       6,6,'W','B','I','N','V','D',
       4,4,'X','A','D','D',             /* 296  */
       0                     };         /*  the terminator  */
 
 
 
   /*  the following table holds the mnemonics for the 80387
       numerics processor.                                    */
 
CHAR a86m387[] = {
     4,4,'$','A','B','S',
     4,4,'$','A','D','D',               /*   2  */
     5,5,'$','A','D','D','L',
     5,5,'$','A','D','D','P',           /*   4  */
     5,5,'$','A','D','D','S',
     4,4,'$','B','L','D',               /*   6  */
     5,5,'$','B','S','T','P',
     4,4,'$','C','H','S',               /*   8  */
     5,5,'$','C','L','E','X',
     4,4,'$','C','O','M',               /*  10  */
     5,5,'$','C','O','M','L',
     5,5,'$','C','O','M','P',           /*  12  */
     6,6,'$','C','O','M','P','L',
     6,6,'$','C','O','M','P','P',       /*  14  */
     6,6,'$','C','O','M','P','S',
     5,5,'$','C','O','M','S',           /*  16  */
     7,7,'$','D','E','C','S','T','P',
     5,5,'$','D','I','S','I',           /*  18  */
     4,4,'$','D','I','V',
     5,5,'$','D','I','V','L',           /*  20  */
     5,5,'$','D','I','V','P',
     5,5,'$','D','I','V','R',           /*  22  */
     6,6,'$','D','I','V','R','L',
     6,6,'$','D','I','V','R','P',       /*  24  */
     6,6,'$','D','I','V','R','S',
     5,5,'$','D','I','V','S',           /*  26  */
     4,4,'$','E','N','I',
     5,5,'$','F','R','E','E',           /*  28  */
     6,6,'$','I','A','D','D','S',
     6,6,'$','I','A','D','D','W',       /*  30  */
     6,6,'$','I','C','O','M','S',
     6,6,'$','I','C','O','M','W',       /*  32  */
     7,7,'$','I','C','O','M','P','S',
     7,7,'$','I','C','O','M','P','W',   /*  34  */
     6,6,'$','I','D','I','V','S',
     6,6,'$','I','D','I','V','W',       /*  36  */
     7,7,'$','I','D','I','V','R','S',
     7,7,'$','I','D','I','V','R','W',   /*  38  */
     5,5,'$','I','L','D','L',
     5,5,'$','I','L','D','S',           /*  40  */
     5,5,'$','I','L','D','W',
     6,6,'$','I','M','U','L','S',       /*  42  */
     6,6,'$','I','M','U','L','W',
     7,7,'$','I','N','C','S','T','P',   /*  44  */
     5,5,'$','I','N','I','T',
     6,6,'$','I','S','T','P','L',       /*  46  */
     6,6,'$','I','S','T','P','S',
     6,6,'$','I','S','T','P','W',       /*  48  */
     5,5,'$','I','S','T','S',
     5,5,'$','I','S','T','W',           /*  50  */
     7,7,'$','I','S','U','B','R','S',
     7,7,'$','I','S','U','B','R','W',   /*  52  */
     6,6,'$','I','S','U','B','S',
     6,6,'$','I','S','U','B','W',       /*  54  */
     3,3,'$','L','D',
     5,5,'$','L','D','C','W',           /*  56  */
     6,6,'$','L','D','E','N','V',
     4,4,'$','L','D','L',               /*  58  */
     6,6,'$','L','D','L','G','2',
     6,6,'$','L','D','L','N','2',       /*  60  */
     6,6,'$','L','D','L','2','E',
     6,6,'$','L','D','L','2','T',       /*  62  */
     5,5,'$','L','D','P','I',
     4,4,'$','L','D','S',               /*  64  */
     4,4,'$','L','D','T',
     4,4,'$','L','D','Z',               /*  66  */
     4,4,'$','L','D','1',
     4,4,'$','M','U','L',               /*  68  */
     5,5,'$','M','U','L','L',
     5,5,'$','M','U','L','P',           /*  70  */
     5,5,'$','M','U','L','S',
     4,4,'$','N','O','P',               /*  72  */
     6,6,'$','P','A','T','A','N',
     5,5,'$','P','R','E','M',           /*  74  */
     5,5,'$','P','T','A','N',
     7,7,'$','R','N','D','I','N','T',   /*  76  */
     6,6,'$','R','S','T','O','R',
     5,5,'$','S','A','V','E',           /*  78  */
     6,6,'$','S','C','A','L','E',
     6,6,'$','S','E','T','P','M',       /*  80  */
     5,5,'$','S','Q','R','T',
     3,3,'$','S','T',                   /*  82  */
     5,5,'$','S','T','C','W',
     6,6,'$','S','T','E','N','V',       /*  84  */
     4,4,'$','S','T','L',
     4,4,'$','S','T','P',               /*  86  */
     5,5,'$','S','T','P','L',
     5,5,'$','S','T','P','S',           /*  88  */
     5,5,'$','S','T','P','T',
     4,4,'$','S','T','S',               /*  90  */
     5,5,'$','S','T','S','W',
     4,4,'$','S','U','B',               /*  92  */
     5,5,'$','S','U','B','L',
     5,5,'$','S','U','B','P',           /*  94  */
     5,5,'$','S','U','B','R',
     6,6,'$','S','U','B','R','L',       /*  96  */
     6,6,'$','S','U','B','R','P',
     6,6,'$','S','U','B','R','S',       /*  98  */
     5,5,'$','S','U','B','S',
     4,4,'$','T','S','T',               /* 100  */
     4,4,'$','X','A','M',
     4,4,'$','X','C','H',               /* 102  */
     7,7,'$','X','T','R','A','C','T',
     5,5,'$','Y','L','2','X',           /* 104  */
     7,7,'$','Y','L','2','X','P','1',
     5,5,'$','2','X','M','1',           /* 106  */
     4,4,'?','?','?','?',
     6,6,'$','F','R','E','E','P',       /* 108  */
     4,4,'$','C','O','S',
     6,6,'$','P','R','E','M','1',       /* 110  */
     4,4,'$','S','I','N',
     7,7,'$','S','I','N','C','O','S',   /* 112  */
     5,5,'$','U','C','O','M',
     6,6,'$','U','C','O','M','P',       /* 114  */
     7,7,'$','U','C','O','M','P','P',
     0                     };           /*  the terminator  */
 
 
 
   /*  mnemonic numbers for each instruction - a value of "odd" in
       this table implies a special case of some sort, and the
       mnemonic is not to be printed automatically without looking
       further
                                                                     */
USHORT a86mnem_16[256] = {
         1, 1, 1, 1, 11, 11, 183, 176,            /*   0  */
         165, 165, 165, 165, 166, 166, 183, odd,  /*   8  */
         6, 6, 6, 6, 7, 7, 183, 176,              /*  10  */
         217, 217, 217, 217, 218, 218, 183, 176,  /*  18  */
         155, 155, 155, 155, 156, 156, odd, 49,   /*  20  */
         216, 216, 216, 216, 246, 246, odd, 50,   /*  28  */
         283, 283, 283, 283, 285, 285, odd, 2,    /*  30  */
         24, 24, 24, 24, 33, 33, odd, 5,          /*  38  */
         69, 69, 69, 69, 69, 69, 69, 69,          /*  40  */
         51, 51, 51, 51, 51, 51, 51, 51,          /*  48  */
         183, 183, 183, 183, 183, 183, 183, 183,  /*  50  */
         176, 176, 176, 176, 176, 176, 176, 176,  /*  58  */
         184, 177, 17, 15, odd, odd, odd, odd,    /*  60  */
         191, 144, 191, 144, 75, 77, 172, 174,    /*  68  */
         102, 98, 93, 96, 107, 101, 95, 91,       /*  70  */
         106, 100, 104, 105, 94, 97, 99, 103,     /*  78  */
         odd, odd, odd, odd, 276, 276, 284, 284,  /*  80  */
         269, 269, 108, 108, odd, 109, odd, odd,  /*  88  */
         160, 284, 284, 284, 284, 284, 284, 284,  /*  90  */
         44, 46, 26, 275, 187, 180, 270, 110,     /*  98  */
         108, 108, 269, 269, 148, 153, 31, 47,    /*  A0  */
         277, 277, 271, 274, 112, 131, 222, 224,  /*  A8  */
         120, 120, 120, 120, 120, 120, 120, 120,  /*  B0  */
         120, 120, 120, 120, 120, 120, 120, 120,  /*  B8  */
         odd, odd, 196, 196, 116, 114, odd, odd,  /*  C0  */
         64, 115, 199, 199, 79, 78, 80, 81,       /*  C8  */
         odd, odd, odd, odd, odd, odd, odd, 289,  /*  D0  */
         odd, odd, odd, odd, odd, odd, odd, odd,  /*  D8  */
         126, 127, 125, 85, 68, 83, 170, 175,     /*  E0  */
         25, 84, 87, 84, 68, 83, 170, 175,        /*  E8  */
         124, odd, odd, odd, 67, 40, odd, odd,    /*  F0  */
         37, 226, 74, 63, 66, 16, odd, odd     }; /*  F8  */
 
USHORT a86mnem_32[256] = {
         1, 1, 1, 1, 11, 11, 183, 176,            /*   0  */
         165, 165, 165, 165, 166, 166, 183, odd,  /*   8  */
         6, 6, 6, 6, 7, 7, 183, 176,              /*  10  */
         217, 217, 217, 217, 218, 218, 183, 176,  /*  18  */
         155, 155, 155, 155, 156, 156, odd, 49,   /*  20  */
         216, 216, 216, 216, 246, 246, odd, 50,   /*  28  */
         283, 283, 283, 283, 285, 285, odd, 2,    /*  30  */
         24, 24, 24, 24, 33, 33, odd, 5,          /*  38  */
         69, 69, 69, 69, 69, 69, 69, 69,          /*  40  */
         51, 51, 51, 51, 51, 51, 51, 51,          /*  48  */
         183, 183, 183, 183, 183, 183, 183, 183,  /*  50  */
         176, 176, 176, 176, 176, 176, 176, 176,  /*  58  */
         185, 178, 17, 15, odd, odd, odd, odd,    /*  60  */
         190, 144, 190, 144, 75, 76, 172, 173,    /*  68  */
         102, 98, 93, 96, 107, 101, 95, 91,       /*  70  */
         106, 100, 104, 105, 94, 97, 99, 103,     /*  78  */
         odd, odd, odd, odd, 276, 276, 284, 284,  /*  80  */
         269, 269, 108, 108, odd, 109, odd, odd,  /*  88  */
         160, 284, 284, 284, 284, 284, 284, 284,  /*  90  */
         48, 45, 26, 275, 188, 181, 270, 110,     /*  98  */
         108, 108, 269, 269, 148, 149, 31, 32,    /*  A0  */
         277, 277, 271, 272, 112, 113, 222, 223,  /*  A8  */
         120, 120, 120, 120, 120, 120, 120, 120,  /*  B0  */
         120, 120, 120, 120, 120, 120, 120, 120,  /*  B8  */
         odd, odd, 196, 196, 116, 114, odd, odd,  /*  C0  */
         64, 115, 198, 198, 79, 78, 80, 82,       /*  C8  */
         odd, odd, odd, odd, odd, odd, odd, 289,  /*  D0  */
         odd, odd, odd, odd, odd, odd, odd, odd,  /*  D8  */
         126, 127, 125, 86, 68, 73, 170, 171,     /*  E0  */
         25, 84, 87, 84, 68, 73, 170, 171,        /*  E8  */
         124, odd, odd, odd, 67, 40, odd, odd,    /*  F0  */
         37, 226, 74, 63, 66, 16, odd, odd     }; /*  F8  */
 
 
 
   /*  mnemonic numbers for 80 and 81 instructions, for each value
       of the "reg" field of the following byte.                     */
 
USHORT a86mnem8081_16[24] = {
             12, 167,  8, 219, 157, 247, 286, 34,
             14, 169, 10, 221, 159, 250, 288, 36,
             11, 166,  7, 218, 156, 246, 285, 33  };
 
USHORT a86mnem8081_32[24] = {
             12, 167,  8, 219, 157, 247, 286, 34,
             13, 168,  9, 220, 158, 248, 287, 35,
             11, 166,  7, 218, 156, 246, 285, 33  };
 
 
   /*  mnemonic numbers for D4, D5 orders  */
 
USHORT a86mnemAA[2] = {4, 3};
 
 
 
   /*  mnemonic numbers for C6, C7 instructions  */
 
USHORT a86mnemC6C7_16[3] = {150, 152, 120};
 
USHORT a86mnemC6C7_32[3] = {150, 151, 120};
 
 
 
   /*  mnemonic numbers for F6, F7 orders, for reg = 2 to 7, and
       for FE, FF orders, for reg = 0 and reg = 1.                */
 
USHORT a86mnemF6F7_16[24] = {
              70, 52, 162, 39, 133, 142, 56, 59,
              72, 54, 164, 42, 154, 147, 62, 61,
              69, 51, 161, 38, 132, 141, 55, 58  };
 
USHORT a86mnemF6F7_32[24] = {
              70, 52, 162, 39, 133, 142, 56, 59,
              71, 53, 163, 41, 134, 143, 57, 60,
              69, 51, 161, 38, 132, 141, 55, 58  };
 
 
 
   /*  mnemonic numbers for FF orders, reg = 2 to reg = 6  */
 
USHORT a86mnemFF_16[5] = { 30, 27, 92, 88, 192 };
 
USHORT a86mnemFF_32[5] = { 30, 27, 92, 88, 186 };
 
 
 
   /*  mnemonic numbers for shift instructions    */
 
USHORT a86shiftmnem_16[24] = {
     208, 209, 211,    /*  ROL  */
     212, 213, 215,    /*  ROR  */
     200, 201, 203,    /*  ROCL  */
     204, 205, 207,    /*  ROCR  */
     256, 257, 259,    /*  SLL  */
     265, 266, 268,    /*  SRL  */
     290, 290, 290,    /*  not used  */
     261, 262, 264 };  /*  SRA  */
 
USHORT a86shiftmnem_32[24] = {
     208, 209, 210,    /*  ROL  */
     212, 213, 214,    /*  ROR  */
     200, 201, 202,    /*  ROCL  */
     204, 205, 206,    /*  ROCR  */
     256, 257, 258,    /*  SLL  */
     265, 266, 267,    /*  SRL  */
     290, 290, 290,    /*  not used  */
     261, 262, 263 };  /*  SRA  */
 
 
 
   /*  mnemonic numbers for REP prefix orders  */
 
USHORT a86repmnem[3] = { 193, 194, 195 };
 
 
   /*  mnemonic numbers for 0F orders  */
 
USHORT a86mnem0F[256] = {
       odd, odd, 111, 128, odd, odd,  43, odd,      /*  00  */
       293, 295, odd, odd, odd, odd, odd, odd,      /*  08  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  10  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  18  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  20  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  28  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  30  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  38  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  40  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  48  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  50  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  58  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  60  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  68  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  70  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  78  */
       102,  98,  93,  96, 107, 101,  95,  91,      /*  80  */
       106, 100, 104, 105,  94,  97,  99, 103,      /*  88  */
       237, 233, 228, 230, 242, 236, 231, 227,      /*  90  */
       241, 235, 239, 240, 229, 232, 234, 238,      /*  98  */
       183, 176, odd,  20, 244, 244, 292, 292,      /*  A0  */
       183, 176, odd,  23, 245, 245, odd, 141,      /*  A8  */
       odd, odd, 129,  22, 117, 119, odd, odd,      /*  B0  */
       odd, odd, odd,  21,  18,  19, odd, odd,      /*  B8  */
       296, 296, odd, odd, odd, odd, odd, odd,      /*  C0  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  C8  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  D0  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  D8  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  E0  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  E8  */
       odd, odd, odd, odd, odd, odd, odd, odd,      /*  F0  */
       odd, odd, odd, odd, odd, odd, odd, odd  };   /*  F8  */
 
 
   /*  mnemonic numbers for 0F 00 orders  */
 
USHORT a86mnem0F00[6] = {
     255, 273, 122, 130, 281, 282 };
 
 
   /*  mnemonic numbers for 0F 01 orders  */
 
USHORT a86mnem0F01[8] = {
     243, 249, 118, 121, 260, 290, 123, 294 };
 
 
   /*  mnemonic numbers for 0F B6,B7 orders  */
 
USHORT a86mnem0FB6[3] = { 139, 140, 138 };
 
 
   /*  mnemonic numbers for 0F BA orders  */
 
USHORT a86mnem0FBA[4] = { 20, 23, 22, 21 };
 
 
   /*  mnemonic numbers for 0F BE,BF orders  */
 
USHORT a86mnem0FBE[3] = { 136, 137, 135 };
 
 
 
   /*  the following table is the mnemonic table for memory access
       387 instructions                                              */
 
USHORT a86m387mem[64] = {
     5,  71, 16, 15,  99,  98,  26, 25,       /*   0  (D8)  */
    64, 107, 90, 88,  57,  56,  84, 83,       /*   8  (D9)  */
    29,  42, 31, 33,  53,  51,  35, 37,       /*  10  (DA)  */
    40, 107, 49, 47, 107,  65, 107, 89,       /*  18  (DB)  */
     3,  69, 11, 13,  93,  96,  20, 23,       /*  20  (DC)  */
    58, 107, 85, 87,  77, 107,  78, 91,       /*  28  (DD)  */
    30,  43, 32, 34,  54,  52,  36, 38,       /*  30  (DE)  */
    41, 107, 50, 48,   6,  39,   7, 46  };    /*  38  (DF)  */
 
 
   /*  the following table is the mnemonic table for 387
       instructions with a reg field                                 */
 
USHORT a86m387reg[64] = {
      2,  68,  10,  12,  92,  95,  19,  22,   /*   0  (D8)  */
     55, 102, odd,  86, odd, odd, odd, odd,   /*   8  (D9)  */
    107, 107, 107, 107, 107, 107, 107, 107,   /*  10  (DA)  */
    107, 107, 107, 107, odd, 107, 107, 107,   /*  18  (DB)  */
      2,  68,  10,  12,  92,  95,  19,  22,   /*  20  (DC)  */
     28, 102,  82,  86, 113, 114, 107, 107,   /*  28  (DD)  */
      4,  70,  12, odd,  97,  94,  21,  24,   /*  30  (DE)  */
    108, 102,  86,  86, odd, 107, 107, 107 }; /*  38  (DF)  */
 
 
 
   /*  the following table is the mnemonic table for 387
       orders D9, mod = 3, regf = 4-7                                */
 
USHORT a86mnemD94[32] = {
      8,   1, odd, odd, 100, 101, odd, odd,
     67,  62,  61,  63,  59,  60,  66, odd,
    106, 104,  75,  73, 103, 110,  17,  44,
     74, 105,  81, 112,  76,  79, 111, 109   };
 
 
 
   /*  the following table is the mnemonic table for 387
       orders DB, mod = 3, regf = 4                                  */
 
USHORT a86mnemDB4[8] = { 27, 18, 9, 45, 80, odd, odd, odd };
 
 
 
 /********************************************************************
 *                                                                   *
 *    The following are structures to enable use to choose either    *
 *    16-bit or 32-bit dis-assembly when generating ASM/86 format    *
 *    instructions                                                   *
 *                                                                   *
 ********************************************************************/
 
 
struct {
  CHAR *p1[2];
  USHORT *p2[16];
  USHORT w1[19];
  CHAR m;
} ASM286_16 = {
                a86mnem,
                a86m387,
                a86mnem_16,
                a86mnem8081_16,
                a86mnemAA,
                a86mnemC6C7_16,
                a86mnemF6F7_16,
                a86mnemFF_16,
                a86shiftmnem_16,
                a86repmnem,
                a86mnem0F00,
                a86mnem0F01,
                a86m387mem,
                a86m387reg,
                a86mnemD94,
                a86mnemDB4,
                a86mnem0F,
                a86mnem0FBA,
                65,                       /*  index of mnemonic ESCAPE  */
                176,                         /*  index of mnemonic POP  */
                182,                    /*  index of mnemonic POP word  */
                179,                   /*  index of mnemonic POP dword  */
                225,                       /*  index of mnemonic SEGOV  */
                108,                           /*  index of mnemonic L  */
                269,                          /*  index of mnemonic ST  */
                290,              /*  index of mnemonic ???? (illegal)  */
                277,                          /*  index of mnemonic TI  */
                278,                         /*  index of mnemonic TIB  */
                280,                         /*  index of mnemonic TIW  */
                183,                        /*  index of mnemonic PUSH  */
                291,                       /*  index of mnemonic BSWAP  */
                1,                      /*  index of 387 mnemonic FABS  */
                72,                     /*  index of 387 mnemonic FNOP  */
                14,                   /*  index of 387 mnemonic FCOMPP  */
                115,                 /*  index of 387 mnemonic FUCOMPP  */
                91,                    /*  index of 387 mnemonic FSTSW  */
                107,          /*  index of 387 mnemonic ???? (illegal)  */
                0     };           /*  set to 1 if this is MASM format  */
 
 
struct {
  CHAR *p1[2];
  USHORT *p2[16];
  USHORT w1[19];
  CHAR m;
} ASM286_32 = {
                a86mnem,
                a86m387,
                a86mnem_32,
                a86mnem8081_32,
                a86mnemAA,
                a86mnemC6C7_32,
                a86mnemF6F7_32,
                a86mnemFF_32,
                a86shiftmnem_32,
                a86repmnem,
                a86mnem0F00,
                a86mnem0F01,
                a86m387mem,
                a86m387reg,
                a86mnemD94,
                a86mnemDB4,
                a86mnem0F,
                a86mnem0FBA,
                65,                       /*  index of mnemonic ESCAPE  */
                176,                         /*  index of mnemonic POP  */
                182,                    /*  index of mnemonic POP word  */
                179,                   /*  index of mnemonic POP dword  */
                225,                       /*  index of mnemonic SEGOV  */
                108,                           /*  index of mnemonic L  */
                269,                          /*  index of mnemonic ST  */
                290,              /*  index of mnemonic ???? (illegal)  */
                277,                          /*  index of mnemonic TI  */
                278,                         /*  index of mnemonic TIB  */
                279,                         /*  index of mnemonic TID  */
                183,                        /*  index of mnemonic PUSH  */
                291,                       /*  index of mnemonic BSWAP  */
                1,                      /*  index of 387 mnemonic FABS  */
                72,                     /*  index of 387 mnemonic FNOP  */
                14,                   /*  index of 387 mnemonic FCOMPP  */
                115,                 /*  index of 387 mnemonic FUCOMPP  */
                91,                    /*  index of 387 mnemonic FSTSW  */
                107,          /*  index of 387 mnemonic ???? (illegal)  */
                0     };           /*  set to 1 if this is MASM format  */
