/* A REXX script to package up MozTools in a Warp-IN package */

/*
'wic packs\MozTools.wpi -a 1 -ce:\MozTools -s MozTools.wis'
'wic packs\MozTools.wpi -a 2 -ce:\MozTools cvs.exe -s MozTools.wis'
'wic packs\MozTools.wpi -a 3 -ce:\MozTools nsinstall.exe -s MozTools.wis'
'wic packs\MozTools.wpi -a 4 -ce:\MozTools gbash.exe date.exe expr.exe tee.exe test.exe uname.exe -s MozTools.wis'
'wic packs\MozTools.wpi -a 5 -ce:\MozTools dirname.exe pwd.exe gnushu.dll -s MozTools.wis'
'wic packs\MozTools.wpi -a 6 -ce:\MozTools cat.exe sort.exe tr.exe gnutu.dll -s MozTools.wis'
'wic packs\MozTools.wpi -a 7 -ce:\MozTools chmod.exe cp.exe mkdir.exe mv.exe rm.exe touch.exe gnufu.dll gnuintl.dll -s MozTools.wis'
'wic packs\MozTools.wpi -a 8 -ce:\MozTools cmp.exe -s MozTools.wis'
'wic packs\MozTools.wpi -a 9 -ce:\MozTools egrep.exe grep.exe gnugrep.dll gnuregex.dll -s MozTools.wis'
'wic packs\MozTools.wpi -a 10 -ce:\MozTools awk.exe -s MozTools.wis'
'wic packs\MozTools.wpi -a 11 -ce:\MozTools m4.exe -s MozTools.wis'
'wic packs\MozTools.wpi -a 12 -ce:\MozTools gmake.exe -s MozTools.wis'
'wic packs\MozTools.wpi -a 13 -ce:\MozTools sed.exe -s MozTools.wis'
'wic packs\MozTools.wpi -a 14 -ce:\MozTools regex.dll -s MozTools.wis'
'wic packs\MozTools.wpi -a 15 -ce:\MozTools xargs.exe gnufind.dll -s MozTools.wis'
*/

/* Package list... used to correlate zip archives against the WarpIN script */
packlist.0 = 17; /* Total number of separate packages */
packlist.1 = "moztoolsbase";
packlist.2 = "cvs";
packlist.3 = "nsinstall";
packlist.4 = "gnubash";
packlist.5 = "gnusutils";
packlist.6 = "gnututils";
packlist.7 = "gnufutils";
packlist.8 = "gnudiff";
packlist.9 = "gnugrep";
packlist.10 = "gnuawk";
packlist.11 = "gnum4";
packlist.12 = "gnumake";
packlist.13 = "gnused";
/* packlist.14 = "libregex"; */
packlist.14 = "gnufind";
packlist.15 = "infozip";
packlist.16 = "gettext";
packlist.17 = "shareddlls";

homedir = directory(); /*Starting directory for this script */
target = directory()"\WarpIN"; /* Where are new WarpIN archive will be created */
packdate = translate(DATE('O'), "-", "/"); /* Translate the date into the WarpIN archive version */
buildDirName = "build";
builddir = directory()||"\"||buildDirName; /* Where the unzipped files are assembled before the archive is created */
infofile = "MozToolsPackList.txt"; /* File that contains all our archive information */
archivedir = directory()||"\zip"; /* Location of all the original .zip archives */
wic = "wic"; /* Location of wic.exe, or just 'wic' if it is already in your path */
unzip = "unzip"; /* Location of info-zip unzip, or just 'unzip' if it is already in your path */

/* Create the needed directories */
'mkdir '||target;
'mkdir '||builddir;

/* Read in a list of the archives we need */
lc = 0;

DO WHILE LINES(infofile) > 0
    lc = lc + 1;
    pf.lc = LINEIN(infofile);
END;
pf.0 = lc;

/* For each item on the list we'll unpack it from our archives directly into the target directory */
DO arch = 1 TO pf.0;
/* break our line into package name, zip archive, version, and file-list */
    if (pf.arch <> "") THEN DO
        getParts(pf.arch);
        DO group = 1 TO packlist.0
            /* Assign a number to the build-group */
            if (BuildGroup = packlist.group) THEN DO
                BuildGroup = group;
                LEAVE;
            END
            
        END
        
        /* If a group is marked "repack" then we have a zip file within a zip file,
         * so we'll need to unpack the first one and skip the rest of the steps
         * (which should be taken care of in follow lines of our MozToolsPackList.txt
         */
        
        if (BuildGroup = "repack") THEN DO
            /* Get rid of any old versions first */
            rc = SysFileDelete(archiveDir||"\"||ZipFileList);
            unzip||' -o -j -C '||archiveDir||"\"||ZipArchive||' '||ZipFileList||' -d '||archiveDir;
        END;
        ELSE DO
            packVer.BuildGroup = ZipVersion;
            
            UnzipTarget = buildDir||'\'||BuildGroup;

            unzip||' -o -j -C '||archiveDir||"\"||ZipArchive||' '||ZipFileList||' -d '||UnzipTarget
        END;
        
    END;
    
END;

/* Now add the base package stuff */
mkdir||' '||builddir||'\1';
copy archiveDir||'\setmozenv.cmd '||builddir||'\1';
copy COPYING builddir||'\1';
packVer.1 = translate(packDate, ".", "-"); /* We change the dash to dot so our loop fixes the version properly */


say "Creating the MozTools.sed file."
sedFile = "MozTools.sed"

rc = SysFileDelete(sedFile); /* Get rid of any old versions of the sedFile */

rc = LINEOUT(sedFile, "{", 1)
rc = LINEOUT(sedFile, "s/PACKDATE/"||packDate||"/g");
do group = 1 to packlist.0
/* thisVer = TRANSLATE(packVer.group, "\", "."); */
    thisVer = dotToSlash(packVer.group);
    /* replaceName = PARSE UPPER VALUE packlist.group; */
    replaceName = TRANSLATE(packlist.group);
    replaceName = replaceName||"VERSION";
    /* say "Package: "||packlist.group||" Version: "||packVer.group||"  Translated: "||thisVer; */
    rc = LINEOUT(sedFile, "s/"||replaceName||"/"||thisVer||"/g");
end;

rc = LINEOUT(sedFile, "}")
/* Now close the file */
rc = LINEOUT(sedFile)

/* Create new .wis and .txt files using our sedFile */
/*
rc = stream('sed.exe','c','query exists');

if (rc = "") THEN DO
    say "We require sed.exe (and it's associated libraries) to complete packing the archive!";
    
    say "There is no sed.exe here, we'll unpack it.";
    do list = 1 to packlist.0;
    if (packlist.list = "gnused") THEN DO
    copy buildDir||"\"||list||"\sed.exe .";
    end;
    end;
    
END
*/

"sed -f MozTools.sed MozTools-txt.template > "||buildDir||"\MozTools-"||packDate||".txt";
"sed -f MozTools.sed MozTools-wis.template > "||buildDir||"\MozTools-"||packDate||".wis";

/* Now build a list of directories/packages for our command */
dirList = "";
DO list = 1 TO packList.0;
    dirList = dirList||" "||list||" -c"||list||" *";
END;

/* Now create the archive*/
/*
call directory builddir;
'wic '||target||'\MozTools-'||packdate||'.wpi -a 1 -c1 * 2 -c2 * 3 -c3 * 4 -c4 * 5 -c5 * 6 -c6 * 7 -c7 * 8 -c8 * 9 -c9 * 10 -c10 * 11 -c11 * 12 -c12 * 13 -c13 * 14 -c14 * 15 -c15 * 16 -c16 *-s '||homedir||'\MozTools.wis'
call directory homedir;
*/
call directory builddir;
rc = SysFileDelete("MozTools-"||packdate||".wpi");
'wic MozTools-'||packdate||'.wpi -a'||dirList||' -s MozTools-'||packdate||'.wis';
call directory homedir;

say "wic called with -a"||dirList||" -s MozTools-"||packdate||".wis";
exit;

/* Break line into our needed variables */
getParts: procedure expose BuildGroup ZipArchive ZipFileList ZipVersion
    PARSE ARG archiveLine;
/*    say "Argument: "||archiveLine; */
    PARSE VALUE archiveLine WITH BuildGroup "," ZipArchive "," ZipVersion "," ZipFileList;
/*    say "Group: "||BuildGroup;
    say "ZipArchive: "||ZipArchive;
    say "ZipVersion: "||ZipVersion;
    say "ZipFileList: "||ZipFileLIst;
*/
return "";
    
dotToSlash: procedure;
    PARSE ARG slash;
    parse var slash slash'.'rest
    do while (rest <> "")
        slash = slash'\\'rest
        parse var slash slash'.'rest
    end;

return slash;
    
